/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.edit;

import com.dbeaver.ee.mongodb.model.MGDatabase;
import com.dbeaver.ee.mongodb.model.MongoDataSource;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.DirectDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.utils.CommonUtils;

public class MongoDatabaseManager
extends SQLObjectEditor<MGDatabase, MongoDataSource> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, MGDatabase> getObjectsCache(MGDatabase object) {
        return object.getDataSource().getDatabaseCache();
    }

    protected MGDatabase createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final Object container, Object copyFrom, Map<String, Object> options) {
        return (MGDatabase)new UITask<MGDatabase>(){

            protected MGDatabase runTask() {
                String colName = EnterNameDialog.chooseName((Shell)UIUtils.getActiveWorkbenchShell(), (String)"Collection name");
                if (CommonUtils.isEmpty((String)colName)) {
                    return null;
                }
                return new MGDatabase((MongoDataSource)container, colName);
            }
        }.execute();
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, final SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new DirectDatabasePersistAction("Create database"){

            public void afterExecute(DBCSession session, Throwable error) throws DBCException {
                MGDatabase database = (MGDatabase)command.getObject();
                if (database.getDataSource().getDatabase(database.getName()) != null) {
                    throw new DBCException("Database '" + database.getName() + "' already exists");
                }
                DB db = database.getDataSource().getExecutionContext().getClient().getDB(database.getName());
                BasicDBObject testObject = new BasicDBObject("test", (Object)"test");
                DBCollection testCollection = db.getCollection("test");
                testCollection.save((DBObject)testObject);
                testCollection.drop();
            }
        });
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, final SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new DirectDatabasePersistAction("Drop database"){

            public void afterExecute(DBCSession session, Throwable error) throws DBCException {
                MGDatabase database = (MGDatabase)command.getObject();
                database.getDatabase().drop();
            }
        });
    }
}

