/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataType;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.LongKeyMap;

public final class ExasolDataTypeCache
extends JDBCObjectCache<ExasolDataSource, ExasolDataType> {
    private LongKeyMap<ExasolDataType> dataTypeMap = new LongKeyMap();
    private static final String SQL_TYPE_CACHE = "select * from SYS.EXA_SQL_TYPES";

    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull ExasolDataSource owner) throws SQLException {
        JDBCStatement dbstat = session.createStatement();
        dbstat.setQueryString(SQL_TYPE_CACHE);
        return dbstat;
    }

    protected ExasolDataType fetchObject(@NotNull JDBCSession session, @NotNull ExasolDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
        return new ExasolDataType((DBSObject)owner, (ResultSet)resultSet);
    }

    public void clearCache() {
        super.clearCache();
        this.dataTypeMap.clear();
    }

    public void removeObject(@NotNull ExasolDataType object, boolean resetFullCache) {
        super.removeObject((DBSObject)object, resetFullCache);
        this.dataTypeMap.remove(object.getExasolTypeId());
    }

    public void setCache(List<ExasolDataType> objects) {
        super.setCache(objects);
        for (ExasolDataType dt : objects) {
            this.dataTypeMap.put(dt.getExasolTypeId(), (Object)dt);
        }
    }

    public ExasolDataType getDataTypeId(long id) {
        return (ExasolDataType)this.dataTypeMap.get(id);
    }
}

