/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxStatement;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxInteger
extends IfxObject {
    private int h;
    public static final int IFX_INT_NULL = Integer.MIN_VALUE;

    IfxInteger() throws SQLException {
        this.setIfxType(2);
    }

    public IfxInteger(int n) throws SQLException {
        this.h = n;
        this.setIfxType(2);
        this.unnullify();
    }

    IfxInteger(Integer n) throws SQLException {
        this.h = n;
        this.setIfxType(2);
        this.unnullify();
    }

    @Override
    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxInt(this.h);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] byArray = new byte[]{-128, 0, 0, 0};
            return byArray;
        }
        return JavaToIfxType.JavaToIfxInt(this.h);
    }

    @Override
    public void fromIfx(byte[] byArray) {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) {
        block3: {
            block2: {
                this.h = IfxToJavaType.IfxToJavaInt(byArray, n);
                if (!this.isIfxNull()) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.unnullify();
        }
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Integer(this.h);
    }

    @Override
    public byte toByte() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (byte)this.h;
    }

    @Override
    public void fromByte(byte by) throws SQLException {
        this.h = by;
        this.unnullify();
    }

    @Override
    public void fromByte(Byte by) throws SQLException {
        block3: {
            block2: {
                if (by != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.h = by.intValue();
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (short)this.h;
    }

    @Override
    public void fromShort(short s) throws SQLException {
        this.h = s;
        this.unnullify();
    }

    @Override
    public void fromShort(Short s) throws SQLException {
        block3: {
            block2: {
                if (s != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.h = s.intValue();
            this.unnullify();
        }
    }

    @Override
    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.h;
    }

    @Override
    public void fromInt(int n) throws SQLException {
        this.h = n;
        this.unnullify();
    }

    @Override
    public void fromInt(Integer n) throws SQLException {
        block3: {
            block2: {
                if (n != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.h = n;
            this.unnullify();
        }
    }

    @Override
    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.h;
    }

    @Override
    public void fromLong(long l2) throws SQLException {
        this.clearWarning();
        this.h = (int)l2;
        this.unnullify();
    }

    @Override
    public void fromLong(Long l2) throws SQLException {
        block3: {
            block2: {
                this.clearWarning();
                if (l2 != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.unnullify();
            this.h = l2.intValue();
        }
    }

    @Override
    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.h;
    }

    @Override
    public void fromFloat(float f2) throws SQLException {
        this.clearWarning();
        this.h = (int)f2;
        this.unnullify();
    }

    @Override
    public void fromFloat(Float f2) throws SQLException {
        block3: {
            block2: {
                this.clearWarning();
                if (f2 != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.unnullify();
            this.h = f2.intValue();
        }
    }

    @Override
    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.h;
    }

    @Override
    public void fromDouble(double d2) throws SQLException {
        this.clearWarning();
        this.h = (int)d2;
        this.unnullify();
    }

    @Override
    public void fromDouble(Double d2) throws SQLException {
        block3: {
            block2: {
                this.clearWarning();
                if (d2 != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.unnullify();
            this.h = d2.intValue();
        }
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal((double)this.h);
    }

    @Override
    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        block3: {
            block2: {
                if (bigDecimal != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.h = bigDecimal.intValue();
            this.unnullify();
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.h != 0;
    }

    @Override
    public void fromBoolean(boolean bl) throws SQLException {
        this.h = bl ? 1 : 0;
        this.unnullify();
    }

    @Override
    public void fromBoolean(Boolean bl) throws SQLException {
        block3: {
            block2: {
                if (bl != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.h = bl == true ? 1 : 0;
            this.unnullify();
        }
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return Integer.toString(this.h);
    }

    @Override
    public void fromString(String string) throws SQLException {
        block3: {
            block2: {
                if (string != null && string != "") break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.h = Integer.valueOf(string.trim());
            this.unnullify();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this.isNull() || object == null) {
            return false;
        }
        return object instanceof IfxInteger && this.h == ((IfxInteger)object).h;
    }

    @Override
    public short getEncodedLength() {
        short s = 2560;
        return s;
    }

    public boolean isIfxNull() {
        return this.h == Integer.MIN_VALUE;
    }
}

