/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDComplexValue;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetTrace;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.trace.DBCTrace;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.virtual.DBVColorOverride;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ResultSetModel {
    private static final Log log = Log.getLog(ResultSetModel.class);
    private DBDAttributeBinding[] attributes = new DBDAttributeBinding[0];
    private List<DBDAttributeBinding> visibleAttributes = new ArrayList<DBDAttributeBinding>();
    private DBDAttributeBinding documentAttribute = null;
    private DBDDataFilter dataFilter;
    private DBSEntity singleSourceEntity;
    private DBCExecutionSource executionSource;
    private List<ResultSetRow> curRows = new ArrayList<ResultSetRow>();
    private Long totalRowCount = null;
    private int changesCount = 0;
    private volatile boolean hasData = false;
    private volatile boolean updateInProgress = false;
    private Map<DBDAttributeBinding, List<AttributeColorSettings>> colorMapping = new HashMap<DBDAttributeBinding, List<AttributeColorSettings>>();
    private DBCStatistics statistics;
    private DBCTrace trace;
    private transient boolean metadataChanged;
    private transient boolean metadataDynamic;
    private final Comparator<DBDAttributeBinding> POSITION_SORTER = new Comparator<DBDAttributeBinding>(){

        @Override
        public int compare(DBDAttributeBinding o1, DBDAttributeBinding o2) {
            DBDAttributeConstraint c1 = ResultSetModel.this.dataFilter.getConstraint(o1);
            DBDAttributeConstraint c2 = ResultSetModel.this.dataFilter.getConstraint(o2);
            if (c1 == null) {
                log.debug((Object)("Missing constraint for " + o1));
                return -1;
            }
            if (c2 == null) {
                log.debug((Object)("Missing constraint for " + o2));
                return 1;
            }
            return c1.getVisualPosition() - c2.getVisualPosition();
        }
    };

    public ResultSetModel() {
        this.dataFilter = this.createDataFilter();
    }

    @NotNull
    public DBDDataFilter createDataFilter() {
        this.fillVisibleAttributes();
        ArrayList<DBDAttributeConstraint> constraints = new ArrayList<DBDAttributeConstraint>(this.attributes.length);
        DBDAttributeBinding[] dBDAttributeBindingArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
            this.addConstraints(constraints, binding);
            ++n2;
        }
        return new DBDDataFilter(constraints);
    }

    private void addConstraints(List<DBDAttributeConstraint> constraints, DBDAttributeBinding binding) {
        DBDAttributeConstraint constraint = new DBDAttributeConstraint(binding);
        constraint.setVisible(this.visibleAttributes.contains(binding) || binding.getParentObject() != null);
        constraints.add(constraint);
        List nestedBindings = binding.getNestedBindings();
        if (nestedBindings != null) {
            for (DBDAttributeBinding nested : nestedBindings) {
                this.addConstraints(constraints, nested);
            }
        }
    }

    public boolean isSingleSource() {
        return this.singleSourceEntity != null;
    }

    @Nullable
    public DBSEntity getSingleSource() {
        return this.singleSourceEntity;
    }

    public void resetCellValue(DBDAttributeBinding attr, ResultSetRow row) {
        if (row.getState() == 3) {
            row.setState((byte)1);
        } else if (row.changes != null && row.changes.containsKey(attr)) {
            DBUtils.resetValue((Object)this.getCellValue(attr, row));
            this.updateCellValue(attr, row, row.changes.get(attr), false);
            row.resetChange(attr);
            if (row.getState() == 1) {
                --this.changesCount;
            }
        }
    }

    public void refreshChangeCount() {
        this.changesCount = 0;
        for (ResultSetRow row : this.curRows) {
            if (row.getState() != 1) {
                ++this.changesCount;
                continue;
            }
            if (row.changes == null) continue;
            this.changesCount += row.changes.size();
        }
    }

    public DBDAttributeBinding getDocumentAttribute() {
        return this.documentAttribute;
    }

    @NotNull
    public DBDAttributeBinding[] getAttributes() {
        return this.attributes;
    }

    @NotNull
    public DBDAttributeBinding getAttribute(int index) {
        return this.attributes[index];
    }

    @NotNull
    public DBDAttributeBinding[] getRealAttributes() {
        ArrayList<DBDAttributeBinding> result = new ArrayList<DBDAttributeBinding>();
        DBDAttributeBinding[] dBDAttributeBindingArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
            if (!attr.isCustom()) {
                result.add(attr);
            }
            ++n2;
        }
        return result.toArray(new DBDAttributeBinding[0]);
    }

    @NotNull
    public List<DBDAttributeBinding> getVisibleAttributes() {
        return this.visibleAttributes;
    }

    public int getVisibleAttributeCount() {
        return this.visibleAttributes.size();
    }

    @Nullable
    public List<DBDAttributeBinding> getVisibleAttributes(DBDAttributeBinding parent) {
        List nestedBindings = parent.getNestedBindings();
        if (nestedBindings == null || nestedBindings.isEmpty()) {
            return null;
        }
        ArrayList<DBDAttributeBinding> result = new ArrayList<DBDAttributeBinding>(nestedBindings);
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            DBDAttributeConstraint constraint = this.dataFilter.getConstraint((DBDAttributeBinding)iter.next());
            if (constraint == null || constraint.isVisible()) continue;
            iter.remove();
        }
        return result;
    }

    @NotNull
    public DBDAttributeBinding getVisibleAttribute(int index) {
        return this.visibleAttributes.get(index);
    }

    public void setAttributeVisibility(@NotNull DBDAttributeBinding attribute, boolean visible) {
        DBDAttributeConstraint constraint = this.dataFilter.getConstraint(attribute);
        if (constraint != null && constraint.isVisible() != visible) {
            constraint.setVisible(visible);
            if (attribute.getParentObject() == null) {
                if (visible) {
                    this.visibleAttributes.add(attribute);
                } else {
                    this.visibleAttributes.remove(attribute);
                }
            }
        }
    }

    @Nullable
    public DBDAttributeBinding getAttributeBinding(@Nullable DBSAttributeBase attribute) {
        return DBUtils.findBinding((DBDAttributeBinding[])this.attributes, (DBSAttributeBase)attribute);
    }

    @Nullable
    DBDAttributeBinding getAttributeBinding(@Nullable DBSEntity entity, @NotNull String attrName) {
        for (DBDAttributeBinding attribute : this.visibleAttributes) {
            DBDRowIdentifier rowIdentifier = attribute.getRowIdentifier();
            if (entity != null && (rowIdentifier == null || rowIdentifier.getEntity() != entity) || !attribute.getName().equals(attrName)) continue;
            return attribute;
        }
        return null;
    }

    DBVEntity getVirtualEntity(boolean create) {
        DBSEntity entity = this.isSingleSource() ? this.getSingleSource() : null;
        return this.getVirtualEntity(entity, create);
    }

    DBVEntity getVirtualEntity(DBSEntity entity, boolean create) {
        if (entity != null) {
            return DBVUtils.getVirtualEntity((DBSEntity)entity, (boolean)true);
        }
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer != null) {
            return DBVUtils.getVirtualEntity((DBSDataContainer)dataContainer, (boolean)create);
        }
        return null;
    }

    @Nullable
    private DBSDataContainer getDataContainer() {
        return this.executionSource == null ? null : this.executionSource.getDataContainer();
    }

    public boolean isEmpty() {
        return this.getRowCount() <= 0 || this.visibleAttributes.size() <= 0;
    }

    public int getRowCount() {
        return this.curRows.size();
    }

    @NotNull
    public List<ResultSetRow> getAllRows() {
        return this.curRows;
    }

    @NotNull
    public Object[] getRowData(int index) {
        return this.curRows.get((int)index).values;
    }

    @NotNull
    public ResultSetRow getRow(int index) {
        return this.curRows.get(index);
    }

    public Long getTotalRowCount() {
        return this.totalRowCount;
    }

    void setTotalRowCount(Long totalRowCount) {
        this.totalRowCount = totalRowCount;
    }

    @Nullable
    public Object getCellValue(@NotNull DBDAttributeBinding attribute, @NotNull ResultSetRow row) {
        return DBUtils.getAttributeValue((DBDAttributeBinding)attribute, (DBDAttributeBinding[])this.attributes, (Object[])row.values);
    }

    public boolean updateCellValue(@NotNull DBDAttributeBinding attr, @NotNull ResultSetRow row, @Nullable Object value) {
        return this.updateCellValue(attr, row, value, true);
    }

    public boolean updateCellValue(@NotNull DBDAttributeBinding attr, @NotNull ResultSetRow row, @Nullable Object value, boolean updateChanges) {
        int depth = attr.getLevel();
        int rootIndex = depth == 0 ? attr.getOrdinalPosition() : attr.getTopParent().getOrdinalPosition();
        Object rootValue = row.values[rootIndex];
        Object ownerValue = depth > 0 ? rootValue : null;
        int i = 0;
        while (i < depth) {
            if (ownerValue == null) {
                log.warn((Object)("Null owner value for '" + attr.getName() + "', row " + row.getVisualNumber()));
                return false;
            }
            if (i == depth - 1) break;
            DBDAttributeBinding ownerAttr = attr.getParent(depth - i - 1);
            assert (ownerAttr != null);
            try {
                Object nestedValue = ownerAttr.extractNestedValue(ownerValue);
                if (nestedValue == null) {
                    DBCExecutionContext context = DBUtils.getDefaultContext((DBSObject)ownerAttr, (boolean)false);
                    nestedValue = DBUtils.createNewAttributeValue((DBCExecutionContext)context, (DBDValueHandler)ownerAttr.getValueHandler(), (DBSTypedObject)ownerAttr.getAttribute(), DBDComplexValue.class);
                    if (ownerValue instanceof DBDComposite) {
                        ((DBDComposite)ownerValue).setAttributeValue((DBSAttributeBase)ownerAttr, nestedValue);
                    }
                    if (ownerAttr.getDataKind() == DBPDataKind.ARRAY) {
                        if (nestedValue instanceof DBDCollection) {
                            Object elemValue = null;
                            try {
                                DBSDataType componentType = ((DBDCollection)nestedValue).getComponentType();
                                DBDValueHandler elemValueHandler = DBUtils.findValueHandler((DBPDataSource)context.getDataSource(), (DBSTypedObject)componentType);
                                elemValue = DBUtils.createNewAttributeValue((DBCExecutionContext)context, (DBDValueHandler)elemValueHandler, (DBSTypedObject)componentType, DBDComplexValue.class);
                            }
                            catch (DBException e) {
                                log.warn((Object)"Error while getting component type name", (Throwable)e);
                            }
                            ((DBDCollection)nestedValue).setContents(new Object[]{elemValue});
                        } else {
                            log.warn((Object)("Attribute '" + ownerAttr.getName() + "' has collection type but attribute value is not a collection: " + nestedValue));
                        }
                    }
                    if (ownerValue instanceof DBDComposite) {
                        ((DBDComposite)ownerValue).setAttributeValue((DBSAttributeBase)ownerAttr, nestedValue);
                    }
                }
                ownerValue = nestedValue;
            }
            catch (DBCException e) {
                log.warn((Object)("Error getting field [" + ownerAttr.getName() + "] value"), (Throwable)e);
                return false;
            }
            ++i;
        }
        Object oldValue = rootValue;
        if (ownerValue != null) {
            try {
                oldValue = attr.extractNestedValue(ownerValue);
            }
            catch (DBCException e) {
                log.error((Object)("Error getting [" + attr.getName() + "] value"), (Throwable)e);
            }
        }
        if (value instanceof DBDValue && value == oldValue && ((DBDValue)value).isModified() || !CommonUtils.equalObjects((Object)oldValue, (Object)value)) {
            if (ownerValue == null && DBUtils.isNullValue((Object)oldValue) && DBUtils.isNullValue((Object)value)) {
                return false;
            }
            if (ownerValue != null) {
                DBDCollection collection;
                if (ownerValue instanceof DBDCollection && (collection = (DBDCollection)ownerValue).getItemCount() > 0) {
                    ownerValue = collection.getItem(0);
                }
                if (!(ownerValue instanceof DBDComposite)) {
                    log.warn((Object)("Value [" + ownerValue + "] edit is not supported"));
                    return false;
                }
            }
            if (row.getState() == 1) {
                Object oldOldValue;
                boolean cellWasEdited = row.changes != null && row.changes.containsKey(attr);
                Object object = oldOldValue = !cellWasEdited ? null : row.changes.get(attr);
                if (cellWasEdited && !CommonUtils.equalObjects((Object)oldValue, (Object)oldOldValue) && !CommonUtils.equalObjects((Object)oldValue, (Object)value)) {
                    DBUtils.releaseValue((Object)oldValue);
                } else if (updateChanges) {
                    if (value instanceof DBDValue || !CommonUtils.equalObjects((Object)value, (Object)oldValue)) {
                        row.addChange(attr, oldValue);
                    } else {
                        updateChanges = false;
                    }
                }
                if (updateChanges && row.getState() == 1 && !cellWasEdited) {
                    ++this.changesCount;
                }
            }
            if (ownerValue != null) {
                ((DBDComposite)ownerValue).setAttributeValue(attr.getAttribute(), value);
            } else {
                row.values[rootIndex] = value;
            }
            return true;
        }
        return false;
    }

    boolean isDynamicMetadata() {
        return this.metadataDynamic;
    }

    public boolean isMetadataChanged() {
        return this.metadataChanged;
    }

    public void setMetaData(@NotNull DBCResultSet resultSet, @NotNull DBDAttributeBinding[] newAttributes) {
        DBCStatement sourceStatement = resultSet.getSourceStatement();
        this.executionSource = sourceStatement != null ? sourceStatement.getStatementSource() : null;
        this.trace = resultSet instanceof DBCResultSetTrace ? ((DBCResultSetTrace)resultSet).getExecutionTrace() : null;
        this.clearData();
        this.updateMetaData(newAttributes);
    }

    void updateMetaData(@NotNull DBDAttributeBinding[] newAttributes) {
        boolean update = false;
        if (this.attributes == null || this.attributes.length == 0 || this.attributes.length != newAttributes.length || this.isDynamicMetadata()) {
            update = true;
        } else {
            int i = 0;
            while (i < this.attributes.length) {
                DBCAttributeMetaData oldMeta = this.attributes[i].getMetaAttribute();
                DBCAttributeMetaData newMeta = newAttributes[i].getMetaAttribute();
                if (oldMeta == null && newMeta != null || oldMeta != null && newMeta == null) {
                    update = true;
                    break;
                }
                if (oldMeta != newMeta && !ResultSetUtils.equalAttributes(oldMeta, newMeta)) {
                    update = true;
                    break;
                }
                ++i;
            }
        }
        this.metadataChanged = update;
        if (update) {
            this.metadataChanged = ArrayUtils.isEmpty((Object[])this.attributes) || ArrayUtils.isEmpty((Object[])newAttributes) || !this.isDynamicMetadata() || this.attributes[0].getTopParent().getMetaAttribute() == null || newAttributes[0].getTopParent().getMetaAttribute() == null || this.attributes[0].getTopParent().getMetaAttribute().getSource() != newAttributes[0].getTopParent().getMetaAttribute().getSource();
        }
        this.attributes = newAttributes;
        this.documentAttribute = null;
        this.metadataDynamic = this.attributes.length > 0 && this.attributes[0].getTopParent().getDataSource().getInfo().isDynamicMetadata();
        DBDAttributeBinding realAttr = null;
        if (this.attributes.length == 1) {
            realAttr = this.attributes[0];
        } else {
            DBDAttributeBinding[] dBDAttributeBindingArray = this.attributes;
            int n = this.attributes.length;
            int n2 = 0;
            while (n2 < n) {
                DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
                if (!attr.isPseudoAttribute()) {
                    if (realAttr != null) {
                        realAttr = null;
                        break;
                    }
                    realAttr = attr;
                }
                ++n2;
            }
        }
        if (realAttr != null && (realAttr.getDataKind() == DBPDataKind.DOCUMENT || realAttr.getDataKind() == DBPDataKind.CONTENT)) {
            this.documentAttribute = realAttr;
        }
        this.updateColorMapping(false);
    }

    void updateDataFilter() {
        if (this.metadataChanged) {
            this.dataFilter = this.createDataFilter();
        } else {
            DBDDataFilter prevFilter = this.dataFilter;
            this.dataFilter = this.createDataFilter();
            this.updateDataFilter(prevFilter, false);
        }
    }

    public void setData(@NotNull List<Object[]> rows) {
        List nested;
        DBDAttributeBinding topAttr;
        this.clearData();
        if (this.attributes.length == 1 && this.attributes[0].getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.transform.complex.type") && (topAttr = this.attributes[0]).getDataKind() == DBPDataKind.DOCUMENT && (nested = topAttr.getNestedBindings()) != null && !nested.isEmpty()) {
            this.attributes = nested.toArray(new DBDAttributeBinding[0]);
            this.fillVisibleAttributes();
        }
        this.appendData(rows, true);
        this.updateDataFilter();
        this.visibleAttributes.sort(this.POSITION_SORTER);
        DBSEntity sourceTable = null;
        for (DBDAttributeBinding attribute : this.visibleAttributes) {
            DBDRowIdentifier rowIdentifier;
            if (attribute.isPseudoAttribute() || (rowIdentifier = attribute.getRowIdentifier()) == null) continue;
            if (sourceTable == null) {
                sourceTable = rowIdentifier.getEntity();
                continue;
            }
            if (sourceTable == rowIdentifier.getEntity()) continue;
            sourceTable = null;
            break;
        }
        this.singleSourceEntity = sourceTable;
        this.updateColorMapping(false);
        this.hasData = true;
    }

    boolean hasColorMapping(DBDAttributeBinding binding) {
        return this.colorMapping.containsKey(binding);
    }

    boolean hasColorMapping(DBSEntity entity) {
        DBVEntity virtualEntity = DBVUtils.getVirtualEntity((DBSEntity)entity, (boolean)false);
        return virtualEntity != null && !CommonUtils.isEmpty((Collection)virtualEntity.getColorOverrides());
    }

    void updateColorMapping(boolean reset) {
        this.colorMapping.clear();
        DBSEntity entity = this.getSingleSource();
        if (entity != null) {
            List coList;
            DBVEntity virtualEntity = DBVUtils.getVirtualEntity((DBSEntity)entity, (boolean)false);
            if (virtualEntity != null && !CommonUtils.isEmpty((Collection)(coList = virtualEntity.getColorOverrides()))) {
                for (DBVColorOverride co : coList) {
                    DBDAttributeBinding binding = this.getAttributeBinding(entity, co.getAttributeName());
                    if (binding == null) continue;
                    List cmList = this.colorMapping.computeIfAbsent(binding, k -> new ArrayList());
                    cmList.add(new AttributeColorSettings(co));
                }
            }
        } else {
            DBDAttributeBinding[] dBDAttributeBindingArray = this.attributes;
            int n = this.attributes.length;
            int n2 = 0;
            while (n2 < n) {
                List coList;
                DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
                DBVEntity virtualEntity = DBVUtils.getVirtualEntity((DBDAttributeBinding)attr, (boolean)false);
                if (virtualEntity != null && !CommonUtils.isEmpty((Collection)(coList = virtualEntity.getColorOverrides()))) {
                    for (DBVColorOverride co : coList) {
                        if (!CommonUtils.equalObjects((Object)attr.getName(), (Object)co.getAttributeName())) continue;
                        List cmList = this.colorMapping.computeIfAbsent(attr, k -> new ArrayList());
                        cmList.add(new AttributeColorSettings(co));
                    }
                }
                ++n2;
            }
        }
        this.updateRowColors(reset, this.curRows);
    }

    private void updateRowColors(boolean reset, List<ResultSetRow> rows) {
        if (this.colorMapping.isEmpty() || reset) {
            for (ResultSetRow resultSetRow : rows) {
                resultSetRow.colorInfo = null;
            }
        }
        if (!this.colorMapping.isEmpty()) {
            for (Map.Entry entry : this.colorMapping.entrySet()) {
                if (!ArrayUtils.contains((Object[])this.attributes, (Object)((DBDAttributeBinding)entry.getKey()))) continue;
                for (ResultSetRow row : rows) {
                    for (AttributeColorSettings acs : (List)entry.getValue()) {
                        Color background = null;
                        Color foreground = null;
                        if (acs.rangeCheck) {
                            if (acs.attributeValues != null && acs.attributeValues.length > 1) {
                                DBDAttributeBinding binding;
                                Object cellValue;
                                double value;
                                double minValue = ResultSetUtils.makeNumericValue(acs.attributeValues[0]);
                                double maxValue = ResultSetUtils.makeNumericValue(acs.attributeValues[1]);
                                if (acs.colorBackground != null && acs.colorBackground2 != null && (value = ResultSetUtils.makeNumericValue(cellValue = this.getCellValue(binding = (DBDAttributeBinding)entry.getKey(), row))) >= minValue && value <= maxValue) {
                                    foreground = acs.colorForeground;
                                    RGB rowRGB = ResultSetUtils.makeGradientValue(acs.colorBackground.getRGB(), acs.colorBackground2.getRGB(), minValue, maxValue, value);
                                    background = UIUtils.getSharedColor((RGB)rowRGB);
                                }
                            }
                        } else {
                            DBDAttributeBinding binding = (DBDAttributeBinding)entry.getKey();
                            Object cellValue = this.getCellValue(binding, row);
                            if (acs.evaluate(cellValue)) {
                                foreground = acs.colorForeground;
                                background = acs.colorBackground;
                            }
                        }
                        if (foreground == null && background == null) continue;
                        ResultSetRow.ColorInfo colorInfo = row.colorInfo;
                        if (colorInfo == null) {
                            row.colorInfo = colorInfo = new ResultSetRow.ColorInfo();
                        }
                        if (!acs.singleColumn) {
                            colorInfo.rowForeground = foreground;
                            colorInfo.rowBackground = background;
                            continue;
                        }
                        if (foreground != null) {
                            Color[] cellFgColors = colorInfo.cellFgColors;
                            if (cellFgColors == null) {
                                colorInfo.cellFgColors = cellFgColors = new Color[this.attributes.length];
                            }
                            cellFgColors[((DBDAttributeBinding)entry.getKey()).getOrdinalPosition()] = foreground;
                        }
                        if (background == null) continue;
                        Color[] cellBgColors = colorInfo.cellBgColors;
                        if (cellBgColors == null) {
                            colorInfo.cellBgColors = cellBgColors = new Color[this.attributes.length];
                        }
                        cellBgColors[((DBDAttributeBinding)entry.getKey()).getOrdinalPosition()] = background;
                    }
                }
            }
        }
    }

    public void appendData(@NotNull List<Object[]> rows, boolean resetOldRows) {
        if (resetOldRows) {
            this.curRows.clear();
        }
        int rowCount = rows.size();
        int firstRowNum = this.curRows.size();
        ArrayList<ResultSetRow> newRows = new ArrayList<ResultSetRow>(rowCount);
        int i = 0;
        while (i < rowCount) {
            newRows.add(new ResultSetRow(firstRowNum + i, rows.get(i)));
            ++i;
        }
        this.curRows.addAll(newRows);
        this.updateRowColors(false, newRows);
    }

    void clearData() {
        this.releaseAll();
        this.hasData = false;
    }

    public boolean hasData() {
        return this.hasData;
    }

    public boolean isDirty() {
        return this.changesCount != 0;
    }

    public boolean isAttributeReadOnly(@NotNull DBDAttributeBinding attribute) {
        if (attribute == null || attribute.getMetaAttribute() == null || attribute.getMetaAttribute().isReadOnly()) {
            return true;
        }
        DBDRowIdentifier rowIdentifier = attribute.getRowIdentifier();
        if (rowIdentifier == null || !(rowIdentifier.getEntity() instanceof DBSDataManipulator)) {
            return true;
        }
        DBSDataManipulator dataContainer = (DBSDataManipulator)rowIdentifier.getEntity();
        return (dataContainer.getSupportedFeatures() & 0x20000) == 0;
    }

    public boolean isUpdateInProgress() {
        return this.updateInProgress;
    }

    void setUpdateInProgress(boolean updateInProgress) {
        this.updateInProgress = updateInProgress;
    }

    @NotNull
    ResultSetRow addNewRow(int rowNum, @NotNull Object[] data) {
        ResultSetRow newRow = new ResultSetRow(this.curRows.size(), data);
        newRow.setVisualNumber(rowNum);
        newRow.setState((byte)2);
        this.shiftRows(newRow, 1);
        this.curRows.add(rowNum, newRow);
        ++this.changesCount;
        return newRow;
    }

    boolean deleteRow(@NotNull ResultSetRow row) {
        if (row.getState() == 2) {
            this.cleanupRow(row);
            return true;
        }
        row.setState((byte)3);
        ++this.changesCount;
        return false;
    }

    void cleanupRow(@NotNull ResultSetRow row) {
        row.release();
        this.curRows.remove(row.getVisualNumber());
        this.shiftRows(row, -1);
    }

    boolean cleanupRows(Collection<ResultSetRow> rows) {
        if (rows != null && !rows.isEmpty()) {
            ArrayList<ResultSetRow> rowsToRemove = new ArrayList<ResultSetRow>(rows);
            rowsToRemove.sort(Comparator.comparingInt(ResultSetRow::getVisualNumber));
            for (ResultSetRow row : rowsToRemove) {
                this.cleanupRow(row);
            }
            return true;
        }
        return false;
    }

    private void shiftRows(@NotNull ResultSetRow relative, int delta) {
        for (ResultSetRow row : this.curRows) {
            if (row.getVisualNumber() >= relative.getVisualNumber()) {
                row.setVisualNumber(row.getVisualNumber() + delta);
            }
            if (row.getRowNumber() < relative.getRowNumber()) continue;
            row.setRowNumber(row.getRowNumber() + delta);
        }
    }

    private void releaseAll() {
        final List<ResultSetRow> oldRows = this.curRows;
        this.curRows = new ArrayList<ResultSetRow>();
        this.totalRowCount = null;
        new AbstractJob("Cleanup model"){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(DBRProgressMonitor monitor) {
                for (ResultSetRow row : oldRows) {
                    row.release();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public DBDDataFilter getDataFilter() {
        return this.dataFilter;
    }

    boolean setDataFilter(DBDDataFilter dataFilter) {
        this.dataFilter = dataFilter;
        ArrayList<DBDAttributeConstraint> newConstraints = new ArrayList<DBDAttributeConstraint>();
        DBDAttributeBinding[] dBDAttributeBindingArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
            if (dataFilter.getConstraint(binding) == null) {
                this.addConstraints(newConstraints, binding);
            }
            ++n2;
        }
        if (!newConstraints.isEmpty()) {
            dataFilter.addConstraints(newConstraints);
        }
        ArrayList<DBDAttributeBinding> newBindings = new ArrayList<DBDAttributeBinding>();
        for (DBSAttributeBase attr : this.dataFilter.getOrderedVisibleAttributes()) {
            DBDAttributeBinding binding = this.getAttributeBinding(attr);
            if (binding == null) continue;
            newBindings.add(binding);
        }
        if (!newBindings.equals(this.visibleAttributes)) {
            this.visibleAttributes = newBindings;
            return true;
        }
        return false;
    }

    void updateDataFilter(DBDDataFilter filter, boolean forceUpdate) {
        this.visibleAttributes.clear();
        Collections.addAll(this.visibleAttributes, this.attributes);
        ArrayList<DBDAttributeConstraint> missingConstraints = new ArrayList<DBDAttributeConstraint>();
        for (DBDAttributeConstraint constraint : filter.getConstraints()) {
            DBDAttributeBinding attribute;
            DBSAttributeBase cAttr;
            DBDAttributeConstraint filterConstraint = this.dataFilter.getConstraint(constraint.getAttribute(), true);
            if (filterConstraint == null) {
                if (constraint.getOperator() == null) continue;
                missingConstraints.add(constraint);
                continue;
            }
            if (!forceUpdate && constraint.getVisualPosition() != DBDAttributeConstraint.NULL_VISUAL_POSITION && constraint.getVisualPosition() != filterConstraint.getVisualPosition() && constraint.getVisualPosition() == constraint.getOriginalVisualPosition()) continue;
            if (constraint.getOperator() != null) {
                filterConstraint.setOperator(constraint.getOperator());
                filterConstraint.setReverseOperator(constraint.isReverseOperator());
                filterConstraint.setValue(constraint.getValue());
            } else {
                filterConstraint.setCriteria(constraint.getCriteria());
            }
            filterConstraint.setOrderPosition(constraint.getOrderPosition());
            filterConstraint.setOrderDescending(constraint.isOrderDescending());
            filterConstraint.setVisible(constraint.isVisible());
            if (constraint.getVisualPosition() != DBDAttributeConstraint.NULL_VISUAL_POSITION) {
                filterConstraint.setVisualPosition(constraint.getVisualPosition());
            }
            if (!((cAttr = filterConstraint.getAttribute()) instanceof DBDAttributeBinding)) continue;
            if (!constraint.isVisible()) {
                this.visibleAttributes.remove(cAttr);
                continue;
            }
            if (this.visibleAttributes.contains(cAttr) || (attribute = (DBDAttributeBinding)cAttr).getParentObject() != null) continue;
            this.visibleAttributes.add(attribute);
        }
        if (!missingConstraints.isEmpty()) {
            this.dataFilter.addConstraints(missingConstraints);
        }
        if (filter.getConstraints().size() != this.attributes.length) {
            Iterator<DBDAttributeBinding> iter = this.visibleAttributes.iterator();
            while (iter.hasNext()) {
                DBDAttributeBinding attr = iter.next();
                if (filter.getConstraint((DBSAttributeBase)attr, true) != null || DBDAttributeConstraint.isVisibleByDefault((DBDAttributeBinding)attr)) continue;
                iter.remove();
            }
        }
        this.visibleAttributes.sort(this.POSITION_SORTER);
        this.dataFilter.setWhere(filter.getWhere());
        this.dataFilter.setOrder(filter.getOrder());
        this.dataFilter.setAnyConstraint(filter.isAnyConstraint());
    }

    public void resetOrdering() {
        boolean hasOrdering = this.dataFilter.hasOrdering();
        List orderConstraints = this.dataFilter.getOrderConstraints();
        this.curRows.sort((row1, row2) -> {
            if (!hasOrdering) {
                return row1.getRowNumber() - row2.getRowNumber();
            }
            int result = 0;
            for (DBDAttributeConstraint co : orderConstraints) {
                DBDAttributeBinding binding = this.getAttributeBinding(co.getAttribute());
                if (binding == null) continue;
                Object cell1 = this.getCellValue(binding, (ResultSetRow)row1);
                Object cell2 = this.getCellValue(binding, (ResultSetRow)row2);
                result = DBUtils.compareDataValues((Object)cell1, (Object)cell2);
                if (co.isOrderDescending()) {
                    result = -result;
                }
                if (result != 0) break;
            }
            return result;
        });
        int i = 0;
        while (i < this.curRows.size()) {
            this.curRows.get(i).setVisualNumber(i);
            ++i;
        }
    }

    private void fillVisibleAttributes() {
        DBSEntityAttribute entityAttribute;
        DBSEntity entity;
        DBPDataSourceContainer container;
        this.visibleAttributes.clear();
        boolean entityDataView = this.executionSource != null && this.executionSource.getDataContainer() instanceof DBSEntity;
        DBSObjectFilter columnFilter = null;
        if (entityDataView && (container = (entity = (DBSEntity)this.executionSource.getDataContainer()).getDataSource().getContainer()).getPreferenceStore().getBoolean("resultset.filter.use.navigator") && this.attributes.length > 0 && (entityAttribute = this.attributes[0].getEntityAttribute()) != null) {
            columnFilter = container.getObjectFilter(entityAttribute.getClass(), (DBSObject)entity, false);
        }
        DBDAttributeBinding[] dBDAttributeBindingArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
            if (!(entityDataView && !DBDAttributeConstraint.isVisibleByDefault((DBDAttributeBinding)binding) || columnFilter != null && !columnFilter.matches(binding.getName()))) {
                this.visibleAttributes.add(binding);
            }
            ++n2;
        }
    }

    public DBCStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(DBCStatistics statistics) {
        this.statistics = statistics;
    }

    public DBCTrace getTrace() {
        return this.trace;
    }

    public static class AttributeColorSettings {
        private DBCLogicalOperator operator;
        private boolean rangeCheck;
        private boolean singleColumn;
        private Object[] attributeValues;
        private Color colorForeground;
        private Color colorForeground2;
        private Color colorBackground;
        private Color colorBackground2;

        AttributeColorSettings(DBVColorOverride co) {
            this.operator = co.getOperator();
            this.rangeCheck = co.isRange();
            this.singleColumn = co.isSingleColumn();
            this.colorForeground = AttributeColorSettings.getColor(co.getColorForeground());
            this.colorForeground2 = AttributeColorSettings.getColor(co.getColorForeground2());
            this.colorBackground = AttributeColorSettings.getColor(co.getColorBackground());
            this.colorBackground2 = AttributeColorSettings.getColor(co.getColorBackground2());
            this.attributeValues = co.getAttributeValues();
        }

        private static Color getColor(String color) {
            if (CommonUtils.isEmpty((String)color)) {
                return null;
            }
            return UIUtils.getSharedColor((String)color);
        }

        public boolean evaluate(Object cellValue) {
            return this.operator.evaluate(cellValue, this.attributeValues);
        }
    }
}

