/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.impl.liquibase;

import com.dbeaver.ee.scmp.impl.liquibase.LBResultChangeItem;
import com.dbeaver.ee.scmp.model.CMPOptions;
import com.dbeaver.ee.scmp.model.CMPResultChangeItem;
import com.dbeaver.ee.scmp.model.CMPResultChangeSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.diff.compare.CompareControl;
import org.jkiss.dbeaver.Log;

public class LBResultChangeSet
implements CMPResultChangeSet {
    private static final Log log = Log.getLog(LBResultChangeSet.class);
    private final CMPOptions options;
    private final Database sourceDatabase;
    private final Database targetDatabase;
    private final CompareControl compareControl;
    private final List<ChangeSet> sourceDiff;
    private Map<Change, LBResultChangeItem> rootItems = new LinkedHashMap<Change, LBResultChangeItem>();

    public LBResultChangeSet(CMPOptions options, Database sourceDatabase, Database targetDatabase, CompareControl control, List<ChangeSet> lbcs) {
        this.options = options;
        this.sourceDatabase = sourceDatabase;
        this.targetDatabase = targetDatabase;
        this.compareControl = control;
        this.sourceDiff = lbcs;
        for (ChangeSet cs : lbcs) {
            for (Change change : cs.getChanges()) {
                this.rootItems.put(change, new LBResultChangeItem(this, change));
            }
        }
    }

    public CMPOptions getOptions() {
        return this.options;
    }

    public List<ChangeSet> getSourceDiff() {
        return this.sourceDiff;
    }

    public Database getSourceDatabase() {
        return this.sourceDatabase;
    }

    public Database getTargetDatabase() {
        return this.targetDatabase;
    }

    public CompareControl getCompareControl() {
        return this.compareControl;
    }

    public Collection<LBResultChangeItem> getChangeItems() {
        return this.rootItems.values();
    }

    public String toString() {
        return "CMPResultChangeSet [rootItems=" + this.rootItems + "]";
    }

    public CMPResultChangeItem getChangeItem(Change change) {
        return this.rootItems.get(change);
    }

    public boolean isChangeEnabled(Change change) {
        CMPResultChangeItem changeItem = this.getChangeItem(change);
        return changeItem != null && changeItem.isEnabled();
    }
}

