/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.dashboard.pie;

import java.awt.Dimension;
import java.awt.Paint;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PieLabelLinkStyle;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleInsets;
import org.jkiss.dbeaver.ui.AWTUtils;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.charts.BaseChartDrawingSupplier;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardChartComposite;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardItem;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardRendererBase;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemViewConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardValueType;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewContainer;
import org.jkiss.dbeaver.ui.dashboard.model.data.DashboardDataset;
import org.jkiss.dbeaver.ui.dashboard.model.data.DashboardDatasetRow;
import org.jkiss.utils.ByteNumberFormat;

public class DashboardRendererPie
extends DashboardRendererBase {
    public DashboardChartComposite createDashboard(Composite composite, DashboardContainer container, DashboardViewContainer viewContainer, Point preferredSize) {
        DashboardItemViewConfiguration viewConfig = viewContainer.getViewConfiguration().getDashboardConfig(container.getDashboardId());
        DefaultPieDataset dataset = new DefaultPieDataset();
        JFreeChart pieChart = ChartFactory.createPieChart(null, (PieDataset)dataset, (boolean)true, (boolean)true, (Locale)Locale.getDefault());
        pieChart.setBorderVisible(false);
        pieChart.setPadding(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        pieChart.setTextAntiAlias(true);
        pieChart.setBackgroundPaint((Paint)AWTUtils.makeAWTColor((Color)UIStyles.getDefaultTextBackground()));
        this.createDefaultLegend(viewConfig, pieChart);
        ChartPanel chartPanel = new ChartPanel(pieChart);
        chartPanel.setPreferredSize(new Dimension(preferredSize.x, preferredSize.y));
        PiePlot plot = (PiePlot)pieChart.getPlot();
        plot.setOutlinePaint(null);
        plot.setShadowGenerator(null);
        plot.setDrawingSupplier((DrawingSupplier)new BaseChartDrawingSupplier());
        plot.setBackgroundPaint(pieChart.getBackgroundPaint());
        plot.setLabelBackgroundPaint(pieChart.getBackgroundPaint());
        plot.setLabelLinkStyle(PieLabelLinkStyle.QUAD_CURVE);
        plot.setLabelOutlinePaint(null);
        plot.setLabelShadowPaint(null);
        if (container.getDashboardValueType() == DashboardValueType.bytes) {
            ByteNumberFormat numberFormat = new ByteNumberFormat();
            plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator("{0}: ({1})", (NumberFormat)numberFormat, (NumberFormat)numberFormat));
        }
        DashboardChartComposite chartComposite = this.createChartComposite(composite, container, viewContainer, preferredSize);
        chartComposite.setChart(pieChart);
        return chartComposite;
    }

    public void updateDashboardData(DashboardContainer container, Date lastUpdateTime, DashboardDataset dataset) {
        long secondsPassed;
        DashboardChartComposite chartComposite = this.getChartComposite(container);
        if (chartComposite.isDisposed()) {
            return;
        }
        PiePlot plot = this.getDashboardPlot(container);
        DefaultPieDataset chartDataset = (DefaultPieDataset)plot.getDataset();
        long currentTime = System.currentTimeMillis();
        long l = secondsPassed = lastUpdateTime == null ? 1L : (currentTime - lastUpdateTime.getTime()) / 1000L;
        if (secondsPassed <= 0L) {
            secondsPassed = 1L;
        }
        DashboardDatasetRow lastRow = (DashboardDatasetRow)chartComposite.getData("last_row");
        List rows = dataset.getRows();
        if (rows.isEmpty()) {
            return;
        }
        DashboardDatasetRow row = (DashboardDatasetRow)rows.get(rows.size() - 1);
        String[] srcSeries = dataset.getColumnNames();
        int i = 0;
        while (i < srcSeries.length) {
            String valueName = srcSeries[i];
            Object value = row.getValues()[i];
            if (value instanceof Number) {
                switch (container.getDashboardCalcType()) {
                    case value: {
                        chartDataset.setValue((Comparable)((Object)valueName), (Number)value);
                        break;
                    }
                    case delta: {
                        if (lastRow == null) break;
                        Object prevValue = lastRow.getValues()[i];
                        double deltaValue = ((Number)value).doubleValue() - ((Number)prevValue).doubleValue();
                        chartDataset.setValue((Comparable)((Object)valueName), deltaValue /= (double)secondsPassed);
                    }
                }
            }
            ++i;
        }
        chartComposite.setData("last_row", (Object)row);
    }

    public void resetDashboardData(DashboardContainer container, Date lastUpdateTime) {
        PiePlot plot = this.getDashboardPlot(container);
        if (plot != null) {
            DefaultPieDataset chartDataset = (DefaultPieDataset)plot.getDataset();
            chartDataset.clear();
        }
    }

    public void updateDashboardView(DashboardItem dashboardItem) {
        DashboardChartComposite chartComposite;
        DashboardViewConfiguration viewConfiguration;
        DashboardItemViewConfiguration dashboardConfig;
        PiePlot plot = this.getDashboardPlot((DashboardContainer)dashboardItem);
        if (plot != null && (dashboardConfig = (viewConfiguration = (chartComposite = this.getChartComposite((DashboardContainer)dashboardItem)).getViewContainer().getViewConfiguration()).getDashboardConfig(dashboardItem.getDashboardId())) != null) {
            plot.setLabelLinksVisible(dashboardConfig.isDomainTicksVisible());
            chartComposite.getChart().getLegend().setVisible(dashboardConfig.isLegendVisible());
        }
        dashboardItem.getParent().layout(true, true);
    }

    private PiePlot getDashboardPlot(DashboardContainer container) {
        DashboardChartComposite chartComposite = this.getChartComposite(container);
        JFreeChart chart = chartComposite.getChart();
        return (PiePlot)chart.getPlot();
    }
}

