/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support.security;

import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import com.vertica.support.ObjectWrapper;
import com.vertica.support.security.ICredentialFactory;
import com.vertica.support.security.ICredentials;
import com.vertica.support.security.SimbaAuthenticatedCredentials;
import com.vertica.support.security.SimbaLocalCredentials;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimbaCredentialFactory
implements ICredentialFactory {
    private GSSManager m_gssManager = GSSManager.getInstance();
    private final ILogger m_logger;
    private SimbaLocalCredentials m_acceptorCredentials = null;
    private GSSContext m_remoteContext = null;

    public SimbaCredentialFactory(ILogger iLogger) {
        this.m_logger = iLogger;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public ICredentials getLocalCredentials() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return new SimbaLocalCredentials(this.m_logger, this.m_gssManager, false);
    }

    @Override
    public ICredentials getAuthenticatedCredentials(byte[] byArray, ObjectWrapper<byte[]> objectWrapper) throws Exception {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == byArray) {
            byArray = new byte[]{};
        }
        if (null == this.m_acceptorCredentials) {
            this.m_acceptorCredentials = new SimbaLocalCredentials(this.m_logger, this.m_gssManager, true);
            this.m_remoteContext = this.m_gssManager.createContext(this.m_acceptorCredentials.getCredentialHandle());
            this.m_remoteContext.requestCredDeleg(true);
        }
        objectWrapper.setValue(this.m_remoteContext.acceptSecContext(byArray, 0, byArray.length));
        if (this.m_remoteContext.isEstablished()) {
            return new SimbaAuthenticatedCredentials(this.m_logger, this.m_gssManager, this.m_remoteContext);
        }
        return null;
    }
}

