/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.splittable;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.ext.ora.createtrigger.CreateTriggerGenerator;
import liquibase.ext.ora.createtrigger.CreateTriggerStatement;
import liquibase.ext.ora.droptrigger.DropTriggerGenerator;
import liquibase.ext.ora.droptrigger.DropTriggerStatement;
import liquibase.ext.ora.splittable.SplitTableStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.sqlgenerator.core.AddColumnGenerator;
import liquibase.sqlgenerator.core.AddForeignKeyConstraintGenerator;
import liquibase.sqlgenerator.core.DropColumnGenerator;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddColumnStatement;
import liquibase.statement.core.AddForeignKeyConstraintStatement;
import liquibase.statement.core.DropColumnStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;

public class SplitTableGenerator
extends AbstractSqlGenerator<SplitTableStatement> {
    private String[] columnList;
    boolean isTransition;
    private final List<UnparsedSql> sqlList = new ArrayList<UnparsedSql>();

    public Sql[] generateSql(SplitTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (statement.getContext().equalsIgnoreCase("BASIC_CONTEXT")) {
            this.isTransition = false;
            this.Transition(statement, database, sqlGeneratorChain);
            this.Resulting(statement, database, sqlGeneratorChain);
        } else if (statement.getContext().equalsIgnoreCase("TRANSITION_CONTEXT")) {
            this.isTransition = true;
            this.Transition(statement, database, sqlGeneratorChain);
        } else if (statement.getContext().equalsIgnoreCase("RESULTING_CONTEXT")) {
            this.isTransition = true;
            this.Resulting(statement, database, sqlGeneratorChain);
        }
        Sql[] a = (Sql[])this.sqlList.toArray(new UnparsedSql[this.sqlList.size()]);
        return a;
    }

    public boolean generateStatementsIsVolatile(Database database) {
        return false;
    }

    public boolean generateRollbackStatementsIsVolatile(Database database) {
        return false;
    }

    public boolean supports(SplitTableStatement statement, Database database) {
        return database instanceof OracleDatabase;
    }

    public ValidationErrors validate(SplitTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validation = new ValidationErrors();
        validation.checkRequiredField("splitTableName", (Object)statement.getSplitTableName());
        validation.checkRequiredField("newTableName", (Object)statement.getNewTableName());
        validation.checkRequiredField("primaryKeyColumnName", (Object)statement.getPrimaryKeyColumnName());
        validation.checkRequiredField("columnNameList", (Object)statement.getColumnNameList());
        if (statement.getColumnNameList() != "") {
            this.columnList = statement.getColumnNameList().split(",");
        } else {
            validation.addError("Incorect column list");
        }
        for (String name : this.columnList) {
            if (!name.toUpperCase().equals(statement.getPrimaryKeyColumnName().toUpperCase())) continue;
            statement.setPrimaryKeyColumnName(statement.getPrimaryKeyColumnName() + "_ID");
            break;
        }
        return validation;
    }

    private void Transition(SplitTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sb = new StringBuilder();
        AddForeignKeyConstraintGenerator FKGenerator = new AddForeignKeyConstraintGenerator();
        AddColumnGenerator ColGenerator = new AddColumnGenerator();
        CreateTriggerGenerator trigger = new CreateTriggerGenerator();
        try {
            Connection connection = ((JdbcConnection)database.getConnection()).getWrappedConnection();
            Statement stat = connection.createStatement();
            sb.append("CREATE TABLE " + database.escapeObjectName(statement.getNewTableName(), Table.class) + "(");
            sb.append(statement.getPrimaryKeyColumnName() + " INTEGER,");
            for (String name : this.columnList) {
                ResultSet result = stat.executeQuery("SELECT DATA_TYPE,DATA_LENGTH,DATA_PRECISION, DATA_SCALE FROM USER_TAB_COLS where (COLUMN_NAME='" + name.toUpperCase() + "'and TABLE_NAME='" + statement.getSplitTableName() + "')");
                result.next();
                sb.append(name + " " + result.getString(1));
                if (result.getString(2) != null && result.getString(3) == null) {
                    sb.append("(" + result.getString(2) + ")");
                } else if (result.getString(3) != null) {
                    sb.append("(" + result.getString(3));
                    if (result.getString(4) != null) {
                        sb.append("," + result.getString(4));
                    }
                    sb.append(")");
                } else if (result.getString(4) != null) {
                    sb.append("(" + result.getString(4) + ")");
                }
                sb.append(",");
            }
            sb.append("CONSTRAINT " + statement.getPrimaryKeyColumnName() + "_PK PRIMARY KEY(" + statement.getPrimaryKeyColumnName() + "))");
        }
        catch (SQLException e) {
            System.out.println("wystapil blad: " + e.getMessage());
        }
        this.sqlList.add(new UnparsedSql(sb.toString(), new DatabaseObject[0]));
        AddColumnStatement acs = new AddColumnStatement(null, statement.getSplitTableSchemaName(), statement.getSplitTableName(), statement.getPrimaryKeyColumnName(), "INTEGER", null, new ColumnConstraint[0]);
        this.sqlList.add(new UnparsedSql(ColGenerator.generateSql(acs, database, sqlGeneratorChain)[0].toSql(), new DatabaseObject[0]));
        this.sqlList.add(new UnparsedSql("CREATE SEQUENCE " + statement.getPrimaryKeyColumnName() + "_seq MINVALUE 1 " + "START WITH 1 " + "INCREMENT BY 1 " + "CACHE 20", new DatabaseObject[0]));
        CreateTriggerStatement cts = new CreateTriggerStatement(statement.getNewTableSchemaName(), "sequence_trigger_" + statement.getNewTableName(), "before");
        cts.setReplace(true);
        cts.setTableName(statement.getNewTableName());
        cts.setForEachRow(true);
        cts.setInsert(true);
        StringBuilder procedure = new StringBuilder();
        procedure.append("BEGIN SELECT " + statement.getPrimaryKeyColumnName() + "_seq.nextval into :new." + statement.getPrimaryKeyColumnName());
        procedure.append(" from dual;end;");
        cts.setProcedure(procedure.toString());
        this.sqlList.add(new UnparsedSql(trigger.generateSql(cts, database, sqlGeneratorChain)[0].toSql(), new DatabaseObject[0]));
        this.sqlList.add(new UnparsedSql("INSERT INTO " + statement.getNewTableName() + "(" + statement.getColumnNameList() + ")" + "select distinct " + statement.getColumnNameList() + " from " + statement.getSplitTableName(), new DatabaseObject[0]));
        sb = new StringBuilder();
        sb.append("UPDATE " + statement.getSplitTableName() + " SET " + statement.getPrimaryKeyColumnName() + "=(SELECT ");
        sb.append(statement.getPrimaryKeyColumnName() + " FROM " + statement.getNewTableName() + " WHERE ");
        for (int i = 0; i < this.columnList.length; ++i) {
            sb.append(statement.getNewTableName() + "." + this.columnList[i] + "=" + statement.getSplitTableName() + "." + this.columnList[i]);
            if (i >= this.columnList.length - 1) continue;
            sb.append(" and ");
        }
        sb.append(")");
        this.sqlList.add(new UnparsedSql(sb.toString(), new DatabaseObject[0]));
        this.sqlList.add(new UnparsedSql(FKGenerator.generateSql(new AddForeignKeyConstraintStatement(statement.getPrimaryKeyColumnName() + "_FK", null, statement.getSplitTableSchemaName(), statement.getSplitTableName(), new ColumnConfig[]{new ColumnConfig().setName(statement.getPrimaryKeyColumnName())}, null, statement.getNewTableSchemaName(), statement.getNewTableName(), new ColumnConfig[]{new ColumnConfig().setName(statement.getPrimaryKeyColumnName())}), database, sqlGeneratorChain)[0].toSql(), new DatabaseObject[0]));
        if (this.isTransition) {
            cts = new CreateTriggerStatement(statement.getSplitTableSchemaName(), "before_insert_" + statement.getSplitTableName(), "before");
            cts.setInsert(true);
            cts.setReplace(true);
            cts.setForEachRow(true);
            cts.setTableName(statement.getSplitTableName());
            procedure = new StringBuilder();
            procedure.append("\n DECLARE \n dat integer; \n BEGIN \n IF :NEW." + statement.getPrimaryKeyColumnName() + " IS NOT NULL THEN \n ");
            procedure.append("SELECT " + statement.getColumnNameList() + " INTO ");
            for (String s : this.columnList) {
                procedure.append(":NEW." + s + ",");
            }
            procedure.deleteCharAt(procedure.lastIndexOf(","));
            procedure.append(" FROM " + statement.getNewTableName() + " WHERE :NEW." + statement.getPrimaryKeyColumnName() + "=" + statement.getNewTableName() + "." + statement.getPrimaryKeyColumnName() + "; \n ");
            procedure.append("ELSE \n SELECT " + statement.getPrimaryKeyColumnName() + " INTO dat FROM " + statement.getNewTableName() + " WHERE ");
            for (int i = 0; i < this.columnList.length; ++i) {
                procedure.append(":NEW." + this.columnList[i] + "=" + statement.getNewTableName() + "." + this.columnList[i]);
                if (i >= this.columnList.length - 1) continue;
                procedure.append(" and ");
            }
            procedure.append("; \n ");
            procedure.append(":NEW." + statement.getPrimaryKeyColumnName() + " := dat; \n END IF; \n EXCEPTION \n WHEN NO_DATA_FOUND THEN INSERT INTO ");
            procedure.append(statement.getNewTableName() + "(" + statement.getColumnNameList() + ") VALUES (");
            for (String s : this.columnList) {
                procedure.append(":NEW." + s + ",");
            }
            procedure.deleteCharAt(procedure.lastIndexOf(","));
            procedure.append("); \n SELECT MAX(" + statement.getPrimaryKeyColumnName() + ") INTO :NEW." + statement.getPrimaryKeyColumnName() + " FROM " + statement.getNewTableName() + "; \n ");
            procedure.append("END;");
            cts.setProcedure(procedure.toString());
            this.sqlList.add(new UnparsedSql(trigger.generateSql(cts, database, sqlGeneratorChain)[0].toSql(), new DatabaseObject[0]));
            cts = new CreateTriggerStatement(statement.getSplitTableSchemaName(), "before_update_" + statement.getSplitTableName(), "before");
            cts.setUpdateOf(true);
            cts.setColumnNames(statement.getColumnNameList());
            cts.setReplace(true);
            cts.setForEachRow(true);
            cts.setTableName(statement.getSplitTableName());
            procedure = new StringBuilder();
            procedure.append("\n DECLARE \n dat integer; \n BEGIN \n ");
            procedure.append("SELECT " + statement.getPrimaryKeyColumnName() + " INTO dat FROM " + statement.getNewTableName() + " WHERE ");
            for (int i = 0; i < this.columnList.length; ++i) {
                procedure.append(":NEW." + this.columnList[i] + "=" + statement.getNewTableName() + "." + this.columnList[i]);
                if (i >= this.columnList.length - 1) continue;
                procedure.append(" and ");
            }
            procedure.append("; \n :NEW." + statement.getPrimaryKeyColumnName() + ":=dat; \n ");
            procedure.append("EXCEPTION \n WHEN NO_DATA_FOUND THEN INSERT INTO " + statement.getNewTableName() + "(" + statement.getColumnNameList() + ") VALUES (");
            for (String s : this.columnList) {
                procedure.append(":NEW." + s + ",");
            }
            procedure.deleteCharAt(procedure.lastIndexOf(",")).append("); \n ");
            procedure.append("SELECT MAX(" + statement.getPrimaryKeyColumnName() + ") INTO :NEW." + statement.getPrimaryKeyColumnName() + " FROM " + statement.getNewTableName() + "; \n END;");
            cts.setProcedure(procedure.toString());
            this.sqlList.add(new UnparsedSql(trigger.generateSql(cts, database, sqlGeneratorChain)[0].toSql(), new DatabaseObject[0]));
        }
    }

    private void Resulting(SplitTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        DropTriggerGenerator dto = new DropTriggerGenerator();
        DropTriggerStatement dts = new DropTriggerStatement(statement.getNewTableSchemaName(), "sequence_trigger_" + statement.getNewTableName());
        this.sqlList.add(new UnparsedSql(dto.generateSql(dts, database, sqlGeneratorChain)[0].toSql(), new DatabaseObject[0]));
        if (this.isTransition) {
            dts = new DropTriggerStatement(statement.getSplitTableSchemaName(), "before_insert_" + statement.getSplitTableName());
            this.sqlList.add(new UnparsedSql(dto.generateSql(dts, database, sqlGeneratorChain)[0].toSql(), new DatabaseObject[0]));
            dts = new DropTriggerStatement(statement.getSplitTableSchemaName(), "before_update_" + statement.getSplitTableName());
            this.sqlList.add(new UnparsedSql(dto.generateSql(dts, database, sqlGeneratorChain)[0].toSql(), new DatabaseObject[0]));
        }
        this.sqlList.add(new UnparsedSql("DROP SEQUENCE " + statement.getPrimaryKeyColumnName() + "_seq", new DatabaseObject[0]));
        DropColumnGenerator dcg = new DropColumnGenerator();
        for (String name : this.columnList) {
            DropColumnStatement dcs = new DropColumnStatement(null, statement.getSplitTableSchemaName(), statement.getSplitTableName(), name);
            this.sqlList.add(new UnparsedSql(dcg.generateSql(dcs, database, sqlGeneratorChain)[0].toSql(), new DatabaseObject[0]));
        }
    }

    public boolean requiresUpdatedDatabaseMetadata(Database database) {
        return false;
    }

    public Warnings warn(SplitTableStatement statementType, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return sqlGeneratorChain.warn((SqlStatement)statementType, database);
    }
}

