/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.refreshmaterializedview;

import liquibase.change.AbstractChange;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.refreshmaterializedview.RefreshMaterializedViewStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="refreshMaterializedView", description="Refresh Materialized View", priority=1)
public class RefreshMaterializedViewChange
extends AbstractChange {
    private String schemaName;
    private String viewName;
    private Boolean atomicRefresh;
    private String refreshType;

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getConfirmationMessage() {
        return "Materialized view " + this.getViewName() + " has been refreshed";
    }

    public SqlStatement[] generateStatements(Database database) {
        RefreshMaterializedViewStatement statement = new RefreshMaterializedViewStatement(this.getViewName());
        statement.setSchemaName(this.getSchemaName());
        statement.setAtomicRefresh(this.getAtomicRefresh());
        statement.setRefreshType(this.getRefreshType());
        return new SqlStatement[]{statement};
    }

    public Boolean getAtomicRefresh() {
        return this.atomicRefresh;
    }

    public void setAtomicRefresh(Boolean atomicRefresh) {
        this.atomicRefresh = atomicRefresh;
    }

    public String getRefreshType() {
        return this.refreshType;
    }

    public void setRefreshType(String refreshType) {
        this.refreshType = refreshType;
    }
}

