/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ds;

import java.sql.SQLException;
import javax.naming.BinaryRefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.firebirdsql.ds.DataSourceFactory;
import org.firebirdsql.ds.RootCommonDataSource;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.jdbc.FBConnectionProperties;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;

public abstract class FBAbstractCommonDataSource
extends RootCommonDataSource
implements FirebirdConnectionProperties {
    protected static final String REF_DATABASE_NAME = "databaseName";
    protected static final String REF_PORT_NUMBER = "portNumber";
    protected static final String REF_SERVER_NAME = "serverName";
    protected static final String REF_DESCRIPTION = "description";
    protected static final String REF_PROPERTIES = "properties";
    private String description;
    private String serverName;
    private int portNumber;
    private String databaseName;
    protected final Object lock = new Object();
    private FBConnectionProperties connectionProperties = new FBConnectionProperties();

    protected abstract void checkNotStarted() throws IllegalStateException;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getServerName() {
        Object object = this.lock;
        synchronized (object) {
            return this.serverName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setServerName(String serverName) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.serverName = serverName;
            this.setDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPortNumber() {
        Object object = this.lock;
        synchronized (object) {
            return this.portNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPortNumber(int portNumber) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.portNumber = portNumber;
            this.setDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getDatabaseName() {
        Object object = this.lock;
        synchronized (object) {
            return this.databaseName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDatabaseName(String databaseName) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.databaseName = databaseName;
            this.setDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getType() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setType(String type) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setType(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUser() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getUserName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUser(String user) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setUserName(user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPassword() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getPassword();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPassword(String password) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setPassword(password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRoleName() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getRoleName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRoleName(String roleName) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setRoleName(roleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getCharSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getCharSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setCharSet(String charSet) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setCharSet(charSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getEncoding() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getEncoding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setEncoding(String encoding) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setEncoding(encoding);
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getConnectTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.setConnectTimeout(seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConnectTimeout() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getConnectTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnectTimeout(int connectTimeout) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setConnectTimeout(connectTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public String getDatabase() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setDatabase(String database) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setDatabase(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBlobBufferSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getBlobBufferSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlobBufferSize(int bufferSize) {
        Object object = this.lock;
        synchronized (object) {
            this.connectionProperties.setBlobBufferSize(bufferSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSqlDialect() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getSqlDialect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSqlDialect(String sqlDialect) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setSqlDialect(sqlDialect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUseTranslation() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getUseTranslation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUseTranslation(String translationPath) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setUseTranslation(translationPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUseStreamBlobs() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.isUseStreamBlobs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUseStreamBlobs(boolean useStreamBlobs) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setUseStreamBlobs(useStreamBlobs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUseStandardUdf() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.isUseStandardUdf();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUseStandardUdf(boolean useStandardUdf) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setUseStandardUdf(useStandardUdf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSocketBufferSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getSocketBufferSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSocketBufferSize(int socketBufferSize) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setSocketBufferSize(socketBufferSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTimestampUsesLocalTimezone() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.isTimestampUsesLocalTimezone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestampUsesLocalTimezone(boolean timestampUsesLocalTimezone) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setTimestampUsesLocalTimezone(timestampUsesLocalTimezone);
        }
    }

    @Override
    @Deprecated
    public String getUserName() {
        return this.getUser();
    }

    @Override
    @Deprecated
    public void setUserName(String userName) {
        this.setUser(userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBuffersNumber() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getBuffersNumber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBuffersNumber(int buffersNumber) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setBuffersNumber(buffersNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseParameterBuffer getDatabaseParameterBuffer() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getDatabaseParameterBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTpbMapping() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getTpbMapping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTpbMapping(String tpbMapping) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setTpbMapping(tpbMapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDefaultTransactionIsolation() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getDefaultTransactionIsolation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultTransactionIsolation(int defaultIsolationLevel) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setDefaultTransactionIsolation(defaultIsolationLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultIsolation() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getDefaultIsolation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultIsolation(String isolation) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setDefaultIsolation(isolation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getTransactionParameters(isolation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionParameters(int isolation, TransactionParameterBuffer tpb) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setTransactionParameters(isolation, tpb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDefaultResultSetHoldable() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.isDefaultResultSetHoldable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultResultSetHoldable(boolean isHoldable) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setDefaultResultSetHoldable(isHoldable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSoTimeout() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getSoTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSoTimeout(int soTimeout) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setSoTimeout(soTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUseFirebirdAutocommit() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.isUseFirebirdAutocommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUseFirebirdAutocommit(boolean useFirebirdAutocommit) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setUseFirebirdAutocommit(useFirebirdAutocommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setNonStandardProperty(String propertyMapping) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setNonStandardProperty(propertyMapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setNonStandardProperty(String key, String value) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setNonStandardProperty(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getNonStandardProperty(String key) {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getNonStandardProperty(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setDatabase() {
        Object object = this.lock;
        synchronized (object) {
            StringBuilder sb = new StringBuilder();
            if (this.serverName != null && this.serverName.length() > 0) {
                sb.append("//").append(this.serverName);
                if (this.portNumber > 0) {
                    sb.append(':').append(this.portNumber);
                }
                sb.append('/');
            }
            if (this.databaseName != null) {
                sb.append(this.databaseName);
            }
            if (sb.length() > 0) {
                this.connectionProperties.setDatabase(sb.toString());
            } else {
                this.connectionProperties.setDatabase(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setConnectionProperties(FBConnectionProperties connectionProperties) {
        Object object = this.lock;
        synchronized (object) {
            if (connectionProperties == null) {
                throw new NullPointerException("null value not allowed for connectionProperties");
            }
            this.connectionProperties = connectionProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final FBConnectionProperties getConnectionProperties() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void updateReference(Reference ref, FBAbstractCommonDataSource instance) {
        Object object = instance.lock;
        synchronized (object) {
            ref.add(new StringRefAddr(REF_DESCRIPTION, instance.getDescription()));
            ref.add(new StringRefAddr(REF_SERVER_NAME, instance.getServerName()));
            if (instance.getPortNumber() != 0) {
                ref.add(new StringRefAddr(REF_PORT_NUMBER, Integer.toString(instance.getPortNumber())));
            }
            ref.add(new StringRefAddr(REF_DATABASE_NAME, instance.getDatabaseName()));
            byte[] data = DataSourceFactory.serialize(instance.connectionProperties);
            ref.add(new BinaryRefAddr(REF_PROPERTIES, data));
        }
    }
}

