/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.atomic.AtomicInteger;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.IntIndex;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.persist.BitMapCachedObject;
import org.hsqldb.persist.BlockObjectStore;
import org.hsqldb.persist.CachedObjectBase;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.DirectoryBlockCachedObject;
import org.hsqldb.persist.IntArrayCachedObject;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.persist.TableSpaceManagerBlocks;

public class DataSpaceManagerBlocks
implements DataSpaceManager {
    final DataFileCache cache;
    final TableSpaceManagerBlocks defaultSpaceManager;
    final TableSpaceManagerBlocks directorySpaceManager;
    final IntKeyHashMap spaceManagerList;
    final BlockObjectStore rootStore;
    final BlockObjectStore directoryStore;
    final BlockObjectStore bitMapStore;
    IntArrayCachedObject rootBlock;
    final AtomicInteger spaceIdSequence = new AtomicInteger(8);
    final IntIndex emptySpaceList;
    int released = 0;
    public static final int dirBlockSize = 2048;
    public static final int fileBlockItemCountLimit = 65536;
    final int bitmapIntSize;
    final int bitmapStorageSize;
    final int fileBlockItemCount;
    final int fileBlockSize;
    final int dataFileScale;
    BlockAccessor ba;

    public DataSpaceManagerBlocks(DataFileCache dataFileCache) {
        this.cache = dataFileCache;
        this.dataFileScale = this.cache.getDataFileScale();
        this.fileBlockSize = this.cache.database.logger.getDataFileSpaces() * 1024 * 1024;
        this.fileBlockItemCount = this.fileBlockSize / this.dataFileScale;
        this.bitmapIntSize = this.fileBlockItemCount / 32;
        int n = 4 * this.bitmapIntSize;
        if (n < 4096) {
            n = 4096;
        }
        this.bitmapStorageSize = n;
        this.ba = new BlockAccessor();
        this.spaceManagerList = new IntKeyHashMap();
        this.emptySpaceList = new IntIndex(32, false);
        this.directorySpaceManager = new TableSpaceManagerBlocks(this, 1, this.fileBlockSize, 16, this.dataFileScale, 0);
        this.defaultSpaceManager = new TableSpaceManagerBlocks(this, 7, this.fileBlockSize, this.cache.database.logger.propMaxFreeBlocks, this.dataFileScale, this.cache.database.logger.propMinReuse);
        this.spaceManagerList.put(1, this.directorySpaceManager);
        this.spaceManagerList.put(7, this.defaultSpaceManager);
        this.rootStore = new BlockObjectStore(this.cache, this.directorySpaceManager, IntArrayCachedObject.class, 8192, 2048);
        this.directoryStore = new BlockObjectStore(this.cache, this.directorySpaceManager, DirectoryBlockCachedObject.class, 24576, 2048);
        this.bitMapStore = new BlockObjectStore(this.cache, this.directorySpaceManager, BitMapCachedObject.class, this.bitmapStorageSize, this.bitmapIntSize);
        if (this.cache.spaceManagerPosition == 0L) {
            this.initialiseNewSpaceDirectory();
            this.cache.spaceManagerPosition = this.rootBlock.getPos() * (long)this.dataFileScale;
        } else {
            long l = this.cache.spaceManagerPosition / (long)this.dataFileScale;
            this.rootBlock = (IntArrayCachedObject)this.rootStore.get(l, true);
            if (this.getBlockIndexLimit() == 0) {
                throw Error.error(452);
            }
            this.initialiseSpaceList();
            this.initialiseTableSpace(this.directorySpaceManager);
            this.initialiseTableSpace(this.defaultSpaceManager);
        }
    }

    private void initialiseNewSpaceDirectory() {
        long l = this.cache.getFileFreePos();
        long l2 = l / (long)this.fileBlockSize + 1L;
        long l3 = this.cache.enlargeFileSpace(l2 * (long)this.fileBlockSize - l);
        this.defaultSpaceManager.initialiseFileBlock(null, l3, this.cache.getFileFreePos());
        long l4 = l2;
        long l5 = this.calculateDirectorySpaceBlocks(l2);
        l3 = this.cache.enlargeFileSpace(l5 * (long)this.fileBlockSize);
        this.directorySpaceManager.initialiseFileBlock(null, l3, this.cache.getFileFreePos());
        IntArrayCachedObject intArrayCachedObject = new IntArrayCachedObject(2048);
        this.rootStore.add(intArrayCachedObject, true);
        this.rootBlock = intArrayCachedObject;
        this.createFileBlocksInDirectory((int)l4, (int)l5, 1);
        this.createFileBlocksInDirectory(0, (int)l4, 7);
    }

    private long calculateDirectorySpaceBlocks(long l) {
        long l2 = this.calculateDirectorySpaceSize(l);
        long l3 = l2 / (long)this.fileBlockSize + 1L;
        l2 += this.calculateDirectorySpaceSize(l3);
        l3 = l2 / (long)this.fileBlockSize + 1L;
        return l3;
    }

    private long calculateDirectorySpaceSize(long l) {
        long l2 = ArrayUtil.getBinaryMultipleCeiling(l + 1L, 2048L);
        long l3 = 4L * l2;
        l3 += 12L * l2;
        return l3 += (long)this.bitmapStorageSize * (l + 1L);
    }

    private void ensureDirectorySpaceAvailable(int n) {
        int n2 = this.bitmapStorageSize * n;
        boolean bl = this.directorySpaceManager.hasFileRoom(n2 += 24576);
        if (!bl) {
            int n3 = this.getBlockIndexLimit();
            int n4 = n2 / this.fileBlockSize + 1;
            long l = this.cache.enlargeFileSpace((long)n4 * (long)this.fileBlockSize);
            this.directorySpaceManager.addFileBlock(l, l + (long)n4 * (long)this.fileBlockSize);
            this.createFileBlocksInDirectory(n3, n4, 1);
            n3 = this.getBlockIndexLimit();
            if ((long)n3 * (long)this.fileBlockSize != this.cache.getFileFreePos()) {
                this.cache.logSevereEvent("space manager end file pos different from data file: " + n3 * this.fileBlockSize + ", " + this.cache.getFileFreePos(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFileBlocks(int n, int n2) {
        this.cache.writeLock.lock();
        try {
            long l = this.getExistingBlockIndex(n, n2);
            if (l > 0L) {
                long l2 = l * (long)this.fileBlockSize;
                return l2;
            }
            long l3 = this.getNewFileBlocks(n, n2);
            return l3;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    private long getNewFileBlocks(int n, int n2) {
        this.ensureDirectorySpaceAvailable(n2);
        return this.getNewFileBlocksNoCheck(n, n2);
    }

    private long getNewFileBlocksNoCheck(int n, int n2) {
        long l = this.getBlockIndexLimit();
        long l2 = l * (long)this.fileBlockSize;
        long l3 = l2 + (long)n2 * (long)this.fileBlockSize - this.cache.getFileFreePos();
        if (l3 > 0L) {
            this.cache.enlargeFileSpace(l3);
        }
        this.createFileBlocksInDirectory((int)l, n2, n);
        return l2;
    }

    private void createFileBlocksInDirectory(int n, int n2, int n3) {
        for (int i = 0; i < n2; ++i) {
            this.createFileBlockInDirectory(n + i, n3);
        }
    }

    private void createFileBlockInDirectory(int n, int n2) {
        BitMapCachedObject bitMapCachedObject = new BitMapCachedObject(this.bitmapIntSize);
        this.bitMapStore.add(bitMapCachedObject, false);
        int n3 = (int)(bitMapCachedObject.getPos() * (long)this.dataFileScale / 4096L);
        int n4 = n % 2048;
        DirectoryBlockCachedObject directoryBlockCachedObject = this.getDirectory(n, true);
        if (directoryBlockCachedObject == null) {
            this.createDirectory(n);
            directoryBlockCachedObject = this.getDirectory(n, true);
        }
        directoryBlockCachedObject.getTableIdArray()[n4] = n2;
        directoryBlockCachedObject.getBitmapAddressArray()[n4] = n3;
        directoryBlockCachedObject.setChanged(true);
        directoryBlockCachedObject.keepInMemory(false);
    }

    private DirectoryBlockCachedObject getDirectory(int n, boolean bl) {
        int n2 = n / 2048;
        long l = this.rootBlock.getIntArray()[n2];
        if (l == 0L) {
            return null;
        }
        DirectoryBlockCachedObject directoryBlockCachedObject = (DirectoryBlockCachedObject)this.directoryStore.get(l *= (long)(4096 / this.dataFileScale), bl);
        return directoryBlockCachedObject;
    }

    private void createDirectory(int n) {
        int n2;
        DirectoryBlockCachedObject directoryBlockCachedObject = new DirectoryBlockCachedObject(2048);
        this.directoryStore.add(directoryBlockCachedObject, false);
        int n3 = n / 2048;
        this.rootBlock.getIntArray()[n3] = n2 = (int)(directoryBlockCachedObject.getPos() * (long)this.dataFileScale / 4096L);
        this.rootBlock.setChanged(true);
    }

    private int getBlockIndexLimit() {
        int n;
        int n2;
        int[] nArray = this.rootBlock.getIntArray();
        for (n2 = 0; n2 < nArray.length && nArray[n2] != 0; ++n2) {
        }
        if (n2 == 0) {
            return 0;
        }
        long l = nArray[--n2];
        DirectoryBlockCachedObject directoryBlockCachedObject = (DirectoryBlockCachedObject)this.directoryStore.get(l *= (long)(4096 / this.dataFileScale), false);
        int[] nArray2 = directoryBlockCachedObject.getBitmapAddressArray();
        for (n = 0; n < nArray2.length && nArray2[n] != 0; ++n) {
        }
        return n2 * 2048 + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseSpaceList() {
        int n = 7;
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        this.ba.initialise(false);
        try {
            boolean bl;
            while (bl = this.ba.nextBlock()) {
                int n2 = this.ba.getTableId();
                if (n2 > n) {
                    n = n2;
                }
                if (n2 != 0) continue;
                char c = this.ba.getFreeSpaceValue();
                char c2 = this.ba.getFreeBlockValue();
                if (c == '\u0000' && c2 == '\u0000') {
                    this.emptySpaceList.addUnique(this.ba.currentBlockIndex);
                    continue;
                }
                orderedIntHashSet.add(this.ba.currentBlockIndex);
            }
        }
        finally {
            this.ba.reset();
        }
        this.spaceIdSequence.set(n + 2 & 0xFFFFFFFE);
        if (orderedIntHashSet.size() > 0) {
            this.setAsideBlocks(orderedIntHashSet);
            String string = "space manager error - recovered (freeItems in empty blocks) : (" + orderedIntHashSet.size() + ")";
            this.cache.logSevereEvent(string, null);
        }
    }

    private int getExistingBlockIndex(int n, int n2) {
        int n3 = this.emptySpaceList.removeFirstConsecutiveKeys(n2, -1);
        if (n3 > 0) {
            this.setDirectoryBlocksAsTable(n, n3, n2);
        }
        return n3;
    }

    private void setDirectoryBlocksAsTable(int n, int n2, int n3) {
        int n4 = -1;
        CachedObjectBase cachedObjectBase = null;
        for (int i = n2; i < n2 + n3; ++i) {
            if (n4 != i / 2048) {
                if (cachedObjectBase != null) {
                    cachedObjectBase.keepInMemory(false);
                }
                cachedObjectBase = this.getDirectory(i, true);
                n4 = i / 2048;
            }
            int n5 = i % 2048;
            ((DirectoryBlockCachedObject)cachedObjectBase).getTableIdArray()[n5] = n;
            cachedObjectBase.setChanged(true);
        }
        cachedObjectBase.keepInMemory(false);
    }

    @Override
    public TableSpaceManager getDefaultTableSpace() {
        return this.defaultSpaceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableSpaceManager getTableSpace(int n) {
        if (n == 7) {
            return this.defaultSpaceManager;
        }
        if (n >= this.spaceIdSequence.get()) {
            this.spaceIdSequence.set(n + 2 & 0xFFFFFFFE);
        }
        this.cache.writeLock.lock();
        try {
            TableSpaceManagerBlocks tableSpaceManagerBlocks = (TableSpaceManagerBlocks)this.spaceManagerList.get(n);
            if (tableSpaceManagerBlocks == null) {
                int n2 = this.cache.database.logger.propMinReuse;
                tableSpaceManagerBlocks = new TableSpaceManagerBlocks(this, n, this.fileBlockSize, this.cache.database.logger.propMaxFreeBlocks, this.dataFileScale, n2);
                this.spaceManagerList.put(n, tableSpaceManagerBlocks);
            }
            TableSpaceManagerBlocks tableSpaceManagerBlocks2 = tableSpaceManagerBlocks;
            return tableSpaceManagerBlocks2;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public int getNewTableSpaceID() {
        return this.spaceIdSequence.getAndAdd(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTableSpace(int n) {
        if (n == 7 || n == 1) {
            return;
        }
        this.cache.writeLock.lock();
        try {
            TableSpaceManager tableSpaceManager = (TableSpaceManager)this.spaceManagerList.get(n);
            if (tableSpaceManager != null) {
                tableSpaceManager.reset();
                this.spaceManagerList.remove(n);
            }
            IntIndex intIndex = new IntIndex(16, false);
            this.ba.initialise(true);
            try {
                while (this.ba.nextBlockForTable(n)) {
                    intIndex.addUnsorted(this.ba.currentBlockIndex);
                    this.ba.setTable(0);
                    this.emptySpaceList.addUnique(this.ba.currentBlockIndex);
                }
            }
            finally {
                this.ba.reset();
            }
            this.cache.releaseRange(intIndex, this.fileBlockItemCount);
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTableSpace(int n, DoubleIntIndex doubleIntIndex, long l, long l2, boolean bl) {
        int n2;
        if (doubleIntIndex.size() == 0 && l == l2) {
            return;
        }
        doubleIntIndex.compactLookupAsIntervals();
        if (!bl && (n2 = doubleIntIndex.capacity() - doubleIntIndex.size()) > doubleIntIndex.capacity() / 4) {
            doubleIntIndex.setValuesSearchTarget();
            doubleIntIndex.sort();
            return;
        }
        this.cache.writeLock.lock();
        try {
            this.ba.initialise(true);
            try {
                int n3;
                int[] nArray = doubleIntIndex.getKeys();
                int[] nArray2 = doubleIntIndex.getValues();
                for (int i = 0; i < doubleIntIndex.size(); ++i) {
                    int n4 = nArray[i];
                    n3 = nArray2[i];
                    this.freeTableSpacePart(n4, n3);
                }
                long l3 = l / (long)this.dataFileScale;
                n3 = (int)((l2 - l) / (long)this.dataFileScale);
                this.freeTableSpacePart(l3, n3);
            }
            finally {
                this.ba.reset();
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
        doubleIntIndex.clear();
        doubleIntIndex.setValuesSearchTarget();
    }

    private void freeTableSpacePart(long l, int n) {
        while (n > 0) {
            boolean bl;
            int n2 = (int)(l / (long)this.fileBlockItemCount);
            int n3 = (int)(l % (long)this.fileBlockItemCount);
            int n4 = this.fileBlockItemCount - n3;
            if (n4 > n) {
                n4 = n;
            }
            if (bl = this.ba.moveToBlock(n2)) {
                int n5 = this.ba.setRange(n3, n4);
                if (n5 != n4) {
                    this.ba.unsetRange(n3, n4);
                    String string = "space manager error - recovered (block, offset, units) : (" + n2 + "," + n3 + "," + n + ")";
                    this.cache.logSevereEvent(string, null);
                }
            } else {
                String string = "space manager error - recovered (block, offset, units) : (" + n2 + "," + n3 + "," + n + ")";
                this.cache.logSevereEvent(string, null);
            }
            n -= n4;
            l += (long)n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findTableSpace(long l) {
        int n = (int)(l / (long)this.fileBlockItemCount);
        this.cache.writeLock.lock();
        try {
            int n2;
            block8: {
                this.ba.initialise(false);
                try {
                    boolean bl = this.ba.moveToBlock(n);
                    if (bl) break block8;
                    int n3 = -1;
                    this.ba.reset();
                    return n3;
                }
                catch (Throwable throwable) {
                    this.ba.reset();
                    throw throwable;
                }
            }
            int n4 = n2 = this.ba.getTableId();
            this.ba.reset();
            return n4;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAsideBlocks(OrderedIntHashSet orderedIntHashSet) {
        this.cache.writeLock.lock();
        try {
            this.ba.initialise(true);
            try {
                for (int i = 0; i < orderedIntHashSet.size(); ++i) {
                    int n = orderedIntHashSet.get(i);
                    boolean bl = this.ba.moveToBlock(n);
                    if (!bl) continue;
                    this.ba.setTable(6);
                }
            }
            finally {
                this.ba.reset();
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLostBlocksSize() {
        long l = 0L;
        this.cache.writeLock.lock();
        try {
            this.ba.initialise(false);
            try {
                boolean bl;
                while (bl = this.ba.nextBlock()) {
                    if (this.ba.getTableId() == 1) continue;
                    l += (long)(this.ba.getFreeSpaceValue() * this.dataFileScale);
                    if (this.ba.getTableId() != 0) continue;
                    l += (long)this.fileBlockSize;
                }
            }
            finally {
                this.ba.reset();
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
        return l;
    }

    @Override
    public int getFileBlockSize() {
        return this.fileBlockSize;
    }

    @Override
    public boolean isModified() {
        return true;
    }

    @Override
    public void initialiseSpaces() {
        this.cache.writeLock.lock();
        try {
            Iterator iterator = this.spaceManagerList.values().iterator();
            while (iterator.hasNext()) {
                TableSpaceManagerBlocks tableSpaceManagerBlocks = (TableSpaceManagerBlocks)iterator.next();
                if (tableSpaceManagerBlocks.getSpaceID() != 1 && tableSpaceManagerBlocks.getFileBlockIndex() == -1) continue;
                this.initialiseTableSpace(tableSpaceManagerBlocks);
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public void reset() {
        this.cache.writeLock.lock();
        try {
            Iterator iterator = this.spaceManagerList.values().iterator();
            while (iterator.hasNext()) {
                TableSpaceManagerBlocks tableSpaceManagerBlocks = (TableSpaceManagerBlocks)iterator.next();
                tableSpaceManagerBlocks.reset();
            }
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public boolean isMultiSpace() {
        return true;
    }

    @Override
    public int getFileBlockItemCount() {
        return this.fileBlockItemCount;
    }

    @Override
    public DirectoryBlockCachedObject[] getDirectoryList() {
        int n = 0;
        int[] nArray = this.rootBlock.getIntArray();
        while (nArray[n] != 0) {
            ++n;
        }
        DirectoryBlockCachedObject[] directoryBlockCachedObjectArray = new DirectoryBlockCachedObject[n];
        for (int i = 0; i < directoryBlockCachedObjectArray.length; ++i) {
            directoryBlockCachedObjectArray[i] = this.getDirectory(i * 2048, false);
        }
        return directoryBlockCachedObjectArray;
    }

    DoubleIntIndex checkDirectorySpaces() {
        DirectoryBlockCachedObject[] directoryBlockCachedObjectArray = this.getDirectoryList();
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(8, false);
        doubleIntIndex.setKeysSearchTarget();
        DoubleIntIndex doubleIntIndex2 = new DoubleIntIndex(8, false);
        doubleIntIndex2.setKeysSearchTarget();
        for (int i = 0; i < directoryBlockCachedObjectArray.length; ++i) {
            boolean bl;
            int n;
            DirectoryBlockCachedObject directoryBlockCachedObject = directoryBlockCachedObjectArray[i];
            long l = directoryBlockCachedObject.getPos();
            int n2 = this.findTableSpace(l);
            int n3 = i;
            int n4 = this.rootBlock.getIntArray()[n3];
            int n5 = directoryBlockCachedObject.getStorageSize() / 4096;
            for (n = 0; n < n5; ++n) {
                bl = doubleIntIndex2.addUnique(n4, n3);
            }
            for (n = 0; n < directoryBlockCachedObject.bitmapAddress.length && (n4 = directoryBlockCachedObject.bitmapAddress[n]) != 0; ++n) {
                l = n4 * (4096 / this.dataFileScale);
                n2 = this.findTableSpace(l);
                n3 = i * 2048 + n;
                if (n2 != 1) {
                    doubleIntIndex.add(n3, n2);
                    continue;
                }
                bl = doubleIntIndex2.addUnique(n4, n3);
                if (bl) continue;
                doubleIntIndex.add(n3, n2);
                int n6 = doubleIntIndex2.findFirstEqualKeyIndex(n4);
                n3 = doubleIntIndex2.getValue(n6);
                doubleIntIndex.add(n3, n2);
            }
        }
        return doubleIntIndex;
    }

    DoubleIntIndex checkDirectoryBitmaps(DirectoryBlockCachedObject directoryBlockCachedObject) {
        DirectoryBlockCachedObject[] directoryBlockCachedObjectArray = this.getDirectoryList();
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(8, false);
        doubleIntIndex.setKeysSearchTarget();
        int n = 0;
        block0: for (int i = 0; i < directoryBlockCachedObjectArray.length; ++i) {
            int n2;
            DirectoryBlockCachedObject directoryBlockCachedObject2 = directoryBlockCachedObjectArray[i];
            for (int j = 0; j < directoryBlockCachedObject2.bitmapAddress.length && (n2 = directoryBlockCachedObject2.bitmapAddress[j]) != 0; ++j) {
                long l = n2 * (4096 / this.dataFileScale);
                int n3 = this.findTableSpace(l);
                int n4 = i * 2048 + j;
                BitMapCachedObject bitMapCachedObject = (BitMapCachedObject)this.bitMapStore.get(l, false);
                n3 = directoryBlockCachedObject2.tableIds[j];
                int n5 = bitMapCachedObject.bitMap.countSetBits();
                int n6 = bitMapCachedObject.bitMap.countSetBitsEnd();
                if (directoryBlockCachedObject2.freeSpace[j] == n5 && directoryBlockCachedObject2.freeSpaceBlock[j] == n6) continue;
                doubleIntIndex.add(n4, n3);
                directoryBlockCachedObject.getTableIdArray()[n] = n3;
                directoryBlockCachedObject.getFreeSpaceArray()[n] = (char)n5;
                directoryBlockCachedObject.getFreeBlockArray()[n] = (char)n6;
                if (++n == directoryBlockCachedObject.getTableIdArray().length) continue block0;
            }
        }
        return doubleIntIndex;
    }

    private void initialiseTableSpace(TableSpaceManagerBlocks tableSpaceManagerBlocks) {
        int n = tableSpaceManagerBlocks.getSpaceID();
        int n2 = -1;
        int n3 = tableSpaceManagerBlocks.getFileBlockIndex();
        if (n3 >= 0 && this.hasFreeSpace(n, n3)) {
            n2 = n3;
        }
        if (n2 < 0) {
            n2 = this.findLargestFreeSpace(n);
        }
        if (n2 < 0) {
            return;
        }
        this.initialiseTableSpace(tableSpaceManagerBlocks, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasFreeSpace(int n, int n2) {
        this.ba.initialise(false);
        try {
            boolean bl = this.ba.moveToBlock(n2);
            if (bl && this.ba.getTableId() == n && this.ba.getFreeBlockValue() > '\u0000') {
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.ba.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findLargestFreeSpace(int n) {
        int n2 = 0;
        int n3 = -1;
        this.ba.initialise(false);
        try {
            int n4;
            while (this.ba.nextBlockForTable(n)) {
                n4 = this.ba.getFreeBlockValue();
                if (n4 <= n2) continue;
                n3 = this.ba.currentBlockIndex;
                n2 = n4;
            }
            n4 = n3;
            return n4;
        }
        finally {
            this.ba.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseTableSpace(TableSpaceManagerBlocks tableSpaceManagerBlocks, int n) {
        this.ba.initialise(true);
        try {
            this.ba.moveToBlock(n);
            char c = this.ba.getFreeBlockValue();
            long l = (long)n * (long)this.fileBlockSize;
            int n2 = this.ba.unsetRange(this.fileBlockItemCount - c, c);
            if (n2 == c) {
                tableSpaceManagerBlocks.initialiseFileBlock(null, l + (long)(this.fileBlockSize - c * this.dataFileScale), l + (long)this.fileBlockSize);
            } else {
                this.cache.logSevereEvent("space manager error - recovered", null);
            }
        }
        finally {
            this.ba.reset();
        }
    }

    private class BlockAccessor {
        boolean currentKeep;
        int currentBlockIndex = -1;
        int currentDirIndex = -1;
        int currentBlockOffset = -1;
        DirectoryBlockCachedObject currentDir = null;
        BitMapCachedObject currentBitMap = null;

        private BlockAccessor() {
        }

        void initialise(boolean bl) {
            this.currentKeep = bl;
        }

        boolean nextBlock() {
            boolean bl = this.moveToBlock(this.currentBlockIndex + 1);
            return bl;
        }

        boolean nextBlockForTable(int n) {
            do {
                boolean bl;
                if (bl = this.moveToBlock(this.currentBlockIndex + 1)) continue;
                return false;
            } while (this.getTableId() != n);
            return true;
        }

        boolean moveToBlock(int n) {
            if (this.currentBlockIndex != n) {
                this.endBlockUpdate();
                this.currentBitMap = null;
                if (this.currentDirIndex != n / 2048) {
                    this.reset();
                    this.currentDirIndex = n / 2048;
                    this.currentDir = DataSpaceManagerBlocks.this.getDirectory(n, this.currentKeep);
                }
                if (this.currentDir == null) {
                    this.reset();
                    return false;
                }
                this.currentBlockIndex = n;
                this.currentBlockOffset = n % 2048;
                long l = this.currentDir.getBitmapAddressArray()[this.currentBlockOffset];
                if (l == 0L) {
                    this.reset();
                    return false;
                }
                if (this.currentKeep) {
                    this.currentBitMap = (BitMapCachedObject)DataSpaceManagerBlocks.this.bitMapStore.get(l *= (long)(4096 / DataSpaceManagerBlocks.this.dataFileScale), true);
                }
            }
            return true;
        }

        int setRange(int n, int n2) {
            this.currentBitMap.setChanged(true);
            return this.currentBitMap.bitMap.setRange(n, n2);
        }

        int unsetRange(int n, int n2) {
            this.currentBitMap.setChanged(true);
            return this.currentBitMap.bitMap.unsetRange(n, n2);
        }

        void reset() {
            this.endBlockUpdate();
            if (this.currentDir != null && this.currentKeep) {
                this.currentDir.keepInMemory(false);
            }
            this.currentBlockIndex = -1;
            this.currentDirIndex = -1;
            this.currentBlockOffset = -1;
            this.currentDir = null;
            this.currentBitMap = null;
        }

        private void endBlockUpdate() {
            if (this.currentBitMap == null) {
                return;
            }
            if (!this.currentBitMap.hasChanged()) {
                this.currentBitMap.keepInMemory(false);
                return;
            }
            int n = this.currentBitMap.bitMap.countSetBits();
            int n2 = this.currentBitMap.bitMap.countSetBitsEnd();
            if (n == DataSpaceManagerBlocks.this.fileBlockItemCount) {
                int n3 = this.currentDir.getTableIdArray()[this.currentBlockOffset];
                if (n3 != 6) {
                    this.setTable(0);
                    DataSpaceManagerBlocks.this.emptySpaceList.addUnique(this.currentBlockIndex);
                    ++DataSpaceManagerBlocks.this.released;
                }
                this.currentBitMap.keepInMemory(false);
                return;
            }
            this.currentBitMap.keepInMemory(false);
            this.currentDir.getFreeSpaceArray()[this.currentBlockOffset] = (char)n;
            this.currentDir.getFreeBlockArray()[this.currentBlockOffset] = (char)n2;
            this.currentDir.setChanged(true);
        }

        void setTable(int n) {
            this.currentDir.getTableIdArray()[this.currentBlockOffset] = n;
            this.currentDir.getFreeSpaceArray()[this.currentBlockOffset] = '\u0000';
            this.currentDir.getFreeBlockArray()[this.currentBlockOffset] = '\u0000';
            this.currentDir.setChanged(true);
            this.currentBitMap.bitMap.reset();
            this.currentBitMap.setChanged(true);
        }

        int getTableId() {
            return this.currentDir.getTableIdArray()[this.currentBlockOffset];
        }

        char getFreeSpaceValue() {
            return this.currentDir.getFreeSpaceArray()[this.currentBlockOffset];
        }

        char getFreeBlockValue() {
            return this.currentDir.getFreeBlockArray()[this.currentBlockOffset];
        }
    }
}

