/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.Row;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableUtil;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.navigator.RowSetNavigatorDataTable;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class TableDerived
extends Table {
    public static final TableDerived[] emptyArray = new TableDerived[0];
    QueryExpression queryExpression;
    Expression dataExpression;
    boolean uniqueRows;
    boolean uniquePredicate;
    String sql;
    View view;
    int depth;
    boolean canRecompile = false;

    public TableDerived(Database database, HsqlNameManager.HsqlName hsqlName, int n) {
        super(database, hsqlName, n);
        switch (n) {
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "Table");
            }
        }
    }

    public TableDerived(Database database, HsqlNameManager.HsqlName hsqlName, int n, Type[] typeArray, HashMappedList hashMappedList, int[] nArray) {
        this(database, hsqlName, n);
        this.colTypes = typeArray;
        this.columnList = hashMappedList;
        this.columnCount = hashMappedList.size();
        this.createPrimaryKey(null, nArray, true);
    }

    public TableDerived(Database database, HsqlNameManager.HsqlName hsqlName, int n, QueryExpression queryExpression, Expression expression, int n2, int n3) {
        super(database, hsqlName, n);
        switch (n) {
            case 2: 
            case 8: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "Table");
            }
        }
        this.queryExpression = queryExpression;
        this.dataExpression = expression;
        this.depth = n3;
        switch (n2) {
            case 55: {
                queryExpression.setSingleRow();
                break;
            }
            case 54: {
                if (queryExpression != null) {
                    queryExpression.setFullOrder();
                }
                this.uniqueRows = true;
                break;
            }
            case 63: {
                queryExpression.setFullOrder();
                this.uniquePredicate = true;
                break;
            }
            case 65: {
                queryExpression.setFullOrder();
                break;
            }
        }
        if (expression != null) {
            expression.table = this;
        }
    }

    public TableDerived newDerivedTable(Session session) {
        TableDerived tableDerived = this;
        if (this.isRecompiled()) {
            ParserDQL parserDQL = new ParserDQL(session, new Scanner(), session.parser.compileContext);
            parserDQL.reset(session, this.sql);
            parserDQL.read();
            parserDQL.compileContext.setCurrentSubquery(this.tableName.name);
            tableDerived = parserDQL.XreadSubqueryTableBody(this.tableName, 23);
            tableDerived.queryExpression.resolve(session, parserDQL.compileContext.getOuterRanges(), null);
            tableDerived.columnList = this.columnList;
            tableDerived.columnCount = this.columnList.size();
            tableDerived.triggerList = this.triggerList;
            tableDerived.triggerLists = this.triggerLists;
            tableDerived.view = this.view;
            tableDerived.createPrimaryKey();
        }
        return tableDerived;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public boolean isQueryBased() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean isInsertable() {
        if (this.view != null && this.view.isTriggerInsertable) {
            return false;
        }
        return this.queryExpression == null ? false : this.queryExpression.isInsertable();
    }

    @Override
    public boolean isUpdatable() {
        if (this.view != null && this.view.isTriggerUpdatable) {
            return false;
        }
        return this.queryExpression == null ? false : this.queryExpression.isUpdatable();
    }

    @Override
    public int[] getUpdatableColumns() {
        if (this.queryExpression != null) {
            return this.queryExpression.getBaseTableColumnMap();
        }
        return this.defaultColumnMap;
    }

    @Override
    public boolean isTriggerInsertable() {
        if (this.view != null) {
            return this.view.isTriggerInsertable;
        }
        return false;
    }

    @Override
    public boolean isTriggerUpdatable() {
        if (this.view != null) {
            return this.view.isTriggerUpdatable;
        }
        return false;
    }

    @Override
    public boolean isTriggerDeletable() {
        if (this.view != null) {
            return this.view.isTriggerDeletable;
        }
        return false;
    }

    @Override
    public Table getBaseTable() {
        return this.queryExpression == null ? this : this.queryExpression.getBaseTable();
    }

    @Override
    public int[] getBaseTableColumnMap() {
        return this.queryExpression == null ? null : this.queryExpression.getBaseTableColumnMap();
    }

    @Override
    public QueryExpression getQueryExpression() {
        return this.queryExpression;
    }

    @Override
    public Expression getDataExpression() {
        return this.dataExpression;
    }

    @Override
    public void prepareTable(Session session) {
        if (this.columnCount > 0) {
            return;
        }
        if (this.dataExpression != null && this.columnCount == 0) {
            TableUtil.addAutoColumns(this, this.dataExpression.nodeDataTypes);
            this.setTableIndexesForSubquery(session);
        }
        if (this.queryExpression != null) {
            this.columnList = this.queryExpression.getColumns();
            this.columnCount = this.queryExpression.getColumnCount();
            this.setTableIndexesForSubquery(session);
        }
    }

    public void prepareTable(Session session, HsqlNameManager.HsqlName[] hsqlNameArray) {
        this.prepareTable(session);
        if (hsqlNameArray != null) {
            if (hsqlNameArray.length != this.columnList.size()) {
                throw Error.error(5593);
            }
            for (int i = 0; i < this.columnCount; ++i) {
                this.columnList.setKey(i, hsqlNameArray[i].name);
                ColumnSchema columnSchema = (ColumnSchema)this.columnList.get(i);
                columnSchema.setName(hsqlNameArray[i]);
            }
        }
    }

    private void setTableIndexesForSubquery(Session session) {
        int[] nArray = null;
        boolean bl = false;
        if (this.queryExpression != null && this.queryExpression.fullIndex != null) {
            bl = true;
        }
        if (bl || this.uniqueRows || this.uniquePredicate) {
            nArray = new int[this.getColumnCount()];
            ArrayUtil.fillSequence(nArray);
        }
        int[] nArray2 = (int[])(this.uniqueRows ? nArray : null);
        this.createPrimaryKey(null, nArray2, false);
        if (this.uniqueRows) {
            this.fullIndex = this.getPrimaryIndex();
        } else if (this.uniquePredicate || bl) {
            this.fullIndex = this.createIndexForColumns(session, nArray);
        }
    }

    void setCorrelated() {
        if (this.dataExpression != null) {
            this.dataExpression.isCorrelated = true;
        }
        if (this.queryExpression != null) {
            this.queryExpression.isCorrelated = true;
        }
    }

    boolean isCorrelated() {
        if (this.dataExpression != null) {
            return this.dataExpression.isCorrelated;
        }
        if (this.queryExpression != null) {
            return this.queryExpression.isCorrelated;
        }
        return false;
    }

    boolean hasUniqueNotNullRows(Session session) {
        return this.getNavigator(session).hasUniqueNotNullRows(session);
    }

    void resetToView() {
        this.queryExpression = this.view.getQueryExpression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void materialise(Session session) {
        session.sessionContext.pushStatementState();
        try {
            if (this.dataExpression != null) {
                PersistentStore persistentStore = session.sessionData.getSubqueryRowStore(this);
                this.dataExpression.insertValuesIntoSubqueryTable(session, persistentStore);
                return;
            }
            if (this.queryExpression == null) {
                return;
            }
            Result result = this.queryExpression.getResult(session, 0);
            if (this.uniqueRows) {
                RowSetNavigatorData rowSetNavigatorData = (RowSetNavigatorData)result.getNavigator();
                rowSetNavigatorData.removeDuplicates(session);
            }
            PersistentStore persistentStore = session.sessionData.getSubqueryRowStore(this);
            this.insertResult(session, persistentStore, result);
            result.getNavigator().release();
        }
        finally {
            session.sessionContext.popStatementState();
        }
    }

    @Override
    public void materialiseCorrelated(Session session) {
        if (this.isCorrelated()) {
            this.materialise(session);
        }
    }

    public boolean isRecompiled() {
        if (this.canRecompile && this.queryExpression instanceof QuerySpecification) {
            QuerySpecification querySpecification = (QuerySpecification)this.queryExpression;
            return !querySpecification.isAggregated && !querySpecification.isGrouped && !querySpecification.isOrderSensitive;
        }
        return false;
    }

    public Object[] getValues(Session session) {
        RowIterator rowIterator = this.rowIterator(session);
        if (rowIterator.next()) {
            Row row = rowIterator.getCurrentRow();
            if (rowIterator.next()) {
                throw Error.error(3201);
            }
            return row.getData();
        }
        return new Object[this.getColumnCount()];
    }

    public Object getValue(Session session) {
        Object[] objectArray = this.getValues(session);
        return objectArray[0];
    }

    public RowSetNavigatorData getNavigator(Session session) {
        RowSetNavigatorDataTable rowSetNavigatorDataTable = new RowSetNavigatorDataTable(session, this);
        return rowSetNavigatorDataTable;
    }

    public void setSQL(String string) {
        this.sql = string;
    }
}

