/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.ColumnName;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.CsvStatement;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.ParsedExpression;
import org.relique.jdbc.csv.ParsedStatement;
import org.relique.jdbc.csv.SqlParser;
import org.relique.jdbc.csv.SubQueryEqualsRowMatcher;
import org.relique.jdbc.csv.SubQueryRowMatcher;

class SubQueryExpression
extends Expression {
    private ParsedStatement parsedStatement;

    public SubQueryExpression(ParsedStatement parsedStatement) {
        this.parsedStatement = parsedStatement;
    }

    @Override
    public Object eval(Map<String, Object> map) throws SQLException {
        SubQueryEqualsRowMatcher subQueryEqualsRowMatcher = new SubQueryEqualsRowMatcher();
        this.evalList(map, subQueryEqualsRowMatcher);
        ArrayList<Object> arrayList = subQueryEqualsRowMatcher.getValues();
        int n = arrayList.size();
        if (n == 0) {
            return null;
        }
        if (n > 1) {
            throw new SQLException(CsvResources.getString("subqueryOneRow"));
        }
        return arrayList.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evalList(Map<String, Object> map, SubQueryRowMatcher subQueryRowMatcher) throws SQLException {
        boolean bl = false;
        CsvStatement csvStatement = null;
        ResultSet resultSet = null;
        try {
            SqlParser sqlParser = new SqlParser();
            for (ParsedExpression object : this.parsedStatement.queryEntries) {
                object.resetAggregateFunctions();
            }
            sqlParser.setParsedStatement(this.parsedStatement);
            ColumnName columnName = new ColumnName("@STATEMENT");
            csvStatement = (CsvStatement)((Expression)columnName).eval(map);
            resultSet = csvStatement.executeParsedQuery(sqlParser, map);
            if (resultSet.getMetaData().getColumnCount() != 1) {
                throw new SQLException(CsvResources.getString("subqueryOneColumn"));
            }
            while (!bl && resultSet.next()) {
                Object object = resultSet.getObject(1);
                bl = subQueryRowMatcher.matches(object);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(this.parsedStatement.toString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public List<String> usedColumns(Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        List<String> list = this.parsedStatement.usedColumns(set);
        for (String string : list) {
            if (!set.contains(string)) continue;
            linkedList.add(string);
        }
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        return new LinkedList<AggregateFunction>();
    }
}

