/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;

class SQLAbsFunction
extends Expression {
    Expression expression;

    public SQLAbsFunction(Expression expression) {
        this.expression = expression;
    }

    @Override
    public Object eval(Map<String, Object> map) throws SQLException {
        Number number = null;
        Object object = this.expression.eval(map);
        if (object != null) {
            if (!(object instanceof Number)) {
                try {
                    object = new Double(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    object = null;
                }
            }
            if (object != null) {
                if (object instanceof Short) {
                    int n = ((Short)object).intValue();
                    if (n < 0) {
                        n = -n;
                    }
                    number = n;
                } else if (object instanceof Integer) {
                    int n = (Integer)object;
                    if (n < 0) {
                        n = -n;
                    }
                    number = n;
                } else if (object instanceof Long) {
                    long l = ((Long)object).intValue();
                    if (l < 0L) {
                        l = -l;
                    }
                    number = l;
                } else {
                    double d = ((Number)object).doubleValue();
                    if (d < 0.0) {
                        d = -d;
                    }
                    number = new Double(d);
                }
            }
        }
        return number;
    }

    public String toString() {
        return "ABS(" + this.expression + ")";
    }

    @Override
    public List<String> usedColumns(Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.expression.usedColumns(set));
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        linkedList.addAll(this.expression.aggregateFunctions());
        return linkedList;
    }
}

