/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.InExpressionSubQueryRowMatcher;
import org.relique.jdbc.csv.LogicalExpression;
import org.relique.jdbc.csv.RelopExpression;
import org.relique.jdbc.csv.SubQueryExpression;

class InExpression
extends LogicalExpression {
    Expression obj;
    List<Expression> inList = null;
    SubQueryExpression subQuery = null;

    public InExpression(Expression expression, List<Expression> list) {
        this.obj = expression;
        this.inList = list;
    }

    public InExpression(Expression expression, SubQueryExpression subQueryExpression) {
        this.obj = expression;
        this.subQuery = subQueryExpression;
    }

    @Override
    public Boolean isTrue(Map<String, Object> map) throws SQLException {
        Comparable comparable = (Comparable)this.obj.eval(map);
        if (comparable == null) {
            return null;
        }
        if (this.inList != null) {
            for (Expression expression : this.inList) {
                Comparable comparable2 = (Comparable)expression.eval(map);
                Integer n = RelopExpression.compare(comparable, comparable2, map);
                if (n == null || n != 0) continue;
                return Boolean.TRUE;
            }
        } else {
            boolean bl = this.subQuery.evalList(map, new InExpressionSubQueryRowMatcher(map, comparable));
            return bl;
        }
        return Boolean.FALSE;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("IN ");
        stringBuilder.append(this.obj.toString());
        if (this.inList != null) {
            stringBuilder.append(" (");
            String string = "";
            for (Expression expression : this.inList) {
                stringBuilder.append(string);
                stringBuilder.append(expression.toString());
                string = ", ";
            }
            stringBuilder.append(")");
        } else {
            stringBuilder.append(this.subQuery.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public List<String> usedColumns(Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.obj.usedColumns(set));
        if (this.inList != null) {
            for (Expression expression : this.inList) {
                linkedList.addAll(expression.usedColumns(set));
            }
        }
        if (this.subQuery != null) {
            linkedList.addAll(this.subQuery.usedColumns(set));
        }
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        if (this.inList != null) {
            for (Expression expression : this.inList) {
                linkedList.addAll(expression.aggregateFunctions());
            }
        }
        if (this.subQuery != null) {
            linkedList.addAll(this.subQuery.aggregateFunctions());
        }
        return linkedList;
    }
}

