/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.relique.jdbc.csv.CsvConnection;
import org.relique.jdbc.csv.CsvDriver;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.CsvStatement;
import org.relique.jdbc.csv.SqlParser;

public class CsvPreparedStatement
extends CsvStatement
implements PreparedStatement {
    private Object[] parameters;
    private String templateQuery;
    private SqlParser parser = new SqlParser();

    protected CsvPreparedStatement(CsvConnection csvConnection, String string, int n) throws SQLException {
        super(csvConnection, n);
        try {
            this.parser.parse(string);
        }
        catch (Exception exception) {
            throw new SQLException(CsvResources.getString("syntaxError") + ": " + exception.getMessage());
        }
        this.parameters = new Object[this.parser.getPlaceholdersCount() + 1];
        this.templateQuery = string;
    }

    private void checkParameterIndex(int n) throws SQLException {
        if (n < 1 || n >= this.parameters.length) {
            throw new SQLException(CsvResources.getString("parameterIndex") + ": " + n);
        }
    }

    @Override
    public void addBatch() throws SQLException {
    }

    @Override
    public void clearParameters() throws SQLException {
        for (int i = 1; i < this.parameters.length; ++i) {
            this.parameters[i] = null;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        ResultSet resultSet;
        this.checkOpen();
        CsvDriver.writeLog("CsvPreparedStatement:executeQuery() - sql= " + this.templateQuery);
        this.setTimeoutMillis();
        this.cancelled = false;
        this.lastResultSet = resultSet = this.executeQuery();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkOpen();
        CsvDriver.writeLog("CsvPreparedStatement:executeQuery() - sql= " + this.templateQuery);
        try {
            if (this.lastResultSet != null) {
                this.lastResultSet.close();
            }
        }
        finally {
            this.lastResultSet = null;
        }
        this.setTimeoutMillis();
        this.cancelled = false;
        this.parser.setPlaceholdersValues(this.parameters);
        return this.executeParsedQuery(this.parser);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkOpen();
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": executeUpdate()");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = array;
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = inputStream;
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setAsciiStream(int,InputStream,int)");
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setAsciiStream(int,InputStream,long)");
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = bigDecimal;
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = inputStream;
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setBinaryStream(int,InputStream,int)");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setBinaryStream(int,InputStream,long)");
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = blob;
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = inputStream;
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setBlob(int,InputStream,long)");
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = bl;
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = by;
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setBytes(int,byte[])");
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = reader;
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setCharacterStream(int,Reader,int)");
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setAsciiStream(int,InputStream,long)");
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = clob;
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = reader;
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setClob(int,Reader,long)");
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = date;
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setDate(int,Date,Calendar)");
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = new Double(d);
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = Float.valueOf(f);
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = n2;
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = l;
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = reader;
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setNCharacterStream(int,Reader,long)");
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = nClob;
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = reader;
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setNClob(int,Reader,long)");
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setNString(int,String)");
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setNull(int,int)");
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setNull(int,int,String)");
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = object;
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setObject(int,Object,int)");
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setObject(int,Object,int,int)");
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = ref;
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = rowId;
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = sQLXML;
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = s;
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = string;
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = time;
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setTime(int,Time,Calendar)");
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = timestamp;
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setTimestamp(int,Timestamp,Calendar)");
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        this.parameters[n] = uRL;
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkOpen();
        this.checkParameterIndex(n);
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setUnicodeStream(int,InputStream,int)");
    }
}

