/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.ColumnName;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.LogicalExpression;
import org.relique.jdbc.csv.StringConverter;

class BinaryOperation
extends Expression {
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    String operation;
    char op;
    Expression left;
    Expression right;

    public BinaryOperation(String string, Expression expression, Expression expression2) {
        this.operation = string;
        this.op = string.charAt(0);
        this.left = expression;
        this.right = expression2;
    }

    @Override
    public Object eval(Map<String, Object> map) throws SQLException {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5 = this.left.eval(map);
        Object object6 = this.right.eval(map);
        if (object5 == null || object6 == null) {
            return null;
        }
        try {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            boolean bl = false;
            if (object5 instanceof Short) {
                Integer n = ((Short)object5).intValue();
                bigInteger2 = new BigInteger(n.toString());
            } else if (object5 instanceof Long) {
                bigInteger2 = new BigInteger(object5.toString());
                bl = true;
            } else {
                Integer n = (Integer)object5;
                bigInteger2 = new BigInteger(n.toString());
            }
            if (object6 instanceof Short) {
                Integer n = ((Short)object6).intValue();
                bigInteger = new BigInteger(n.toString());
            } else if (object6 instanceof Long) {
                bigInteger = new BigInteger(object6.toString());
                bl = true;
            } else {
                Integer n = (Integer)object6;
                bigInteger = new BigInteger(n.toString());
            }
            if (this.op == '+') {
                bigInteger2 = bigInteger2.add(bigInteger);
            } else if (this.op == '-') {
                bigInteger2 = bigInteger2.subtract(bigInteger);
            } else if (this.op == '*') {
                bigInteger2 = bigInteger2.multiply(bigInteger);
            } else if (this.op == '/') {
                bigInteger2 = bigInteger2.divide(bigInteger);
            } else if (this.op == '%') {
                bigInteger2 = bigInteger2.remainder(bigInteger);
            }
            if (bl) {
                return new Long(bigInteger2.toString());
            }
            return new Integer(bigInteger2.toString());
        }
        catch (ClassCastException classCastException) {
        }
        catch (ArithmeticException arithmeticException) {
            throw new SQLException(arithmeticException.getMessage());
        }
        try {
            object4 = (Number)object5;
            object3 = new BigDecimal(object4.toString());
            object2 = (Number)object6;
            object = new BigDecimal(object2.toString());
            if (this.op == '+') {
                return new Double(((BigDecimal)object3).add((BigDecimal)object).toString());
            }
            if (this.op == '-') {
                return new Double(((BigDecimal)object3).subtract((BigDecimal)object).toString());
            }
            if (this.op == '*') {
                return new Double(((BigDecimal)object3).multiply((BigDecimal)object).toString());
            }
            serializable = new MathContext("precision=14 roundingMode=HALF_UP");
            if (this.op == '/') {
                return new Double(((BigDecimal)object3).divide((BigDecimal)object, ((MathContext)serializable).getPrecision(), ((MathContext)serializable).getRoundingMode()).toString());
            }
            if (this.op == '%') {
                return new Double(((BigDecimal)object3).remainder((BigDecimal)object, (MathContext)serializable).toString());
            }
        }
        catch (ClassCastException classCastException) {
        }
        catch (ArithmeticException arithmeticException) {
            throw new SQLException(arithmeticException.getMessage());
        }
        try {
            if (this.op == '+' && object5 instanceof Date) {
                object4 = (Date)object5;
                if (object6 instanceof Time) {
                    object3 = (Time)object6;
                    object2 = new ColumnName("@STRINGCONVERTER");
                    object = (StringConverter)((Expression)object2).eval(map);
                    return ((StringConverter)object).parseTimestamp(((Date)object4).toString() + " " + ((Time)object3).toString());
                }
                object3 = object6 instanceof Short ? Long.valueOf(((Short)object6).longValue()) : (object6 instanceof Long ? (Long)object6 : Long.valueOf(((Integer)object6).intValue()));
                return this.incrementDate((Date)object4, (Long)object3);
            }
            if (this.op == '+' && object6 instanceof Date) {
                object4 = (Date)object6;
                if (object5 instanceof Time) {
                    object3 = (Time)object5;
                    object2 = new ColumnName("@STRINGCONVERTER");
                    object = (StringConverter)((Expression)object2).eval(map);
                    return ((StringConverter)object).parseTimestamp(((Date)object4).toString() + " " + ((Time)object3).toString());
                }
                object3 = object5 instanceof Short ? Long.valueOf(((Short)object5).intValue()) : (object5 instanceof Long ? (Long)object6 : Long.valueOf(((Integer)object5).intValue()));
                return this.incrementDate((Date)object4, (Long)object3);
            }
            if (this.op == '-' && object5 instanceof Date && object6 instanceof Long) {
                return this.incrementDate((Date)object5, -((Long)object6).longValue());
            }
            if (this.op == '-' && object5 instanceof Date && object6 instanceof Integer) {
                return this.incrementDate((Date)object5, -((Integer)object6).intValue());
            }
            if (this.op == '-' && object5 instanceof Date && object6 instanceof Short) {
                return this.incrementDate((Date)object5, -((Short)object6).intValue());
            }
            if (this.op == '-' && (object5 instanceof Date || object6 instanceof Date)) {
                if (!(object5 instanceof Date)) {
                    object4 = new ColumnName("@STRINGCONVERTER");
                    object3 = (StringConverter)((Expression)object4).eval(map);
                    object5 = ((StringConverter)object3).parseDate(object5.toString());
                }
                if (!(object6 instanceof Date)) {
                    object4 = new ColumnName("@STRINGCONVERTER");
                    object3 = (StringConverter)((Expression)object4).eval(map);
                    object6 = ((StringConverter)object3).parseDate(object6.toString());
                }
                if (object5 != null && object6 != null) {
                    long l = ((Date)object5).getTime() - ((Date)object6).getTime();
                    long l2 = (l + 43200000L) / 86400000L;
                    return new Integer((int)l2);
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            if (this.op == '+' || this.op == '-') {
                object4 = (Timestamp)object5;
                long l = ((Timestamp)object4).getTime();
                object = (Number)object6;
                serializable = new BigDecimal(object.toString());
                if (this.op == '+') {
                    return new Timestamp(l + ((BigDecimal)serializable).longValue());
                }
                if (this.op == '-') {
                    return new Timestamp(l - ((BigDecimal)serializable).longValue());
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (this.op == '+' || this.op == '|') {
            return "" + object5 + object6;
        }
        return null;
    }

    private Date incrementDate(Date date, long l) {
        long l2 = date.getTime() + l * 86400000L + 43200000L;
        Date date2 = new Date(l2);
        date2 = Date.valueOf(date2.toString());
        return date2;
    }

    public String toString() {
        return "" + this.operation + " " + this.left + " " + this.right;
    }

    @Override
    public List<String> usedColumns(Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.left.usedColumns(set));
        linkedList.addAll(this.right.usedColumns(set));
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        linkedList.addAll(this.left.aggregateFunctions());
        linkedList.addAll(this.right.aggregateFunctions());
        return linkedList;
    }

    @Override
    public boolean isValid() {
        if (this.left instanceof LogicalExpression || this.right instanceof LogicalExpression) {
            return false;
        }
        return this.left.isValid() && this.right.isValid();
    }
}

