/*
 * Decompiled with CFR 0.152.
 */
package org.relique.io;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.relique.io.CryptoFilter;

public class EncryptedFileOutputStream
extends OutputStream {
    private OutputStream out;
    private CryptoFilter filter;

    public EncryptedFileOutputStream(String string, CryptoFilter cryptoFilter) throws FileNotFoundException {
        this.filter = cryptoFilter;
        this.filter.reset();
        this.out = new FileOutputStream(string);
    }

    @Override
    public void write(int n) throws IOException {
        if (this.filter == null) {
            this.out.write(n);
        } else {
            this.filter.write(this.out, n);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }
}

