/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sqlite.crypt;

import com.dbeaver.db.sqlite.crypt.SQLiteCryptParam;
import org.jkiss.utils.CommonUtils;

public enum SQLiteCipherType {
    AES128CBC("aes128cbc", "AES 128", "AES 128 Bit CBC - No HMAC (wxSQLite3)", new ParamValue(SQLiteCryptParam.legacy, 0), new ParamValue(SQLiteCryptParam.legacy_page_size, 0)),
    AES256CBC("aes256cbc", "AES 256", "AES 256 Bit CBC - No HMAC (wxSQLite3)", new ParamValue(SQLiteCryptParam.kdf_iter, 4001), new ParamValue(SQLiteCryptParam.legacy, 0), new ParamValue(SQLiteCryptParam.legacy_page_size, 0)),
    CHACHA20("chacha20", "ChaCha20", "ChaCha20 - Poly1305 HMAC (sqleet)", new ParamValue(SQLiteCryptParam.kdf_iter, 64007), new ParamValue(SQLiteCryptParam.legacy, 0), new ParamValue(SQLiteCryptParam.legacy_page_size, 4096)),
    SQLCIPHER("sqlcipher", "SQLCipher", "AES 256 Bit CBC - SHA1/SHA256/SHA512 HMAC (SQLCipher)", new ParamValue(SQLiteCryptParam.kdf_iter, 256000), new ParamValue(SQLiteCryptParam.fast_kdf_iter, 2), new ParamValue(SQLiteCryptParam.hmac_use, 1), new ParamValue(SQLiteCryptParam.hmac_pgno, 1), new ParamValue(SQLiteCryptParam.hmac_salt_mask, "0x3a"), new ParamValue(SQLiteCryptParam.legacy, 0), new ParamValue(SQLiteCryptParam.legacy_page_size, 4096), new ParamValue(SQLiteCryptParam.kdf_algorithm, 2), new ParamValue(SQLiteCryptParam.hmac_algorithm, 2), new ParamValue(SQLiteCryptParam.plaintext_header_size, 0)),
    SQLCIPHER1("sqlcipher", "SQLCipher v1", "SQLCipher Legacy v1", new ParamValue(SQLiteCryptParam.kdf_iter, 4000), new ParamValue(SQLiteCryptParam.fast_kdf_iter, 2), new ParamValue(SQLiteCryptParam.hmac_use, 0), new ParamValue(SQLiteCryptParam.legacy, 1), new ParamValue(SQLiteCryptParam.legacy_page_size, 1024), new ParamValue(SQLiteCryptParam.kdf_algorithm, 0), new ParamValue(SQLiteCryptParam.hmac_algorithm, 0)),
    SQLCIPHER2("sqlcipher", "SQLCipher v2", "SQLCipher Legacy v2", new ParamValue(SQLiteCryptParam.kdf_iter, 4000), new ParamValue(SQLiteCryptParam.fast_kdf_iter, 2), new ParamValue(SQLiteCryptParam.hmac_use, 1), new ParamValue(SQLiteCryptParam.hmac_pgno, 1), new ParamValue(SQLiteCryptParam.hmac_salt_mask, "0x3a"), new ParamValue(SQLiteCryptParam.legacy, 2), new ParamValue(SQLiteCryptParam.legacy_page_size, 1024), new ParamValue(SQLiteCryptParam.kdf_algorithm, 0), new ParamValue(SQLiteCryptParam.hmac_algorithm, 0)),
    SQLCIPHER3("sqlcipher", "SQLCipher v3", "SQLCipher Legacy v3", new ParamValue(SQLiteCryptParam.kdf_iter, 64000), new ParamValue(SQLiteCryptParam.fast_kdf_iter, 2), new ParamValue(SQLiteCryptParam.hmac_use, 1), new ParamValue(SQLiteCryptParam.hmac_pgno, 1), new ParamValue(SQLiteCryptParam.hmac_salt_mask, "0x3a"), new ParamValue(SQLiteCryptParam.legacy, 3), new ParamValue(SQLiteCryptParam.legacy_page_size, 1024), new ParamValue(SQLiteCryptParam.kdf_algorithm, 0), new ParamValue(SQLiteCryptParam.hmac_algorithm, 0), new ParamValue(SQLiteCryptParam.plaintext_header_size, 0)),
    SQLCIPHER4("sqlcipher", "SQLCipher v4", "SQLCipher Legacy v4", new ParamValue(SQLiteCryptParam.kdf_iter, 256000), new ParamValue(SQLiteCryptParam.fast_kdf_iter, 2), new ParamValue(SQLiteCryptParam.hmac_use, 1), new ParamValue(SQLiteCryptParam.hmac_pgno, 1), new ParamValue(SQLiteCryptParam.hmac_salt_mask, "0x3a"), new ParamValue(SQLiteCryptParam.legacy, 0), new ParamValue(SQLiteCryptParam.legacy_page_size, 4096), new ParamValue(SQLiteCryptParam.kdf_algorithm, 2), new ParamValue(SQLiteCryptParam.hmac_algorithm, 2), new ParamValue(SQLiteCryptParam.plaintext_header_size, 0)),
    CUSTOM("custom", "Custom", "Custom Cipher parameters", new ParamValue[0]);

    private String cipherId;
    private String displayName;
    private String description;
    private ParamValue[] defaultParameters;

    private SQLiteCipherType(String cipherId, String displayName, String description, ParamValue ... defaultParameters) {
        this.cipherId = cipherId;
        this.displayName = displayName;
        this.description = description;
        this.defaultParameters = defaultParameters;
    }

    public String getCipherId() {
        return this.cipherId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public ParamValue[] getDefaultParameters() {
        return this.defaultParameters;
    }

    public String getDefaultParameter(SQLiteCryptParam param) {
        if (this.defaultParameters.length == 0) {
            return CommonUtils.toString((Object)param.getDefaultValue());
        }
        ParamValue[] paramValueArray = this.defaultParameters;
        int n = this.defaultParameters.length;
        int n2 = 0;
        while (n2 < n) {
            ParamValue pv = paramValueArray[n2];
            if (pv.param == param) {
                return pv.value;
            }
            ++n2;
        }
        return null;
    }

    public static class ParamValue {
        SQLiteCryptParam param;
        String value;

        ParamValue(SQLiteCryptParam param, int value) {
            this.param = param;
            this.value = String.valueOf(value);
        }

        ParamValue(SQLiteCryptParam param, String value) {
            this.param = param;
            this.value = value;
        }

        public SQLiteCryptParam getParam() {
            return this.param;
        }

        public String getValue() {
            return this.value;
        }
    }
}

