/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.ProxyFileSystem;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLogServlet;
import org.apache.hadoop.mapred.WebHCatJTShim20S;
import org.apache.hadoop.mapred.lib.TotalOrderPartitioner;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.KerberosName;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.tools.distcp2.DistCp;
import org.apache.hadoop.tools.distcp2.DistCpOptions;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.VersionInfo;

public class Hadoop20SShims
extends HadoopShimsSecure {
    private volatile HadoopShims.HCatHadoopShims hcatShimInstance;
    private static final String DISTCP_OPTIONS_PREFIX = "distcp.options.";

    @Override
    public HadoopShims.CombineFileInputFormatShim getCombineFileInputFormat() {
        return new HadoopShimsSecure.CombineFileInputFormatShim(){

            public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
                throw new IOException("CombineFileInputFormat.getRecordReader not needed.");
            }

            protected FileStatus[] listStatus(JobConf job) throws IOException {
                FileStatus[] result = super.listStatus(job);
                boolean foundDir = false;
                for (FileStatus stat : result) {
                    if (!stat.isDir()) continue;
                    foundDir = true;
                    break;
                }
                if (!foundDir) {
                    return result;
                }
                ArrayList<FileStatus> files = new ArrayList<FileStatus>();
                for (FileStatus stat : result) {
                    if (stat.isDir()) continue;
                    files.add(stat);
                }
                return files.toArray(new FileStatus[files.size()]);
            }
        };
    }

    @Override
    public String getTaskAttemptLogUrl(JobConf conf, String taskTrackerHttpAddress, String taskAttemptId) throws MalformedURLException {
        URL taskTrackerHttpURL = new URL(taskTrackerHttpAddress);
        return TaskLogServlet.getTaskLogUrl((String)taskTrackerHttpURL.getHost(), (String)Integer.toString(taskTrackerHttpURL.getPort()), (String)taskAttemptId);
    }

    @Override
    public HadoopShims.JobTrackerState getJobTrackerState(ClusterStatus clusterStatus) throws Exception {
        switch (clusterStatus.getJobTrackerState()) {
            case INITIALIZING: {
                return HadoopShims.JobTrackerState.INITIALIZING;
            }
            case RUNNING: {
                return HadoopShims.JobTrackerState.RUNNING;
            }
        }
        String errorMsg = "Unrecognized JobTracker state: " + clusterStatus.getJobTrackerState();
        throw new Exception(errorMsg);
    }

    @Override
    public TaskAttemptContext newTaskAttemptContext(Configuration conf, final Progressable progressable) {
        return new TaskAttemptContext(conf, new org.apache.hadoop.mapreduce.TaskAttemptID()){

            public void progress() {
                progressable.progress();
            }
        };
    }

    @Override
    public org.apache.hadoop.mapreduce.TaskAttemptID newTaskAttemptID(JobID jobId, boolean isMap, int taskId, int id) {
        return new org.apache.hadoop.mapreduce.TaskAttemptID(jobId.getJtIdentifier(), jobId.getId(), isMap, taskId, id);
    }

    @Override
    public org.apache.hadoop.mapreduce.JobContext newJobContext(Job job) {
        return new org.apache.hadoop.mapreduce.JobContext(job.getConfiguration(), job.getJobID());
    }

    @Override
    public boolean isLocalMode(Configuration conf) {
        return "local".equals(this.getJobLauncherRpcAddress(conf));
    }

    @Override
    public String getJobLauncherRpcAddress(Configuration conf) {
        return conf.get("mapred.job.tracker");
    }

    @Override
    public void setJobLauncherRpcAddress(Configuration conf, String val) {
        conf.set("mapred.job.tracker", val);
    }

    @Override
    public String getJobLauncherHttpAddress(Configuration conf) {
        return conf.get("mapred.job.tracker.http.address");
    }

    @Override
    public boolean moveToAppropriateTrash(FileSystem fs, Path path, Configuration conf) throws IOException {
        Configuration dupConf = new Configuration(conf);
        FileSystem.setDefaultUri(dupConf, fs.getUri());
        Trash trash = new Trash(dupConf);
        return trash.moveToTrash(path);
    }

    @Override
    public long getDefaultBlockSize(FileSystem fs, Path path) {
        return fs.getDefaultBlockSize();
    }

    @Override
    public short getDefaultReplication(FileSystem fs, Path path) {
        return fs.getDefaultReplication();
    }

    @Override
    public void refreshDefaultQueue(Configuration conf, String userName) {
    }

    @Override
    public void setTotalOrderPartitionFile(JobConf jobConf, Path partitionFile) {
        TotalOrderPartitioner.setPartitionFile((JobConf)jobConf, (Path)partitionFile);
    }

    @Override
    public Comparator<LongWritable> getLongComparator() {
        return new Comparator<LongWritable>(){

            @Override
            public int compare(LongWritable o1, LongWritable o2) {
                return o1.compareTo((Object)o2);
            }
        };
    }

    @Override
    public MiniMrShim getMiniMrCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        return new MiniMrShim(conf, numberOfTaskTrackers, nameNode, numDir);
    }

    @Override
    public MiniMrShim getMiniTezCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        throw new IOException("Cannot run tez on current hadoop, Version: " + VersionInfo.getVersion());
    }

    @Override
    public MiniMrShim getMiniSparkCluster(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
        throw new IOException("Cannot run Spark on YARN on current Hadoop, Version: " + VersionInfo.getVersion());
    }

    @Override
    public HadoopShims.MiniDFSShim getMiniDfs(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        return new MiniDFSShim(new MiniDFSCluster(conf, numDataNodes, format, racks));
    }

    @Override
    public HadoopShims.HCatHadoopShims getHCatShim() {
        if (this.hcatShimInstance == null) {
            this.hcatShimInstance = new HCatHadoopShims20S();
        }
        return this.hcatShimInstance;
    }

    @Override
    public HadoopShims.WebHCatJTShim getWebHCatShim(Configuration conf, UserGroupInformation ugi) throws IOException {
        return new WebHCatJTShim20S(conf, ugi);
    }

    @Override
    public List<FileStatus> listLocatedStatus(FileSystem fs, Path path, PathFilter filter) throws IOException {
        return Arrays.asList(fs.listStatus(path, filter));
    }

    @Override
    public BlockLocation[] getLocations(FileSystem fs, FileStatus status) throws IOException {
        return fs.getFileBlockLocations(status, 0L, status.getLen());
    }

    @Override
    public TreeMap<Long, BlockLocation> getLocationsWithOffset(FileSystem fs, FileStatus status) throws IOException {
        BlockLocation[] locations;
        TreeMap<Long, BlockLocation> offsetBlockMap = new TreeMap<Long, BlockLocation>();
        for (BlockLocation location : locations = this.getLocations(fs, status)) {
            offsetBlockMap.put(location.getOffset(), location);
        }
        return offsetBlockMap;
    }

    @Override
    public void hflush(FSDataOutputStream stream) throws IOException {
        stream.sync();
    }

    @Override
    public HadoopShims.HdfsFileStatus getFullFileStatus(Configuration conf, FileSystem fs, Path file) throws IOException {
        return new Hadoop20SFileStatus(fs.getFileStatus(file));
    }

    @Override
    public void setFullFileStatus(Configuration conf, HadoopShims.HdfsFileStatus sourceStatus, FileSystem fs, Path target, boolean recursion) throws IOException {
        this.setFullFileStatus(conf, sourceStatus, null, fs, target, recursion);
    }

    @Override
    public void setFullFileStatus(Configuration conf, HadoopShims.HdfsFileStatus sourceStatus, String targetGroup, FileSystem fs, Path target, boolean recursive) throws IOException {
        String group = sourceStatus.getFileStatus().getGroup();
        String permission = Integer.toString(sourceStatus.getFileStatus().getPermission().toShort(), 8);
        try {
            FsShell fshell = new FsShell();
            fshell.setConf(conf);
            this.run(fshell, new String[]{"-chgrp", "-R", group, target.toString()});
            this.run(fshell, new String[]{"-chmod", "-R", permission, target.toString()});
        }
        catch (Exception e) {
            throw new IOException("Unable to set permissions of " + target, e);
        }
        try {
            if (LOG.isDebugEnabled()) {
                this.getFullFileStatus(conf, fs, target).debugLog();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public FileSystem createProxyFileSystem(FileSystem fs, URI uri) {
        return new ProxyFileSystem(fs, uri);
    }

    @Override
    public Map<String, String> getHadoopConfNames() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("HADOOPFS", "fs.default.name");
        ret.put("HADOOPMAPFILENAME", "map.input.file");
        ret.put("HADOOPMAPREDINPUTDIR", "mapred.input.dir");
        ret.put("HADOOPMAPREDINPUTDIRRECURSIVE", "mapred.input.dir.recursive");
        ret.put("MAPREDMAXSPLITSIZE", "mapred.max.split.size");
        ret.put("MAPREDMINSPLITSIZE", "mapred.min.split.size");
        ret.put("MAPREDMINSPLITSIZEPERNODE", "mapred.min.split.size.per.node");
        ret.put("MAPREDMINSPLITSIZEPERRACK", "mapred.min.split.size.per.rack");
        ret.put("HADOOPNUMREDUCERS", "mapred.reduce.tasks");
        ret.put("HADOOPJOBNAME", "mapred.job.name");
        ret.put("HADOOPSPECULATIVEEXECREDUCERS", "mapred.reduce.tasks.speculative.execution");
        ret.put("MAPREDSETUPCLEANUPNEEDED", "mapred.committer.job.setup.cleanup.needed");
        ret.put("MAPREDTASKCLEANUPNEEDED", "mapreduce.job.committer.task.cleanup.needed");
        return ret;
    }

    @Override
    public HadoopShims.ZeroCopyReaderShim getZeroCopyReader(FSDataInputStream in, HadoopShims.ByteBufferPoolShim pool) throws IOException {
        return null;
    }

    @Override
    public HadoopShims.DirectDecompressorShim getDirectDecompressor(HadoopShims.DirectCompressionType codec) {
        return null;
    }

    @Override
    public Configuration getConfiguration(org.apache.hadoop.mapreduce.JobContext context) {
        return context.getConfiguration();
    }

    @Override
    public JobConf getJobConf(JobContext context) {
        return context.getJobConf();
    }

    @Override
    public FileSystem getNonCachedFileSystem(URI uri, Configuration conf) throws IOException {
        boolean origDisableHDFSCache = conf.getBoolean("fs." + uri.getScheme() + ".impl.disable.cache", false);
        conf.setBoolean("fs." + uri.getScheme() + ".impl.disable.cache", true);
        FileSystem fs = FileSystem.get(uri, conf);
        conf.setBoolean("fs." + uri.getScheme() + ".impl.disable.cache", origDisableHDFSCache);
        return fs;
    }

    @Override
    public void getMergedCredentials(JobConf jobConf) throws IOException {
        throw new IOException("Merging of credentials not supported in this version of hadoop");
    }

    @Override
    public void mergeCredentials(JobConf dest, JobConf src) throws IOException {
        throw new IOException("Merging of credentials not supported in this version of hadoop");
    }

    @Override
    public String getPassword(Configuration conf, String name) {
        return conf.get(name);
    }

    @Override
    public boolean supportStickyBit() {
        return false;
    }

    @Override
    public boolean hasStickyBit(FsPermission permission) {
        return false;
    }

    @Override
    public boolean supportTrashFeature() {
        return false;
    }

    @Override
    public Path getCurrentTrashPath(Configuration conf, FileSystem fs) {
        return null;
    }

    @Override
    public boolean isDirectory(FileStatus fileStatus) {
        return fileStatus.isDir();
    }

    @Override
    public KerberosNameShim getKerberosNameShim(String name) throws IOException {
        return new KerberosNameShim(name);
    }

    @Override
    public HadoopShims.StoragePolicyShim getStoragePolicyShim(FileSystem fs) {
        return null;
    }

    List<String> constructDistCpParams(List<Path> srcPaths, Path dst, Configuration conf) {
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry<String, String> entry : conf) {
            if (!entry.getKey().startsWith(DISTCP_OPTIONS_PREFIX)) continue;
            String distCpOption = entry.getKey();
            String distCpVal = entry.getValue();
            params.add("-" + distCpOption.replace(DISTCP_OPTIONS_PREFIX, ""));
            if (distCpVal == null || distCpVal.isEmpty()) continue;
            params.add(distCpVal);
        }
        if (params.size() == 0) {
            params.add("-update");
            params.add("-skipcrccheck");
        }
        for (Path src : srcPaths) {
            params.add(src.toString());
        }
        params.add(dst.toString());
        return params;
    }

    @Override
    public boolean runDistCpAs(final List<Path> srcPaths, final Path dst, final Configuration conf, String doAsUser) throws IOException {
        UserGroupInformation proxyUser = UserGroupInformation.createProxyUser(doAsUser, UserGroupInformation.getLoginUser());
        try {
            return proxyUser.doAs(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return Hadoop20SShims.this.runDistCp(srcPaths, dst, conf);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean runDistCp(List<Path> srcPaths, Path dst, Configuration conf) throws IOException {
        DistCpOptions options = new DistCpOptions(srcPaths, dst);
        options.setSyncFolder(true);
        options.setSkipCRC(true);
        options.preserve(DistCpOptions.FileAttribute.BLOCKSIZE);
        List<String> params = this.constructDistCpParams(srcPaths, dst, conf);
        try {
            DistCp distcp = new DistCp(conf, options);
            return distcp.run(params.toArray(new String[0])) == 0;
        }
        catch (Exception e) {
            throw new IOException("Cannot execute DistCp process: " + e, e);
        }
    }

    @Override
    public HadoopShims.HdfsEncryptionShim createHdfsEncryptionShim(FileSystem fs, Configuration conf) throws IOException {
        return new HadoopShims.NoopHdfsEncryptionShim();
    }

    @Override
    public Path getPathWithoutSchemeAndAuthority(Path path) {
        return path;
    }

    @Override
    public int readByteBuffer(FSDataInputStream file, ByteBuffer dest) throws IOException {
        int pos = dest.position();
        if (dest.hasArray()) {
            int result = file.read(dest.array(), dest.arrayOffset(), dest.remaining());
            if (result > 0) {
                dest.position(pos + result);
            }
            return result;
        }
        byte[] arr = new byte[dest.remaining()];
        int result = file.read(arr, 0, arr.length);
        if (result > 0) {
            dest.put(arr, 0, result);
            dest.position(pos + result);
        }
        return result;
    }

    @Override
    public void addDelegationTokens(FileSystem fs, Credentials cred, String uname) throws IOException {
        Token<?> fsToken = fs.getDelegationToken(uname);
        cred.addToken(fsToken.getService(), fsToken);
    }

    @Override
    public void setHadoopCallerContext(String callerContext) {
    }

    @Override
    public String getHadoopCallerContext() {
        return null;
    }

    @Override
    public void setHadoopQueryContext(String callerContext) {
    }

    @Override
    public void setHadoopSessionContext(String sessionId) {
    }

    public class KerberosNameShim
    implements HadoopShims.KerberosNameShim {
        private final KerberosName kerberosName;

        public KerberosNameShim(String name) {
            this.kerberosName = new KerberosName(name);
        }

        @Override
        public String getDefaultRealm() {
            return this.kerberosName.getDefaultRealm();
        }

        @Override
        public String getServiceName() {
            return this.kerberosName.getServiceName();
        }

        @Override
        public String getHostName() {
            return this.kerberosName.getHostName();
        }

        @Override
        public String getRealm() {
            return this.kerberosName.getRealm();
        }

        @Override
        public String getShortName() throws IOException {
            return this.kerberosName.getShortName();
        }
    }

    public class Hadoop20SFileStatus
    implements HadoopShims.HdfsFileStatus {
        private final FileStatus fileStatus;

        public Hadoop20SFileStatus(FileStatus fileStatus) {
            this.fileStatus = fileStatus;
        }

        @Override
        public FileStatus getFileStatus() {
            return this.fileStatus;
        }

        @Override
        public void debugLog() {
            if (this.fileStatus != null) {
                HadoopShimsSecure.LOG.debug(((Object)this.fileStatus).toString());
            }
        }
    }

    private final class HCatHadoopShims20S
    implements HadoopShims.HCatHadoopShims {
        private HCatHadoopShims20S() {
        }

        @Override
        public TaskID createTaskID() {
            return new TaskID();
        }

        @Override
        public org.apache.hadoop.mapreduce.TaskAttemptID createTaskAttemptID() {
            return new org.apache.hadoop.mapreduce.TaskAttemptID();
        }

        @Override
        public TaskAttemptContext createTaskAttemptContext(Configuration conf, org.apache.hadoop.mapreduce.TaskAttemptID taskId) {
            return new TaskAttemptContext(conf, taskId);
        }

        @Override
        public org.apache.hadoop.mapred.TaskAttemptContext createTaskAttemptContext(JobConf conf, TaskAttemptID taskId, Progressable progressable) {
            org.apache.hadoop.mapred.TaskAttemptContext newContext = null;
            try {
                Constructor construct = org.apache.hadoop.mapred.TaskAttemptContext.class.getDeclaredConstructor(JobConf.class, TaskAttemptID.class, Progressable.class);
                construct.setAccessible(true);
                newContext = (org.apache.hadoop.mapred.TaskAttemptContext)construct.newInstance(conf, taskId, progressable);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return newContext;
        }

        @Override
        public org.apache.hadoop.mapreduce.JobContext createJobContext(Configuration conf, JobID jobId) {
            return new org.apache.hadoop.mapreduce.JobContext(conf, jobId);
        }

        @Override
        public JobContext createJobContext(JobConf conf, JobID jobId, Progressable progressable) {
            JobContext newContext = null;
            try {
                Constructor construct = JobContext.class.getDeclaredConstructor(JobConf.class, JobID.class, Progressable.class);
                construct.setAccessible(true);
                newContext = (JobContext)construct.newInstance(conf, jobId, progressable);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return newContext;
        }

        @Override
        public void commitJob(OutputFormat outputFormat, Job job) throws IOException {
            if (job.getConfiguration().get("mapred.job.tracker", "").equalsIgnoreCase("local")) {
                try {
                    outputFormat.getOutputCommitter(this.createTaskAttemptContext(job.getConfiguration(), this.createTaskAttemptID())).commitJob((org.apache.hadoop.mapreduce.JobContext)job);
                }
                catch (IOException e) {
                    throw new IOException("Failed to cleanup job", e);
                }
                catch (InterruptedException e) {
                    throw new IOException("Failed to cleanup job", e);
                }
            }
        }

        @Override
        public void abortJob(OutputFormat outputFormat, Job job) throws IOException {
            if (job.getConfiguration().get("mapred.job.tracker", "").equalsIgnoreCase("local")) {
                try {
                    outputFormat.getOutputCommitter(this.createTaskAttemptContext(job.getConfiguration(), new org.apache.hadoop.mapreduce.TaskAttemptID())).abortJob((org.apache.hadoop.mapreduce.JobContext)job, JobStatus.State.FAILED);
                }
                catch (IOException e) {
                    throw new IOException("Failed to abort job", e);
                }
                catch (InterruptedException e) {
                    throw new IOException("Failed to abort job", e);
                }
            }
        }

        @Override
        public InetSocketAddress getResourceManagerAddress(Configuration conf) {
            return JobTracker.getAddress((Configuration)conf);
        }

        @Override
        public String getPropertyName(HadoopShims.HCatHadoopShims.PropertyName name) {
            switch (name) {
                case CACHE_ARCHIVES: {
                    return "mapred.cache.archives";
                }
                case CACHE_FILES: {
                    return "mapred.cache.files";
                }
                case CACHE_SYMLINK: {
                    return "mapred.create.symlink";
                }
                case CLASSPATH_ARCHIVES: {
                    return "mapred.job.classpath.archives";
                }
                case CLASSPATH_FILES: {
                    return "mapred.job.classpath.files";
                }
            }
            return "";
        }

        @Override
        public boolean isFileInHDFS(FileSystem fs, Path path) throws IOException {
            return "hdfs".equals(fs.getUri().getScheme());
        }
    }

    public class MiniDFSShim
    implements HadoopShims.MiniDFSShim {
        private final MiniDFSCluster cluster;

        public MiniDFSShim(MiniDFSCluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public FileSystem getFileSystem() throws IOException {
            return this.cluster.getFileSystem();
        }

        @Override
        public void shutdown() {
            this.cluster.shutdown();
        }
    }

    public class MiniMrShim
    implements HadoopShims.MiniMrShim {
        private final MiniMRCluster mr;

        public MiniMrShim(Configuration conf, int numberOfTaskTrackers, String nameNode, int numDir) throws IOException {
            this.mr = new MiniMRCluster(numberOfTaskTrackers, nameNode, numDir);
        }

        @Override
        public int getJobTrackerPort() throws UnsupportedOperationException {
            return this.mr.getJobTrackerPort();
        }

        @Override
        public void shutdown() throws IOException {
            MiniMRCluster.JobTrackerRunner runner = this.mr.getJobTrackerRunner();
            JobTracker tracker = runner.getJobTracker();
            if (tracker != null) {
                for (JobInProgress running : tracker.getRunningJobs()) {
                    try {
                        running.kill();
                    }
                    catch (Exception exception) {}
                }
            }
            runner.shutdown();
        }

        @Override
        public void setupConfiguration(Configuration conf) {
            Hadoop20SShims.this.setJobLauncherRpcAddress(conf, "localhost:" + this.mr.getJobTrackerPort());
        }
    }
}

