/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import com.google.common.annotations.VisibleForTesting;
import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.BoneCPDataSource;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTransactionRollbackException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.ServerUtils;
import org.apache.hadoop.hive.common.StringableMap;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.common.classification.RetrySemantics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfUtil;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.HouseKeeperService;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.TxnState;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.tools.SQLGenerator;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
abstract class TxnHandler
implements TxnStore,
TxnStore.MutexAPI {
    protected static final char INITIATED_STATE = 'i';
    protected static final char WORKING_STATE = 'w';
    protected static final char READY_FOR_CLEANING = 'r';
    static final char FAILED_STATE = 'f';
    static final char SUCCEEDED_STATE = 's';
    static final char ATTEMPTED_STATE = 'a';
    protected static final char MAJOR_TYPE = 'a';
    protected static final char MINOR_TYPE = 'i';
    protected static final char TXN_ABORTED = 'a';
    protected static final char TXN_OPEN = 'o';
    protected static final char LOCK_ACQUIRED = 'a';
    protected static final char LOCK_WAITING = 'w';
    protected static final char LOCK_EXCLUSIVE = 'e';
    protected static final char LOCK_SHARED = 'r';
    protected static final char LOCK_SEMI_SHARED = 'w';
    private static final int ALLOWED_REPEATED_DEADLOCKS = 10;
    public static final int TIMED_OUT_TXN_ABORT_BATCH_SIZE = 1000;
    private static final Log LOG = LogFactory.getLog(TxnHandler.class.getName());
    private static DataSource connPool;
    private static DataSource connPoolMutex;
    private static boolean doRetryOnConnPool;
    private static volatile int maxOpenTxns;
    private static volatile long numOpenTxns;
    private static volatile boolean tooManyOpenTxns;
    private static volatile HouseKeeperService openTxnsCounter;
    private int deadlockCnt;
    private long deadlockRetryInterval;
    protected HiveConf conf;
    private static DatabaseProduct dbProduct;
    private static SQLGenerator sqlGenerator;
    private long timeout;
    private String identifierQuoteString;
    private long retryInterval;
    private int retryLimit;
    private int retryNum;
    private static final ReentrantLock derbyLock;
    private static final ConcurrentHashMap<String, Semaphore> derbyKey2Lock;
    private static final String hostname;
    private static Map<LockType, Map<LockType, Map<LockState, LockAction>>> jumpTable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConf(HiveConf conf) {
        this.conf = conf;
        this.checkQFileTestHack();
        Class<TxnHandler> clazz = TxnHandler.class;
        synchronized (TxnHandler.class) {
            if (connPool == null) {
                LOG.info(HiveConfUtil.dumpConfig(conf).toString());
                Connection dbConn = null;
                try {
                    int maxPoolSize = conf.getIntVar(HiveConf.ConfVars.METASTORE_CONNECTION_POOLING_MAX_CONNECTIONS);
                    long getConnectionTimeoutMs = 30000L;
                    connPool = TxnHandler.setupJdbcConnectionPool(conf, maxPoolSize, getConnectionTimeoutMs);
                    connPoolMutex = TxnHandler.setupJdbcConnectionPool(conf, maxPoolSize + TxnStore.MUTEX_KEY.values().length, getConnectionTimeoutMs);
                    dbConn = this.getDbConn(2);
                    dbProduct = DatabaseProduct.determineDatabaseProduct(dbConn.getMetaData().getDatabaseProductName());
                    sqlGenerator = new SQLGenerator(dbProduct, conf);
                }
                catch (SQLException e) {
                    try {
                        String msg = "Unable to instantiate JDBC connection pooling, " + e.getMessage();
                        LOG.error(msg);
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        TxnHandler.closeDbConn(dbConn);
                        throw throwable;
                    }
                }
                TxnHandler.closeDbConn(dbConn);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.timeout = HiveConf.getTimeVar(conf, HiveConf.ConfVars.HIVE_TXN_TIMEOUT, TimeUnit.MILLISECONDS);
            TxnHandler.buildJumpTable();
            this.retryInterval = HiveConf.getTimeVar(conf, HiveConf.ConfVars.HMSHANDLERINTERVAL, TimeUnit.MILLISECONDS);
            this.retryLimit = HiveConf.getIntVar(conf, HiveConf.ConfVars.HMSHANDLERATTEMPTS);
            this.deadlockRetryInterval = this.retryInterval / 10L;
            maxOpenTxns = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_MAX_OPEN_TXNS);
            return;
        }
    }

    @Override
    @RetrySemantics.ReadOnly
    public GetOpenTxnsInfoResponse getOpenTxnsInfo() throws MetaException {
        GetOpenTxnsInfoResponse getOpenTxnsInfoResponse;
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            String s = "select ntxn_next - 1 from NEXT_TXN_ID";
            LOG.debug("Going to execute query <" + s + ">");
            rs = stmt.executeQuery(s);
            if (!rs.next()) {
                throw new MetaException("Transaction tables not properly initialized, no record found in next_txn_id");
            }
            long hwm = rs.getLong(1);
            if (rs.wasNull()) {
                throw new MetaException("Transaction tables not properly initialized, null record found in next_txn_id");
            }
            TxnHandler.close(rs);
            ArrayList<TxnInfo> txnInfos = new ArrayList<TxnInfo>();
            s = "select txn_id, txn_state, txn_user, txn_host, txn_started, txn_last_heartbeat from TXNS where txn_id <= " + hwm;
            LOG.debug("Going to execute query<" + s + ">");
            rs = stmt.executeQuery(s);
            while (rs.next()) {
                TxnState state;
                char c = rs.getString(2).charAt(0);
                switch (c) {
                    case 'a': {
                        state = TxnState.ABORTED;
                        break;
                    }
                    case 'o': {
                        state = TxnState.OPEN;
                        break;
                    }
                    default: {
                        throw new MetaException("Unexpected transaction state " + c + " found in txns table");
                    }
                }
                TxnInfo txnInfo = new TxnInfo(rs.getLong(1), state, rs.getString(3), rs.getString(4));
                txnInfo.setStartedTime(rs.getLong(5));
                txnInfo.setLastHeartbeatTime(rs.getLong(6));
                txnInfos.add(txnInfo);
            }
            LOG.debug("Going to rollback");
            dbConn.rollback();
            getOpenTxnsInfoResponse = new GetOpenTxnsInfoResponse(hwm, txnInfos);
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "getOpenTxnsInfo");
                    throw new MetaException("Unable to select from transaction database: " + TxnHandler.getMessage(e) + StringUtils.stringifyException(e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(rs, stmt, dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.getOpenTxnsInfo();
            }
        }
        TxnHandler.close(rs, stmt, dbConn);
        return getOpenTxnsInfoResponse;
    }

    @Override
    @RetrySemantics.ReadOnly
    public GetOpenTxnsResponse getOpenTxns() throws MetaException {
        GetOpenTxnsResponse getOpenTxnsResponse;
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            String s = "select ntxn_next - 1 from NEXT_TXN_ID";
            LOG.debug("Going to execute query <" + s + ">");
            rs = stmt.executeQuery(s);
            if (!rs.next()) {
                throw new MetaException("Transaction tables not properly initialized, no record found in next_txn_id");
            }
            long hwm = rs.getLong(1);
            if (rs.wasNull()) {
                throw new MetaException("Transaction tables not properly initialized, null record found in next_txn_id");
            }
            TxnHandler.close(rs);
            HashSet<Long> openList = new HashSet<Long>();
            s = "select txn_id, txn_state from TXNS where txn_id <= " + hwm;
            LOG.debug("Going to execute query<" + s + ">");
            rs = stmt.executeQuery(s);
            long minOpenTxn = Long.MAX_VALUE;
            while (rs.next()) {
                long txnId = rs.getLong(1);
                openList.add(txnId);
                char c = rs.getString(2).charAt(0);
                if (c != 'o') continue;
                minOpenTxn = Math.min(minOpenTxn, txnId);
            }
            LOG.debug("Going to rollback");
            dbConn.rollback();
            GetOpenTxnsResponse otr = new GetOpenTxnsResponse(hwm, openList);
            if (minOpenTxn < Long.MAX_VALUE) {
                otr.setMin_open_txn(minOpenTxn);
            }
            getOpenTxnsResponse = otr;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "getOpenTxns");
                    throw new MetaException("Unable to select from transaction database, " + StringUtils.stringifyException(e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(rs, stmt, dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.getOpenTxns();
            }
        }
        TxnHandler.close(rs, stmt, dbConn);
        return getOpenTxnsResponse;
    }

    public static ValidTxnList createValidReadTxnList(GetOpenTxnsResponse txns, long currentTxn) {
        long highWater = txns.getTxn_high_water_mark();
        Set<Long> open = txns.getOpen_txns();
        long[] exceptions = new long[open.size() - (currentTxn > 0L ? 1 : 0)];
        int i = 0;
        for (long txn : open) {
            if (currentTxn > 0L && currentTxn == txn) continue;
            exceptions[i++] = txn;
        }
        return new ValidReadTxnList(exceptions, highWater);
    }

    private static void startHouseKeeperService(HiveConf conf, Class c) {
        try {
            openTxnsCounter = (HouseKeeperService)c.newInstance();
            openTxnsCounter.start(conf);
        }
        catch (Exception ex) {
            LOG.error("Failed to start {}" + openTxnsCounter.getClass() + ".  The system will not handle {} " + openTxnsCounter.getServiceDescription() + ".  Root Cause: ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @RetrySemantics.Idempotent
    public OpenTxnsResponse openTxns(OpenTxnRequest rqst) throws MetaException {
        if (openTxnsCounter == null) {
            Class<TxnHandler> clazz = TxnHandler.class;
            // MONITORENTER : org.apache.hadoop.hive.metastore.txn.TxnHandler.class
            try {
                if (openTxnsCounter == null) {
                    TxnHandler.startHouseKeeperService(this.conf, Class.forName("org.apache.hadoop.hive.ql.txn.AcidOpenTxnsCounterService"));
                }
            }
            catch (ClassNotFoundException e) {
                throw new MetaException(e.getMessage());
            }
        }
        if (!tooManyOpenTxns && numOpenTxns >= (long)maxOpenTxns) {
            tooManyOpenTxns = true;
        }
        if (tooManyOpenTxns) {
            if (!((double)numOpenTxns < (double)maxOpenTxns * 0.9)) {
                LOG.warn("Maximum allowed number of open transactions (" + maxOpenTxns + ") has been " + "reached. Current number of open transactions: " + numOpenTxns);
                throw new MetaException("Maximum allowed number of open transactions has been reached. See hive.max.open.txns.");
            }
            tooManyOpenTxns = false;
        }
        int numTxns = rqst.getNum_txns();
        try {
            OpenTxnsResponse openTxnsResponse;
            Connection dbConn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                this.lockInternal();
                dbConn = this.getDbConn(2);
                int maxTxns = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.HIVE_TXN_MAX_OPEN_BATCH);
                if (numTxns > maxTxns) {
                    numTxns = maxTxns;
                }
                stmt = dbConn.createStatement();
                String s = sqlGenerator.addForUpdateClause("select ntxn_next from NEXT_TXN_ID");
                LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                if (!rs.next()) {
                    throw new MetaException("Transaction database not properly configured, can't find next transaction id.");
                }
                long first = rs.getLong(1);
                s = "update NEXT_TXN_ID set ntxn_next = " + (first + (long)numTxns);
                LOG.debug("Going to execute update <" + s + ">");
                stmt.executeUpdate(s);
                long now = this.getDbTime(dbConn);
                ArrayList<Long> txnIds = new ArrayList<Long>(numTxns);
                ArrayList<String> rows = new ArrayList<String>();
                for (long i = first; i < first + (long)numTxns; ++i) {
                    txnIds.add(i);
                    rows.add(i + "," + TxnHandler.quoteChar('o') + "," + now + "," + now + "," + TxnHandler.quoteString(rqst.getUser()) + "," + TxnHandler.quoteString(rqst.getHostname()));
                }
                List<String> queries = sqlGenerator.createInsertValuesStmt("TXNS (txn_id, txn_state, txn_started, txn_last_heartbeat, txn_user, txn_host)", rows);
                for (String q : queries) {
                    LOG.debug("Going to execute update <" + q + ">");
                    stmt.execute(q);
                }
                LOG.debug("Going to commit");
                dbConn.commit();
                openTxnsResponse = new OpenTxnsResponse(txnIds);
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "openTxns(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + StringUtils.stringifyException(e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(rs, stmt, dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.close(rs, stmt, dbConn);
            this.unlockInternal();
            return openTxnsResponse;
        }
        catch (RetryException e) {
            return this.openTxns(rqst);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @RetrySemantics.Idempotent
    public void abortTxn(AbortTxnRequest rqst) throws NoSuchTxnException, MetaException, TxnAbortedException {
        txnid = rqst.getTxnid();
        try {
            block7: {
                dbConn = null;
                stmt = null;
                this.lockInternal();
                dbConn = this.getDbConn(2);
                if (this.abortTxns(dbConn, Collections.singletonList(txnid), true) == 1) ** GOTO lbl19
                stmt = dbConn.createStatement();
                status = this.findTxnState(txnid, stmt);
                if (status != TxnStatus.ABORTED) break block7;
                TxnHandler.LOG.info("abortTxn(" + JavaUtils.txnIdToString(txnid) + ") requested by it is already " + (Object)TxnStatus.ABORTED);
                TxnHandler.close(null, stmt, dbConn);
                this.unlockInternal();
                return;
            }
            try {
                TxnHandler.raiseTxnUnexpectedState(status, txnid);
lbl19:
                // 2 sources

                TxnHandler.LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    TxnHandler.LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "abortTxn(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + StringUtils.stringifyException(e));
                }
                catch (Throwable var7_8) {
                    TxnHandler.close(null, stmt, dbConn);
                    this.unlockInternal();
                    throw var7_8;
                }
            }
            TxnHandler.close(null, stmt, dbConn);
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.abortTxn(rqst);
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public void abortTxns(AbortTxnsRequest rqst) throws NoSuchTxnException, MetaException {
        List<Long> txnids = rqst.getTxn_ids();
        try {
            Connection dbConn = null;
            try {
                dbConn = this.getDbConn(2);
                int numAborted = this.abortTxns(dbConn, txnids, false);
                if (numAborted != txnids.size()) {
                    LOG.warn("Abort Transactions command only aborted " + numAborted + " out of " + txnids.size() + " transactions. It's possible that the other " + (txnids.size() - numAborted) + " transactions have been aborted or committed, or the transaction ids are invalid.");
                }
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                LOG.debug("Going to rollback");
                TxnHandler.rollbackDBConn(dbConn);
                this.checkRetryable(dbConn, e, "abortTxns(" + rqst + ")");
                throw new MetaException("Unable to update transaction database " + StringUtils.stringifyException(e));
            }
            finally {
                TxnHandler.closeDbConn(dbConn);
            }
        }
        catch (RetryException e) {
            this.abortTxns(rqst);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @RetrySemantics.Idempotent(value={"No-op if already committed"})
    public void commitTxn(CommitTxnRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        txnid = rqst.getTxnid();
        try {
            block13: {
                dbConn = null;
                stmt = null;
                lockHandle = null;
                commitIdRs = null;
                this.lockInternal();
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                lockHandle = this.lockTransactionRecord(stmt, txnid, Character.valueOf('o'));
                if (lockHandle != null) ** GOTO lbl24
                actualTxnStatus = this.findTxnState(txnid, stmt);
                if (actualTxnStatus != TxnStatus.COMMITTED) break block13;
                TxnHandler.LOG.info("Nth commitTxn(" + JavaUtils.txnIdToString(txnid) + ") msg");
                TxnHandler.close(commitIdRs);
                TxnHandler.close(lockHandle, stmt, dbConn);
                this.unlockInternal();
                return;
            }
            try {
                TxnHandler.raiseTxnUnexpectedState(actualTxnStatus, txnid);
                TxnHandler.shouldNeverHappen(txnid);
lbl24:
                // 2 sources

                conflictSQLSuffix = "from TXN_COMPONENTS where tc_txnid=" + txnid + " and tc_operation_type IN(" + TxnHandler.quoteChar(OpertaionType.access$000(OpertaionType.UPDATE)) + "," + TxnHandler.quoteChar(OpertaionType.access$000(OpertaionType.DELETE)) + ")";
                rs = stmt.executeQuery(TxnHandler.sqlGenerator.addLimitClause(1, "tc_operation_type " + conflictSQLSuffix));
                if (rs.next()) {
                    TxnHandler.close(rs);
                    commitIdRs = stmt.executeQuery(TxnHandler.sqlGenerator.addForUpdateClause("select ntxn_next - 1 from NEXT_TXN_ID"));
                    if (!commitIdRs.next()) {
                        throw new IllegalStateException("No rows found in NEXT_TXN_ID");
                    }
                    commitId = commitIdRs.getLong(1);
                    undoWriteSetForCurrentTxn = dbConn.setSavepoint();
                    numCompsWritten = stmt.executeUpdate("insert into WRITE_SET (ws_database, ws_table, ws_partition, ws_txnid, ws_commit_id, ws_operation_type) select distinct tc_database, tc_table, tc_partition, tc_txnid, " + commitId + ", tc_operation_type " + "from TXN_COMPONENTS where tc_txnid=" + txnid + " and tc_operation_type IN(" + TxnHandler.quoteChar(OpertaionType.access$000(OpertaionType.UPDATE)) + "," + TxnHandler.quoteChar(OpertaionType.access$000(OpertaionType.DELETE)) + ")");
                    rs = stmt.executeQuery(TxnHandler.sqlGenerator.addLimitClause(1, "committed.ws_txnid, committed.ws_commit_id, committed.ws_database,committed.ws_table, committed.ws_partition, cur.ws_commit_id cur_ws_commit_id, cur.ws_operation_type cur_op, committed.ws_operation_type committed_op from WRITE_SET committed INNER JOIN WRITE_SET cur ON committed.ws_database=cur.ws_database and committed.ws_table=cur.ws_table and (committed.ws_partition=cur.ws_partition or (committed.ws_partition is null and cur.ws_partition is null)) where cur.ws_txnid <= committed.ws_commit_id and cur.ws_txnid=" + txnid + " and committed.ws_txnid <> " + txnid + " and (committed.ws_operation_type=" + TxnHandler.quoteChar(OpertaionType.access$000(OpertaionType.UPDATE)) + " OR cur.ws_operation_type=" + TxnHandler.quoteChar(OpertaionType.access$000(OpertaionType.UPDATE)) + ")"));
                    if (rs.next()) {
                        committedTxn = "[" + JavaUtils.txnIdToString(rs.getLong(1)) + "," + rs.getLong(2) + "]";
                        resource = new StringBuilder(rs.getString(3)).append("/").append(rs.getString(4));
                        partitionName = rs.getString(5);
                        if (partitionName != null) {
                            resource.append('/').append(partitionName);
                        }
                        msg = "Aborting [" + JavaUtils.txnIdToString(txnid) + "," + rs.getLong(6) + "]" + " due to a write conflict on " + resource + " committed by " + committedTxn + " " + rs.getString(7) + "/" + rs.getString(8);
                        TxnHandler.close(rs);
                        dbConn.rollback(undoWriteSetForCurrentTxn);
                        TxnHandler.LOG.info(msg);
                        if (this.abortTxns(dbConn, Collections.singletonList(txnid), true) != 1) {
                            throw new IllegalStateException(msg + " FAILED!");
                        }
                        dbConn.commit();
                        TxnHandler.close(null, stmt, dbConn);
                        throw new TxnAbortedException(msg);
                    }
                }
                s = "insert into COMPLETED_TXN_COMPONENTS select tc_txnid, tc_database, tc_table, tc_partition from TXN_COMPONENTS where tc_txnid = " + txnid;
                TxnHandler.LOG.debug("Going to execute insert <" + s + ">");
                modCount = 0;
                modCount = stmt.executeUpdate(s);
                if (modCount < 1) {
                    TxnHandler.LOG.info("Expected to move at least one record from txn_components to completed_txn_components when committing txn! " + JavaUtils.txnIdToString(txnid));
                }
                s = "delete from TXN_COMPONENTS where tc_txnid = " + txnid;
                TxnHandler.LOG.debug("Going to execute update <" + s + ">");
                modCount = stmt.executeUpdate(s);
                s = "delete from HIVE_LOCKS where hl_txnid = " + txnid;
                TxnHandler.LOG.debug("Going to execute update <" + s + ">");
                modCount = stmt.executeUpdate(s);
                s = "delete from TXNS where txn_id = " + txnid;
                TxnHandler.LOG.debug("Going to execute update <" + s + ">");
                modCount = stmt.executeUpdate(s);
                TxnHandler.LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    TxnHandler.LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "commitTxn(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + StringUtils.stringifyException(e));
                }
                catch (Throwable var18_20) {
                    TxnHandler.close(commitIdRs);
                    TxnHandler.close(lockHandle, stmt, dbConn);
                    this.unlockInternal();
                    throw var18_20;
                }
            }
            TxnHandler.close(commitIdRs);
            TxnHandler.close(lockHandle, stmt, dbConn);
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.commitTxn(rqst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.SafeToRetry
    public void performWriteSetGC() {
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            rs = stmt.executeQuery("select ntxn_next - 1 from NEXT_TXN_ID");
            if (!rs.next()) {
                throw new IllegalStateException("NEXT_TXN_ID is empty: DB is corrupted");
            }
            long highestAllocatedTxnId = rs.getLong(1);
            TxnHandler.close(rs);
            rs = stmt.executeQuery("select min(txn_id) from TXNS where txn_state=" + TxnHandler.quoteChar('o'));
            if (!rs.next()) {
                throw new IllegalStateException("Scalar query returned no rows?!?!!");
            }
            long lowestOpenTxnId = rs.getLong(1);
            long commitHighWaterMark = rs.wasNull() ? highestAllocatedTxnId + 1L : lowestOpenTxnId;
            int delCnt = stmt.executeUpdate("delete from WRITE_SET where ws_commit_id < " + commitHighWaterMark);
            LOG.info("Deleted " + delCnt + " obsolete rows from WRTIE_SET");
            dbConn.commit();
        }
        catch (SQLException ex) {
            try {
                LOG.warn("WriteSet GC failed due to " + TxnHandler.getMessage(ex), ex);
            }
            catch (Throwable throwable) {
                TxnHandler.close(rs, stmt, dbConn);
                throw throwable;
            }
            TxnHandler.close(rs, stmt, dbConn);
        }
        TxnHandler.close(rs, stmt, dbConn);
    }

    @Override
    @RetrySemantics.CannotRetry
    public LockResponse lock(LockRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        ConnectionLockIdPair connAndLockId = this.enqueueLockWithRetry(rqst);
        try {
            return this.checkLockWithRetry(connAndLockId.dbConn, connAndLockId.extLockId, rqst.getTxnid());
        }
        catch (NoSuchLockException e) {
            throw new MetaException("Couldn't find a lock we just created! " + e.getMessage());
        }
    }

    private ResultSet lockTransactionRecord(Statement stmt, long txnId, Character txnState) throws SQLException, MetaException {
        String query = "select TXN_STATE from TXNS where TXN_ID = " + txnId + (txnState != null ? " AND TXN_STATE=" + TxnHandler.quoteChar(txnState.charValue()) : "");
        ResultSet rs = stmt.executeQuery(sqlGenerator.addForUpdateClause(query));
        if (rs.next()) {
            return rs;
        }
        TxnHandler.close(rs);
        return null;
    }

    private ConnectionLockIdPair enqueueLockWithRetry(LockRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        ConnectionLockIdPair connectionLockIdPair;
        boolean success = false;
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ResultSet lockHandle = null;
        try {
            ArrayList<String> rows;
            this.lockInternal();
            dbConn = this.getDbConn(2);
            long txnid = rqst.getTxnid();
            stmt = dbConn.createStatement();
            if (TxnHandler.isValidTxn(txnid) && (lockHandle = this.lockTransactionRecord(stmt, txnid, Character.valueOf('o'))) == null) {
                TxnHandler.ensureValidTxn(dbConn, txnid, stmt);
                TxnHandler.shouldNeverHappen(txnid);
            }
            String s = sqlGenerator.addForUpdateClause("select nl_next from NEXT_LOCK_ID");
            LOG.debug("Going to execute query <" + s + ">");
            rs = stmt.executeQuery(s);
            if (!rs.next()) {
                LOG.debug("Going to rollback");
                dbConn.rollback();
                throw new MetaException("Transaction tables not properly initialized, no record found in next_lock_id");
            }
            long extLockId = rs.getLong(1);
            s = "update NEXT_LOCK_ID set nl_next = " + (extLockId + 1L);
            LOG.debug("Going to execute update <" + s + ">");
            stmt.executeUpdate(s);
            if (txnid > 0L) {
                rows = new ArrayList<String>();
                for (LockComponent lc : rqst.getComponent()) {
                    boolean updateTxnComponents;
                    if (lc.isSetIsAcid() && !lc.isIsAcid()) continue;
                    if (!lc.isSetOperationType()) {
                        updateTxnComponents = true;
                    } else {
                        switch (lc.getOperationType()) {
                            case INSERT: 
                            case UPDATE: 
                            case DELETE: {
                                if (!lc.isSetIsDynamicPartitionWrite()) {
                                    updateTxnComponents = true;
                                    break;
                                }
                                updateTxnComponents = !lc.isIsDynamicPartitionWrite();
                                break;
                            }
                            case SELECT: {
                                updateTxnComponents = false;
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected DataOperationType: " + lc.getOperationType() + " agentInfo=" + rqst.getAgentInfo() + " " + JavaUtils.txnIdToString(txnid));
                            }
                        }
                    }
                    if (!updateTxnComponents) continue;
                    String dbName = lc.getDbname();
                    String tblName = lc.getTablename();
                    String partName = lc.getPartitionname();
                    rows.add(txnid + ", '" + dbName + "', " + (tblName == null ? "null" : "'" + tblName + "'") + ", " + (partName == null ? "null" : "'" + partName + "'") + "," + TxnHandler.quoteString(OpertaionType.fromDataOperationType(lc.getOperationType()).toString()));
                }
                List<String> queries = sqlGenerator.createInsertValuesStmt("TXN_COMPONENTS (tc_txnid, tc_database, tc_table, tc_partition, tc_operation_type)", rows);
                for (String query : queries) {
                    LOG.debug("Going to execute update <" + query + ">");
                    int dbName = stmt.executeUpdate(query);
                }
            }
            rows = new ArrayList();
            long intLockId = 0L;
            for (LockComponent lc : rqst.getComponent()) {
                if (lc.isSetOperationType() && lc.getOperationType() == DataOperationType.UNSET && (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) || this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEZ_TEST))) {
                    throw new IllegalStateException("Bug: operationType=" + lc.getOperationType() + " for component " + lc + " agentInfo=" + rqst.getAgentInfo());
                }
                ++intLockId;
                String dbName = lc.getDbname();
                String tblName = lc.getTablename();
                String partName = lc.getPartitionname();
                LockType lockType = lc.getType();
                char lockChar = 'z';
                switch (lockType) {
                    case EXCLUSIVE: {
                        lockChar = 'e';
                        break;
                    }
                    case SHARED_READ: {
                        lockChar = 'r';
                        break;
                    }
                    case SHARED_WRITE: {
                        lockChar = 'w';
                    }
                }
                long now = this.getDbTime(dbConn);
                rows.add(extLockId + ", " + intLockId + "," + txnid + ", " + TxnHandler.quoteString(dbName) + ", " + TxnHandler.valueOrNullLiteral(tblName) + ", " + TxnHandler.valueOrNullLiteral(partName) + ", " + TxnHandler.quoteChar('w') + ", " + TxnHandler.quoteChar(lockChar) + ", " + (TxnHandler.isValidTxn(txnid) ? 0L : now) + ", " + TxnHandler.valueOrNullLiteral(rqst.getUser()) + ", " + TxnHandler.valueOrNullLiteral(rqst.getHostname()) + ", " + TxnHandler.valueOrNullLiteral(rqst.getAgentInfo()));
            }
            List<String> queries = sqlGenerator.createInsertValuesStmt("HIVE_LOCKS (hl_lock_ext_id, hl_lock_int_id, hl_txnid, hl_db, hl_table, hl_partition,hl_lock_state, hl_lock_type, hl_last_heartbeat, hl_user, hl_host, hl_agent_info)", rows);
            for (String query : queries) {
                LOG.debug("Going to execute update <" + query + ">");
                int n = stmt.executeUpdate(query);
            }
            dbConn.commit();
            success = true;
            connectionLockIdPair = new ConnectionLockIdPair(dbConn, extLockId);
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "enqueueLockWithRetry(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + StringUtils.stringifyException(e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(lockHandle);
                    TxnHandler.close(rs, stmt, null);
                    if (!success) {
                        TxnHandler.closeDbConn(dbConn);
                    }
                    this.unlockInternal();
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.enqueueLockWithRetry(rqst);
            }
        }
        TxnHandler.close(lockHandle);
        TxnHandler.close(rs, stmt, null);
        if (!success) {
            TxnHandler.closeDbConn(dbConn);
        }
        this.unlockInternal();
        return connectionLockIdPair;
    }

    private LockResponse checkLockWithRetry(Connection dbConn, long extLockId, long txnId) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, MetaException {
        LockResponse lockResponse;
        try {
            this.lockInternal();
            if (dbConn.isClosed()) {
                dbConn = this.getDbConn(2);
            }
            lockResponse = this.checkLock(dbConn, extLockId);
            this.unlockInternal();
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "checkLockWithRetry(" + extLockId + "," + txnId + ")");
                    throw new MetaException("Unable to update transaction database " + StringUtils.stringifyException(e));
                }
                catch (Throwable throwable) {
                    this.unlockInternal();
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.checkLockWithRetry(dbConn, extLockId, txnId);
            }
        }
        TxnHandler.closeDbConn(dbConn);
        return lockResponse;
    }

    @Override
    @RetrySemantics.SafeToRetry
    public LockResponse checkLock(CheckLockRequest rqst) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException {
        LockResponse lockResponse;
        Connection dbConn = null;
        long extLockId = rqst.getLockid();
        try {
            this.lockInternal();
            dbConn = this.getDbConn(2);
            LockInfo info = this.getTxnIdFromLockId(dbConn, extLockId);
            if (info == null) {
                throw new NoSuchLockException("No such lock " + JavaUtils.lockIdToString(extLockId));
            }
            if (info.txnId > 0L) {
                this.heartbeatTxn(dbConn, info.txnId);
            } else {
                this.heartbeatLock(dbConn, extLockId);
            }
            lockResponse = this.checkLock(dbConn, extLockId);
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "checkLock(" + rqst + " )");
                    throw new MetaException("Unable to update transaction database " + JavaUtils.lockIdToString(extLockId) + " " + StringUtils.stringifyException(e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeDbConn(dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.checkLock(rqst);
            }
        }
        TxnHandler.closeDbConn(dbConn);
        this.unlockInternal();
        return lockResponse;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @RetrySemantics.Idempotent
    public void unlock(UnlockRequest rqst) throws NoSuchLockException, TxnOpenException, MetaException {
        try {
            block9: {
                dbConn = null;
                stmt = null;
                extLockId = rqst.getLockid();
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                s = "delete from HIVE_LOCKS where hl_lock_ext_id = " + extLockId + " AND (hl_txnid = 0 OR" + " (hl_txnid <> 0 AND hl_lock_state = '" + 'w' + "'))";
                TxnHandler.LOG.debug("Going to execute update <" + s + ">");
                rc = stmt.executeUpdate(s);
                if (rc >= 1) ** GOTO lbl30
                TxnHandler.LOG.debug("Going to rollback");
                dbConn.rollback();
                info = this.getTxnIdFromLockId(dbConn, extLockId);
                if (info != null) break block9;
                TxnHandler.LOG.info("No lock in w mode found for unlock(" + JavaUtils.lockIdToString(rqst.getLockid()) + ")");
                TxnHandler.closeStmt(stmt);
                TxnHandler.closeDbConn(dbConn);
                return;
            }
            try {
                if (LockInfo.access$400(info) != 0L) {
                    msg = "Unlocking locks associated with transaction not permitted.  " + info;
                    TxnHandler.LOG.error(msg);
                    throw new TxnOpenException(msg);
                }
                if (LockInfo.access$400(info) == 0L) {
                    msg = "Found lock in unexpected state " + info;
                    TxnHandler.LOG.error(msg);
                    throw new MetaException(msg);
                }
lbl30:
                // 3 sources

                TxnHandler.LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    TxnHandler.LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "unlock(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + JavaUtils.lockIdToString(extLockId) + " " + StringUtils.stringifyException(e));
                }
                catch (Throwable var10_12) {
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    throw var10_12;
                }
            }
            TxnHandler.closeStmt(stmt);
            TxnHandler.closeDbConn(dbConn);
        }
        catch (RetryException e) {
            this.unlock(rqst);
        }
    }

    @Override
    @RetrySemantics.ReadOnly
    public ShowLocksResponse showLocks(ShowLocksRequest rqst) throws MetaException {
        try {
            Connection dbConn = null;
            ShowLocksResponse rsp = new ShowLocksResponse();
            ArrayList<ShowLocksResponseElement> elems = new ArrayList<ShowLocksResponseElement>();
            ArrayList<LockInfoExt> sortedList = new ArrayList<LockInfoExt>();
            Statement stmt = null;
            try {
                String whereClause;
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "select hl_lock_ext_id, hl_txnid, hl_db, hl_table, hl_partition, hl_lock_state, hl_lock_type, hl_last_heartbeat, hl_acquired_at, hl_user, hl_host, hl_lock_int_id,hl_blockedby_ext_id, hl_blockedby_int_id, hl_agent_info from HIVE_LOCKS";
                String dbName = rqst.getDbname();
                String tableName = rqst.getTablename();
                String partName = rqst.getPartname();
                StringBuilder filter = new StringBuilder();
                if (dbName != null && !dbName.isEmpty()) {
                    filter.append("hl_db=").append(TxnHandler.quoteString(dbName));
                }
                if (tableName != null && !tableName.isEmpty()) {
                    if (filter.length() > 0) {
                        filter.append(" and ");
                    }
                    filter.append("hl_table=").append(TxnHandler.quoteString(tableName));
                }
                if (partName != null && !partName.isEmpty()) {
                    if (filter.length() > 0) {
                        filter.append(" and ");
                    }
                    filter.append("hl_partition=").append(TxnHandler.quoteString(partName));
                }
                if (!(whereClause = filter.toString()).isEmpty()) {
                    s = s + " where " + whereClause;
                }
                LOG.debug("Doing to execute query <" + s + ">");
                ResultSet rs = stmt.executeQuery(s);
                while (rs.next()) {
                    ShowLocksResponseElement e = new ShowLocksResponseElement();
                    e.setLockid(rs.getLong(1));
                    long txnid = rs.getLong(2);
                    if (!rs.wasNull()) {
                        e.setTxnid(txnid);
                    }
                    e.setDbname(rs.getString(3));
                    e.setTablename(rs.getString(4));
                    String partition = rs.getString(5);
                    if (partition != null) {
                        e.setPartname(partition);
                    }
                    switch (rs.getString(6).charAt(0)) {
                        case 'a': {
                            e.setState(LockState.ACQUIRED);
                            break;
                        }
                        case 'w': {
                            e.setState(LockState.WAITING);
                            break;
                        }
                        default: {
                            throw new MetaException("Unknown lock state " + rs.getString(6).charAt(0));
                        }
                    }
                    switch (rs.getString(7).charAt(0)) {
                        case 'w': {
                            e.setType(LockType.SHARED_WRITE);
                            break;
                        }
                        case 'e': {
                            e.setType(LockType.EXCLUSIVE);
                            break;
                        }
                        case 'r': {
                            e.setType(LockType.SHARED_READ);
                            break;
                        }
                        default: {
                            throw new MetaException("Unknown lock type " + rs.getString(6).charAt(0));
                        }
                    }
                    e.setLastheartbeat(rs.getLong(8));
                    long acquiredAt = rs.getLong(9);
                    if (!rs.wasNull()) {
                        e.setAcquiredat(acquiredAt);
                    }
                    e.setUser(rs.getString(10));
                    e.setHostname(rs.getString(11));
                    e.setLockIdInternal(rs.getLong(12));
                    long id = rs.getLong(13);
                    if (!rs.wasNull()) {
                        e.setBlockedByExtId(id);
                    }
                    id = rs.getLong(14);
                    if (!rs.wasNull()) {
                        e.setBlockedByIntId(id);
                    }
                    e.setAgentInfo(rs.getString(15));
                    sortedList.add(new LockInfoExt(e));
                }
                LOG.debug("Going to rollback");
                dbConn.rollback();
            }
            catch (SQLException e) {
                try {
                    this.checkRetryable(dbConn, e, "showLocks(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + StringUtils.stringifyException(e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            TxnHandler.closeStmt(stmt);
            TxnHandler.closeDbConn(dbConn);
            Collections.sort(sortedList, new LockInfoComparator());
            for (LockInfoExt lockInfoExt : sortedList) {
                elems.add(lockInfoExt.e);
            }
            rsp.setLocks(elems);
            return rsp;
        }
        catch (RetryException e) {
            return this.showLocks(rqst);
        }
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void heartbeat(HeartbeatRequest ids) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException {
        try {
            Connection dbConn = null;
            try {
                dbConn = this.getDbConn(2);
                this.heartbeatLock(dbConn, ids.getLockid());
                this.heartbeatTxn(dbConn, ids.getTxnid());
            }
            catch (SQLException e) {
                LOG.debug("Going to rollback");
                TxnHandler.rollbackDBConn(dbConn);
                this.checkRetryable(dbConn, e, "heartbeat(" + ids + ")");
                throw new MetaException("Unable to select from transaction database " + StringUtils.stringifyException(e));
            }
            finally {
                TxnHandler.closeDbConn(dbConn);
            }
        }
        catch (RetryException e) {
            this.heartbeat(ids);
        }
    }

    @Override
    @RetrySemantics.SafeToRetry
    public HeartbeatTxnRangeResponse heartbeatTxnRange(HeartbeatTxnRangeRequest rqst) throws MetaException {
        HeartbeatTxnRangeResponse txn2;
        Connection dbConn = null;
        HeartbeatTxnRangeResponse rsp = new HeartbeatTxnRangeResponse();
        HashSet<Long> nosuch = new HashSet<Long>();
        HashSet<Long> aborted = new HashSet<Long>();
        rsp.setNosuch(nosuch);
        rsp.setAborted(aborted);
        try {
            dbConn = this.getDbConn(2);
            for (long txn2 = rqst.getMin(); txn2 <= rqst.getMax(); ++txn2) {
                try {
                    this.heartbeatTxn(dbConn, txn2);
                    continue;
                }
                catch (NoSuchTxnException e) {
                    nosuch.add(txn2);
                    continue;
                }
                catch (TxnAbortedException e) {
                    aborted.add(txn2);
                }
            }
            txn2 = rsp;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "heartbeatTxnRange(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + StringUtils.stringifyException(e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.heartbeatTxnRange(rqst);
            }
        }
        TxnHandler.closeDbConn(dbConn);
        return txn2;
    }

    long generateCompactionQueueId(Statement stmt) throws SQLException, MetaException {
        String s = sqlGenerator.addForUpdateClause("select ncq_next from NEXT_COMPACTION_QUEUE_ID");
        LOG.debug("going to execute query <" + s + ">");
        ResultSet rs = stmt.executeQuery(s);
        if (!rs.next()) {
            throw new IllegalStateException("Transaction tables not properly initiated, no record found in next_compaction_queue_id");
        }
        long id = rs.getLong(1);
        s = "update NEXT_COMPACTION_QUEUE_ID set ncq_next = " + (id + 1L);
        LOG.debug("Going to execute update <" + s + ">");
        stmt.executeUpdate(s);
        return id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RetrySemantics.Idempotent
    public CompactionResponse compact(CompactionRequest rqst) throws MetaException {
        try {
            CompactionResponse compactionResponse;
            ResultSet rs;
            long id;
            TxnStore.MutexAPI.LockHandle handle;
            Statement stmt;
            Connection dbConn;
            block22: {
                dbConn = null;
                stmt = null;
                handle = null;
                this.lockInternal();
                handle = this.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.CompactionScheduler.name());
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                id = this.generateCompactionQueueId(stmt);
                StringBuilder sb = new StringBuilder("select cq_id, cq_state from COMPACTION_QUEUE where").append(" cq_state IN(").append(TxnHandler.quoteChar('i')).append(",").append(TxnHandler.quoteChar('w')).append(") AND cq_database=").append(TxnHandler.quoteString(rqst.getDbname())).append(" AND cq_table=").append(TxnHandler.quoteString(rqst.getTablename())).append(" AND ");
                if (rqst.getPartitionname() == null) {
                    sb.append("cq_partition is null");
                } else {
                    sb.append("cq_partition=").append(TxnHandler.quoteString(rqst.getPartitionname()));
                }
                LOG.debug("Going to execute query <" + sb.toString() + ">");
                rs = stmt.executeQuery(sb.toString());
                if (!rs.next()) break block22;
                long enqueuedId = rs.getLong(1);
                String state = TxnHandler.compactorStateToResponse(rs.getString(2).charAt(0));
                LOG.info("Ignoring request to compact " + rqst.getDbname() + "/" + rqst.getTablename() + "/" + rqst.getPartitionname() + " since it is already " + TxnHandler.quoteString(state) + " with id=" + enqueuedId);
                CompactionResponse compactionResponse2 = new CompactionResponse(enqueuedId, state, false);
                TxnHandler.closeStmt(stmt);
                TxnHandler.closeDbConn(dbConn);
                if (handle != null) {
                    handle.releaseLocks();
                }
                this.unlockInternal();
                return compactionResponse2;
            }
            try {
                TxnHandler.close(rs);
                StringBuilder buf = new StringBuilder("insert into COMPACTION_QUEUE (cq_id, cq_database, cq_table, ");
                String partName = rqst.getPartitionname();
                if (partName != null) {
                    buf.append("cq_partition, ");
                }
                buf.append("cq_state, cq_type");
                if (rqst.getProperties() != null) {
                    buf.append(", cq_tblproperties");
                }
                if (rqst.getRunas() != null) {
                    buf.append(", cq_run_as");
                }
                buf.append(") values (");
                buf.append(id);
                buf.append(", '");
                buf.append(rqst.getDbname());
                buf.append("', '");
                buf.append(rqst.getTablename());
                buf.append("', '");
                if (partName != null) {
                    buf.append(partName);
                    buf.append("', '");
                }
                buf.append('i');
                buf.append("', '");
                switch (rqst.getType()) {
                    case MAJOR: {
                        buf.append('a');
                        break;
                    }
                    case MINOR: {
                        buf.append('i');
                        break;
                    }
                    default: {
                        LOG.debug("Going to rollback");
                        dbConn.rollback();
                        throw new MetaException("Unexpected compaction type " + rqst.getType().toString());
                    }
                }
                if (rqst.getProperties() != null) {
                    buf.append("', '");
                    buf.append(new StringableMap(rqst.getProperties()).toString());
                }
                if (rqst.getRunas() != null) {
                    buf.append("', '");
                    buf.append(rqst.getRunas());
                }
                buf.append("')");
                String s = buf.toString();
                LOG.debug("Going to execute update <" + s + ">");
                stmt.executeUpdate(s);
                LOG.debug("Going to commit");
                dbConn.commit();
                compactionResponse = new CompactionResponse(id, "initiated", true);
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "compact(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + StringUtils.stringifyException(e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    if (handle != null) {
                        handle.releaseLocks();
                    }
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.closeStmt(stmt);
            TxnHandler.closeDbConn(dbConn);
            if (handle != null) {
                handle.releaseLocks();
            }
            this.unlockInternal();
            return compactionResponse;
        }
        catch (RetryException e2) {
            return this.compact(rqst);
        }
    }

    private static String compactorStateToResponse(char s) {
        switch (s) {
            case 'i': {
                return "initiated";
            }
            case 'w': {
                return "working";
            }
            case 'r': {
                return "ready for cleaning";
            }
            case 'f': {
                return "failed";
            }
            case 's': {
                return "succeeded";
            }
            case 'a': {
                return "attempted";
            }
        }
        return Character.toString(s);
    }

    @Override
    @RetrySemantics.ReadOnly
    public ShowCompactResponse showCompact(ShowCompactRequest rqst) throws MetaException {
        ShowCompactResponse response = new ShowCompactResponse(new ArrayList<ShowCompactResponseElement>());
        Connection dbConn = null;
        Statement stmt = null;
        try {
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "select cq_database, cq_table, cq_partition, cq_state, cq_type, cq_worker_id, cq_start, -1 cc_end, cq_run_as, cq_hadoop_job_id, cq_id from COMPACTION_QUEUE union all select cc_database, cc_table, cc_partition, cc_state, cc_type, cc_worker_id, cc_start, cc_end, cc_run_as, cc_hadoop_job_id, cc_id from COMPLETED_COMPACTIONS";
                LOG.debug("Going to execute query <" + s + ">");
                ResultSet rs = stmt.executeQuery(s);
                while (rs.next()) {
                    long endTime;
                    ShowCompactResponseElement e = new ShowCompactResponseElement();
                    e.setDbname(rs.getString(1));
                    e.setTablename(rs.getString(2));
                    e.setPartitionname(rs.getString(3));
                    e.setState(TxnHandler.compactorStateToResponse(rs.getString(4).charAt(0)));
                    switch (rs.getString(5).charAt(0)) {
                        case 'a': {
                            e.setType(CompactionType.MAJOR);
                            break;
                        }
                        case 'i': {
                            e.setType(CompactionType.MINOR);
                            break;
                        }
                    }
                    e.setWorkerid(rs.getString(6));
                    long start = rs.getLong(7);
                    if (!rs.wasNull()) {
                        e.setStart(start);
                    }
                    if ((endTime = rs.getLong(8)) != -1L) {
                        e.setEndTime(endTime);
                    }
                    e.setRunAs(rs.getString(9));
                    e.setHadoopJobId(rs.getString(10));
                    e.setId(rs.getLong(11));
                    response.addToCompacts(e);
                }
                LOG.debug("Going to rollback");
                dbConn.rollback();
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "showCompact(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + StringUtils.stringifyException(e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            TxnHandler.closeStmt(stmt);
            TxnHandler.closeDbConn(dbConn);
            return response;
        }
        catch (RetryException e) {
            return this.showCompact(rqst);
        }
    }

    private static void shouldNeverHappen(long txnid) {
        throw new RuntimeException("This should never happen: " + JavaUtils.txnIdToString(txnid));
    }

    private static void shouldNeverHappen(long txnid, long extLockId, long intLockId) {
        throw new RuntimeException("This should never happen: " + JavaUtils.txnIdToString(txnid) + " " + JavaUtils.lockIdToString(extLockId) + " " + intLockId);
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void addDynamicPartitions(AddDynamicPartitions rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet lockHandle = null;
        Object rs = null;
        try {
            try {
                this.lockInternal();
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                lockHandle = this.lockTransactionRecord(stmt, rqst.getTxnid(), Character.valueOf('o'));
                if (lockHandle == null) {
                    TxnHandler.ensureValidTxn(dbConn, rqst.getTxnid(), stmt);
                    TxnHandler.shouldNeverHappen(rqst.getTxnid());
                }
                OpertaionType ot = OpertaionType.UPDATE;
                if (rqst.isSetOperationType()) {
                    ot = OpertaionType.fromDataOperationType(rqst.getOperationType());
                }
                ArrayList<String> rows = new ArrayList<String>();
                for (String partName : rqst.getPartitionnames()) {
                    rows.add(rqst.getTxnid() + "," + TxnHandler.quoteString(rqst.getDbname()) + "," + TxnHandler.quoteString(rqst.getTablename()) + "," + TxnHandler.quoteString(partName) + "," + TxnHandler.quoteChar(ot.sqlConst));
                }
                int modCount = 0;
                List<String> queries = sqlGenerator.createInsertValuesStmt("TXN_COMPONENTS (tc_txnid, tc_database, tc_table, tc_partition, tc_operation_type)", rows);
                for (String query : queries) {
                    LOG.debug("Going to execute update <" + query + ">");
                    modCount = stmt.executeUpdate(query);
                }
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback");
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "addDynamicPartitions(" + rqst + ")");
                    throw new MetaException("Unable to insert into from transaction database " + StringUtils.stringifyException(e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(lockHandle, stmt, dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.close(lockHandle, stmt, dbConn);
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.addDynamicPartitions(rqst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.Idempotent
    public void cleanupRecords(HiveObjectType type, Database db, Table table, Iterator<Partition> partitionIterator) throws MetaException {
        block14: {
            try {
                Connection dbConn = null;
                Statement stmt = null;
                try {
                    dbConn = this.getDbConn(2);
                    stmt = dbConn.createStatement();
                    ArrayList<String> queries = new ArrayList<String>();
                    StringBuilder buff = new StringBuilder();
                    switch (type) {
                        case DATABASE: {
                            String dbName = db.getName();
                            buff.append("delete from TXN_COMPONENTS where tc_database='");
                            buff.append(dbName);
                            buff.append("'");
                            queries.add(buff.toString());
                            buff.setLength(0);
                            buff.append("delete from COMPLETED_TXN_COMPONENTS where ctc_database='");
                            buff.append(dbName);
                            buff.append("'");
                            queries.add(buff.toString());
                            buff.setLength(0);
                            buff.append("delete from COMPACTION_QUEUE where cq_database='");
                            buff.append(dbName);
                            buff.append("'");
                            queries.add(buff.toString());
                            buff.setLength(0);
                            buff.append("delete from COMPLETED_COMPACTIONS where cc_database='");
                            buff.append(dbName);
                            buff.append("'");
                            queries.add(buff.toString());
                            break;
                        }
                        case TABLE: {
                            String dbName = table.getDbName();
                            String tblName = table.getTableName();
                            buff.append("delete from TXN_COMPONENTS where tc_database='");
                            buff.append(dbName);
                            buff.append("' and tc_table='");
                            buff.append(tblName);
                            buff.append("'");
                            queries.add(buff.toString());
                            buff.setLength(0);
                            buff.append("delete from COMPLETED_TXN_COMPONENTS where ctc_database='");
                            buff.append(dbName);
                            buff.append("' and ctc_table='");
                            buff.append(tblName);
                            buff.append("'");
                            queries.add(buff.toString());
                            buff.setLength(0);
                            buff.append("delete from COMPACTION_QUEUE where cq_database='");
                            buff.append(dbName);
                            buff.append("' and cq_table='");
                            buff.append(tblName);
                            buff.append("'");
                            queries.add(buff.toString());
                            buff.setLength(0);
                            buff.append("delete from COMPLETED_COMPACTIONS where cc_database='");
                            buff.append(dbName);
                            buff.append("' and cc_table='");
                            buff.append(tblName);
                            buff.append("'");
                            queries.add(buff.toString());
                            break;
                        }
                        case PARTITION: {
                            String dbName = table.getDbName();
                            String tblName = table.getTableName();
                            List<FieldSchema> partCols = table.getPartitionKeys();
                            while (partitionIterator.hasNext()) {
                                Partition p = partitionIterator.next();
                                List<String> partVals = p.getValues();
                                String partName = Warehouse.makePartName(partCols, partVals);
                                buff.append("delete from TXN_COMPONENTS where tc_database='");
                                buff.append(dbName);
                                buff.append("' and tc_table='");
                                buff.append(tblName);
                                buff.append("' and tc_partition='");
                                buff.append(partName);
                                buff.append("'");
                                queries.add(buff.toString());
                                buff.setLength(0);
                                buff.append("delete from COMPLETED_TXN_COMPONENTS where ctc_database='");
                                buff.append(dbName);
                                buff.append("' and ctc_table='");
                                buff.append(tblName);
                                buff.append("' and ctc_partition='");
                                buff.append(partName);
                                buff.append("'");
                                queries.add(buff.toString());
                                buff.setLength(0);
                                buff.append("delete from COMPACTION_QUEUE where cq_database='");
                                buff.append(dbName);
                                buff.append("' and cq_table='");
                                buff.append(tblName);
                                buff.append("' and cq_partition='");
                                buff.append(partName);
                                buff.append("'");
                                queries.add(buff.toString());
                                buff.setLength(0);
                                buff.append("delete from COMPLETED_COMPACTIONS where cc_database='");
                                buff.append(dbName);
                                buff.append("' and cc_table='");
                                buff.append(tblName);
                                buff.append("' and cc_partition='");
                                buff.append(partName);
                                buff.append("'");
                                queries.add(buff.toString());
                            }
                            break;
                        }
                        default: {
                            throw new MetaException("Invalid object type for cleanup: " + type);
                        }
                    }
                    for (String query : queries) {
                        LOG.debug("Going to execute update <" + query + ">");
                        stmt.executeUpdate(query);
                    }
                    LOG.debug("Going to commit");
                    dbConn.commit();
                }
                catch (SQLException e) {
                    try {
                        LOG.debug("Going to rollback");
                        TxnHandler.rollbackDBConn(dbConn);
                        this.checkRetryable(dbConn, e, "cleanupRecords");
                        if (!e.getMessage().contains("does not exist")) {
                            throw new MetaException("Unable to clean up " + StringUtils.stringifyException(e));
                        }
                        LOG.warn("Cannot perform cleanup since metastore table does not exist");
                    }
                    catch (Throwable throwable) {
                        TxnHandler.closeStmt(stmt);
                        TxnHandler.closeDbConn(dbConn);
                        throw throwable;
                    }
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    break block14;
                }
                TxnHandler.closeStmt(stmt);
                TxnHandler.closeDbConn(dbConn);
            }
            catch (RetryException e) {
                this.cleanupRecords(type, db, table, partitionIterator);
            }
        }
    }

    public static boolean isAcidTable(Table table) {
        if (table == null) {
            return false;
        }
        Map<String, String> parameters = table.getParameters();
        String tableIsTransactional = parameters.get("transactional");
        return tableIsTransactional != null && tableIsTransactional.equalsIgnoreCase("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public int numLocksInLockTable() throws SQLException, MetaException {
        int n;
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            String s = "select count(*) from HIVE_LOCKS";
            LOG.debug("Going to execute query <" + s + ">");
            rs = stmt.executeQuery(s);
            rs.next();
            int rc = rs.getInt(1);
            dbConn.rollback();
            n = rc;
        }
        catch (Throwable throwable) {
            TxnHandler.close(rs, stmt, dbConn);
            throw throwable;
        }
        TxnHandler.close(rs, stmt, dbConn);
        return n;
    }

    @Override
    public long setTimeout(long milliseconds) {
        long previous_timeout = this.timeout;
        this.timeout = milliseconds;
        return previous_timeout;
    }

    Connection getDbConn(int isolationLevel) throws SQLException {
        return this.getDbConn(isolationLevel, connPool);
    }

    private Connection getDbConn(int isolationLevel, DataSource connPool) throws SQLException {
        int rc = doRetryOnConnPool ? 10 : 1;
        Connection dbConn = null;
        while (true) {
            try {
                dbConn = connPool.getConnection();
                dbConn.setAutoCommit(false);
                dbConn.setTransactionIsolation(isolationLevel);
                return dbConn;
            }
            catch (SQLException e) {
                TxnHandler.closeDbConn(dbConn);
                if (--rc <= 0) {
                    throw e;
                }
                LOG.error("There is a problem with a connection from the pool, retrying(rc=" + rc + "): " + TxnHandler.getMessage(e), e);
                continue;
            }
            break;
        }
    }

    static void rollbackDBConn(Connection dbConn) {
        try {
            if (dbConn != null && !dbConn.isClosed()) {
                dbConn.rollback();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to rollback db connection " + TxnHandler.getMessage(e));
        }
    }

    protected static void closeDbConn(Connection dbConn) {
        try {
            if (dbConn != null && !dbConn.isClosed()) {
                dbConn.close();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to close db connection " + TxnHandler.getMessage(e));
        }
    }

    protected static void closeStmt(Statement stmt) {
        try {
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to close statement " + TxnHandler.getMessage(e));
        }
    }

    static void close(ResultSet rs) {
        try {
            if (rs != null && !rs.isClosed()) {
                rs.close();
            }
        }
        catch (SQLException ex) {
            LOG.warn("Failed to close statement " + TxnHandler.getMessage(ex));
        }
    }

    static void close(ResultSet rs, Statement stmt, Connection dbConn) {
        TxnHandler.close(rs);
        TxnHandler.closeStmt(stmt);
        TxnHandler.closeDbConn(dbConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkRetryable(Connection conn, SQLException e, String caller) throws RetryException, MetaException {
        boolean sendRetrySignal;
        block14: {
            sendRetrySignal = false;
            try {
                if (dbProduct == null) {
                    throw new IllegalStateException("DB Type not determined yet.");
                }
                if (e instanceof SQLTransactionRollbackException || (dbProduct == DatabaseProduct.MYSQL || dbProduct == DatabaseProduct.POSTGRES || dbProduct == DatabaseProduct.SQLSERVER) && e.getSQLState().equals("40001") || dbProduct == DatabaseProduct.POSTGRES && e.getSQLState().equals("40P01") || dbProduct == DatabaseProduct.ORACLE && (e.getMessage().contains("deadlock detected") || e.getMessage().contains("can't serialize access for this transaction"))) {
                    if (this.deadlockCnt++ < 10) {
                        long waitInterval = this.deadlockRetryInterval * (long)this.deadlockCnt;
                        LOG.warn("Deadlock detected in " + caller + ". Will wait " + waitInterval + "ms try again up to " + (10 - this.deadlockCnt + 1) + " times.");
                        try {
                            Thread.sleep(waitInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        sendRetrySignal = true;
                        break block14;
                    }
                    LOG.error("Too many repeated deadlocks in " + caller + ", giving up.");
                    break block14;
                }
                if (TxnHandler.isRetryable(this.conf, e, dbProduct)) {
                    if (this.retryNum++ < this.retryLimit) {
                        LOG.warn("Retryable error detected in " + caller + ".  Will wait " + this.retryInterval + "ms and retry up to " + (this.retryLimit - this.retryNum + 1) + " times.  Error: " + TxnHandler.getMessage(e));
                        try {
                            Thread.sleep(this.retryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        sendRetrySignal = true;
                        break block14;
                    }
                    LOG.error("Fatal error in " + caller + ". Retry limit (" + this.retryLimit + ") reached. Last error: " + TxnHandler.getMessage(e));
                    break block14;
                }
                LOG.info("Non-retryable error in " + caller + " : " + TxnHandler.getMessage(e));
            }
            finally {
                if (!sendRetrySignal) {
                    this.deadlockCnt = 0;
                    this.retryNum = 0;
                }
            }
        }
        if (sendRetrySignal) {
            throw new RetryException();
        }
    }

    protected long getDbTime(Connection conn) throws MetaException {
        Statement stmt = null;
        try {
            String s;
            stmt = conn.createStatement();
            switch (dbProduct) {
                case DERBY: {
                    s = "values current_timestamp";
                    break;
                }
                case MYSQL: 
                case POSTGRES: 
                case SQLSERVER: {
                    s = "select current_timestamp";
                    break;
                }
                case ORACLE: {
                    s = "select current_timestamp from dual";
                    break;
                }
                default: {
                    String msg = "Unknown database product: " + dbProduct.toString();
                    LOG.error(msg);
                    throw new MetaException(msg);
                }
            }
            LOG.debug("Going to execute query <" + s + ">");
            ResultSet rs = stmt.executeQuery(s);
            if (!rs.next()) {
                throw new MetaException("No results from date query");
            }
            long l = rs.getTimestamp(1).getTime();
            return l;
        }
        catch (SQLException e) {
            String msg = "Unable to determine current time: " + e.getMessage();
            LOG.error(msg);
            throw new MetaException(msg);
        }
        finally {
            TxnHandler.closeStmt(stmt);
        }
    }

    protected String getIdentifierQuoteString(Connection conn) throws SQLException {
        if (this.identifierQuoteString == null) {
            this.identifierQuoteString = conn.getMetaData().getIdentifierQuoteString();
        }
        return this.identifierQuoteString;
    }

    private void checkQFileTestHack() {
        block3: {
            boolean hackOn;
            boolean bl = hackOn = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_IN_TEST) || HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_IN_TEZ_TEST);
            if (hackOn) {
                LOG.info("Hacking in canned values for transaction manager");
                TxnDbUtil.setConfValues(this.conf);
                try {
                    TxnDbUtil.prepDb();
                }
                catch (Exception e) {
                    if (e.getMessage() == null || e.getMessage().contains("already exists")) break block3;
                    throw new RuntimeException("Unable to set up transaction database for testing: " + e.getMessage(), e);
                }
            }
        }
    }

    private int abortTxns(Connection dbConn, List<Long> txnids, boolean isStrict) throws SQLException {
        return this.abortTxns(dbConn, txnids, -1L, isStrict);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int abortTxns(Connection dbConn, List<Long> txnids, long max_heartbeat, boolean isStrict) throws SQLException {
        Statement stmt = null;
        int updateCnt = 0;
        if (txnids.isEmpty()) {
            return 0;
        }
        try {
            stmt = dbConn.createStatement();
            ArrayList<String> queries = new ArrayList<String>();
            StringBuilder prefix = new StringBuilder();
            StringBuilder suffix = new StringBuilder();
            prefix.append("update TXNS set txn_state = " + TxnHandler.quoteChar('a') + " where txn_state = " + TxnHandler.quoteChar('o') + " and ");
            if (max_heartbeat > 0L) {
                suffix.append(" and txn_last_heartbeat < ").append(max_heartbeat);
            } else {
                suffix.append("");
            }
            TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, txnids, "txn_id", true, false);
            for (String query : queries) {
                LOG.debug("Going to execute update <" + query + ">");
                updateCnt += stmt.executeUpdate(query);
            }
            if (updateCnt < txnids.size() && isStrict) {
                int n = updateCnt;
                return n;
            }
            queries.clear();
            prefix.setLength(0);
            suffix.setLength(0);
            prefix.append("delete from HIVE_LOCKS where ");
            suffix.append("");
            TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, txnids, "hl_txnid", false, false);
            for (String query : queries) {
                LOG.debug("Going to execute update <" + query + ">");
                int rc = stmt.executeUpdate(query);
                LOG.debug("Removed " + rc + " records from HIVE_LOCKS");
            }
        }
        finally {
            TxnHandler.closeStmt(stmt);
        }
        return updateCnt;
    }

    private static boolean isValidTxn(long txnId) {
        return txnId != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RetrySemantics.SafeToRetry(value={"See @SafeToRetry"})
    private LockResponse checkLock(Connection dbConn, long extLockId) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, MetaException, SQLException {
        TxnStore.MutexAPI.LockHandle handle = null;
        Statement stmt = null;
        ResultSet rs = null;
        LockResponse response = new LockResponse();
        boolean isPartOfDynamicPartitionInsert = true;
        try {
            boolean bl;
            handle = this.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.CheckLock.name());
            List<LockInfo> locksBeingChecked = this.getLockInfoFromLockId(dbConn, extLockId);
            response.setLockid(extLockId);
            LOG.debug("checkLock(): Setting savepoint. extLockId=" + JavaUtils.lockIdToString(extLockId));
            Savepoint save = dbConn.setSavepoint();
            StringBuilder query = new StringBuilder("select hl_lock_ext_id, hl_lock_int_id, hl_db, hl_table, hl_partition, hl_lock_state, hl_lock_type, hl_txnid from HIVE_LOCKS where hl_db in (");
            HashSet<String> strings = new HashSet<String>(locksBeingChecked.size());
            ArrayList<LockInfo> writeSet = new ArrayList<LockInfo>();
            for (LockInfo lockInfo : locksBeingChecked) {
                strings.add(lockInfo.db);
                if (isPartOfDynamicPartitionInsert || lockInfo.type != LockType.SHARED_WRITE) continue;
                writeSet.add(lockInfo);
            }
            if (!writeSet.isEmpty()) {
                if (((LockInfo)writeSet.get(0)).txnId == 0L) {
                    throw new IllegalStateException("Found Write lock for " + JavaUtils.lockIdToString(extLockId) + " but no txnid");
                }
                stmt = dbConn.createStatement();
                StringBuilder sb = new StringBuilder(" ws_database, ws_table, ws_partition, ws_txnid, ws_commit_id from WRITE_SET where ws_commit_id >= " + ((LockInfo)writeSet.get(0)).txnId + " and (");
                for (LockInfo lockInfo : writeSet) {
                    sb.append("(ws_database = ").append(TxnHandler.quoteString(lockInfo.db)).append(" and ws_table = ").append(TxnHandler.quoteString(lockInfo.table)).append(" and ws_partition ").append(lockInfo.partition == null ? "is null" : "= " + TxnHandler.quoteString(lockInfo.partition)).append(") or ");
                }
                sb.setLength(sb.length() - 4);
                sb.append(")");
                rs = stmt.executeQuery(sqlGenerator.addLimitClause(1, sb.toString()));
                if (rs.next()) {
                    void var15_19;
                    String string = rs.getString(1) + '/' + rs.getString(2);
                    String string2 = rs.getString(3);
                    if (string2 != null) {
                        String string3 = string + '/' + string2;
                    }
                    String msg = "Aborting " + JavaUtils.txnIdToString(((LockInfo)writeSet.get(0)).txnId) + " since a concurrent committed transaction [" + JavaUtils.txnIdToString(rs.getLong(4)) + "," + rs.getLong(5) + "] has already updated resouce '" + (String)var15_19 + "'";
                    LOG.info(msg);
                    if (this.abortTxns(dbConn, Collections.singletonList(((LockInfo)writeSet.get(0)).txnId), true) != 1) {
                        throw new IllegalStateException(msg + " FAILED!");
                    }
                    dbConn.commit();
                    throw new TxnAbortedException(msg);
                }
                TxnHandler.close(rs, stmt, null);
            }
            boolean first = true;
            for (String string : strings) {
                if (first) {
                    first = false;
                } else {
                    query.append(", ");
                }
                query.append('\'');
                query.append(string);
                query.append('\'');
            }
            query.append(")");
            boolean bl2 = false;
            strings.clear();
            for (LockInfo info : locksBeingChecked) {
                if (info.table == null) {
                    bl = true;
                    break;
                }
                strings.add(info.table);
            }
            if (!bl) {
                boolean bl3;
                query.append(" and (hl_table is null or hl_table in(");
                first = true;
                for (String s : strings) {
                    if (first) {
                        first = false;
                    } else {
                        query.append(", ");
                    }
                    query.append('\'');
                    query.append(s);
                    query.append('\'');
                }
                query.append("))");
                boolean bl4 = false;
                strings.clear();
                for (LockInfo info : locksBeingChecked) {
                    if (info.partition == null) {
                        bl3 = true;
                        break;
                    }
                    strings.add(info.partition);
                }
                if (!bl3) {
                    query.append(" and (hl_partition is null or hl_partition in(");
                    first = true;
                    for (String s : strings) {
                        if (first) {
                            first = false;
                        } else {
                            query.append(", ");
                        }
                        query.append('\'');
                        query.append(s);
                        query.append('\'');
                    }
                    query.append("))");
                }
            }
            query.append(" and hl_lock_ext_id <= ").append(extLockId);
            LOG.debug("Going to execute query <" + query.toString() + ">");
            stmt = dbConn.createStatement();
            rs = stmt.executeQuery(query.toString());
            TreeSet<LockInfo> treeSet = new TreeSet<LockInfo>(new LockInfoComparator());
            while (rs.next()) {
                treeSet.add(new LockInfo(rs));
            }
            LockInfo[] locks = treeSet.toArray(new LockInfo[treeSet.size()]);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Locks to check(full): ");
                for (LockInfo info : locks) {
                    LOG.debug("  " + info);
                }
            }
            LockInfo[] lockInfoArray = locksBeingChecked.iterator();
            while (true) {
                int index;
                LockInfo info;
                if (lockInfoArray.hasNext()) {
                    info = (LockInfo)lockInfoArray.next();
                    index = -1;
                } else {
                    LOG.debug("Going to commit");
                    dbConn.commit();
                    response.setState(LockState.ACQUIRED);
                    TxnHandler.close(rs, stmt, null);
                    if (handle == null) return response;
                    handle.releaseLocks();
                    return response;
                }
                for (int i = 0; i < locks.length; ++i) {
                    if (!locks[i].equals(info)) continue;
                    index = i;
                    break;
                }
                if (index == -1) {
                    LOG.debug("Going to rollback");
                    dbConn.rollback();
                    throw new MetaException("How did we get here, we heartbeated our lock before we started! ( " + info + ")");
                }
                if (locks[index].state == LockState.ACQUIRED) continue;
                boolean acquired = false;
                block19: for (int i = index - 1; i >= 0; --i) {
                    if (!locks[index].db.equals(locks[i].db) || locks[index].table != null && locks[i].table != null && !locks[index].table.equals(locks[i].table) || locks[index].partition != null && locks[i].partition != null && !locks[index].partition.equals(locks[i].partition)) continue;
                    LockAction lockAction = jumpTable.get(locks[index].type).get(locks[i].type).get(locks[i].state);
                    LOG.debug("desired Lock: " + info + " checked Lock: " + locks[i] + " action: " + (Object)((Object)lockAction));
                    switch (lockAction) {
                        case WAIT: {
                            if (!this.ignoreConflict(info, locks[i])) {
                                this.wait(dbConn, save);
                                String sqlText = "update HIVE_LOCKS set HL_BLOCKEDBY_EXT_ID=" + locks[i].extLockId + ", HL_BLOCKEDBY_INT_ID=" + locks[i].intLockId + " where HL_LOCK_EXT_ID=" + info.extLockId + " and HL_LOCK_INT_ID=" + info.intLockId;
                                LOG.debug("Executing sql: " + sqlText);
                                int updCnt = stmt.executeUpdate(sqlText);
                                if (updCnt != 1) {
                                    TxnHandler.shouldNeverHappen(info.txnId, info.extLockId, info.intLockId);
                                }
                                LOG.debug("Going to commit");
                                dbConn.commit();
                                response.setState(LockState.WAITING);
                                LOG.debug("Lock(" + info + ") waiting for Lock(" + locks[i] + ")");
                                LockResponse lockResponse = response;
                                TxnHandler.close(rs, stmt, null);
                                if (handle == null) return lockResponse;
                                handle.releaseLocks();
                                return lockResponse;
                            }
                        }
                        case ACQUIRE: {
                            this.acquire(dbConn, stmt, extLockId, info);
                            acquired = true;
                            break;
                        }
                        case KEEP_LOOKING: {
                            continue block19;
                        }
                    }
                    if (acquired) break;
                }
                if (acquired) continue;
                this.acquire(dbConn, stmt, extLockId, info);
            }
        }
        catch (Throwable throwable) {
            TxnHandler.close(rs, stmt, null);
            if (handle == null) throw throwable;
            handle.releaseLocks();
            throw throwable;
        }
    }

    private boolean ignoreConflict(LockInfo desiredLock, LockInfo existingLock) {
        return desiredLock.isDbLock() && desiredLock.type == LockType.SHARED_READ && existingLock.isTableLock() && existingLock.type == LockType.EXCLUSIVE || existingLock.isDbLock() && existingLock.type == LockType.SHARED_READ && desiredLock.isTableLock() && desiredLock.type == LockType.EXCLUSIVE || desiredLock.isDbLock() && desiredLock.type == LockType.SHARED_READ && existingLock.isPartitionLock() && existingLock.type == LockType.EXCLUSIVE || existingLock.isDbLock() && existingLock.type == LockType.SHARED_READ && desiredLock.isPartitionLock() && desiredLock.type == LockType.EXCLUSIVE || desiredLock.txnId != 0L && desiredLock.txnId == existingLock.txnId || desiredLock.txnId == 0L && desiredLock.extLockId == existingLock.extLockId;
    }

    private void wait(Connection dbConn, Savepoint save) throws SQLException {
        LOG.debug("Going to rollback to savepoint");
        dbConn.rollback(save);
    }

    private void acquire(Connection dbConn, Statement stmt, long extLockId, LockInfo lockInfo) throws SQLException, NoSuchLockException, MetaException {
        long now = this.getDbTime(dbConn);
        String s = "update HIVE_LOCKS set hl_lock_state = 'a', hl_last_heartbeat = " + (TxnHandler.isValidTxn(lockInfo.txnId) ? 0L : now) + ", hl_acquired_at = " + now + ",HL_BLOCKEDBY_EXT_ID=NULL,HL_BLOCKEDBY_INT_ID=null" + " where hl_lock_ext_id = " + extLockId + " and hl_lock_int_id = " + lockInfo.intLockId;
        LOG.debug("Going to execute update <" + s + ">");
        int rc = stmt.executeUpdate(s);
        if (rc < 1) {
            LOG.debug("Going to rollback");
            dbConn.rollback();
            throw new NoSuchLockException("No such lock: (" + JavaUtils.lockIdToString(extLockId) + "," + lockInfo.intLockId + ") " + JavaUtils.txnIdToString(lockInfo.txnId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void heartbeatLock(Connection dbConn, long extLockId) throws NoSuchLockException, SQLException, MetaException {
        if (extLockId == 0L) {
            return;
        }
        Statement stmt = null;
        try {
            stmt = dbConn.createStatement();
            long now = this.getDbTime(dbConn);
            String s = "update HIVE_LOCKS set hl_last_heartbeat = " + now + " where hl_lock_ext_id = " + extLockId;
            LOG.debug("Going to execute update <" + s + ">");
            int rc = stmt.executeUpdate(s);
            if (rc < 1) {
                LOG.debug("Going to rollback");
                dbConn.rollback();
                throw new NoSuchLockException("No such lock: " + JavaUtils.lockIdToString(extLockId));
            }
            LOG.debug("Going to commit");
            dbConn.commit();
        }
        finally {
            TxnHandler.closeStmt(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void heartbeatTxn(Connection dbConn, long txnid) throws NoSuchTxnException, TxnAbortedException, SQLException, MetaException {
        if (txnid == 0L) {
            return;
        }
        Statement stmt = null;
        try {
            stmt = dbConn.createStatement();
            long now = this.getDbTime(dbConn);
            String s = "update TXNS set txn_last_heartbeat = " + now + " where txn_id = " + txnid + " and txn_state = '" + 'o' + "'";
            LOG.debug("Going to execute update <" + s + ">");
            int rc = stmt.executeUpdate(s);
            if (rc < 1) {
                TxnHandler.ensureValidTxn(dbConn, txnid, stmt);
                LOG.warn("Can neither heartbeat txn nor confirm it as invalid: " + JavaUtils.txnIdToString(txnid));
                dbConn.rollback();
                throw new NoSuchTxnException("No such transaction " + JavaUtils.txnIdToString(txnid));
            }
            LOG.debug("Going to commit");
            dbConn.commit();
        }
        finally {
            TxnHandler.closeStmt(stmt);
        }
    }

    private TxnStatus findTxnState(long txnid, Statement stmt) throws SQLException, MetaException {
        String s = "select txn_state from TXNS where txn_id = " + txnid;
        LOG.debug("Going to execute query <" + s + ">");
        ResultSet rs = stmt.executeQuery(s);
        if (!rs.next()) {
            s = sqlGenerator.addLimitClause(1, "1 from COMPLETED_TXN_COMPONENTS where CTC_TXNID = " + txnid);
            LOG.debug("Going to execute query <" + s + ">");
            ResultSet rs2 = stmt.executeQuery(s);
            if (rs2.next()) {
                return TxnStatus.COMMITTED;
            }
            return TxnStatus.UNKNOWN;
        }
        char txnState = rs.getString(1).charAt(0);
        if (txnState == 'a') {
            return TxnStatus.ABORTED;
        }
        assert (txnState == 'o') : "we found it in TXNS but it's not ABORTED, so must be OPEN";
        return TxnStatus.OPEN;
    }

    private static void raiseTxnUnexpectedState(TxnStatus actualStatus, long txnid) throws NoSuchTxnException, TxnAbortedException {
        switch (actualStatus) {
            case ABORTED: {
                throw new TxnAbortedException("Transaction " + JavaUtils.txnIdToString(txnid) + " already aborted");
            }
            case COMMITTED: {
                throw new NoSuchTxnException("Transaction " + JavaUtils.txnIdToString(txnid) + " is already committed.");
            }
            case UNKNOWN: {
                throw new NoSuchTxnException("No such transaction " + JavaUtils.txnIdToString(txnid));
            }
            case OPEN: {
                throw new NoSuchTxnException(JavaUtils.txnIdToString(txnid) + " is " + (Object)((Object)TxnStatus.OPEN));
            }
        }
        throw new IllegalArgumentException("Unknown TxnStatus " + (Object)((Object)actualStatus));
    }

    private static void ensureValidTxn(Connection dbConn, long txnid, Statement stmt) throws SQLException, NoSuchTxnException, TxnAbortedException {
        String s = "select txn_state from TXNS where txn_id = " + txnid;
        LOG.debug("Going to execute query <" + s + ">");
        ResultSet rs = stmt.executeQuery(s);
        if (!rs.next()) {
            s = "select count(*) from COMPLETED_TXN_COMPONENTS where CTC_TXNID = " + txnid;
            ResultSet rs2 = stmt.executeQuery(s);
            boolean alreadyCommitted = rs2.next() && rs2.getInt(1) > 0;
            LOG.debug("Going to rollback");
            TxnHandler.rollbackDBConn(dbConn);
            if (alreadyCommitted) {
                throw new NoSuchTxnException("Transaction " + JavaUtils.txnIdToString(txnid) + " is already committed.");
            }
            throw new NoSuchTxnException("No such transaction " + JavaUtils.txnIdToString(txnid));
        }
        if (rs.getString(1).charAt(0) == 'a') {
            LOG.debug("Going to rollback");
            TxnHandler.rollbackDBConn(dbConn);
            throw new TxnAbortedException("Transaction " + JavaUtils.txnIdToString(txnid) + " already aborted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockInfo getTxnIdFromLockId(Connection dbConn, long extLockId) throws NoSuchLockException, MetaException, SQLException {
        ResultSet rs;
        Statement stmt;
        block3: {
            LockInfo lockInfo;
            stmt = null;
            rs = null;
            try {
                stmt = dbConn.createStatement();
                String s = "select hl_lock_ext_id, hl_lock_int_id, hl_db, hl_table, hl_partition, hl_lock_state, hl_lock_type, hl_txnid from HIVE_LOCKS where hl_lock_ext_id = " + extLockId;
                LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                if (rs.next()) break block3;
                lockInfo = null;
            }
            catch (Throwable throwable) {
                TxnHandler.close(rs);
                TxnHandler.closeStmt(stmt);
                throw throwable;
            }
            TxnHandler.close(rs);
            TxnHandler.closeStmt(stmt);
            return lockInfo;
        }
        LockInfo info = new LockInfo(rs);
        LOG.debug("getTxnIdFromLockId(" + extLockId + ") Return " + JavaUtils.txnIdToString(info.txnId));
        LockInfo lockInfo = info;
        TxnHandler.close(rs);
        TxnHandler.closeStmt(stmt);
        return lockInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LockInfo> getLockInfoFromLockId(Connection dbConn, long extLockId) throws NoSuchLockException, MetaException, SQLException {
        Statement stmt = null;
        try {
            stmt = dbConn.createStatement();
            String s = "select hl_lock_ext_id, hl_lock_int_id, hl_db, hl_table, hl_partition, hl_lock_state, hl_lock_type, hl_txnid from HIVE_LOCKS where hl_lock_ext_id = " + extLockId;
            LOG.debug("Going to execute query <" + s + ">");
            ResultSet rs = stmt.executeQuery(s);
            boolean sawAtLeastOne = false;
            ArrayList<LockInfo> ourLockInfo = new ArrayList<LockInfo>();
            while (rs.next()) {
                ourLockInfo.add(new LockInfo(rs));
                sawAtLeastOne = true;
            }
            if (!sawAtLeastOne) {
                throw new MetaException("This should never happen!  We already checked the lock(" + JavaUtils.lockIdToString(extLockId) + ") existed but now we can't find it!");
            }
            ArrayList<LockInfo> arrayList = ourLockInfo;
            return arrayList;
        }
        finally {
            TxnHandler.closeStmt(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void timeOutLocks(Connection dbConn, long now) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.createStatement();
            long maxHeartbeatTime = now - this.timeout;
            String s = "select distinct hl_lock_ext_id from HIVE_LOCKS where hl_last_heartbeat < " + maxHeartbeatTime + " and hl_txnid = 0";
            ArrayList<Long> extLockIDs = new ArrayList<Long>();
            rs = stmt.executeQuery(s);
            while (rs.next()) {
                extLockIDs.add(rs.getLong(1));
            }
            rs.close();
            dbConn.commit();
            if (extLockIDs.size() <= 0) {
                TxnHandler.close(rs);
                TxnHandler.closeStmt(stmt);
                return;
            }
            ArrayList<String> queries = new ArrayList<String>();
            StringBuilder prefix = new StringBuilder();
            StringBuilder suffix = new StringBuilder();
            prefix.append("delete from HIVE_LOCKS where hl_last_heartbeat < ");
            prefix.append(maxHeartbeatTime);
            prefix.append(" and hl_txnid = 0 and ");
            suffix.append("");
            TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, extLockIDs, "hl_lock_ext_id", true, false);
            int deletedLocks = 0;
            for (String query : queries) {
                LOG.debug("Removing expired locks via: " + query);
                deletedLocks += stmt.executeUpdate(query);
            }
            if (deletedLocks > 0) {
                Collections.sort(extLockIDs);
                LOG.info("Deleted " + deletedLocks + " int locks from HIVE_LOCKS due to timeout (" + "HL_LOCK_EXT_ID list:  " + extLockIDs + ") maxHeartbeatTime=" + maxHeartbeatTime);
            }
            LOG.debug("Going to commit");
            dbConn.commit();
            TxnHandler.close(rs);
        }
        catch (SQLException ex) {
            LOG.error("Failed to purge timedout locks due to: " + TxnHandler.getMessage(ex), ex);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception ex2) {
                LOG.error("Failed to purge timedout locks due to: " + ex2.getMessage(), ex2);
                return;
            }
        }
        finally {
            TxnHandler.close(rs);
            TxnHandler.closeStmt(stmt);
        }
        TxnHandler.closeStmt(stmt);
        return;
    }

    private String addLimitClause(int numRows, String noSelectsqlQuery) throws MetaException {
        switch (dbProduct) {
            case DERBY: {
                return "select " + noSelectsqlQuery + " fetch first " + numRows + " rows only";
            }
            case MYSQL: 
            case POSTGRES: {
                return "select " + noSelectsqlQuery + " limit " + numRows;
            }
            case ORACLE: {
                return "select * from (select " + noSelectsqlQuery + ") where rownum <= " + numRows;
            }
            case SQLSERVER: {
                return "select TOP(" + numRows + ") " + noSelectsqlQuery;
            }
        }
        String msg = "Unrecognized database product name <" + (Object)((Object)dbProduct) + ">";
        LOG.error(msg);
        throw new MetaException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RetrySemantics.Idempotent
    public void performTimeOuts() {
        dbConn = null;
        stmt = null;
        rs = null;
        try {
            dbConn = this.getDbConn(2);
            now = this.getDbTime(dbConn);
            this.timeOutLocks(dbConn, now);
lbl8:
            // 2 sources

            while (true) {
                stmt = dbConn.createStatement();
                s = " txn_id from TXNS where txn_state = 'o' and txn_last_heartbeat <  " + (now - this.timeout);
                s = TxnHandler.sqlGenerator.addLimitClause(250000, s);
                TxnHandler.LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                if (rs.next()) ** GOTO lbl-1000
                ** GOTO lbl27
                break;
            }
        }
        catch (SQLException ex) {
            TxnHandler.LOG.warn("Aborting timedout transactions failed due to " + TxnHandler.getMessage(ex), ex);
            TxnHandler.close(rs, stmt, dbConn);
            return;
        }
        catch (MetaException e) {
            try {
                TxnHandler.LOG.warn("Aborting timedout transactions failed due to " + e.getMessage(), e);
            }
            catch (Throwable var12_13) {
                TxnHandler.close(rs, stmt, dbConn);
                throw var12_13;
            }
lbl27:
            // 1 sources

            TxnHandler.close(rs, stmt, dbConn);
            return;
lbl-1000:
            // 1 sources

            {
                timedOutTxns = new ArrayList<ArrayList<E>>();
                currentBatch = new ArrayList<Long>(1000);
                timedOutTxns.add(currentBatch);
                do {
                    if (currentBatch.size() == 1000) {
                        currentBatch = new ArrayList<E>(1000);
                        timedOutTxns.add(currentBatch);
                    }
                    currentBatch.add(rs.getLong(1));
                } while (rs.next());
                dbConn.commit();
                TxnHandler.close(rs, stmt, null);
                numTxnsAborted = 0;
                for (List var11_12 : timedOutTxns) {
                    if (this.abortTxns(dbConn, var11_12, now - this.timeout, true) == var11_12.size()) {
                        dbConn.commit();
                        numTxnsAborted += var11_12.size();
                        Collections.sort(var11_12);
                        TxnHandler.LOG.info("Aborted the following transactions due to timeout: " + var11_12.toString());
                        continue;
                    }
                    dbConn.rollback();
                }
                TxnHandler.LOG.info("Aborted " + numTxnsAborted + " transactions due to timeout");
                ** continue;
            }
            TxnHandler.close(rs, stmt, dbConn);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.ReadOnly
    public void countOpenTxns() throws MetaException {
        block8: {
            Connection dbConn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                block7: {
                    try {
                        dbConn = this.getDbConn(2);
                        stmt = dbConn.createStatement();
                        String s = "select count(*) from TXNS where txn_state = 'o'";
                        LOG.debug("Going to execute query <" + s + ">");
                        rs = stmt.executeQuery(s);
                        if (!rs.next()) {
                            LOG.error("Transaction database not properly configured, can't find txn_state from TXNS.");
                            break block7;
                        }
                        numOpenTxns = rs.getLong(1);
                    }
                    catch (SQLException e) {
                        try {
                            LOG.debug("Going to rollback");
                            TxnHandler.rollbackDBConn(dbConn);
                            LOG.info("Failed to update number of open transactions");
                            this.checkRetryable(dbConn, e, "countOpenTxns()");
                        }
                        catch (Throwable throwable) {
                            TxnHandler.close(rs, stmt, dbConn);
                            throw throwable;
                        }
                        TxnHandler.close(rs, stmt, dbConn);
                        break block8;
                    }
                }
                TxnHandler.close(rs, stmt, dbConn);
            }
            catch (RetryException e) {
                this.countOpenTxns();
            }
        }
    }

    private static synchronized DataSource setupJdbcConnectionPool(HiveConf conf, int maxPoolSize, long getConnectionTimeoutMs) throws SQLException {
        String passwd;
        String driverUrl = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORECONNECTURLKEY);
        String driverClassName = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_CONNECTION_DRIVER);
        String user = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_CONNECTION_USER_NAME);
        try {
            passwd = ShimLoader.getHadoopShims().getPassword(conf, HiveConf.ConfVars.METASTOREPWD.varname);
        }
        catch (IOException err) {
            throw new SQLException("Error getting metastore password", err);
        }
        String connectionPooler = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_CONNECTION_POOLING_TYPE).toLowerCase();
        if ("bonecp".equals(connectionPooler)) {
            BoneCPConfig config = new BoneCPConfig();
            config.setJdbcUrl(driverUrl);
            config.setConnectionTimeoutInMs(getConnectionTimeoutMs);
            config.setMaxConnectionsPerPartition(maxPoolSize);
            config.setPartitionCount(1);
            config.setUser(user);
            config.setPassword(passwd);
            doRetryOnConnPool = true;
            return new BoneCPDataSource(config);
        }
        if ("dbcp".equals(connectionPooler)) {
            GenericObjectPool objectPool = new GenericObjectPool();
            objectPool.setMaxActive(maxPoolSize);
            objectPool.setMaxWait(getConnectionTimeoutMs);
            DriverManagerConnectionFactory connFactory = new DriverManagerConnectionFactory(driverUrl, user, passwd);
            PoolableConnectionFactory poolConnFactory = new PoolableConnectionFactory((ConnectionFactory)connFactory, (ObjectPool)objectPool, null, null, false, true);
            return new PoolingDataSource((ObjectPool)objectPool);
        }
        if ("hikaricp".equals(connectionPooler)) {
            HikariConfig config = new HikariConfig();
            config.setMaximumPoolSize(maxPoolSize);
            config.setJdbcUrl(driverUrl);
            config.setDriverClassName(driverClassName);
            config.setUsername(user);
            config.setPassword(passwd);
            config.setConnectionTimeout(getConnectionTimeoutMs);
            return new HikariDataSource(config);
        }
        throw new RuntimeException("Unknown JDBC connection pooling " + connectionPooler);
    }

    private static synchronized void buildJumpTable() {
        if (jumpTable != null) {
            return;
        }
        jumpTable = new HashMap<LockType, Map<LockType, Map<LockState, LockAction>>>(3);
        HashMap m = new HashMap(3);
        jumpTable.put(LockType.SHARED_READ, m);
        HashMap<LockState, LockAction> m2 = new HashMap<LockState, LockAction>(2);
        m.put(LockType.SHARED_READ, m2);
        m2.put(LockState.ACQUIRED, LockAction.ACQUIRE);
        m2.put(LockState.WAITING, LockAction.KEEP_LOOKING);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_WRITE, m2);
        m2.put(LockState.ACQUIRED, LockAction.ACQUIRE);
        m2.put(LockState.WAITING, LockAction.KEEP_LOOKING);
        m2 = new HashMap(2);
        m.put(LockType.EXCLUSIVE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m = new HashMap(3);
        jumpTable.put(LockType.SHARED_WRITE, m);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_READ, m2);
        m2.put(LockState.ACQUIRED, LockAction.KEEP_LOOKING);
        m2.put(LockState.WAITING, LockAction.KEEP_LOOKING);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_WRITE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m2 = new HashMap(2);
        m.put(LockType.EXCLUSIVE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m = new HashMap(3);
        jumpTable.put(LockType.EXCLUSIVE, m);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_READ, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_WRITE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m2 = new HashMap(2);
        m.put(LockType.EXCLUSIVE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
    }

    static boolean isRetryable(HiveConf conf, Exception ex, DatabaseProduct dbType) {
        if (ex instanceof SQLException) {
            SQLException sqlException = (SQLException)ex;
            if ("08S01".equalsIgnoreCase(sqlException.getSQLState())) {
                return true;
            }
            if ("ORA-08176".equalsIgnoreCase(sqlException.getSQLState()) || sqlException.getMessage().contains("consistent read failure; rollback data not available")) {
                return true;
            }
            String regex = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_TXN_RETRYABLE_SQLEX_REGEX);
            if (regex != null && !regex.isEmpty()) {
                String[] patterns = regex.split(",(?=\\S)");
                String message = TxnHandler.getMessage((SQLException)ex);
                for (String p : patterns) {
                    if (!Pattern.matches(p, message)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isDuplicateKeyError(SQLException ex) {
        switch (dbProduct) {
            case DERBY: {
                if (!"23505".equals(ex.getSQLState())) break;
                return true;
            }
            case MYSQL: {
                if (ex.getErrorCode() != 1022 && ex.getErrorCode() != 1062 && ex.getErrorCode() != 1586 || !"23000".equals(ex.getSQLState())) break;
                return true;
            }
            case SQLSERVER: {
                if (ex.getErrorCode() != 2627 || !"23000".equals(ex.getSQLState())) break;
                return true;
            }
            case ORACLE: {
                if (ex.getErrorCode() != 1 || !"23000".equals(ex.getSQLState())) break;
                return true;
            }
            case POSTGRES: {
                if (!"23505".equals(ex.getSQLState())) break;
                return true;
            }
            default: {
                throw new IllegalArgumentException("Unexpected DB type: " + (Object)((Object)dbProduct) + "; " + TxnHandler.getMessage(ex));
            }
        }
        return false;
    }

    private static String getMessage(SQLException ex) {
        return ex.getMessage() + " (SQLState=" + ex.getSQLState() + ", ErrorCode=" + ex.getErrorCode() + ")";
    }

    private static String valueOrNullLiteral(String value) {
        return value == null ? "null" : TxnHandler.quoteString(value);
    }

    static String quoteString(String input) {
        return "'" + input + "'";
    }

    static String quoteChar(char c) {
        return "'" + c + "'";
    }

    static CompactionType dbCompactionType2ThriftType(char dbValue) {
        switch (dbValue) {
            case 'a': {
                return CompactionType.MAJOR;
            }
            case 'i': {
                return CompactionType.MINOR;
            }
        }
        LOG.warn("Unexpected compaction type " + dbValue);
        return null;
    }

    static Character thriftCompactionType2DbType(CompactionType ct) {
        switch (ct) {
            case MAJOR: {
                return Character.valueOf('a');
            }
            case MINOR: {
                return Character.valueOf('i');
            }
        }
        LOG.warn("Unexpected compaction type " + ct);
        return null;
    }

    private void lockInternal() {
        if (dbProduct == DatabaseProduct.DERBY) {
            derbyLock.lock();
        }
    }

    private void unlockInternal() {
        if (dbProduct == DatabaseProduct.DERBY) {
            derbyLock.unlock();
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public TxnStore.MutexAPI getMutexAPI() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TxnStore.MutexAPI.LockHandle acquireLock(String key) throws MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                String sqlStmt = sqlGenerator.addForUpdateClause("select MT_COMMENT from AUX_TABLE where MT_KEY1=" + TxnHandler.quoteString(key) + " and MT_KEY2=0");
                this.lockInternal();
                dbConn = this.getDbConn(2, connPoolMutex);
                stmt = dbConn.createStatement();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("About to execute SQL: " + sqlStmt);
                }
                if (!(rs = stmt.executeQuery(sqlStmt)).next()) {
                    TxnHandler.close(rs);
                    try {
                        stmt.executeUpdate("insert into AUX_TABLE(MT_KEY1,MT_KEY2) values(" + TxnHandler.quoteString(key) + ", 0)");
                        dbConn.commit();
                    }
                    catch (SQLException ex) {
                        if (!this.isDuplicateKeyError(ex)) {
                            throw new RuntimeException("Unable to lock " + TxnHandler.quoteString(key) + " due to: " + TxnHandler.getMessage(ex), ex);
                        }
                        dbConn.rollback();
                    }
                    rs = stmt.executeQuery(sqlStmt);
                    if (!rs.next()) {
                        throw new IllegalStateException("Unable to lock " + TxnHandler.quoteString(key) + ".  Expected row in AUX_TABLE is missing.");
                    }
                }
                Semaphore derbySemaphore = null;
                if (dbProduct == DatabaseProduct.DERBY) {
                    derbyKey2Lock.putIfAbsent(key, new Semaphore(1));
                    derbySemaphore = derbyKey2Lock.get(key);
                    derbySemaphore.acquire();
                }
                LOG.debug(TxnHandler.quoteString(key) + " locked by " + TxnHandler.quoteString(hostname));
                LockHandleImpl lockHandleImpl = new LockHandleImpl(dbConn, stmt, rs, key, derbySemaphore);
                return lockHandleImpl;
            }
            catch (SQLException ex) {
                TxnHandler.rollbackDBConn(dbConn);
                TxnHandler.close(rs, stmt, dbConn);
                this.checkRetryable(dbConn, ex, "acquireLock(" + key + ")");
                throw new MetaException("Unable to lock " + TxnHandler.quoteString(key) + " due to: " + TxnHandler.getMessage(ex) + "; " + StringUtils.stringifyException(ex));
            }
            catch (InterruptedException ex) {
                TxnHandler.rollbackDBConn(dbConn);
                TxnHandler.close(rs, stmt, dbConn);
                throw new MetaException("Unable to lock " + TxnHandler.quoteString(key) + " due to: " + ex.getMessage() + StringUtils.stringifyException(ex));
            }
            finally {
                this.unlockInternal();
            }
        }
        catch (RetryException ex) {
            return this.acquireLock(key);
        }
    }

    @Override
    public void acquireLock(String key, TxnStore.MutexAPI.LockHandle handle) {
        throw new NotImplementedException();
    }

    static {
        doRetryOnConnPool = false;
        maxOpenTxns = 0;
        numOpenTxns = 0L;
        tooManyOpenTxns = false;
        openTxnsCounter = null;
        derbyLock = new ReentrantLock(true);
        derbyKey2Lock = new ConcurrentHashMap();
        hostname = ServerUtils.hostname();
    }

    private static final class LockHandleImpl
    implements TxnStore.MutexAPI.LockHandle {
        private final Connection dbConn;
        private final Statement stmt;
        private final ResultSet rs;
        private final Semaphore derbySemaphore;
        private final List<String> keys = new ArrayList<String>();

        LockHandleImpl(Connection conn, Statement stmt, ResultSet rs, String key, Semaphore derbySemaphore) {
            this.dbConn = conn;
            this.stmt = stmt;
            this.rs = rs;
            this.derbySemaphore = derbySemaphore;
            if (derbySemaphore != null) assert (derbySemaphore.availablePermits() == 0) : "Expected locked Semaphore";
            this.keys.add(key);
        }

        void addKey(String key) {
            throw new NotImplementedException();
        }

        @Override
        public void releaseLocks() {
            TxnHandler.rollbackDBConn(this.dbConn);
            TxnHandler.close(this.rs, this.stmt, this.dbConn);
            if (this.derbySemaphore != null) {
                this.derbySemaphore.release();
            }
            for (String key : this.keys) {
                LOG.debug(TxnHandler.quoteString(key) + " unlocked by " + TxnHandler.quoteString(hostname));
            }
        }
    }

    private static enum LockAction {
        ACQUIRE,
        WAIT,
        KEEP_LOOKING;

    }

    private static final class LockTypeComparator
    implements Comparator<LockType> {
        private LockTypeComparator() {
        }

        @Override
        public boolean equals(Object other) {
            return this == other;
        }

        @Override
        public int compare(LockType t1, LockType t2) {
            switch (t1) {
                case EXCLUSIVE: {
                    if (t2 == LockType.EXCLUSIVE) {
                        return 0;
                    }
                    return 1;
                }
                case SHARED_WRITE: {
                    switch (t2) {
                        case EXCLUSIVE: {
                            return -1;
                        }
                        case SHARED_WRITE: {
                            return 0;
                        }
                        case SHARED_READ: {
                            return 1;
                        }
                    }
                    throw new RuntimeException("Unexpected LockType: " + t2);
                }
                case SHARED_READ: {
                    if (t2 == LockType.SHARED_READ) {
                        return 0;
                    }
                    return -1;
                }
            }
            throw new RuntimeException("Unexpected LockType: " + t1);
        }
    }

    private static class LockInfoComparator
    implements Comparator<LockInfo> {
        private static final LockTypeComparator lockTypeComparator = new LockTypeComparator();

        private LockInfoComparator() {
        }

        @Override
        public boolean equals(Object other) {
            return this == other;
        }

        @Override
        public int compare(LockInfo info1, LockInfo info2) {
            if (info1.state == LockState.ACQUIRED && info2.state != LockState.ACQUIRED) {
                return -1;
            }
            if (info1.state != LockState.ACQUIRED && info2.state == LockState.ACQUIRED) {
                return 1;
            }
            int sortByType = lockTypeComparator.compare(info1.type, info2.type);
            if (sortByType != 0) {
                return sortByType;
            }
            if (info1.extLockId < info2.extLockId) {
                return -1;
            }
            if (info1.extLockId > info2.extLockId) {
                return 1;
            }
            if (info1.intLockId < info2.intLockId) {
                return -1;
            }
            if (info1.intLockId > info2.intLockId) {
                return 1;
            }
            return 0;
        }
    }

    private static class LockInfo {
        private final long extLockId;
        private final long intLockId;
        private final long txnId;
        private final String db;
        private final String table;
        private final String partition;
        private final LockState state;
        private final LockType type;

        LockInfo(ResultSet rs) throws SQLException, MetaException {
            this.extLockId = rs.getLong("hl_lock_ext_id");
            this.intLockId = rs.getLong("hl_lock_int_id");
            this.db = rs.getString("hl_db");
            String t = rs.getString("hl_table");
            this.table = rs.wasNull() ? null : t;
            String p = rs.getString("hl_partition");
            this.partition = rs.wasNull() ? null : p;
            switch (rs.getString("hl_lock_state").charAt(0)) {
                case 'w': {
                    this.state = LockState.WAITING;
                    break;
                }
                case 'a': {
                    this.state = LockState.ACQUIRED;
                    break;
                }
                default: {
                    throw new MetaException("Unknown lock state " + rs.getString("hl_lock_state").charAt(0));
                }
            }
            switch (rs.getString("hl_lock_type").charAt(0)) {
                case 'e': {
                    this.type = LockType.EXCLUSIVE;
                    break;
                }
                case 'r': {
                    this.type = LockType.SHARED_READ;
                    break;
                }
                case 'w': {
                    this.type = LockType.SHARED_WRITE;
                    break;
                }
                default: {
                    throw new MetaException("Unknown lock type " + rs.getString("hl_lock_type").charAt(0));
                }
            }
            this.txnId = rs.getLong("hl_txnid");
        }

        LockInfo(ShowLocksResponseElement e) {
            this.extLockId = e.getLockid();
            this.intLockId = e.getLockIdInternal();
            this.txnId = e.getTxnid();
            this.db = e.getDbname();
            this.table = e.getTablename();
            this.partition = e.getPartname();
            this.state = e.getState();
            this.type = e.getType();
        }

        public boolean equals(Object other) {
            if (!(other instanceof LockInfo)) {
                return false;
            }
            LockInfo o = (LockInfo)other;
            return this.extLockId == o.extLockId && this.intLockId == o.intLockId;
        }

        public String toString() {
            return JavaUtils.lockIdToString(this.extLockId) + " intLockId:" + this.intLockId + " " + JavaUtils.txnIdToString(this.txnId) + " db:" + this.db + " table:" + this.table + " partition:" + this.partition + " state:" + (this.state == null ? "null" : this.state.toString()) + " type:" + (this.type == null ? "null" : this.type.toString());
        }

        private boolean isDbLock() {
            return this.db != null && this.table == null && this.partition == null;
        }

        private boolean isTableLock() {
            return this.db != null && this.table != null && this.partition == null;
        }

        private boolean isPartitionLock() {
            return !this.isDbLock() && !this.isTableLock();
        }
    }

    protected class RetryException
    extends Exception {
        protected RetryException() {
        }
    }

    private static class LockInfoExt
    extends LockInfo {
        private final ShowLocksResponseElement e;

        LockInfoExt(ShowLocksResponseElement e) {
            super(e);
            this.e = e;
        }
    }

    private static final class ConnectionLockIdPair {
        private final Connection dbConn;
        private final long extLockId;

        private ConnectionLockIdPair(Connection dbConn, long extLockId) {
            this.dbConn = dbConn;
            this.extLockId = extLockId;
        }
    }

    private static enum OpertaionType {
        SELECT('s'),
        INSERT('i'),
        UPDATE('u'),
        DELETE('d');

        private final char sqlConst;

        private OpertaionType(char sqlConst) {
            this.sqlConst = sqlConst;
        }

        public String toString() {
            return Character.toString(this.sqlConst);
        }

        public static OpertaionType fromString(char sqlConst) {
            switch (sqlConst) {
                case 's': {
                    return SELECT;
                }
                case 'i': {
                    return INSERT;
                }
                case 'u': {
                    return UPDATE;
                }
                case 'd': {
                    return DELETE;
                }
            }
            throw new IllegalArgumentException(TxnHandler.quoteChar(sqlConst));
        }

        public static OpertaionType fromDataOperationType(DataOperationType dop) {
            switch (dop) {
                case SELECT: {
                    return SELECT;
                }
                case INSERT: {
                    return INSERT;
                }
                case UPDATE: {
                    return UPDATE;
                }
                case DELETE: {
                    return DELETE;
                }
            }
            throw new IllegalArgumentException("Unexpected value: " + dop);
        }
    }

    static enum TxnStatus {
        OPEN,
        ABORTED,
        COMMITTED,
        UNKNOWN;

    }
}

