/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.api.InsertEventRequestData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;

public class InsertEvent
extends ListenerEvent {
    private final Table tableObj;
    private final Partition ptnObj;
    private final boolean replace;
    private final List<String> files;
    private List<String> fileChecksums = new ArrayList<String>();

    public InsertEvent(String db, String table, List<String> partVals, InsertEventRequestData insertData, boolean status, HiveMetaStore.HMSHandler handler) throws MetaException, NoSuchObjectException {
        super(status, handler);
        this.tableObj = handler.get_table(db, table);
        this.ptnObj = partVals != null ? handler.get_partition(db, table, partVals) : null;
        this.replace = insertData.isSetReplace() ? insertData.isReplace() : true;
        this.files = insertData.getFilesAdded();
        if (insertData.isSetFilesAddedChecksum()) {
            this.fileChecksums = insertData.getFilesAddedChecksum();
        }
    }

    public Table getTableObj() {
        return this.tableObj;
    }

    public Partition getPartitionObj() {
        return this.ptnObj;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public List<String> getFileChecksums() {
        return this.fileChecksums;
    }
}

