/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.snapshot;

import java.sql.SQLException;
import java.util.List;
import liquibase.CatalogAndSchema;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.ext.vertica.database.VerticaDatabase;
import liquibase.ext.vertica.snapshot.VerticaDatabaseSnapshot;
import liquibase.ext.vertica.structure.Projection;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.util.StringUtils;

public class ProjectionSnapshotGenerator
extends JdbcSnapshotGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof VerticaDatabase) {
            return 5;
        }
        return -1;
    }

    public ProjectionSnapshotGenerator() {
        super(Projection.class, new Class[]{Schema.class});
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        VerticaDatabase database = (VerticaDatabase)snapshot.getDatabase();
        Schema schema = example.getSchema();
        List<CachedRow> projectionMetadataRs = null;
        try {
            VerticaDatabaseSnapshot verticaDatabaseSnapshot = new VerticaDatabaseSnapshot(new DatabaseObject[0], snapshot.getDatabase(), snapshot.getSnapshotControl());
            projectionMetadataRs = verticaDatabaseSnapshot.getMetaData().getProjectionDefinition(schema.getName(), example.getName());
            if (projectionMetadataRs.size() > 0) {
                CachedRow row = projectionMetadataRs.get(0);
                String rawSchemaName = StringUtils.trimToNull((String)row.getString("TABLE_SCHEM"));
                String rawProjectionName = row.getString("PROJ_NAME");
                Projection projection = new Projection();
                projection.setName(this.cleanNameFromDatabase(rawProjectionName, (Database)database));
                CatalogAndSchema schemaFromJdbcInfo = database.getSchemaFromJdbcInfo("", rawSchemaName);
                projection.setSchema(new Schema(schemaFromJdbcInfo.getCatalogName(), schemaFromJdbcInfo.getSchemaName()));
                projection.setAnchorTable((String)row.get("TABLE_NAME"));
                projection.setSubquery("Select * from " + (String)row.get("TABLE_NAME"));
                projection.setKSafe((String)row.get("K_SAFE"));
                projection.setOffset((Long)row.get("OFFSET"));
                projection.setIsSegmented((Boolean)row.get("IS_SEGMENTED"));
                projection.setSegmentedBy((String)row.get("SEGMENT_EXRESSION"));
                return projection;
            }
            return null;
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(Projection.class)) {
            return;
        }
        if (foundObject instanceof Schema) {
            Database database = snapshot.getDatabase();
            Schema schema = (Schema)foundObject;
            List<CachedRow> metadata = null;
            try {
                VerticaDatabaseSnapshot verticaDatabaseSnapshot = new VerticaDatabaseSnapshot(new DatabaseObject[0], snapshot.getDatabase(), snapshot.getSnapshotControl());
                metadata = verticaDatabaseSnapshot.getMetaData().getProjectionDefinition(schema.getName(), null);
                for (CachedRow projection : metadata) {
                    Projection pr = new Projection();
                    pr.setName(this.cleanNameFromDatabase((String)projection.get("PROJ_NAME"), database));
                    pr.setAnchorTable((String)projection.get("TABLE_NAME"));
                    pr.setSchema(schema);
                    pr.setSubquery("Select * from " + (String)projection.get("TABLE_NAME"));
                    pr.setKSafe((String)projection.get("K_SAFE"));
                    pr.setOffset((Long)projection.get("OFFSET"));
                    pr.setIsSegmented((Boolean)projection.get("IS_SEGMENTED"));
                    pr.setSegmentedBy((String)projection.get("SEGMENT_EXRESSION"));
                    schema.addDatabaseObject((DatabaseObject)pr);
                }
            }
            catch (SQLException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
    }
}

