/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis.exec;

import com.dbeaver.ee.redis.exec.RedisBaseStatement;
import com.dbeaver.ee.redis.exec.RedisSession;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractResultSet;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.qm.QMUtils;

public abstract class RedisBaseResultSet
extends AbstractResultSet<RedisSession, RedisBaseStatement> {
    private static final Log log = Log.getLog(RedisBaseResultSet.class);
    protected MetaData metaData;
    protected int rowNumber = -1;

    public RedisBaseResultSet(RedisBaseStatement statement) {
        super((DBCSession)statement.getSession(), (DBCStatement)statement);
        if (statement.getSession().isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
        }
    }

    @NotNull
    public MetaData getMeta() throws DBCException {
        if (this.metaData == null) {
            this.metaData = new MetaData();
        }
        return this.metaData;
    }

    public Object getFeature(String name) {
        if ("key-value".equals(name)) {
            return true;
        }
        return super.getFeature(name);
    }

    public void close() {
        if (((RedisBaseStatement)this.statement).getSession().isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetClose((DBCResultSet)this, (long)this.rowNumber);
        }
    }

    protected void fillMetaData(List<DBCAttributeMetaData> attribute) {
    }

    private class MetaData
    implements DBCResultSetMetaData {
        public List<DBCAttributeMetaData> getAttributes() {
            ArrayList<DBCAttributeMetaData> attrs = new ArrayList<DBCAttributeMetaData>(1);
            RedisBaseResultSet.this.fillMetaData(attrs);
            return attrs;
        }
    }

    public class OutputAttribute
    implements DBCAttributeMetaData {
        private final String name;
        private final int position;
        private final int typeId;
        private final DBPDataKind dataKind;

        public OutputAttribute(String name, int position, int typeId, DBPDataKind dataKind) {
            this.name = name;
            this.position = position;
            this.typeId = typeId;
            this.dataKind = dataKind;
        }

        @Property(viewable=true, order=1)
        @NotNull
        public String getName() {
            return this.name;
        }

        @Property(viewable=true, order=2)
        public int getOrdinalPosition() {
            return this.position;
        }

        @Property(viewable=true, order=3)
        public String getTypeName() {
            return this.dataKind.name();
        }

        public String getFullTypeName() {
            return this.getTypeName();
        }

        public int getTypeID() {
            return this.typeId;
        }

        public DBPDataKind getDataKind() {
            return this.dataKind;
        }

        public Integer getScale() {
            return 0;
        }

        public Integer getPrecision() {
            return 0;
        }

        public long getMaxLength() {
            return 0L;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        public Object getSource() {
            return null;
        }

        @NotNull
        public String getLabel() {
            return this.name;
        }

        public String getEntityName() {
            return null;
        }

        public boolean isReadOnly() {
            return false;
        }

        public DBCEntityMetaData getEntityMetaData() {
            return null;
        }
    }
}

