/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.model;

import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import com.dbeaver.db.dynamodb.model.DynamoTableAttribute;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndexColumn;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;

public abstract class DynamoTableIndexAbstract
implements DBSTableIndex {
    private static final Log log = Log.getLog(DynamoTableIndexAbstract.class);
    private final DynamoTable table;
    private boolean persisted;
    private List<IndexAttribute> attributes;

    public DynamoTableIndexAbstract(DBRProgressMonitor monitor, DynamoTable table, List<KeySchemaElement> attributes) throws DBException {
        this.table = table;
        this.persisted = true;
        this.attributes = new ArrayList<IndexAttribute>();
        int i = 0;
        while (i < attributes.size()) {
            KeySchemaElement keySchemaElement = attributes.get(i);
            DynamoTableAttribute attribute = table.getAttribute(monitor, keySchemaElement.attributeName());
            if (attribute == null) {
                log.error((Object)("Can't find index attribute " + keySchemaElement));
            } else {
                this.attributes.add(new IndexAttribute(attribute, i, keySchemaElement));
            }
            ++i;
        }
    }

    @NotNull
    public DynamoDataSource getDataSource() {
        return this.table.getDataSource();
    }

    public String getDescription() {
        return null;
    }

    @NotNull
    public DynamoTable getParentObject() {
        return this.table;
    }

    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return DBSEntityConstraintType.INDEX;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public String toString() {
        return this.getName();
    }

    public DynamoTable getContainer() {
        return this.table;
    }

    public DynamoTable getTable() {
        return this.table;
    }

    public boolean isUnique() {
        return false;
    }

    public boolean isPrimary() {
        return false;
    }

    public DBSIndexType getIndexType() {
        return DBSIndexType.OTHER;
    }

    public List<? extends DBSTableIndexColumn> getAttributeReferences(DBRProgressMonitor monitor) throws DBException {
        return this.attributes;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return this.getName();
    }

    public class IndexAttribute
    implements DBSTableIndexColumn {
        private final DynamoTableAttribute attribute;
        private final int position;
        private final KeySchemaElement keySchemaElement;

        public IndexAttribute(DynamoTableAttribute attribute, int position, KeySchemaElement keySchemaElement) {
            this.attribute = attribute;
            this.position = position;
            this.keySchemaElement = keySchemaElement;
        }

        @NotNull
        public DynamoDataSource getDataSource() {
            return DynamoTableIndexAbstract.this.getDataSource();
        }

        public DynamoTableIndexAbstract getParentObject() {
            return DynamoTableIndexAbstract.this;
        }

        @Property(viewable=true)
        @NotNull
        public String getName() {
            return this.attribute.getName();
        }

        public String getDescription() {
            return null;
        }

        public boolean isPersisted() {
            return true;
        }

        public DynamoTableAttribute getAttribute() {
            return this.attribute;
        }

        @NotNull
        public DynamoTableIndexAbstract getIndex() {
            return DynamoTableIndexAbstract.this;
        }

        public int getOrdinalPosition() {
            return this.position;
        }

        public boolean isAscending() {
            return false;
        }

        public DynamoTableAttribute getTableColumn() {
            return this.attribute;
        }

        @Property(viewable=true)
        public String getKeyType() {
            return this.keySchemaElement.keyTypeAsString();
        }
    }
}

