/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.model;

import com.dbeaver.db.dynamodb.exec.DynamoResultIterable;
import com.dbeaver.db.dynamodb.exec.DynamoScanStatement;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTableAttribute;
import com.dbeaver.db.dynamodb.model.DynamoTableIndexAbstract;
import com.dbeaver.db.dynamodb.model.DynamoTableIndexGlobal;
import com.dbeaver.db.dynamodb.model.DynamoTableIndexLocal;
import com.dbeaver.db.dynamodb.model.DynamoTableKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBFetchProgress;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.BillingModeSummary;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;

public class DynamoTable
implements DBSTable,
DBPSaveableObject,
DBPNamedObject2,
DBPRefreshableObject,
DBSDataContainer {
    private static final Log log = Log.getLog(DynamoTable.class);
    private static final String CAT_STATS = "Statistics";
    private final DynamoDataSource dataSource;
    private String tableName;
    private boolean persisted;
    private volatile DynamoTableKey key;
    private final AttributeCache attributeCache = new AttributeCache();
    private volatile List<DynamoTableIndexLocal> localIndexes;
    private volatile List<DynamoTableIndexGlobal> globalIndexes;
    private volatile TableDescription tableDescription;
    private Long readCapacityUnits;
    private Long writeCapacityUnits;

    public DynamoTable(DynamoDataSource dataSource, String tableName, boolean persisted) {
        this.dataSource = dataSource;
        this.tableName = tableName;
        this.persisted = persisted;
    }

    @NotNull
    public DynamoDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.tableName;
    }

    public void setName(String newName) {
        this.tableName = newName;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public String toString() {
        return this.getName();
    }

    @Property(viewable=true, order=40)
    public TableStatus getTableStatus(DBRProgressMonitor monitor) throws DBCException {
        return this.getTableDescription(monitor).tableStatus();
    }

    @Property(viewable=true, category="Statistics", order=41)
    public Instant getCreationDateTime(DBRProgressMonitor monitor) throws DBCException {
        return this.getTableDescription(monitor).creationDateTime();
    }

    @Property(viewable=true, order=42)
    public String getTableArn(DBRProgressMonitor monitor) throws DBCException {
        return this.getTableDescription(monitor).tableArn();
    }

    @Property(viewable=true, category="Statistics", order=43)
    public String getLatestStreamArn(DBRProgressMonitor monitor) throws DBCException {
        return this.getTableDescription(monitor).latestStreamArn();
    }

    @Property(viewable=true, category="Statistics", order=44)
    public String getLatestStreamLabel(DBRProgressMonitor monitor) throws DBCException {
        return this.getTableDescription(monitor).latestStreamLabel();
    }

    @Property(viewable=true, order=50)
    public String getTableId(DBRProgressMonitor monitor) throws DBCException {
        return this.getTableDescription(monitor).tableId();
    }

    @Property(viewable=true, category="Statistics", order=51)
    public Long getTableSizeBytes(DBRProgressMonitor monitor) throws DBCException {
        return this.getTableDescription(monitor).tableSizeBytes();
    }

    @Property(viewable=true, category="Statistics", order=52)
    public Long getRowCount(DBRProgressMonitor monitor) throws DBCException {
        return this.getTableDescription(monitor).itemCount();
    }

    @Property(viewable=true, category="Statistics", order=53)
    public String getBillingModeSummary(DBRProgressMonitor monitor) throws DBCException {
        BillingModeSummary billingModeSummary = this.getTableDescription(monitor).billingModeSummary();
        return billingModeSummary == null ? null : billingModeSummary.billingModeAsString();
    }

    @Property(viewable=true, editable=true, order=60)
    public Long getReadCapacityUnits(DBRProgressMonitor monitor) throws DBCException {
        if (this.readCapacityUnits == null && this.isPersisted()) {
            this.readCapacityUnits = this.getTableDescription(monitor).provisionedThroughput().readCapacityUnits();
        }
        return this.readCapacityUnits;
    }

    public void setReadCapacityUnits(Long readCapacityUnits) {
        this.readCapacityUnits = readCapacityUnits;
    }

    @Property(viewable=true, editable=true, order=61)
    public Long getWriteCapacityUnits(DBRProgressMonitor monitor) throws DBCException {
        if (this.writeCapacityUnits == null && this.isPersisted()) {
            this.writeCapacityUnits = this.getTableDescription(monitor).provisionedThroughput().readCapacityUnits();
        }
        return this.writeCapacityUnits;
    }

    public void setWriteCapacityUnits(Long writeCapacityUnits) {
        this.writeCapacityUnits = writeCapacityUnits;
    }

    public ProvisionedThroughput getProvisionedThroughput() throws DBCException {
        return (ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(this.readCapacityUnits).writeCapacityUnits(this.writeCapacityUnits).build();
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.attributeCache.clearCache();
        this.tableDescription = null;
        this.localIndexes = null;
        this.globalIndexes = null;
        this.key = null;
        return this;
    }

    public boolean isView() {
        return false;
    }

    TableDescription getTableDescription(DBRProgressMonitor monitor) throws DBCException {
        if (!this.persisted) {
            this.tableDescription = (TableDescription)TableDescription.builder().build();
        }
        if (this.tableDescription == null) {
            try {
                DescribeTableResponse dtResponse = this.dataSource.getClient().describeTable((DescribeTableRequest)DescribeTableRequest.builder().tableName(this.tableName).build());
                this.tableDescription = dtResponse == null ? null : dtResponse.table();
            }
            catch (Exception e) {
                throw new DBCException("Error reading table attributes", (Throwable)e);
            }
        }
        return this.tableDescription;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    public AttributeCache getAttributeCache() {
        return this.attributeCache;
    }

    @NotNull
    public Collection<DynamoTableAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBCException {
        return this.attributeCache.getAllObjects(monitor, this);
    }

    public DynamoTableAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (DynamoTableAttribute)DBUtils.findObject(this.getAttributes(monitor), (String)attributeName);
    }

    public Collection<? extends DBSTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        DynamoTableKey key = this.getKey(monitor);
        return key == null ? Collections.emptyList() : Collections.singletonList(key);
    }

    public DynamoTableKey getKey(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.key == null && this.persisted) {
            this.key = new DynamoTableKey(monitor, this, this.getTableDescription(monitor).keySchema());
        }
        return this.key;
    }

    public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<DynamoTableIndexAbstract> getIndexes(DBRProgressMonitor monitor) throws DBException {
        ArrayList<DynamoTableIndexAbstract> allIndexes = new ArrayList<DynamoTableIndexAbstract>();
        allIndexes.addAll(this.getLocalIndexes(monitor));
        allIndexes.addAll(this.getGlobalIndexes(monitor));
        return allIndexes;
    }

    public List<DynamoTableIndexLocal> getLocalIndexes(DBRProgressMonitor monitor) throws DBException {
        if (this.localIndexes == null) {
            ArrayList<DynamoTableIndexLocal> tmp = new ArrayList<DynamoTableIndexLocal>();
            for (LocalSecondaryIndexDescription indexDef : this.getTableDescription(monitor).localSecondaryIndexes()) {
                tmp.add(new DynamoTableIndexLocal(monitor, this, indexDef));
            }
            this.localIndexes = tmp;
        }
        return this.localIndexes;
    }

    public List<DynamoTableIndexGlobal> getGlobalIndexes(DBRProgressMonitor monitor) throws DBException {
        if (this.globalIndexes == null) {
            ArrayList<DynamoTableIndexGlobal> tmp = new ArrayList<DynamoTableIndexGlobal>();
            for (GlobalSecondaryIndexDescription indexDef : this.getTableDescription(monitor).globalSecondaryIndexes()) {
                tmp.add(new DynamoTableIndexGlobal(monitor, this, indexDef));
            }
            this.globalIndexes = tmp;
        }
        return this.globalIndexes;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getQuotedIdentifier((DBSObject)this);
    }

    public int getSupportedFeatures() {
        return 1;
    }

    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        DBCStatistics statistics = new DBCStatistics();
        long startTime = System.currentTimeMillis();
        DynamoScanStatement scanStatement = new DynamoScanStatement((DynamoSession)session, this);
        scanStatement.setLimit(firstRow, maxRows);
        scanStatement.executeStatement();
        DynamoResultIterable resultSet = scanStatement.openResultSet();
        if (resultSet != null) {
            dataReceiver.fetchStart(session, (DBCResultSet)resultSet, firstRow, maxRows);
            DBFetchProgress fetchProgress = new DBFetchProgress(session.getProgressMonitor());
            try {
                while (resultSet.nextRow()) {
                    if (fetchProgress.isCanceled()) break;
                    dataReceiver.fetchRow(session, (DBCResultSet)resultSet);
                    fetchProgress.monitorRowFetch();
                }
                fetchProgress.dumpStatistics(statistics);
            }
            finally {
                dataReceiver.fetchEnd(session, (DBCResultSet)resultSet);
            }
        }
        statistics.addExecuteTime(System.currentTimeMillis() - startTime);
        return statistics;
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, DBDDataFilter dataFilter, long flags) throws DBCException {
        return this.getRowCount(session.getProgressMonitor());
    }

    public class AttributeCache
    extends BasicObjectCache<DynamoTable, DynamoTableAttribute> {
        @NotNull
        public List<DynamoTableAttribute> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable DynamoTable table) throws DBCException {
            if (!this.isFullyCached()) {
                ArrayList<DynamoTableAttribute> attrList = new ArrayList<DynamoTableAttribute>();
                if (DynamoTable.this.isPersisted()) {
                    TableDescription tableDescription = DynamoTable.this.getTableDescription(monitor);
                    for (AttributeDefinition attrDef : tableDescription.attributeDefinitions()) {
                        attrList.add(new DynamoTableAttribute(table, attrDef));
                    }
                    List keySchema = tableDescription.keySchema();
                    for (KeySchemaElement ksItem : keySchema) {
                        for (DynamoTableAttribute attr : attrList) {
                            if (!CommonUtils.equalObjects((Object)ksItem.attributeName(), (Object)attr.getName())) continue;
                            attr.setKey(true);
                            attr.setKeyType(ksItem.keyType());
                        }
                    }
                }
                this.setCache(attrList);
            }
            return this.getCachedObjects();
        }
    }
}

