/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.teradata.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.teradata.database.TeradataDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AddForeignKeyConstraintGenerator;
import liquibase.statement.core.AddForeignKeyConstraintStatement;
import liquibase.structure.DatabaseObject;

public class AddForeignKeyConstraintGeneratorTeradata
extends AddForeignKeyConstraintGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(AddForeignKeyConstraintStatement statement, Database database) {
        return database instanceof TeradataDatabase;
    }

    public Sql[] generateSql(AddForeignKeyConstraintStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ").append(database.escapeTableName(statement.getBaseTableCatalogName(), statement.getBaseTableSchemaName(), statement.getBaseTableName())).append(" ADD CONSTRAINT ");
        sb.append(database.escapeConstraintName(statement.getConstraintName()));
        sb.append(" FOREIGN KEY (").append(database.escapeColumnNameList(statement.getBaseColumnNames())).append(") REFERENCES ");
        if (statement.isDeferrable() || statement.isInitiallyDeferred()) {
            if (statement.isInitiallyDeferred()) {
                sb.append(" WITH NO CHECK OPTION ");
            }
        } else {
            sb.append(" WITH CHECK OPTION ");
        }
        sb.append(database.escapeTableName(statement.getReferencedTableCatalogName(), statement.getReferencedTableSchemaName(), statement.getReferencedTableName())).append("(").append(database.escapeColumnNameList(statement.getReferencedColumnNames())).append(")");
        return new Sql[]{new UnparsedSql(sb.toString(), new DatabaseObject[0])};
    }
}

