/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.teradata.database;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.OfflineConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;

public class TeradataDatabase
extends AbstractJdbcDatabase {
    private String databaseName = null;

    protected String getDatabaseName() {
        if (null == this.databaseName && this.getConnection() != null && !(this.getConnection() instanceof OfflineConnection)) {
            try {
                this.databaseName = (String)ExecutorService.getInstance().getExecutor((Database)this).queryForObject((SqlStatement)new RawSqlStatement("SELECT DATABASE"), String.class);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
        return this.databaseName;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return "Teradata".equals(conn.getDatabaseProductName());
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:teradata:")) {
            return "com.teradata.jdbc.TeraDriver";
        }
        return null;
    }

    public String getShortName() {
        return "teradata";
    }

    protected String getDefaultDatabaseProductName() {
        return "Teradata";
    }

    public Integer getDefaultPort() {
        return 1025;
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return true;
    }

    public String getCurrentDateTimeFunction() {
        return "CURRENT_TIMESTAMP";
    }

    public boolean supportsTablespaces() {
        return false;
    }

    public int getPriority() {
        return 5;
    }

    public boolean supportsDDLInTransaction() {
        return false;
    }

    public String getDefaultCatalogName() {
        return this.getDatabaseName();
    }

    public String getDefaultSchemaName() {
        return this.getDatabaseName();
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean isReservedWord(String string) {
        boolean reserved = false;
        reserved = reserved || "VALUE".equalsIgnoreCase(string);
        reserved = reserved || "PASSWORD".equalsIgnoreCase(string);
        reserved = reserved || "TITLE".equalsIgnoreCase(string);
        reserved = reserved || "ENABLED".equalsIgnoreCase(string);
        reserved = reserved || "RANK".equalsIgnoreCase(string);
        reserved = reserved || "POSITION".equalsIgnoreCase(string);
        reserved = reserved || "YEAR".equalsIgnoreCase(string);
        reserved = reserved || "ACCOUNT".equalsIgnoreCase(string);
        return reserved;
    }

    public String getDateTimeLiteral(Timestamp date) {
        return "'" + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS").format(date) + "'";
    }

    public String getDateLiteral(Date date) {
        return "'" + new SimpleDateFormat("yyyy-MM-dd").format(date) + "'";
    }

    public String getTimeLiteral(Time date) {
        return "'" + new SimpleDateFormat("hh:mm:ss.SSS").format(date) + "'";
    }
}

