/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.internal.ui.preferences;

import com.dbeaver.ee.runtime.core.EnterpriseProjectSecureStorage;
import com.dbeaver.ee.runtime.ui.security.NewPasswordDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSecurity;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.utils.CommonUtils;

public class PrefPageProjectSecurity
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "com.dbeaver.preferences.projectSecurity";
    private static final Log log = Log.getLog(PrefPageProjectSecurity.class);
    private static final String DUMMY_PASSWORD = "dummypassword";
    private static final String BAD_PASSWORD = String.valueOf('\u0000');
    private IProject project;
    private Button useProjectSecurityCheck;
    private String projectPassword = "dummypassword";
    private String lastSavedPassword = BAD_PASSWORD;
    private boolean lastEncryptProject;
    private Button clearProjectPasswordButton;

    public PrefPageProjectSecurity() {
        this.setDescription("Project security settings");
    }

    DBPProject getProjectMetadata() {
        DBPProject projectMeta = DBWorkbench.getPlatform().getWorkspace().getProject(this.project);
        if (projectMeta == null) {
            DBWorkbench.getPlatformUI().showError("No project metadata", "No project metadata for " + this.project.getName());
            throw new IllegalStateException("No project metadata for " + this.project.getName());
        }
        return projectMeta;
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        Group projectPasswordGroup = UIUtils.createControlGroup((Composite)composite, (String)"Project password", (int)1, (int)0, (int)0);
        new Label((Composite)projectPasswordGroup, 0).setText("Setting project password will protect (encrypt) user credentials and project configuration with this password.\nYou will need to pass this password to other users in order to share project configuration.");
        Composite buttonsPanel = UIUtils.createComposite((Composite)projectPasswordGroup, (int)2);
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Set password", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageProjectSecurity.this.setProjectPassword();
            }
        });
        this.clearProjectPasswordButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Clear password", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UIUtils.confirmAction((Shell)PrefPageProjectSecurity.this.getShell(), (String)"Clear project password", (String)"Are you sure you want to clear project password?")) {
                    DBPProject projectMetadata = PrefPageProjectSecurity.this.getProjectMetadata();
                    UIServiceSecurity serviceSecurity = (UIServiceSecurity)DBWorkbench.getService(UIServiceSecurity.class);
                    if (serviceSecurity != null && serviceSecurity.validatePassword(projectMetadata.getSecureStorage(), "Enter project password", "Enter current propject password")) {
                        PrefPageProjectSecurity.this.projectPassword = null;
                        PrefPageProjectSecurity.this.clearProjectPasswordButton.setEnabled(false);
                    }
                }
            }
        });
        Group encryptConfig = UIUtils.createControlGroup((Composite)composite, (String)"Encrypt configuration", (int)1, (int)0, (int)0);
        new Label((Composite)encryptConfig, 0).setText("By default project configuration (connections, hosts, ports, database names) stored as plain text.\nEnabling following option will encrypt connections configuration.\nNote: user credentials are always encrypted and stored separately.");
        this.useProjectSecurityCheck = UIUtils.createCheckbox((Composite)encryptConfig, (String)"Encrypt configuration", (String)"Encrypt project configuration.If enabled all project configuration files will be encrypted.", (boolean)false, (int)1);
        this.performDefaults();
        return composite;
    }

    private void setProjectPassword() {
        this.projectPassword = NewPasswordDialog.getNewPassword(this.getShell(), "Set project password", null);
        this.clearProjectPasswordButton.setEnabled(!CommonUtils.isEmpty((String)this.projectPassword));
    }

    protected void performDefaults() {
        DBPProject projectMetadata = this.getProjectMetadata();
        this.lastEncryptProject = CommonUtils.toBoolean((Object)projectMetadata.getProjectProperty("secureProject"));
        this.useProjectSecurityCheck.setSelection(this.lastEncryptProject);
        boolean usePassword = CommonUtils.toBoolean((Object)projectMetadata.getProjectProperty("useProjectPassword"));
        this.clearProjectPasswordButton.setEnabled(usePassword);
        if (usePassword) {
            this.projectPassword = DUMMY_PASSWORD;
        }
        super.performDefaults();
    }

    private DBPProject getProjectMeta() {
        return DBWorkbench.getPlatform().getWorkspace().getProject(this.project);
    }

    public boolean performOk() {
        boolean encryptProject;
        DBPProject projectMetadata = this.getProjectMetadata();
        boolean configChanged = false;
        boolean oldUsePassword = CommonUtils.toBoolean((Object)projectMetadata.getProjectProperty("useProjectPassword"));
        if (!CommonUtils.equalObjects((Object)this.projectPassword, (Object)this.lastSavedPassword)) {
            if (CommonUtils.isEmpty((String)this.projectPassword)) {
                if (oldUsePassword && !UIUtils.confirmAction((Shell)this.getShell(), (String)"Project password remove", (String)("Are you sure you want to remove project '" + projectMetadata.getName() + "' password?\nProject settings will be saved in plaintext non-secure format."), (int)8)) {
                    return false;
                }
                projectMetadata.setProjectProperty("useProjectPassword", (Object)false);
            } else if (!this.projectPassword.equals(DUMMY_PASSWORD) && (oldUsePassword ? !UIUtils.confirmAction((Shell)this.getShell(), (String)"Project password change", (String)("Are you sure you want to change project '" + projectMetadata.getName() + "' password?\nProject settings will be re-encrypted.")) : !UIUtils.confirmAction((Shell)this.getShell(), (String)"Project password set", (String)("Are you sure you want to protect project '" + projectMetadata.getName() + "' settings with password?\nYou won't be able to access your project settings if you will forget this password."), (int)8))) {
                return false;
            }
            if (!DUMMY_PASSWORD.equals(this.projectPassword)) {
                DBASecureStorage projectSecureStorage = projectMetadata.getSecureStorage();
                if (projectSecureStorage instanceof EnterpriseProjectSecureStorage) {
                    ((EnterpriseProjectSecureStorage)projectSecureStorage).setProjectPassword(this.projectPassword);
                }
                if (this.projectPassword == null) {
                    projectMetadata.setProjectProperty("useProjectPassword", null);
                } else {
                    projectMetadata.setProjectProperty("useProjectPassword", (Object)true);
                }
            }
            this.lastSavedPassword = this.projectPassword;
            configChanged = true;
        }
        if (this.lastEncryptProject != (encryptProject = this.useProjectSecurityCheck.getSelection())) {
            projectMetadata.setProjectProperty("secureProject", (Object)encryptProject);
            this.lastEncryptProject = encryptProject;
            configChanged = true;
        }
        if (configChanged) {
            projectMetadata.getDataSourceRegistry().flushConfig();
        }
        return super.performOk();
    }

    public IAdaptable getElement() {
        return this.project;
    }

    public void setElement(IAdaptable element) {
        this.project = element instanceof IProject ? (IProject)element : (IProject)DBUtils.getAdapter(IProject.class, (Object)element);
    }
}

