/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.LobReader;
import com.sybase.jdbc4.jdbc.MdaManager;
import com.sybase.jdbc4.jdbc.SybCharLob;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LobLocatorReader
extends LobReader {
    public LobLocatorReader(SybCharLob sybCharLob) {
        this(sybCharLob, 1L, Long.MAX_VALUE);
    }

    public LobLocatorReader(SybCharLob sybCharLob, long l, long l2) {
        super(sybCharLob, l, l2);
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        this.checkIfClosed();
        if (cArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > cArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this._nextReadPos > this._readLimit) {
            return -1;
        }
        if (this._nextReadPos + (long)n2 > this._readLimit) {
            n2 = (int)(this._readLimit - this._nextReadPos + 1L);
        }
        int n3 = 0;
        try {
            MdaManager mdaManager = this._lob._context._conn.getMDA(this._lob._context);
            PreparedStatement preparedStatement = mdaManager.getMetaDataAccessor("LOB_GETLOB", this._lob._context);
            preparedStatement.setInt(1, this._lob._lobType.ordinal());
            preparedStatement.setBytes(2, this._lob.getLocator());
            preparedStatement.setLong(3, this._nextReadPos);
            preparedStatement.setInt(4, n2);
            ResultSet resultSet = preparedStatement.executeQuery();
            String string = null;
            char[] cArray2 = null;
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
            if (string == null) {
                return -1;
            }
            cArray2 = string.toCharArray();
            n3 = cArray2.length < n2 ? cArray2.length : n2;
            System.arraycopy(cArray2, 0, cArray, n, n3);
        }
        catch (SQLException sQLException) {
            ErrorMessage.raiseIOException("JZ041", "Read", "Reader", sQLException);
        }
        this._nextReadPos += (long)n3;
        return n3;
    }
}

