/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.model;

import com.dbeaver.ee.influxdb.InfluxUtils;
import com.dbeaver.ee.influxdb.model.InfluxDataSource;
import com.dbeaver.ee.influxdb.model.InfluxMeasurement;
import com.dbeaver.ee.influxdb.model.InfluxRetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.utils.CommonUtils;

public class InfluxDatabase
implements DBSCatalog,
DBPSaveableObject,
DBPSystemObject,
DBPRefreshableObject {
    private static final Log log = Log.getLog(InfluxDatabase.class);
    private final InfluxDataSource dataSource;
    private final String dbName;
    private boolean persisted;
    private MeasurementCache measurementCache = new MeasurementCache();
    private RetentionPolicyCache retentionPolicyCache = new RetentionPolicyCache();

    public InfluxDatabase(InfluxDataSource dataSource, String dbName) {
        this.dataSource = dataSource;
        this.dbName = dbName;
        this.persisted = true;
    }

    @NotNull
    public InfluxDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.dbName;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public List<InfluxMeasurement> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getMeasurements(monitor);
    }

    public InfluxMeasurement getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (InfluxMeasurement)DBUtils.findObject((Collection)this.getChildren(monitor), (String)childName);
    }

    public Class<InfluxMeasurement> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return InfluxMeasurement.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    public String toString() {
        return this.getName();
    }

    public boolean isSystem() {
        return this.dbName.equals("_internal");
    }

    @Association
    public List<InfluxMeasurement> getMeasurements(DBRProgressMonitor monitor) throws DBException {
        return this.measurementCache.getAllObjects(monitor, this);
    }

    @Association
    public List<InfluxRetentionPolicy> getRetentionPolicies(DBRProgressMonitor monitor) throws DBException {
        return this.retentionPolicyCache.getAllObjects(monitor, this);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.measurementCache.clearCache();
        this.retentionPolicyCache.clearCache();
        return this;
    }

    class MeasurementCache
    extends AbstractObjectCache<InfluxDatabase, InfluxMeasurement> {
        MeasurementCache() {
        }

        @NotNull
        public List<InfluxMeasurement> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable InfluxDatabase database) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<InfluxMeasurement> measurements = new ArrayList<InfluxMeasurement>();
                InfluxDB influxDB = InfluxDatabase.this.getDataSource().getDefaultContext(monitor, true).getInfluxDB();
                QueryResult dbListResult = influxDB.query(new Query("SHOW MEASUREMENTS", InfluxDatabase.this.getName()));
                for (QueryResult.Result result : dbListResult.getResults()) {
                    for (QueryResult.Series series : CommonUtils.safeList((List)result.getSeries())) {
                        for (List dbObj : CommonUtils.safeList((List)series.getValues())) {
                            Object dbName = dbObj.get(0);
                            measurements.add(new InfluxMeasurement(database, CommonUtils.toString(dbName)));
                        }
                    }
                }
                measurements.sort(DBUtils.nameComparator());
                this.setCache(measurements);
            }
            return this.getCachedObjects();
        }

        public InfluxMeasurement getObject(@NotNull DBRProgressMonitor monitor, @Nullable InfluxDatabase database, @NotNull String name) throws DBException {
            return (InfluxMeasurement)DBUtils.findObject(this.getAllObjects(monitor, database), (String)name);
        }
    }

    class RetentionPolicyCache
    extends AbstractObjectCache<InfluxDatabase, InfluxRetentionPolicy> {
        RetentionPolicyCache() {
        }

        @NotNull
        public List<InfluxRetentionPolicy> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable InfluxDatabase database) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<InfluxRetentionPolicy> retentionPolicies = new ArrayList<InfluxRetentionPolicy>();
                InfluxDB influxDB = InfluxDatabase.this.getDataSource().getDefaultContext(monitor, true).getInfluxDB();
                QueryResult dbListResult = influxDB.query(new Query("SHOW RETENTION POLICIES ON " + InfluxDatabase.this.getName(), InfluxDatabase.this.getName()));
                for (QueryResult.Result result : dbListResult.getResults()) {
                    for (QueryResult.Series series : CommonUtils.safeList((List)result.getSeries())) {
                        for (List row : CommonUtils.safeList((List)series.getValues())) {
                            String rpName = CommonUtils.toString((Object)InfluxUtils.getResultValue(series, row, "name"));
                            String rpDuration = CommonUtils.toString((Object)InfluxUtils.getResultValue(series, row, "duration"));
                            String shardGroupDuration = CommonUtils.toString((Object)InfluxUtils.getResultValue(series, row, "shardGroupDuration"));
                            String replicaN = CommonUtils.toString((Object)InfluxUtils.getResultValue(series, row, "replicaN"));
                            boolean isDefault = CommonUtils.toBoolean((Object)InfluxUtils.getResultValue(series, row, "default"));
                            retentionPolicies.add(new InfluxRetentionPolicy(database, rpName, rpDuration, shardGroupDuration, replicaN, isDefault));
                        }
                    }
                }
                retentionPolicies.sort(DBUtils.nameComparator());
                this.setCache(retentionPolicies);
            }
            return this.getCachedObjects();
        }

        public InfluxRetentionPolicy getObject(@NotNull DBRProgressMonitor monitor, @Nullable InfluxDatabase database, @NotNull String name) throws DBException {
            return (InfluxRetentionPolicy)DBUtils.findObject(this.getAllObjects(monitor, database), (String)name);
        }
    }
}

