/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class ByteNumberFormat
extends NumberFormat {
    private static final long serialVersionUID = 1L;
    private static final String B = "B";
    private static final String KB = "KB";
    private static final String MB = "MB";
    private static final String GB = "GB";
    private static final String TB = "TB";
    private static final String PB = "PB";
    public static final String[] BYTES = new String[]{"B", "KB", "MB", "GB", "TB", "PB"};

    public static int computeIndex(double bytes) {
        int index = 0;
        int i = 0;
        while (i < BYTES.length) {
            int result = (int)(bytes / 1024.0);
            if (result == 0 || (bytes /= 1024.0) < 10.0) break;
            ++index;
            ++i;
        }
        return index;
    }

    public String getBytes(double bytes) {
        int index = ByteNumberFormat.computeIndex(bytes);
        long intBytes = (long)bytes;
        if (intBytes == 0L) {
            return String.valueOf(0);
        }
        int i = 0;
        while (i < index) {
            intBytes /= 1024L;
            ++i;
        }
        String str = String.valueOf(intBytes);
        if (index == 0) {
            return str;
        }
        return String.valueOf(str) + BYTES[index];
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(this.getBytes(number));
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(this.getBytes(number));
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        return null;
    }

    public static void main(String[] args) {
        System.out.println(new ByteNumberFormat().format(100L));
        System.out.println(new ByteNumberFormat().format(1000L));
        System.out.println(new ByteNumberFormat().format(10000L));
        System.out.println(new ByteNumberFormat().format(11000L));
        System.out.println(new ByteNumberFormat().format(100000L));
        System.out.println(new ByteNumberFormat().format(1000000L));
        System.out.println(new ByteNumberFormat().format(10000000L));
    }
}

