/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.references;

import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPanel;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetListenerAdapter;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.panel.references.ReferencesResultsContainer;

public class ReferencesPanel
implements IResultSetPanel {
    private static final String PANEL_ID = "results-references";
    private static final String SETTINGS_SECTION_GROUPING = "panel-results-references";
    private IResultSetPresentation presentation;
    private IDialogSettings panelSettings;
    private ReferencesResultsContainer resultsContainer;

    @Override
    public Control createContents(IResultSetPresentation presentation, Composite parent) {
        this.presentation = presentation;
        this.panelSettings = ResultSetUtils.getViewerSettings(SETTINGS_SECTION_GROUPING);
        this.loadSettings();
        this.resultsContainer = new ReferencesResultsContainer(parent, presentation.getController());
        ResultSetListenerAdapter dataListener = new ResultSetListenerAdapter(){

            @Override
            public void handleResultSetLoad() {
                ReferencesPanel.this.refresh(true);
            }
        };
        presentation.getController().addListener(dataListener);
        presentation.getControl().addDisposeListener(e -> presentation.getController().removeListener(dataListener));
        if (presentation instanceof ISelectionProvider) {
            ISelectionChangedListener selectionListener = event -> {
                if (presentation.getController().getVisiblePanel() != this) {
                    return;
                }
                this.resultsContainer.refreshReferences();
            };
            ((ISelectionProvider)presentation).addSelectionChangedListener(selectionListener);
            presentation.getControl().addDisposeListener(e -> ((ISelectionProvider)presentation).removeSelectionChangedListener(selectionListener));
        }
        return this.resultsContainer.getControl();
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    private void updateControls() {
        this.presentation.getController().updatePanelActions();
    }

    private void loadSettings() {
        this.panelSettings.getSection("references");
    }

    private void saveSettings() {
        UIUtils.getSettingsSection((IDialogSettings)this.panelSettings, (String)"references");
    }

    @Override
    public void activatePanel() {
        this.refresh(false);
    }

    @Override
    public void deactivatePanel() {
    }

    @Override
    public void refresh(boolean force) {
        if (this.presentation.getController().getVisiblePanel() == this) {
            this.resultsContainer.refreshReferences();
        }
    }

    public void contributeActions(IContributionManager manager) {
    }
}

