/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.model.edit.DBEObjectManager;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.registry.ObjectManagerDescriptor;

public class ObjectManagerRegistry
implements DBERegistry {
    private static final String TAG_MANAGER = "manager";
    private static ObjectManagerRegistry instance = null;
    private List<ObjectManagerDescriptor> entityManagers = new ArrayList<ObjectManagerDescriptor>();
    private Map<String, ObjectManagerDescriptor> entityManagerMap = new HashMap<String, ObjectManagerDescriptor>();
    private Map<String, Boolean> nullEntityManagerMap = new HashMap<String, Boolean>();

    public static synchronized ObjectManagerRegistry getInstance() {
        if (instance == null) {
            instance = new ObjectManagerRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    public ObjectManagerRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.objectManager");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (TAG_MANAGER.equals(ext.getName())) {
                ObjectManagerDescriptor descriptor = new ObjectManagerDescriptor(ext);
                this.entityManagers.add(descriptor);
            }
            ++n2;
        }
        for (ObjectManagerDescriptor em : this.entityManagers) {
            this.entityManagerMap.put(em.getObjectType().getImplName(), em);
        }
    }

    public void dispose() {
        for (ObjectManagerDescriptor descriptor : this.entityManagers) {
            descriptor.dispose();
        }
        this.entityManagers.clear();
        this.entityManagerMap.clear();
        this.nullEntityManagerMap.clear();
    }

    private ObjectManagerDescriptor getEntityManager(Class objectType) {
        String targetTypeName = objectType.getName();
        ObjectManagerDescriptor manager = this.entityManagerMap.get(targetTypeName);
        if (manager != null) {
            return manager;
        }
        if (this.nullEntityManagerMap.containsKey(targetTypeName)) {
            return null;
        }
        for (ObjectManagerDescriptor descriptor : this.entityManagers) {
            if (!descriptor.appliesToType(objectType)) continue;
            this.entityManagerMap.put(targetTypeName, descriptor);
            return descriptor;
        }
        this.nullEntityManagerMap.put(targetTypeName, Boolean.TRUE);
        return null;
    }

    public DBEObjectManager<?> getObjectManager(Class<?> aClass) {
        ObjectManagerDescriptor entityManager = this.getEntityManager(aClass);
        return entityManager == null ? null : entityManager.getManager();
    }

    public <T> T getObjectManager(Class<?> objectClass, Class<T> managerType) {
        DBEObjectManager<?> objectManager = this.getObjectManager(objectClass);
        if (objectManager != null && managerType.isAssignableFrom(objectManager.getClass())) {
            return managerType.cast(objectManager);
        }
        return null;
    }
}

