/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPDataFormatterRegistry;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.impl.preferences.SimplePreferenceStore;
import org.jkiss.dbeaver.registry.formatter.DataFormatterProfile;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.utils.UtilityTaskDescriptor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

public class UtilityTaskRegistry
implements DBPDataFormatterRegistry {
    private static final Log log = Log.getLog(UtilityTaskRegistry.class);
    public static final String CONFIG_FILE_NAME = "dataformat-profiles.xml";
    private static UtilityTaskRegistry instance = null;
    private final List<UtilityTaskDescriptor> dataFormatterList = new ArrayList<UtilityTaskDescriptor>();
    private final Map<String, UtilityTaskDescriptor> dataFormatterMap = new HashMap<String, UtilityTaskDescriptor>();
    private DBDDataFormatterProfile globalProfile;
    private List<DBDDataFormatterProfile> customProfiles = null;

    public static synchronized UtilityTaskRegistry getInstance() {
        if (instance == null) {
            instance = new UtilityTaskRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private UtilityTaskRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.utils");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            UtilityTaskDescriptor formatterDescriptor = new UtilityTaskDescriptor(ext);
            this.dataFormatterList.add(formatterDescriptor);
            this.dataFormatterMap.put(formatterDescriptor.getId(), formatterDescriptor);
            ++n2;
        }
    }

    public void dispose() {
        this.dataFormatterList.clear();
        this.dataFormatterMap.clear();
        this.globalProfile = null;
    }

    public List<UtilityTaskDescriptor> getDataFormatters() {
        return this.dataFormatterList;
    }

    public UtilityTaskDescriptor getDataFormatter(String typeId) {
        return this.dataFormatterMap.get(typeId);
    }

    @Override
    public synchronized DBDDataFormatterProfile getGlobalProfile() {
        if (this.globalProfile == null) {
            this.globalProfile = new DataFormatterProfile("Global", DBWorkbench.getPlatform().getPreferenceStore());
        }
        return this.globalProfile;
    }

    @Override
    @Nullable
    public DBDDataFormatterProfile getCustomProfile(String name) {
        for (DBDDataFormatterProfile profile : this.getCustomProfiles()) {
            if (!profile.getProfileName().equals(name)) continue;
            return profile;
        }
        return null;
    }

    @Override
    public synchronized List<DBDDataFormatterProfile> getCustomProfiles() {
        if (this.customProfiles == null) {
            this.loadProfiles();
        }
        return this.customProfiles;
    }

    private void loadProfiles() {
        this.customProfiles = new ArrayList<DBDDataFormatterProfile>();
        File storeFile = DBWorkbench.getPlatform().getConfigurationFile(CONFIG_FILE_NAME);
        if (!storeFile.exists()) {
            return;
        }
        try {
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (FileInputStream is = new FileInputStream(storeFile);){
                    SAXReader parser = new SAXReader((InputStream)is);
                    try {
                        parser.parse((SAXListener)new FormattersParser());
                    }
                    catch (XMLException ex) {
                        throw new DBException("Datasource config parse error", ex);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (DBException ex) {
                log.warn("Can't load profiles config from " + storeFile.getPath(), ex);
            }
        }
        catch (IOException ex) {
            log.warn("IO error", ex);
        }
    }

    private void saveProfiles() {
        if (this.customProfiles == null) {
            return;
        }
        File storeFile = DBWorkbench.getPlatform().getConfigurationFile(CONFIG_FILE_NAME);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream os = new FileOutputStream(storeFile);){
                XMLBuilder xml = new XMLBuilder((OutputStream)os, GeneralUtils.UTF8_ENCODING);
                xml.setButify(true);
                xml.startElement("profiles");
                for (DBDDataFormatterProfile profile : this.customProfiles) {
                    xml.startElement("profile");
                    xml.addAttribute("name", profile.getProfileName());
                    SimplePreferenceStore store = (SimplePreferenceStore)profile.getPreferenceStore();
                    Map<String, String> props = store.getProperties();
                    if (props != null) {
                        for (Map.Entry<String, String> entry : props.entrySet()) {
                            xml.startElement("property");
                            xml.addAttribute("name", entry.getKey());
                            xml.addAttribute("value", entry.getValue());
                            xml.endElement();
                        }
                    }
                    xml.endElement();
                }
                xml.endElement();
                xml.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            log.warn("IO error", ex);
        }
    }

    public DBDDataFormatterProfile createCustomProfile(String profileName) {
        this.getCustomProfiles();
        DataFormatterProfile profile = new DataFormatterProfile(profileName, new CustomProfileStore());
        this.customProfiles.add(profile);
        this.saveProfiles();
        return profile;
    }

    public void deleteCustomProfile(DBDDataFormatterProfile profile) {
        this.getCustomProfiles();
        if (this.customProfiles.remove(profile)) {
            this.saveProfiles();
        }
    }

    private class CustomProfileStore
    extends SimplePreferenceStore {
        private CustomProfileStore() {
            super(DBWorkbench.getPlatform().getPreferenceStore());
        }

        @Override
        public void save() throws IOException {
            UtilityTaskRegistry.this.saveProfiles();
        }
    }

    private class FormattersParser
    extends SAXListener.BaseListener {
        private String profileName;
        private SimplePreferenceStore curStore;

        private FormattersParser() {
        }

        public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) throws XMLException {
            if (localName.equals("profile")) {
                this.curStore = new CustomProfileStore();
                this.profileName = atts.getValue("name");
            } else if (localName.equals("property") && this.curStore != null) {
                this.curStore.setValue(atts.getValue("name"), atts.getValue("value"));
            }
        }

        public void saxEndElement(SAXReader reader, String namespaceURI, String localName) throws XMLException {
            if (localName.equals("profile") && !CommonUtils.isEmpty((String)this.profileName)) {
                DataFormatterProfile profile = new DataFormatterProfile(this.profileName, this.curStore);
                UtilityTaskRegistry.this.customProfiles.add(profile);
            }
        }
    }
}

