/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVObject;
import org.jkiss.utils.CommonUtils;

public class DBVContainer
extends DBVObject
implements DBSObjectContainer {
    static final String ENTITY_PREFIX = ":";
    static final String CONFIG_PREFIX = "@";
    private final DBVContainer parent;
    private String name;
    private String type = "container";
    private String description;
    private Map<String, DBVContainer> containers = new LinkedHashMap<String, DBVContainer>();
    private Map<String, DBVEntity> entities = new LinkedHashMap<String, DBVEntity>();

    public DBVContainer(DBVContainer parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    DBVContainer(DBVContainer parent, DBVContainer source) {
        this.parent = parent;
        this.name = source.name;
        this.description = source.description;
        for (Map.Entry<String, DBVContainer> entry : source.containers.entrySet()) {
            this.containers.put(entry.getKey(), new DBVContainer(this, entry.getValue()));
        }
        for (Map.Entry<String, DBVObject> entry : source.entities.entrySet()) {
            this.entities.put(entry.getKey(), new DBVEntity(this, (DBVEntity)entry.getValue()));
        }
        super.copyFrom(source);
    }

    DBVContainer(DBVContainer parent, String name, Map<String, Object> map) {
        this.parent = parent;
        this.name = name;
        for (Map.Entry<String, Object> element : map.entrySet()) {
            String id = element.getKey();
            if (id.startsWith(ENTITY_PREFIX)) {
                DBVEntity entity = new DBVEntity(this, id.substring(ENTITY_PREFIX.length()), (Map)element.getValue());
                this.entities.put(entity.getName(), entity);
                continue;
            }
            if (id.startsWith(CONFIG_PREFIX)) {
                String configMap = id.substring(CONFIG_PREFIX.length());
                if (!configMap.equals("properties")) continue;
                this.loadPropertiesFrom(map, id);
                continue;
            }
            if (!(element.getValue() instanceof Map)) continue;
            DBVContainer child = new DBVContainer(this, id, (Map)element.getValue());
            this.containers.put(child.getName(), child);
        }
    }

    public DBSObjectContainer getRealContainer(DBRProgressMonitor monitor) throws DBException {
        DBSObjectContainer realParent = this.parent.getRealContainer(monitor);
        if (realParent == null) {
            return null;
        }
        DBSObject child = realParent.getChild(monitor, this.name);
        if (child instanceof DBSObjectContainer) {
            return (DBSObjectContainer)child;
        }
        log.warn("Child '" + this.name + "' of '" + realParent.getName() + "' is not an object container");
        return null;
    }

    @Override
    public DBVContainer getParentObject() {
        return this.parent;
    }

    @Override
    @NotNull
    public DBPDataSource getDataSource() {
        return this.parent.getDataSource();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    public Collection<DBVContainer> getContainers() {
        return this.containers.values();
    }

    public DBVContainer getContainer(String name, boolean createNew) {
        DBVContainer container = this.containers.get(name);
        if (container == null && createNew) {
            container = new DBVContainer(this, name);
            this.addContainer(container);
        }
        return container;
    }

    void addContainer(DBVContainer container) {
        this.containers.put(container.getName(), container);
    }

    public Collection<DBVEntity> getEntities() {
        return this.entities.values();
    }

    public DBVEntity getEntity(String name, boolean createNew) {
        String dictName = name;
        DBVEntity entity = this.entities.get(dictName);
        if (entity == null && createNew) {
            entity = new DBVEntity(this, name, null);
            this.entities.put(dictName, entity);
        }
        return entity;
    }

    void addEntity(DBVEntity entity) {
        this.entities.put(entity.getName(), entity);
    }

    @Override
    public boolean hasValuableData() {
        if (!CommonUtils.isEmpty(this.getProperties())) {
            return true;
        }
        for (DBVEntity entity : this.getEntities()) {
            if (!entity.hasValuableData()) continue;
            return true;
        }
        for (DBVContainer child : this.getContainers()) {
            if (!child.hasValuableData()) continue;
            return true;
        }
        return false;
    }

    void copyFrom(DBVContainer container) {
        DBVObject myChild;
        this.name = container.name;
        this.description = container.description;
        this.containers.clear();
        for (DBVContainer dBVContainer : container.getContainers()) {
            myChild = new DBVContainer(this, dBVContainer.getName());
            ((DBVContainer)myChild).copyFrom(dBVContainer);
            this.containers.put(((DBVContainer)myChild).getName(), (DBVContainer)myChild);
        }
        this.entities.clear();
        for (DBVEntity dBVEntity : container.getEntities()) {
            myChild = new DBVEntity(this, dBVEntity);
            this.entities.put(((DBVEntity)myChild).getName(), (DBVEntity)myChild);
        }
    }

    @Override
    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return !this.containers.isEmpty() ? this.containers.values() : this.entities.values();
    }

    @Override
    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return !this.containers.isEmpty() ? (DBSObject)this.containers.get(childName) : (DBSObject)this.entities.get(childName);
    }

    @Override
    public Class<? extends DBSObject> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return !this.containers.isEmpty() ? DBVContainer.class : DBVEntity.class;
    }

    @Override
    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    public String toString() {
        return this.name;
    }
}

