/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKeyColumn;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;

public class DBVEntityForeignKeyColumn
implements DBSTableForeignKeyColumn {
    private static final Log log = Log.getLog(DBVEntityForeignKeyColumn.class);
    private final DBVEntityForeignKey foreignKey;
    private final String attributeName;
    private final String refAttributeName;

    public DBVEntityForeignKeyColumn(DBVEntityForeignKey foreignKey, String attributeName, String refAttributeName) {
        this.foreignKey = foreignKey;
        this.attributeName = attributeName;
        this.refAttributeName = refAttributeName;
    }

    public DBVEntityForeignKeyColumn(DBVEntityForeignKey foreignKey, DBVEntityForeignKeyColumn copy) {
        this.foreignKey = foreignKey;
        this.attributeName = copy.attributeName;
        this.refAttributeName = copy.refAttributeName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.attributeName;
    }

    @Override
    public DBSEntityAttribute getAttribute() {
        return this.foreignKey.getEntity().getAttribute(new VoidProgressMonitor(), this.attributeName);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getRefAttributeName() {
        return this.refAttributeName;
    }

    @Override
    public DBSEntityAttribute getReferencedColumn() {
        DBSEntity associatedEntity = this.foreignKey.getAssociatedEntity();
        try {
            return associatedEntity == null ? null : associatedEntity.getAttribute(new VoidProgressMonitor(), this.refAttributeName);
        }
        catch (DBException e) {
            log.error("Error getting virtual FK referenced column", e);
            return null;
        }
    }
}

