/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.wmi.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.wmi.model.WMIClass;
import org.jkiss.dbeaver.ext.wmi.model.WMIClassAttribute;
import org.jkiss.dbeaver.ext.wmi.model.WMIValueMeta;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.data.DBDValueMeta;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.utils.CommonUtils;
import org.jkiss.wmi.service.WMIException;
import org.jkiss.wmi.service.WMIObject;
import org.jkiss.wmi.service.WMIObjectAttribute;

public class WMIResultSet
implements DBCResultSet,
DBCResultSetMetaData,
DBCEntityMetaData {
    private DBCSession session;
    private WMIClass classObject;
    private Collection<WMIObject> rows;
    private Iterator<WMIObject> iterator;
    private WMIObject row;
    private List<DBCAttributeMetaData> properties;

    public WMIResultSet(DBCSession session, WMIClass classObject, Collection<WMIObject> rows) throws WMIException {
        this.session = session;
        this.classObject = classObject;
        this.rows = rows;
        this.iterator = rows.iterator();
        this.row = null;
        Object metaObject = classObject != null ? classObject.getClassObject() : (!rows.isEmpty() ? rows.iterator().next() : null);
        if (metaObject == null) {
            this.properties = Collections.emptyList();
        } else {
            Collection props = metaObject.getAttributes(0L);
            this.properties = new ArrayList<DBCAttributeMetaData>(props.size());
            int index = 0;
            for (WMIObjectAttribute prop : props) {
                if (prop.isSystem()) continue;
                this.properties.add(new MetaProperty(prop, index++));
            }
        }
    }

    public DBCSession getSession() {
        return this.session;
    }

    public DBCStatement getSourceStatement() {
        return null;
    }

    public Object getAttributeValue(int index) throws DBCException {
        try {
            if (index >= this.properties.size()) {
                throw new DBCException("Column index " + index + " out of bounds (" + this.properties.size() + ")");
            }
            return this.row.getValue(this.properties.get(index).getName());
        }
        catch (WMIException e) {
            throw new DBCException((Throwable)e, this.session.getDataSource());
        }
    }

    @Nullable
    public Object getAttributeValue(String name) throws DBCException {
        try {
            return this.row.getValue(name);
        }
        catch (WMIException e) {
            throw new DBCException((Throwable)e, this.session.getDataSource());
        }
    }

    public DBDValueMeta getAttributeValueMeta(int index) throws DBCException {
        return null;
    }

    public DBDValueMeta getRowMeta() throws DBCException {
        Collection qualifiers;
        block3: {
            try {
                qualifiers = this.row.getQualifiers();
                if (!CommonUtils.isEmpty((Collection)qualifiers)) break block3;
                return null;
            }
            catch (WMIException wMIException) {
                throw new DBCException("Can't read value qualifiers");
            }
        }
        return new WMIValueMeta(qualifiers);
    }

    public boolean nextRow() throws DBCException {
        if (!this.iterator.hasNext()) {
            return false;
        }
        this.row = this.iterator.next();
        return true;
    }

    public boolean moveTo(int position) throws DBCException {
        this.iterator = this.rows.iterator();
        while (position-- > 0) {
            this.nextRow();
        }
        return true;
    }

    @NotNull
    public DBCResultSetMetaData getMeta() throws DBCException {
        return this;
    }

    public String getResultSetName() throws DBCException {
        return null;
    }

    public Object getFeature(String name) {
        return null;
    }

    public void close() {
        for (WMIObject row : this.rows) {
            row.release();
        }
        this.rows.clear();
        this.row = null;
    }

    @NotNull
    public List<DBCAttributeMetaData> getAttributes() {
        return this.properties;
    }

    @Nullable
    public String getCatalogName() {
        return null;
    }

    @Nullable
    public String getSchemaName() {
        return null;
    }

    @NotNull
    public String getEntityName() {
        return this.classObject == null ? null : this.classObject.getName();
    }

    private class MetaProperty
    implements DBCAttributeMetaData,
    DBPImageProvider {
        private final WMIObjectAttribute attribute;
        private final int index;

        private MetaProperty(WMIObjectAttribute attribute, int index) {
            this.attribute = attribute;
            this.index = index;
        }

        @NotNull
        public String getName() {
            return this.attribute.getName();
        }

        public long getMaxLength() {
            return 0L;
        }

        public String getTypeName() {
            return this.attribute.getTypeName();
        }

        public String getFullTypeName() {
            return this.attribute.getTypeName();
        }

        public int getTypeID() {
            return this.attribute.getType();
        }

        public DBPDataKind getDataKind() {
            return WMIClassAttribute.getDataKindById(this.attribute.getType());
        }

        public Integer getScale() {
            return 0;
        }

        public Integer getPrecision() {
            return 0;
        }

        public int getOrdinalPosition() {
            return this.index;
        }

        @Nullable
        public Object getSource() {
            return null;
        }

        @NotNull
        public String getLabel() {
            return this.attribute.getName();
        }

        @Nullable
        public String getEntityName() {
            return WMIResultSet.this.classObject == null ? null : WMIResultSet.this.classObject.getName();
        }

        public boolean isReadOnly() {
            return false;
        }

        @Nullable
        public DBCEntityMetaData getEntityMetaData() {
            return WMIResultSet.this;
        }

        @Nullable
        public DBPImage getObjectImage() {
            return WMIClassAttribute.getPropertyImage(this.attribute.getType());
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }
    }
}

