/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleConstants;
import org.jkiss.dbeaver.ext.oracle.model.OracleDBLink;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.ext.oracle.model.OracleGlobalObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleJavaClass;
import org.jkiss.dbeaver.ext.oracle.model.OracleMaterializedView;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OraclePackage;
import org.jkiss.dbeaver.ext.oracle.model.OracleProcedureStandalone;
import org.jkiss.dbeaver.ext.oracle.model.OracleQueue;
import org.jkiss.dbeaver.ext.oracle.model.OracleRecycledObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchedulerJob;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchedulerProgram;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchemaTrigger;
import org.jkiss.dbeaver.ext.oracle.model.OracleSequence;
import org.jkiss.dbeaver.ext.oracle.model.OracleSynonym;
import org.jkiss.dbeaver.ext.oracle.model.OracleTable;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraint;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraintColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKey;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKeyColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableIndex;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableIndexColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePhysical;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableTrigger;
import org.jkiss.dbeaver.ext.oracle.model.OracleTrigger;
import org.jkiss.dbeaver.ext.oracle.model.OracleUser;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.OracleView;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructLookupCache;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class OracleSchema
extends OracleGlobalObject
implements DBSSchema,
DBPRefreshableObject,
DBPSystemObject,
DBSProcedureContainer {
    private static final Log log = Log.getLog(OracleSchema.class);
    public final TableCache tableCache = new TableCache();
    public final MViewCache mviewCache = new MViewCache();
    public final ConstraintCache constraintCache = new ConstraintCache();
    public final ForeignKeyCache foreignKeyCache = new ForeignKeyCache();
    public final TriggerCache triggerCache = new TriggerCache();
    public final IndexCache indexCache = new IndexCache();
    public final DataTypeCache dataTypeCache = new DataTypeCache();
    public final SequenceCache sequenceCache = new SequenceCache();
    public final QueueCache queueCache = new QueueCache();
    public final PackageCache packageCache = new PackageCache();
    public final SynonymCache synonymCache = new SynonymCache();
    public final DBLinkCache dbLinkCache = new DBLinkCache();
    public final ProceduresCache proceduresCache = new ProceduresCache();
    public final JavaCache javaCache = new JavaCache();
    public final SchedulerJobCache schedulerJobCache = new SchedulerJobCache();
    public final SchedulerProgramCache schedulerProgramCache = new SchedulerProgramCache();
    public final RecycleBin recycleBin = new RecycleBin();
    private long id;
    private String name;
    private Date createTime;
    private transient OracleUser user;

    public OracleSchema(OracleDataSource dataSource, long id, String name) {
        super(dataSource, id > 0L);
        this.id = id;
        this.name = name;
    }

    public OracleSchema(@NotNull OracleDataSource dataSource, @NotNull ResultSet dbResult) {
        super(dataSource, true);
        this.id = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"USER_ID");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"USERNAME");
        if (CommonUtils.isEmpty((String)this.name)) {
            log.warn((Object)"Empty schema name fetched");
            this.name = "? " + super.hashCode();
        }
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
    }

    public boolean isPublic() {
        return "PUBLIC".equals(this.name);
    }

    @Property(order=200)
    public long getId() {
        return this.id;
    }

    @Property(order=190)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return null;
    }

    public OracleUser getUser() {
        return this.user;
    }

    public void setUser(OracleUser user) {
        this.user = user;
    }

    @Association
    public Collection<OracleTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return this.indexCache.getObjects(monitor, this, null);
    }

    @Association
    public Collection<OracleTable> getTables(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getTypedObjects(monitor, this, OracleTable.class);
    }

    public OracleTable getTable(DBRProgressMonitor monitor, String name) throws DBException {
        return (OracleTable)this.tableCache.getObject(monitor, this, name, OracleTable.class);
    }

    @Association
    public Collection<OracleView> getViews(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getTypedObjects(monitor, this, OracleView.class);
    }

    public OracleView getView(DBRProgressMonitor monitor, String name) throws DBException {
        return (OracleView)this.tableCache.getObject(monitor, this, name, OracleView.class);
    }

    @Association
    public Collection<OracleMaterializedView> getMaterializedViews(DBRProgressMonitor monitor) throws DBException {
        return this.mviewCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<OracleDataType> getDataTypes(DBRProgressMonitor monitor) throws DBException {
        return this.dataTypeCache.getAllObjects(monitor, this);
    }

    public OracleDataType getDataType(DBRProgressMonitor monitor, String name) throws DBException {
        OracleDataType type;
        OracleDataType oracleDataType = type = this.isPublic() ? this.getTypeBySynonym(monitor, name) : (OracleDataType)this.dataTypeCache.getObject(monitor, this, name);
        if (type == null && !this.isPublic()) {
            return this.getTypeBySynonym(monitor, name);
        }
        return type;
    }

    @Nullable
    private OracleDataType getTypeBySynonym(DBRProgressMonitor monitor, String name) throws DBException {
        Object object;
        OracleSynonym synonym = (OracleSynonym)this.synonymCache.getObject(monitor, this, name);
        if (synonym != null && (synonym.getObjectType() == OracleObjectType.TYPE || synonym.getObjectType() == OracleObjectType.TYPE_BODY) && (object = synonym.getObject(monitor)) instanceof OracleDataType) {
            return (OracleDataType)object;
        }
        return null;
    }

    @Association
    public Collection<OracleQueue> getQueues(DBRProgressMonitor monitor) throws DBException {
        return this.queueCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<OracleSequence> getSequences(DBRProgressMonitor monitor) throws DBException {
        return this.sequenceCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<OraclePackage> getPackages(DBRProgressMonitor monitor) throws DBException {
        return this.packageCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<OracleProcedureStandalone> getProcedures(DBRProgressMonitor monitor) throws DBException {
        return this.proceduresCache.getAllObjects(monitor, this);
    }

    public OracleProcedureStandalone getProcedure(DBRProgressMonitor monitor, String uniqueName) throws DBException {
        return (OracleProcedureStandalone)this.proceduresCache.getObject(monitor, this, uniqueName);
    }

    @Association
    public Collection<OracleSynonym> getSynonyms(DBRProgressMonitor monitor) throws DBException {
        return this.synonymCache.getAllObjects(monitor, this);
    }

    @Association
    public OracleSynonym getSynonym(DBRProgressMonitor monitor, String name) throws DBException {
        return (OracleSynonym)this.synonymCache.getObject(monitor, this, name);
    }

    @Association
    public Collection<OracleSchemaTrigger> getTriggers(DBRProgressMonitor monitor) throws DBException {
        return this.triggerCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<OracleTableTrigger> getTableTriggers(DBRProgressMonitor monitor) throws DBException {
        ArrayList<OracleTableTrigger> allTableTriggers = new ArrayList<OracleTableTrigger>();
        for (OracleTableBase table : this.tableCache.getAllObjects(monitor, this)) {
            Collection<OracleTableTrigger> triggers = table.getTriggers(monitor);
            if (CommonUtils.isEmpty(triggers)) continue;
            allTableTriggers.addAll(triggers);
        }
        allTableTriggers.sort(Comparator.comparing(OracleTrigger::getName));
        return allTableTriggers;
    }

    @Association
    public Collection<OracleDBLink> getDatabaseLinks(DBRProgressMonitor monitor) throws DBException {
        return this.dbLinkCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<OracleJavaClass> getJavaClasses(DBRProgressMonitor monitor) throws DBException {
        return this.javaCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<OracleSchedulerJob> getSchedulerJobs(DBRProgressMonitor monitor) throws DBException {
        return this.schedulerJobCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<OracleSchedulerProgram> getSchedulerPrograms(DBRProgressMonitor monitor) throws DBException {
        return this.schedulerProgramCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<OracleRecycledObject> getRecycledObjects(DBRProgressMonitor monitor) throws DBException {
        return this.recycleBin.getAllObjects(monitor, this);
    }

    @Property(order=90)
    public OracleUser getSchemaUser(DBRProgressMonitor monitor) throws DBException {
        return this.getDataSource().getUser(monitor, this.name);
    }

    public Collection<DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<DBSObject> children = new ArrayList<DBSObject>();
        children.addAll(this.tableCache.getAllObjects(monitor, this));
        children.addAll(this.synonymCache.getAllObjects(monitor, this));
        children.addAll(this.packageCache.getAllObjects(monitor, this));
        return children;
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        OracleTableBase table = (OracleTableBase)this.tableCache.getObject(monitor, this, childName);
        if (table != null) {
            return table;
        }
        OracleSynonym synonym = (OracleSynonym)this.synonymCache.getObject(monitor, this, childName);
        if (synonym != null) {
            return synonym;
        }
        return this.packageCache.getObject(monitor, this, childName);
    }

    public Class<? extends DBSEntity> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return DBSEntity.class;
    }

    public synchronized void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        monitor.subTask("Cache tables");
        this.tableCache.getAllObjects(monitor, this);
        if ((scope & 2) != 0) {
            monitor.subTask("Cache table columns");
            this.tableCache.loadChildren(monitor, this, null);
        }
        if ((scope & 4) != 0) {
            monitor.subTask("Cache table indexes");
            this.indexCache.getObjects(monitor, this, null);
            monitor.subTask("Cache table constraints");
            this.constraintCache.getObjects(monitor, this, null);
            this.foreignKeyCache.getObjects(monitor, this, null);
        }
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.tableCache.clearCache();
        this.foreignKeyCache.clearCache();
        this.constraintCache.clearCache();
        this.indexCache.clearCache();
        this.packageCache.clearCache();
        this.proceduresCache.clearCache();
        this.triggerCache.clearCache();
        this.dataTypeCache.clearCache();
        this.sequenceCache.clearCache();
        this.synonymCache.clearCache();
        this.schedulerJobCache.clearCache();
        this.recycleBin.clearCache();
        return this;
    }

    public boolean isSystem() {
        return ArrayUtils.contains((Object[])OracleConstants.SYSTEM_SCHEMAS, (Object)this.getName());
    }

    public String toString() {
        return "Schema " + this.name;
    }

    private static OracleTableColumn getTableColumn(JDBCSession session, OracleTableBase parent, ResultSet dbResult, String columnName) throws DBException {
        OracleTableColumn tableColumn;
        OracleTableColumn oracleTableColumn = tableColumn = columnName == null ? null : parent.getAttribute(session.getProgressMonitor(), columnName);
        if (tableColumn == null) {
            log.debug((Object)("Column '" + columnName + "' not found in table '" + parent.getName() + "'"));
        }
        return tableColumn;
    }

    private List<SpecialPosition> parsePositions(String value) {
        String[] data;
        if (value == null) {
            return Collections.emptyList();
        }
        if (value.length() < 3) {
            return Collections.emptyList();
        }
        ArrayList<SpecialPosition> result = new ArrayList<SpecialPosition>(1);
        String[] stringArray = data = value.split(",");
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            result.add(new SpecialPosition(s));
            ++n2;
        }
        return result;
    }

    class ConstraintCache
    extends JDBCCompositeCache<OracleSchema, OracleTableBase, OracleTableConstraint, OracleTableConstraintColumn> {
        ConstraintCache() {
            super((JDBCStructCache)OracleSchema.this.tableCache, OracleTableBase.class, (Object)"TABLE_NAME", (Object)"CONSTRAINT_NAME");
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(JDBCSession session, OracleSchema owner, OracleTableBase forTable) throws SQLException {
            JDBCPreparedStatement dbStat;
            boolean useSimpleConnection = CommonUtils.toBoolean((Object)session.getDataSource().getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-meta-use-simple-constraints@"));
            StringBuilder sql = new StringBuilder(500);
            if (owner.getDataSource().isAtLeastV11() && forTable != null && !useSimpleConnection) {
                sql.append("SELECT\r\n    c.TABLE_NAME,\r\n    c.CONSTRAINT_NAME,\r\n    c.CONSTRAINT_TYPE,\r\n    c.STATUS,\r\n    c.SEARCH_CONDITION,\r\n    (\r\n      SELECT LISTAGG(COLUMN_NAME || ':' || POSITION,',') WITHIN GROUP (ORDER BY \"POSITION\") \r\n      FROM ALL_CONS_COLUMNS col\r\n      WHERE col.OWNER =? AND col.TABLE_NAME = ? AND col.CONSTRAINT_NAME = c.CONSTRAINT_NAME GROUP BY CONSTRAINT_NAME \r\n    ) COLUMN_NAMES_NUMS\r\nFROM\r\n    " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), OracleSchema.this.getDataSource(), "CONSTRAINTS") + " c\r\n" + "WHERE\r\n" + "    c.CONSTRAINT_TYPE <> 'R'\r\n" + "    AND c.OWNER = ?\r\n" + "    AND c.TABLE_NAME = ?");
                dbStat = session.prepareStatement(sql.toString());
                dbStat.setString(1, OracleSchema.this.getName());
                dbStat.setString(2, forTable.getName());
                dbStat.setString(3, OracleSchema.this.getName());
                dbStat.setString(4, forTable.getName());
            } else if (owner.getDataSource().isAtLeastV10() && forTable != null && !useSimpleConnection) {
                sql.append("SELECT\r\n    c.TABLE_NAME,\r\n    c.CONSTRAINT_NAME,\r\n    c.CONSTRAINT_TYPE,\r\n    c.STATUS,\r\n    c.SEARCH_CONDITION,\r\n    (\r\n        SELECT LTRIM(MAX(SYS_CONNECT_BY_PATH(cname || ':' || NVL(p,1),','))    KEEP (DENSE_RANK LAST ORDER BY curr),',') \r\n        FROM   (SELECT \r\n                       col.CONSTRAINT_NAME cn,col.POSITION p,col.COLUMN_NAME cname,\r\n                       ROW_NUMBER() OVER (PARTITION BY col.CONSTRAINT_NAME ORDER BY col.POSITION) AS curr,\r\n                       ROW_NUMBER() OVER (PARTITION BY col.CONSTRAINT_NAME ORDER BY col.POSITION) -1 AS prev\r\n                FROM   " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), OracleSchema.this.getDataSource(), "CONS_COLUMNS") + " col \r\n" + "                WHERE  col.OWNER =? AND col.TABLE_NAME = ? \r\n" + "                ) WHERE cn = c.CONSTRAINT_NAME  GROUP BY cn CONNECT BY prev = PRIOR curr AND cn = PRIOR cn START WITH curr = 1      \r\n" + "        ) COLUMN_NAMES_NUMS\r\n" + "FROM\r\n" + "    " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), OracleSchema.this.getDataSource(), "CONSTRAINTS") + " c\r\n" + "WHERE\r\n" + "    c.CONSTRAINT_TYPE <> 'R'\r\n" + "    AND c.OWNER = ?\r\n" + "    AND c.TABLE_NAME = ?");
                dbStat = session.prepareStatement(sql.toString());
                dbStat.setString(1, OracleSchema.this.getName());
                dbStat.setString(2, forTable.getName());
                dbStat.setString(3, OracleSchema.this.getName());
                dbStat.setString(4, forTable.getName());
            } else {
                sql.append("SELECT ").append(OracleUtils.getSysCatalogHint(owner.getDataSource())).append("\nc.TABLE_NAME, c.CONSTRAINT_NAME,c.CONSTRAINT_TYPE,c.STATUS,c.SEARCH_CONDITION,col.COLUMN_NAME,col.POSITION\nFROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), OracleSchema.this.getDataSource(), "CONSTRAINTS") + " c, " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), OracleSchema.this.getDataSource(), "CONS_COLUMNS") + " col\n" + "WHERE c.CONSTRAINT_TYPE<>'R' AND c.OWNER=? AND c.OWNER=col.OWNER AND c.CONSTRAINT_NAME=col.CONSTRAINT_NAME");
                if (forTable != null) {
                    sql.append(" AND c.TABLE_NAME=?");
                }
                sql.append("\nORDER BY c.CONSTRAINT_NAME,col.POSITION");
                dbStat = session.prepareStatement(sql.toString());
                dbStat.setString(1, OracleSchema.this.getName());
                if (forTable != null) {
                    dbStat.setString(2, forTable.getName());
                }
            }
            return dbStat;
        }

        @Nullable
        protected OracleTableConstraint fetchObject(JDBCSession session, OracleSchema owner, OracleTableBase parent, String indexName, JDBCResultSet dbResult) throws SQLException, DBException {
            return new OracleTableConstraint(parent, (ResultSet)dbResult);
        }

        @Nullable
        protected OracleTableConstraintColumn[] fetchObjectRow(JDBCSession session, OracleTableBase parent, OracleTableConstraint object, JDBCResultSet dbResult) throws SQLException, DBException {
            OracleTableConstraintColumn[] oracleTableConstraintColumnArray;
            if (JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAMES_NUMS") != null) {
                List positions = OracleSchema.this.parsePositions(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAMES_NUMS"));
                OracleTableConstraintColumn[] result = new OracleTableConstraintColumn[positions.size()];
                int idx = 0;
                while (idx < positions.size()) {
                    OracleTableColumn column = OracleSchema.getTableColumn(session, parent, (ResultSet)dbResult, ((SpecialPosition)positions.get(idx)).getColumn());
                    if (column != null) {
                        result[idx] = new OracleTableConstraintColumn((AbstractTableConstraint<OracleTableBase>)object, column, ((SpecialPosition)positions.get(idx)).getPos());
                    }
                    ++idx;
                }
                return result;
            }
            OracleTableColumn tableColumn = OracleSchema.getTableColumn(session, parent, (ResultSet)dbResult, JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"COLUMN_NAME"));
            if (tableColumn == null) {
                oracleTableConstraintColumnArray = null;
            } else {
                OracleTableConstraintColumn[] oracleTableConstraintColumnArray2 = new OracleTableConstraintColumn[1];
                oracleTableConstraintColumnArray = oracleTableConstraintColumnArray2;
                oracleTableConstraintColumnArray2[0] = new OracleTableConstraintColumn((AbstractTableConstraint<OracleTableBase>)object, tableColumn, JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"POSITION"));
            }
            return oracleTableConstraintColumnArray;
        }

        protected void cacheChildren(DBRProgressMonitor monitor, OracleTableConstraint constraint, List<OracleTableConstraintColumn> rows) {
            constraint.setColumns(rows);
        }
    }

    static class DBLinkCache
    extends JDBCObjectCache<OracleSchema, OracleDBLink> {
        DBLinkCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleSchema owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner.getDataSource(), "DB_LINKS") + " WHERE OWNER=? " + " ORDER BY DB_LINK");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected OracleDBLink fetchObject(@NotNull JDBCSession session, @NotNull OracleSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new OracleDBLink(session.getProgressMonitor(), owner, (ResultSet)dbResult);
        }
    }

    static class DataTypeCache
    extends JDBCObjectCache<OracleSchema, OracleDataType> {
        DataTypeCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleSchema owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT " + OracleUtils.getSysCatalogHint(owner.getDataSource()) + " * " + "FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner.getDataSource(), "TYPES") + " " + "WHERE OWNER=? ORDER BY TYPE_NAME");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected OracleDataType fetchObject(@NotNull JDBCSession session, @NotNull OracleSchema owner, @NotNull JDBCResultSet resultSet) throws SQLException {
            return new OracleDataType(owner, (ResultSet)resultSet);
        }
    }

    class ForeignKeyCache
    extends JDBCCompositeCache<OracleSchema, OracleTable, OracleTableForeignKey, OracleTableForeignKeyColumn> {
        ForeignKeyCache() {
            super((JDBCStructCache)OracleSchema.this.tableCache, OracleTable.class, (Object)"TABLE_NAME", (Object)"CONSTRAINT_NAME");
        }

        protected void loadObjects(DBRProgressMonitor monitor, OracleSchema schema, OracleTable forParent) throws DBException {
            if (forParent == null) {
                OracleSchema.this.constraintCache.getAllObjects(monitor, schema);
            }
            super.loadObjects(monitor, (DBSObject)schema, (DBSObject)forParent);
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(JDBCSession session, OracleSchema owner, OracleTable forTable) throws SQLException {
            JDBCPreparedStatement dbStat;
            boolean useSimpleConnection = CommonUtils.toBoolean((Object)session.getDataSource().getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-meta-use-simple-constraints@"));
            StringBuilder sql = new StringBuilder(500);
            if (owner.getDataSource().isAtLeastV11() && forTable != null && !useSimpleConnection) {
                sql.append("SELECT \r\n    c.TABLE_NAME,\r\n    c.CONSTRAINT_NAME,\r\n    c.CONSTRAINT_TYPE,\r\n    c.STATUS,\r\n    c.R_OWNER,\r\n    c.R_CONSTRAINT_NAME,\r\n    (SELECT rc.TABLE_NAME FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), OracleSchema.this.getDataSource(), "CONSTRAINTS") + " rc WHERE rc.OWNER = c.r_OWNER AND rc.CONSTRAINT_NAME = c.R_CONSTRAINT_NAME) AS R_TABLE_NAME,\r\n" + "    c.DELETE_RULE,\r\n" + "    (\r\n" + "      SELECT LISTAGG(COLUMN_NAME || ':' || POSITION,',') WITHIN GROUP (ORDER BY \"POSITION\") \r\n" + "      FROM ALL_CONS_COLUMNS col\r\n" + "      WHERE col.OWNER =? AND col.TABLE_NAME = ? AND col.CONSTRAINT_NAME = c.CONSTRAINT_NAME GROUP BY CONSTRAINT_NAME \r\n" + "    ) COLUMN_NAMES_NUMS\r\n" + "FROM\r\n" + "    " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), OracleSchema.this.getDataSource(), "CONSTRAINTS") + " c\r\n" + "WHERE\r\n" + "    c.CONSTRAINT_TYPE = 'R'\r\n" + "    AND c.OWNER = ?\r\n" + "    AND c.TABLE_NAME = ?");
                dbStat = session.prepareStatement(sql.toString());
                dbStat.setString(1, OracleSchema.this.getName());
                dbStat.setString(2, forTable.getName());
                dbStat.setString(3, OracleSchema.this.getName());
                dbStat.setString(4, forTable.getName());
            } else if (owner.getDataSource().isAtLeastV10() && forTable != null && !useSimpleConnection) {
                sql.append("SELECT \r\n    c.TABLE_NAME,\r\n    c.CONSTRAINT_NAME,\r\n    c.CONSTRAINT_TYPE,\r\n    c.STATUS,\r\n    c.R_OWNER,\r\n    c.R_CONSTRAINT_NAME,\r\n    (SELECT rc.TABLE_NAME FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), OracleSchema.this.getDataSource(), "CONSTRAINTS") + " rc WHERE rc.OWNER = c.r_OWNER AND rc.CONSTRAINT_NAME = c.R_CONSTRAINT_NAME) AS R_TABLE_NAME,\r\n" + "    c.DELETE_RULE,\r\n" + "    (\r\n" + "        SELECT LTRIM(MAX(SYS_CONNECT_BY_PATH(cname || ':' || p,','))    KEEP (DENSE_RANK LAST ORDER BY curr),',') \r\n" + "        FROM   (SELECT \r\n" + "                       col.CONSTRAINT_NAME cn,col.POSITION p,col.COLUMN_NAME cname,\r\n" + "                       ROW_NUMBER() OVER (PARTITION BY col.CONSTRAINT_NAME ORDER BY col.POSITION) AS curr,\r\n" + "                       ROW_NUMBER() OVER (PARTITION BY col.CONSTRAINT_NAME ORDER BY col.POSITION) -1 AS prev\r\n" + "                FROM   " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), OracleSchema.this.getDataSource(), "CONS_COLUMNS") + " col \r\n" + "                WHERE  col.OWNER =? AND col.TABLE_NAME = ? \r\n" + "                )  WHERE cn = c.CONSTRAINT_NAME GROUP BY cn CONNECT BY prev = PRIOR curr AND cn = PRIOR cn START WITH curr = 1      \r\n" + "        ) COLUMN_NAMES_NUMS\r\n" + "FROM\r\n" + "    " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), OracleSchema.this.getDataSource(), "CONSTRAINTS") + " c\r\n" + "WHERE\r\n" + "    c.CONSTRAINT_TYPE = 'R'\r\n" + "    AND c.OWNER = ?\r\n" + "    AND c.TABLE_NAME = ?");
                dbStat = session.prepareStatement(sql.toString());
                dbStat.setString(1, OracleSchema.this.getName());
                dbStat.setString(2, forTable.getName());
                dbStat.setString(3, OracleSchema.this.getName());
                dbStat.setString(4, forTable.getName());
            } else {
                sql.append("SELECT " + OracleUtils.getSysCatalogHint(owner.getDataSource()) + " \r\n" + "c.TABLE_NAME, c.CONSTRAINT_NAME,c.CONSTRAINT_TYPE,c.STATUS,c.R_OWNER,c.R_CONSTRAINT_NAME,rc.TABLE_NAME as R_TABLE_NAME,c.DELETE_RULE, \n" + "col.COLUMN_NAME,col.POSITION\r\n" + "FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), OracleSchema.this.getDataSource(), "CONSTRAINTS") + " c, " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), OracleSchema.this.getDataSource(), "CONS_COLUMNS") + " col, " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), OracleSchema.this.getDataSource(), "CONSTRAINTS") + " rc\n" + "WHERE c.CONSTRAINT_TYPE='R' AND c.OWNER=?\n" + "AND c.OWNER=col.OWNER AND c.CONSTRAINT_NAME=col.CONSTRAINT_NAME\n" + "AND rc.OWNER=c.r_OWNER AND rc.CONSTRAINT_NAME=c.R_CONSTRAINT_NAME");
                if (forTable != null) {
                    sql.append(" AND c.TABLE_NAME=?");
                }
                sql.append("\nORDER BY c.CONSTRAINT_NAME,col.POSITION");
                dbStat = session.prepareStatement(sql.toString());
                dbStat.setString(1, OracleSchema.this.getName());
                if (forTable != null) {
                    dbStat.setString(2, forTable.getName());
                }
            }
            return dbStat;
        }

        @Nullable
        protected OracleTableForeignKey fetchObject(JDBCSession session, OracleSchema owner, OracleTable parent, String indexName, JDBCResultSet dbResult) throws SQLException, DBException {
            return new OracleTableForeignKey(session.getProgressMonitor(), parent, (ResultSet)dbResult);
        }

        @Nullable
        protected OracleTableForeignKeyColumn[] fetchObjectRow(JDBCSession session, OracleTable parent, OracleTableForeignKey object, JDBCResultSet dbResult) throws SQLException, DBException {
            if (JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAMES_NUMS") != null) {
                List positions = OracleSchema.this.parsePositions(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAMES_NUMS"));
                OracleTableForeignKeyColumn[] result = new OracleTableForeignKeyColumn[positions.size()];
                int idx = 0;
                while (idx < positions.size()) {
                    OracleTableColumn column = OracleSchema.getTableColumn(session, parent, (ResultSet)dbResult, ((SpecialPosition)positions.get(idx)).getColumn());
                    if (column != null) {
                        result[idx] = new OracleTableForeignKeyColumn(object, column, ((SpecialPosition)positions.get(idx)).getPos());
                    }
                    ++idx;
                }
                return result;
            }
            OracleTableColumn column = OracleSchema.getTableColumn(session, parent, (ResultSet)dbResult, JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"COLUMN_NAME"));
            if (column == null) {
                return null;
            }
            return new OracleTableForeignKeyColumn[]{new OracleTableForeignKeyColumn(object, column, JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"POSITION"))};
        }

        protected void cacheChildren(DBRProgressMonitor monitor, OracleTableForeignKey foreignKey, List<OracleTableForeignKeyColumn> rows) {
            foreignKey.setColumns(rows);
        }
    }

    class IndexCache
    extends JDBCCompositeCache<OracleSchema, OracleTablePhysical, OracleTableIndex, OracleTableIndexColumn> {
        IndexCache() {
            super((JDBCStructCache)OracleSchema.this.tableCache, OracleTablePhysical.class, (Object)"TABLE_NAME", (Object)"INDEX_NAME");
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(JDBCSession session, OracleSchema owner, OracleTablePhysical forTable) throws SQLException {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT ").append(OracleUtils.getSysCatalogHint(owner.getDataSource())).append(" i.OWNER,i.INDEX_NAME,i.INDEX_TYPE,i.TABLE_OWNER,i.TABLE_NAME,i.UNIQUENESS,i.TABLESPACE_NAME,i.STATUS,i.NUM_ROWS,i.SAMPLE_SIZE,\nic.COLUMN_NAME,ic.COLUMN_POSITION,ic.COLUMN_LENGTH,ic.DESCEND,iex.COLUMN_EXPRESSION\nFROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), OracleSchema.this.getDataSource(), "INDEXES") + " i\n" + "JOIN " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), OracleSchema.this.getDataSource(), "IND_COLUMNS") + " ic ON ic.INDEX_OWNER=i.OWNER AND ic.INDEX_NAME=i.INDEX_NAME \n" + "LEFT OUTER JOIN " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), OracleSchema.this.getDataSource(), "IND_EXPRESSIONS") + " iex ON iex.INDEX_OWNER=i.OWNER AND iex.INDEX_NAME=i.INDEX_NAME AND iex.COLUMN_POSITION=ic.COLUMN_POSITION\n" + "WHERE ");
            if (forTable == null) {
                sql.append("i.OWNER=?");
            } else {
                sql.append("i.TABLE_OWNER=? AND i.TABLE_NAME=?");
            }
            sql.append("\nORDER BY i.INDEX_NAME,ic.COLUMN_POSITION");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            if (forTable == null) {
                dbStat.setString(1, OracleSchema.this.getName());
            } else {
                dbStat.setString(1, OracleSchema.this.getName());
                dbStat.setString(2, forTable.getName());
            }
            return dbStat;
        }

        @Nullable
        protected OracleTableIndex fetchObject(JDBCSession session, OracleSchema owner, OracleTablePhysical parent, String indexName, JDBCResultSet dbResult) throws SQLException, DBException {
            return new OracleTableIndex(owner, parent, indexName, (ResultSet)dbResult);
        }

        @Nullable
        protected OracleTableIndexColumn[] fetchObjectRow(JDBCSession session, OracleTablePhysical parent, OracleTableIndex object, JDBCResultSet dbResult) throws SQLException, DBException {
            OracleTableColumn tableColumn;
            String columnName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"COLUMN_NAME");
            int ordinalPosition = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"COLUMN_POSITION");
            boolean isAscending = "ASC".equals(JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"DESCEND"));
            String columnExpression = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"COLUMN_EXPRESSION");
            OracleTableColumn oracleTableColumn = tableColumn = columnName == null ? null : parent.getAttribute(session.getProgressMonitor(), columnName);
            if (tableColumn == null) {
                log.debug((Object)("Column '" + columnName + "' not found in table '" + parent.getName() + "' for index '" + object.getName() + "'"));
                return null;
            }
            return new OracleTableIndexColumn[]{new OracleTableIndexColumn(object, tableColumn, ordinalPosition, isAscending, columnExpression)};
        }

        protected void cacheChildren(DBRProgressMonitor monitor, OracleTableIndex index, List<OracleTableIndexColumn> rows) {
            index.setColumns(rows);
        }
    }

    static class JavaCache
    extends JDBCObjectCache<OracleSchema, OracleJavaClass> {
        JavaCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleSchema owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner.getDataSource(), "JAVA_CLASSES") + " WHERE OWNER=? ");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected OracleJavaClass fetchObject(@NotNull JDBCSession session, @NotNull OracleSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new OracleJavaClass(owner, (ResultSet)dbResult);
        }
    }

    static class MViewCache
    extends JDBCObjectLookupCache<OracleSchema, OracleMaterializedView> {
        MViewCache() {
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, OracleSchema owner, OracleMaterializedView object, String objectName) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner.getDataSource(), "MVIEWS") + " WHERE OWNER=? " + (object == null && objectName == null ? "" : "AND MVIEW_NAME=? ") + "ORDER BY MVIEW_NAME");
            dbStat.setString(1, owner.getName());
            if (object != null || objectName != null) {
                dbStat.setString(2, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }

        protected OracleMaterializedView fetchObject(@NotNull JDBCSession session, @NotNull OracleSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new OracleMaterializedView(owner, (ResultSet)dbResult);
        }
    }

    static class PackageCache
    extends JDBCObjectCache<OracleSchema, OraclePackage> {
        PackageCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleSchema owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT " + OracleUtils.getSysCatalogHint(owner.getDataSource()) + " * FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner.getDataSource(), "OBJECTS") + " WHERE OBJECT_TYPE='PACKAGE' AND OWNER=? " + " ORDER BY OBJECT_NAME");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected OraclePackage fetchObject(@NotNull JDBCSession session, @NotNull OracleSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new OraclePackage(owner, (ResultSet)dbResult);
        }
    }

    static class ProceduresCache
    extends JDBCObjectLookupCache<OracleSchema, OracleProcedureStandalone> {
        ProceduresCache() {
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull OracleSchema owner, @Nullable OracleProcedureStandalone object, @Nullable String objectName) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT " + OracleUtils.getSysCatalogHint(owner.getDataSource()) + " * FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner.getDataSource(), "OBJECTS") + " " + "WHERE OBJECT_TYPE IN ('PROCEDURE','FUNCTION') " + "AND OWNER=? " + (object == null && objectName == null ? "" : "AND OBJECT_NAME=? ") + "ORDER BY OBJECT_NAME");
            dbStat.setString(1, owner.getName());
            if (object != null || objectName != null) {
                dbStat.setString(2, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }

        protected OracleProcedureStandalone fetchObject(@NotNull JDBCSession session, @NotNull OracleSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new OracleProcedureStandalone(owner, (ResultSet)dbResult);
        }
    }

    static class QueueCache
    extends JDBCObjectCache<OracleSchema, OracleQueue> {
        QueueCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleSchema owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT " + OracleUtils.getSysCatalogHint(owner.getDataSource()) + " * " + "FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner.getDataSource(), "QUEUES") + " WHERE OWNER=? ORDER BY NAME");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected OracleQueue fetchObject(@NotNull JDBCSession session, @NotNull OracleSchema owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleQueue(owner, (ResultSet)resultSet);
        }
    }

    static class RecycleBin
    extends JDBCObjectCache<OracleSchema, OracleRecycledObject> {
        RecycleBin() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleSchema owner) throws SQLException {
            boolean isPublic = owner.isPublic();
            JDBCPreparedStatement dbStat = session.prepareStatement(isPublic ? "SELECT * FROM " + OracleUtils.getSysSchemaPrefix(owner.getDataSource()) + "USER_RECYCLEBIN" : "SELECT * FROM " + OracleUtils.getSysSchemaPrefix(owner.getDataSource()) + "DBA_RECYCLEBIN WHERE OWNER=?");
            if (!isPublic) {
                dbStat.setString(1, owner.getName());
            }
            return dbStat;
        }

        protected OracleRecycledObject fetchObject(@NotNull JDBCSession session, @NotNull OracleSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new OracleRecycledObject(owner, (ResultSet)dbResult);
        }
    }

    static class SchedulerJobCache
    extends JDBCObjectCache<OracleSchema, OracleSchedulerJob> {
        SchedulerJobCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleSchema owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner.getDataSource(), "SCHEDULER_JOBS") + " WHERE OWNER=? ORDER BY JOB_NAME");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected OracleSchedulerJob fetchObject(@NotNull JDBCSession session, @NotNull OracleSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new OracleSchedulerJob(owner, (ResultSet)dbResult);
        }
    }

    static class SchedulerProgramCache
    extends JDBCObjectCache<OracleSchema, OracleSchedulerProgram> {
        SchedulerProgramCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleSchema owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner.getDataSource(), "SCHEDULER_PROGRAMS") + " WHERE OWNER=? ORDER BY PROGRAM_NAME");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected OracleSchedulerProgram fetchObject(@NotNull JDBCSession session, @NotNull OracleSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new OracleSchedulerProgram(owner, (ResultSet)dbResult);
        }
    }

    static class SequenceCache
    extends JDBCObjectCache<OracleSchema, OracleSequence> {
        SequenceCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleSchema owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT " + OracleUtils.getSysCatalogHint(owner.getDataSource()) + " * FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner.getDataSource(), "SEQUENCES") + " WHERE SEQUENCE_OWNER=? ORDER BY SEQUENCE_NAME");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected OracleSequence fetchObject(@NotNull JDBCSession session, @NotNull OracleSchema owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleSequence(owner, (ResultSet)resultSet);
        }
    }

    class SpecialPosition {
        private final String column;
        private final int pos;

        public SpecialPosition(String value) {
            String[] data = value.split(":");
            this.column = data[0];
            this.pos = data.length == 1 ? 0 : Integer.valueOf(data[1]);
        }

        public SpecialPosition(String column, int pos) {
            this.column = column;
            this.pos = pos;
        }

        public String getColumn() {
            return this.column;
        }

        public int getPos() {
            return this.pos;
        }
    }

    static class SynonymCache
    extends JDBCObjectLookupCache<OracleSchema, OracleSynonym> {
        SynonymCache() {
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull OracleSchema owner, OracleSynonym object, String objectName) throws SQLException {
            String synonymTypeFilter = session.getDataSource().getContainer().getPreferenceStore().getBoolean("oracle.read.all.synonyms") ? "" : "AND O.OBJECT_TYPE NOT IN ('JAVA CLASS','PACKAGE BODY')\n";
            String synonymName = object != null ? object.getName() : objectName;
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT OWNER, SYNONYM_NAME, MAX(TABLE_OWNER) as TABLE_OWNER, MAX(TABLE_NAME) as TABLE_NAME, MAX(DB_LINK) as DB_LINK, MAX(OBJECT_TYPE) as OBJECT_TYPE FROM (\n").append("SELECT S.*, NULL OBJECT_TYPE FROM ").append(OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner.getDataSource(), "SYNONYMS")).append(" S WHERE S.OWNER = ?");
            if (synonymName != null) {
                sql.append(" AND S.SYNONYM_NAME = ?");
            }
            sql.append("\nUNION ALL\n").append("SELECT S.*,O.OBJECT_TYPE FROM ").append(OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner.getDataSource(), "SYNONYMS")).append(" S, ").append(OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner.getDataSource(), "OBJECTS")).append(" O\n").append("WHERE S.OWNER = ?\n");
            if (synonymName != null) {
                sql.append(" AND S.SYNONYM_NAME = ? ");
            }
            sql.append(synonymTypeFilter).append("AND O.OWNER=S.TABLE_OWNER AND O.OBJECT_NAME=S.TABLE_NAME\n)\n");
            sql.append("GROUP BY OWNER, SYNONYM_NAME");
            if (synonymName == null) {
                sql.append("\nORDER BY SYNONYM_NAME");
            }
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            int paramNum = 1;
            dbStat.setString(paramNum++, owner.getName());
            if (synonymName != null) {
                dbStat.setString(paramNum++, synonymName);
            }
            dbStat.setString(paramNum++, owner.getName());
            if (synonymName != null) {
                dbStat.setString(paramNum++, synonymName);
            }
            return dbStat;
        }

        protected OracleSynonym fetchObject(@NotNull JDBCSession session, @NotNull OracleSchema owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleSynonym(owner, (ResultSet)resultSet);
        }
    }

    public static class TableCache
    extends JDBCStructLookupCache<OracleSchema, OracleTableBase, OracleTableColumn> {
        TableCache() {
            super((Object)"TABLE_NAME");
            this.setListOrderComparator(DBUtils.nameComparator());
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull OracleSchema owner, @Nullable OracleTableBase object, @Nullable String objectName) throws SQLException {
            String tableOper = "=";
            boolean hasAllAllTables = owner.getDataSource().isViewAvailable(session.getProgressMonitor(), null, "ALL_ALL_TABLES");
            String tablesSource = hasAllAllTables ? "ALL_TABLES" : "TABLES";
            JDBCPreparedStatement dbStat = session.prepareStatement("\tSELECT " + OracleUtils.getSysCatalogHint(owner.getDataSource()) + " t.OWNER,t.TABLE_NAME as TABLE_NAME,'TABLE' as OBJECT_TYPE,'VALID' as STATUS,t.TABLE_TYPE_OWNER,t.TABLE_TYPE,t.TABLESPACE_NAME,t.PARTITIONED,t.IOT_TYPE,t.IOT_NAME,t.TEMPORARY,t.SECONDARY,t.NESTED,t.NUM_ROWS \n" + "\tFROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner.getDataSource(), tablesSource) + " t\n" + "\tWHERE t.OWNER=? AND NESTED='NO'" + (object == null && objectName == null ? "" : " AND t.TABLE_NAME" + tableOper + "?") + "\n" + "UNION ALL\n" + "\tSELECT " + OracleUtils.getSysCatalogHint(owner.getDataSource()) + " o.OWNER,o.OBJECT_NAME as TABLE_NAME,'VIEW' as OBJECT_TYPE,o.STATUS,NULL,NULL,NULL,'NO',NULL,NULL,o.TEMPORARY,o.SECONDARY,'NO',0 \n" + "\tFROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner.getDataSource(), "OBJECTS") + " o \n" + "\tWHERE o.OWNER=? AND o.OBJECT_TYPE='VIEW'" + (object == null && objectName == null ? "" : " AND o.OBJECT_NAME" + tableOper + "?") + "\n");
            int index = 1;
            dbStat.setString(index++, owner.getName());
            if (object != null || objectName != null) {
                dbStat.setString(index++, object != null ? object.getName() : objectName);
            }
            dbStat.setString(index++, owner.getName());
            if (object != null || objectName != null) {
                dbStat.setString(index, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }

        protected OracleTableBase fetchObject(@NotNull JDBCSession session, @NotNull OracleSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            String tableType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_TYPE");
            if ("TABLE".equals(tableType)) {
                return new OracleTable(session.getProgressMonitor(), owner, (ResultSet)dbResult);
            }
            return new OracleView(owner, (ResultSet)dbResult);
        }

        protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull OracleSchema owner, @Nullable OracleTableBase forTable) throws SQLException {
            String colsView = "ALL_TAB_COLS";
            if (!owner.getDataSource().isViewAvailable(session.getProgressMonitor(), "SYS", colsView)) {
                colsView = "ALL_TAB_COLUMNS";
            }
            StringBuilder sql = new StringBuilder(500);
            sql.append("SELECT ").append(OracleUtils.getSysCatalogHint(owner.getDataSource())).append("\nc.* FROM ").append(OracleUtils.getSysSchemaPrefix(owner.getDataSource())).append(colsView).append(" c\nWHERE c.OWNER=?");
            if (forTable != null) {
                sql.append(" AND c.TABLE_NAME=?");
            }
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            dbStat.setString(1, owner.getName());
            if (forTable != null) {
                dbStat.setString(2, forTable.getName());
            }
            return dbStat;
        }

        protected OracleTableColumn fetchChild(@NotNull JDBCSession session, @NotNull OracleSchema owner, @NotNull OracleTableBase table, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new OracleTableColumn(session.getProgressMonitor(), table, (ResultSet)dbResult);
        }

        protected void cacheChildren(OracleTableBase parent, List<OracleTableColumn> oracleTableColumns) {
            oracleTableColumns.sort(DBUtils.orderComparator());
            super.cacheChildren((DBSObject)parent, oracleTableColumns);
        }
    }

    static class TriggerCache
    extends JDBCObjectCache<OracleSchema, OracleSchemaTrigger> {
        TriggerCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleSchema schema) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT *\nFROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), schema.getDataSource(), "TRIGGERS") + " WHERE OWNER=? AND TRIM(BASE_OBJECT_TYPE) IN ('DATABASE','SCHEMA')\n" + "ORDER BY TRIGGER_NAME");
            dbStat.setString(1, schema.getName());
            return dbStat;
        }

        protected OracleSchemaTrigger fetchObject(@NotNull JDBCSession session, @NotNull OracleSchema oracleSchema, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleSchemaTrigger(oracleSchema, (ResultSet)resultSet);
        }
    }
}

