/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.data;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.BytesContentStorage;
import org.jkiss.dbeaver.model.impl.TemporaryContentStorage;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentLOB;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.BeanUtils;

public class OracleContentBFILE
extends JDBCContentLOB {
    private static final Log log = Log.getLog(OracleContentBFILE.class);
    private Object bfile;
    private String name;
    private boolean opened;

    public OracleContentBFILE(DBPDataSource dataSource, Object bfile) {
        super(dataSource);
        this.bfile = bfile;
        if (this.bfile != null) {
            try {
                this.name = (String)BeanUtils.invokeObjectMethod((Object)bfile, (String)"getName");
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    public long getLOBLength() throws DBCException {
        if (this.bfile != null) {
            boolean openLocally = !this.opened;
            try {
                Object length;
                if (openLocally) {
                    this.openFile();
                }
                if ((length = BeanUtils.invokeObjectMethod((Object)this.bfile, (String)"length")) instanceof Number) {
                    long l = ((Number)length).longValue();
                    return l;
                }
            }
            catch (Throwable e) {
                throw new DBCException("Error when reading BFILE length", e, this.dataSource);
            }
            finally {
                if (openLocally) {
                    this.closeFile();
                }
            }
        }
        return 0L;
    }

    private void openFile() throws DBCException {
        if (this.opened) {
            return;
        }
        try {
            BeanUtils.invokeObjectMethod((Object)this.bfile, (String)"openFile");
            this.opened = true;
        }
        catch (Throwable e) {
            throw new DBCException(e, this.dataSource);
        }
    }

    private void closeFile() throws DBCException {
        if (!this.opened) {
            return;
        }
        try {
            BeanUtils.invokeObjectMethod((Object)this.bfile, (String)"closeFile");
            this.opened = false;
        }
        catch (Throwable e) {
            throw new DBCException(e, this.dataSource);
        }
    }

    private InputStream getInputStream() throws DBCException {
        try {
            return (InputStream)BeanUtils.invokeObjectMethod((Object)this.bfile, (String)"getBinaryStream");
        }
        catch (Throwable e) {
            throw new DBCException("Error when reading BFILE length", e, this.dataSource);
        }
    }

    @NotNull
    public String getContentType() {
        return "application/octet-stream";
    }

    public DBDContentStorage getContents(DBRProgressMonitor monitor) throws DBCException {
        if (this.storage == null && this.bfile != null) {
            try {
                block39: {
                    File tempFile;
                    this.openFile();
                    long contentLength = this.getContentLength();
                    DBPPlatform platform = this.dataSource.getContainer().getPlatform();
                    if (contentLength < (long)platform.getPreferenceStore().getInt("content.memory.maxsize")) {
                        try {
                            Throwable throwable = null;
                            Object var6_8 = null;
                            try (InputStream bs = this.getInputStream();){
                                this.storage = BytesContentStorage.createFromStream((InputStream)bs, (long)contentLength, (String)this.getDefaultEncoding());
                                break block39;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            throw new DBCException("IO error while reading content", (Throwable)e);
                        }
                    }
                    try {
                        tempFile = ContentUtils.createTempContentFile((DBRProgressMonitor)monitor, (DBPPlatform)platform, (String)("blob" + this.bfile.hashCode()));
                    }
                    catch (IOException e) {
                        throw new DBCException("Can't create temporary file", (Throwable)e);
                    }
                    try {
                        Throwable e = null;
                        Object var7_16 = null;
                        try (FileOutputStream os = new FileOutputStream(tempFile);){
                            Throwable throwable = null;
                            Object var10_21 = null;
                            try (InputStream bs = this.getInputStream();){
                                ContentUtils.copyStreams((InputStream)bs, (long)contentLength, (OutputStream)os, (DBRProgressMonitor)monitor);
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (Throwable throwable) {
                            if (e == null) {
                                e = throwable;
                            } else if (e != throwable) {
                                e.addSuppressed(throwable);
                            }
                            throw e;
                        }
                    }
                    catch (IOException e) {
                        ContentUtils.deleteTempFile((File)tempFile);
                        throw new DBCException("IO error while copying stream", (Throwable)e);
                    }
                    catch (Throwable e) {
                        ContentUtils.deleteTempFile((File)tempFile);
                        throw new DBCException(e, this.dataSource);
                    }
                    this.storage = new TemporaryContentStorage(platform, tempFile, this.getDefaultEncoding());
                }
                this.releaseBlob();
            }
            finally {
                this.closeFile();
            }
        }
        return this.storage;
    }

    public void release() {
        this.releaseBlob();
        super.release();
    }

    private void releaseBlob() {
        if (this.bfile != null) {
            this.bfile = null;
        }
    }

    public void bindParameter(JDBCSession session, JDBCPreparedStatement preparedStatement, DBSTypedObject columnType, int paramIndex) throws DBCException {
        throw new DBCException("BFILE update not supported");
    }

    public Object getRawValue() {
        return this.bfile;
    }

    public boolean isNull() {
        return this.bfile == null && this.storage == null;
    }

    protected JDBCContentLOB createNewContent() {
        return new OracleContentBFILE(this.dataSource, null);
    }

    public String getDisplayString(DBDDisplayFormat format) {
        return this.bfile == null && this.storage == null ? null : "[BFILE:" + this.name + "]";
    }
}

