/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLGrant;
import org.jkiss.dbeaver.ext.mysql.model.MySQLPrivilege;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLUser;
import org.jkiss.dbeaver.ext.mysql.ui.config.MySQLCommandGrantPrivilege;
import org.jkiss.dbeaver.ext.mysql.ui.controls.PrivilegeTableControl;
import org.jkiss.dbeaver.ext.mysql.ui.editors.MySQLUserEditorAbstract;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.utils.ArrayUtils;

public class MySQLUserEditorPrivileges
extends MySQLUserEditorAbstract {
    private static final Log log = Log.getLog(MySQLUserEditorPrivileges.class);
    private PageControl pageControl;
    private Table catalogsTable;
    private Table tablesTable;
    private boolean isLoaded = false;
    private MySQLCatalog selectedCatalog;
    private MySQLTableBase selectedTable;
    private PrivilegeTableControl tablePrivilegesTable;
    private PrivilegeTableControl otherPrivilegesTable;
    private volatile List<MySQLGrant> grants;
    private Font boldFont;

    public void createPartControl(Composite parent) {
        this.boldFont = UIUtils.makeBoldFont((Font)parent.getFont());
        this.pageControl = new PageControl(parent);
        Composite container = UIUtils.createPlaceholder((Composite)this.pageControl, (int)2, (int)5);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        Composite leftPane = UIUtils.createPlaceholder((Composite)container, (int)2);
        leftPane.setLayoutData((Object)new GridData(1808));
        leftPane.setLayout((Layout)new GridLayout(2, true));
        Group catalogGroup = UIUtils.createControlGroup((Composite)leftPane, (String)MySQLUIMessages.editors_user_editor_privileges_group_catalogs, (int)1, (int)1808, (int)0);
        this.catalogsTable = new Table((Composite)catalogGroup, 2820);
        this.catalogsTable.setHeaderVisible(true);
        gd = new GridData(1808);
        this.catalogsTable.setLayoutData((Object)gd);
        this.catalogsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = MySQLUserEditorPrivileges.this.catalogsTable.getSelectionIndex();
                if (selIndex <= 0) {
                    MySQLUserEditorPrivileges.this.selectedCatalog = null;
                } else {
                    MySQLUserEditorPrivileges.this.selectedCatalog = (MySQLCatalog)MySQLUserEditorPrivileges.this.catalogsTable.getItem(selIndex).getData();
                }
                MySQLUserEditorPrivileges.this.showCatalogTables();
                MySQLUserEditorPrivileges.this.showGrants();
            }
        });
        UIUtils.createTableColumn((Table)this.catalogsTable, (int)16384, (String)MySQLUIMessages.editors_user_editor_privileges_column_catalog);
        TableItem item = new TableItem(this.catalogsTable, 0);
        item.setText("% (All)");
        item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_DATABASE));
        for (MySQLCatalog catalog : ((MySQLUser)this.getDatabaseObject()).getDataSource().getCatalogs()) {
            TableItem item2 = new TableItem(this.catalogsTable, 0);
            item2.setText(catalog.getName());
            item2.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_DATABASE));
            item2.setData((Object)catalog);
        }
        UIUtils.packColumns((Table)this.catalogsTable);
        Group tablesGroup = UIUtils.createControlGroup((Composite)leftPane, (String)MySQLUIMessages.editors_user_editor_privileges_group_tables, (int)1, (int)1808, (int)0);
        this.tablesTable = new Table((Composite)tablesGroup, 2820);
        this.tablesTable.setHeaderVisible(true);
        gd = new GridData(1808);
        this.tablesTable.setLayoutData((Object)gd);
        this.tablesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = MySQLUserEditorPrivileges.this.tablesTable.getSelectionIndex();
                if (selIndex <= 0) {
                    MySQLUserEditorPrivileges.this.selectedTable = null;
                } else {
                    MySQLUserEditorPrivileges.this.selectedTable = (MySQLTableBase)MySQLUserEditorPrivileges.this.tablesTable.getItem(selIndex).getData();
                }
                MySQLUserEditorPrivileges.this.showGrants();
            }
        });
        UIUtils.createTableColumn((Table)this.tablesTable, (int)16384, (String)MySQLUIMessages.editors_user_editor_privileges_column_table);
        UIUtils.packColumns((Table)this.tablesTable);
        Composite ph = UIUtils.createPlaceholder((Composite)container, (int)1);
        ph.setLayoutData((Object)new GridData(1808));
        this.tablePrivilegesTable = new PrivilegeTableControl(ph, MySQLUIMessages.editors_user_editor_privileges_control_table_privileges, false);
        gd = new GridData(1808);
        this.tablePrivilegesTable.setLayoutData(gd);
        this.otherPrivilegesTable = new PrivilegeTableControl(ph, MySQLUIMessages.editors_user_editor_privileges_control_other_privileges, false);
        gd = new GridData(1808);
        this.otherPrivilegesTable.setLayoutData(gd);
        this.catalogsTable.setSelection(0);
        this.showCatalogTables();
        this.pageControl.createProgressPanel();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UIUtils.dispose((Resource)MySQLUserEditorPrivileges.this.boldFont);
            }
        });
        this.addGrantListener(this.tablePrivilegesTable);
        this.addGrantListener(this.otherPrivilegesTable);
    }

    private void addGrantListener(final PrivilegeTableControl privTable) {
        privTable.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                final MySQLPrivilege privilege = (MySQLPrivilege)event.data;
                final boolean isGrant = event.detail == 1;
                final MySQLCatalog curCatalog = MySQLUserEditorPrivileges.this.selectedCatalog;
                final MySQLTableBase curTable = MySQLUserEditorPrivileges.this.selectedTable;
                MySQLUserEditorPrivileges.this.updateLocalData(privilege, isGrant, curCatalog, curTable);
                MySQLUserEditorPrivileges.this.addChangeCommand((DBECommand)new MySQLCommandGrantPrivilege((MySQLUser)MySQLUserEditorPrivileges.this.getDatabaseObject(), isGrant, curCatalog, curTable, privilege), (DBECommandReflector)new DBECommandReflector<MySQLUser, MySQLCommandGrantPrivilege>(){

                    public void redoCommand(MySQLCommandGrantPrivilege mySQLCommandGrantPrivilege) {
                        if (!privTable.isDisposed() && curCatalog == MySQLUserEditorPrivileges.this.selectedCatalog && curTable == MySQLUserEditorPrivileges.this.selectedTable) {
                            privTable.checkPrivilege(privilege, isGrant);
                        }
                        MySQLUserEditorPrivileges.this.updateLocalData(privilege, isGrant, curCatalog, curTable);
                    }

                    public void undoCommand(MySQLCommandGrantPrivilege mySQLCommandGrantPrivilege) {
                        if (!privTable.isDisposed() && curCatalog == MySQLUserEditorPrivileges.this.selectedCatalog && curTable == MySQLUserEditorPrivileges.this.selectedTable) {
                            privTable.checkPrivilege(privilege, !isGrant);
                        }
                        MySQLUserEditorPrivileges.this.updateLocalData(privilege, !isGrant, curCatalog, curTable);
                    }
                });
            }
        });
    }

    private void updateLocalData(MySQLPrivilege privilege, boolean isGrant, MySQLCatalog curCatalog, MySQLTableBase curTable) {
        ((MySQLUser)this.getDatabaseObject()).clearGrantsCache();
        boolean found = false;
        for (MySQLGrant grant : this.grants) {
            if (!grant.matches(curCatalog) || !grant.matches(curTable)) continue;
            if (privilege.isGrantOption()) {
                grant.setGrantOption(isGrant);
            } else if (isGrant) {
                if (!ArrayUtils.contains((Object[])grant.getPrivileges(), (Object)privilege)) {
                    grant.addPrivilege(privilege);
                }
            } else {
                grant.removePrivilege(privilege);
            }
            found = true;
            break;
        }
        if (!found) {
            ArrayList<MySQLPrivilege> privileges = new ArrayList<MySQLPrivilege>();
            if (!privilege.isGrantOption()) {
                privileges.add(privilege);
            }
            MySQLGrant grant = new MySQLGrant((MySQLUser)this.getDatabaseObject(), privileges, curCatalog == null ? "*" : curCatalog.getName(), curTable == null ? "*" : curTable.getName(), false, privilege.isGrantOption());
            this.grants.add(grant);
        }
        this.highlightCatalogs();
        this.highlightTables();
    }

    private void showCatalogTables() {
        LoadingJob.createService((ILoadService)new DatabaseLoadService<Collection<MySQLTableBase>>(MySQLUIMessages.editors_user_editor_privileges_service_load_tables, this.getExecutionContext()){

            public Collection<MySQLTableBase> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (MySQLUserEditorPrivileges.this.selectedCatalog == null) {
                    return Collections.emptyList();
                }
                try {
                    return MySQLUserEditorPrivileges.this.selectedCatalog.getTableCache().getAllObjects(monitor, (DBSObject)MySQLUserEditorPrivileges.this.selectedCatalog);
                }
                catch (DBException e) {
                    log.error((Object)e);
                    return null;
                }
            }
        }, this.pageControl.createTablesLoadVisualizer()).schedule();
    }

    private void showGrants() {
        if (this.grants == null) {
            return;
        }
        ArrayList<MySQLGrant> curGrants = new ArrayList<MySQLGrant>();
        for (MySQLGrant grant : this.grants) {
            if (!grant.matches(this.selectedCatalog) || !grant.matches(this.selectedTable)) continue;
            curGrants.add(grant);
        }
        this.tablePrivilegesTable.fillGrants(curGrants);
        this.otherPrivilegesTable.fillGrants(curGrants);
    }

    public synchronized void activatePart() {
        if (this.isLoaded) {
            return;
        }
        this.isLoaded = true;
        LoadingJob.createService((ILoadService)new DatabaseLoadService<List<MySQLPrivilege>>(MySQLUIMessages.editors_user_editor_privileges_service_load_privileges, this.getExecutionContext()){

            public List<MySQLPrivilege> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    return ((MySQLUser)MySQLUserEditorPrivileges.this.getDatabaseObject()).getDataSource().getPrivileges(monitor);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, this.pageControl.createPrivilegesLoadVisualizer()).schedule();
    }

    @Override
    protected PageControl getPageControl() {
        return this.pageControl;
    }

    @Override
    protected void processGrants(List<MySQLGrant> grantsTmp) {
        this.grants = new ArrayList<MySQLGrant>(grantsTmp);
        Iterator<MySQLGrant> i = this.grants.iterator();
        while (i.hasNext()) {
            MySQLGrant grant = i.next();
            if (grant.isAllPrivileges() || grant.hasNonAdminPrivileges()) continue;
            i.remove();
        }
        this.highlightCatalogs();
        this.showGrants();
        this.showCatalogTables();
    }

    private void highlightCatalogs() {
        if (this.catalogsTable != null && !this.catalogsTable.isDisposed()) {
            TableItem[] tableItemArray = this.catalogsTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                MySQLCatalog catalog = (MySQLCatalog)item.getData();
                item.setFont(null);
                if (this.grants != null) {
                    for (MySQLGrant grant : this.grants) {
                        if (!grant.matches(catalog) || grant.isEmpty()) continue;
                        item.setFont(this.boldFont);
                        break;
                    }
                }
                ++n2;
            }
        }
    }

    private void highlightTables() {
        if (this.tablesTable != null && !this.tablesTable.isDisposed()) {
            TableItem[] tableItemArray = this.tablesTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                MySQLTableBase table = (MySQLTableBase)item.getData();
                item.setFont(null);
                if (this.grants != null) {
                    for (MySQLGrant grant : this.grants) {
                        if (!grant.matches(this.selectedCatalog) || !grant.matches(table) || grant.isEmpty()) continue;
                        item.setFont(this.boldFont);
                        break;
                    }
                }
                ++n2;
            }
        }
    }

    public void refreshPart(Object source, boolean force) {
    }

    private class PageControl
    extends MySQLUserEditorAbstract.UserPageControl {
        public PageControl(Composite parent) {
            super(MySQLUserEditorPrivileges.this, parent);
        }

        public ProgressPageControl.ProgressVisualizer<Collection<MySQLTableBase>> createTablesLoadVisualizer() {
            return new ProgressPageControl.ProgressVisualizer<Collection<MySQLTableBase>>((ProgressPageControl)this){

                public void completeLoading(Collection<MySQLTableBase> tables) {
                    super.completeLoading(tables);
                    if (MySQLUserEditorPrivileges.this.tablesTable.isDisposed()) {
                        return;
                    }
                    MySQLUserEditorPrivileges.this.tablesTable.removeAll();
                    TableItem item = new TableItem(MySQLUserEditorPrivileges.this.tablesTable, 0);
                    item.setText("% (All)");
                    item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_TABLE));
                    if (tables != null) {
                        for (MySQLTableBase table : tables) {
                            TableItem item2 = new TableItem(MySQLUserEditorPrivileges.this.tablesTable, 0);
                            item2.setText(table.getName());
                            item2.setImage(DBeaverIcons.getImage((DBPImage)(table.isView() ? DBIcon.TREE_VIEW : DBIcon.TREE_TABLE)));
                            item2.setData((Object)table);
                        }
                        MySQLUserEditorPrivileges.this.highlightTables();
                    }
                    UIUtils.packColumns((Table)MySQLUserEditorPrivileges.this.tablesTable);
                }
            };
        }

        public ProgressPageControl.ProgressVisualizer<List<MySQLPrivilege>> createPrivilegesLoadVisualizer() {
            return new ProgressPageControl.ProgressVisualizer<List<MySQLPrivilege>>((ProgressPageControl)this){

                public void completeLoading(List<MySQLPrivilege> privs) {
                    super.completeLoading(privs);
                    ArrayList<MySQLPrivilege> otherPrivs = new ArrayList<MySQLPrivilege>();
                    ArrayList<MySQLPrivilege> tablePrivs = new ArrayList<MySQLPrivilege>();
                    for (MySQLPrivilege priv : privs) {
                        if (priv.getKind() == MySQLPrivilege.Kind.ADMIN) continue;
                        if (priv.getContext().contains("Table")) {
                            tablePrivs.add(priv);
                            continue;
                        }
                        otherPrivs.add(priv);
                    }
                    MySQLUserEditorPrivileges.this.tablePrivilegesTable.fillPrivileges(tablePrivs);
                    MySQLUserEditorPrivileges.this.otherPrivilegesTable.fillPrivileges(otherPrivs);
                    MySQLUserEditorPrivileges.this.loadGrants();
                }
            };
        }
    }
}

