/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTable;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndex;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLIndexManager;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.utils.CommonUtils;

public class SQLServerIndexManager
extends SQLIndexManager<SQLServerTableIndex, SQLServerTableBase> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, SQLServerTableIndex> getObjectsCache(SQLServerTableIndex object) {
        return ((SQLServerSchema)((SQLServerTableBase)object.getTable()).getContainer()).getIndexCache();
    }

    protected SQLServerTableIndex createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object from, Map<String, Object> options) {
        SQLServerTable table = (SQLServerTable)container;
        return new SQLServerTableIndex(table, true, false, null, DBSIndexType.UNKNOWN, null, false);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        SQLServerTableIndex index = (SQLServerTableIndex)command.getObject();
        if (index.isPersisted()) {
            try {
                String indexDDL = index.getObjectDefinitionText(monitor, DBPScriptObject.EMPTY_OPTIONS);
                if (!CommonUtils.isEmpty((String)indexDDL)) {
                    actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_index, indexDDL));
                    return;
                }
            }
            catch (DBException e) {
                log.warn((Object)"Can't extract index DDL", (Throwable)e);
            }
        }
        super.addObjectCreateActions(monitor, actions, command, options);
    }

    protected String getDropIndexPattern(SQLServerTableIndex index) {
        return "DROP INDEX " + index.getName() + " ON " + ((SQLServerTableBase)index.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL);
    }
}

