/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolSecurityPolicy;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class ExasolSecurityPolicyManager
extends SQLObjectEditor<ExasolSecurityPolicy, ExasolDataSource> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    public DBSObjectCache<ExasolDataSource, ExasolSecurityPolicy> getObjectsCache(ExasolSecurityPolicy object) {
        ExasolDataSource source = object.getDataSource();
        return source.getSecurityPolicyCache();
    }

    protected ExasolSecurityPolicy createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        throw new DBException("Not Supported");
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        ExasolSecurityPolicy obj = (ExasolSecurityPolicy)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename Connection", "RENAME CONNECTION " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getOldName()) + " to " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getNewName())));
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        ExasolSecurityPolicy con = (ExasolSecurityPolicy)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop Connection", "DROP CONNECTION " + DBUtils.getQuotedIdentifier((DBSObject)con)));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        ExasolSecurityPolicy policy = (ExasolSecurityPolicy)command.getObject();
        if (policy.getEnabled().booleanValue()) {
            String script = String.format("ALTER SYSTEM SET PASSWORD_SECURITY_POLICY='%s'", policy.getSecurityString());
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(script));
        } else {
            String script = String.format("ALTER SYSTEM SET PASSWORD_SECURITY_POLICY='OFF'", policy.getSecurityString());
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(script));
        }
    }

    public boolean canDeleteObject(ExasolSecurityPolicy object) {
        return false;
    }

    public boolean canCreateObject(Object container) {
        return false;
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
    }
}

