/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.command;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDElement;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;

public class AssociationCreateCommand
extends Command {
    protected ERDAssociation association;
    protected ERDElement sourceEntity;
    protected ERDElement targetEntity;

    public boolean canExecute() {
        boolean returnValue = true;
        if (this.sourceEntity.equals(this.targetEntity)) {
            returnValue = false;
        } else {
            if (this.targetEntity == null) {
                return false;
            }
            List<ERDAssociation> relationships = this.targetEntity.getReferences();
            for (ERDAssociation currentRelationship : relationships) {
                if (!currentRelationship.getSourceEntity().equals(this.sourceEntity)) continue;
                returnValue = false;
                break;
            }
        }
        return returnValue;
    }

    public void execute() {
        if (this.sourceEntity instanceof ERDEntity && this.targetEntity instanceof ERDEntity) {
            DBSEntity srcEntityObject = (DBSEntity)((ERDEntity)this.sourceEntity).getObject();
            DBSEntity targetEntityObject = (DBSEntity)((ERDEntity)this.targetEntity).getObject();
            DBVEntity vEntity = DBVUtils.getVirtualEntity((DBSEntity)srcEntityObject, (boolean)true);
            DBVEntityForeignKey vfk = EditForeignKeyPage.createVirtualForeignKey((DBVEntity)vEntity, (DBSEntity)targetEntityObject, (EditForeignKeyPage.FKType[])new EditForeignKeyPage.FKType[]{EditForeignKeyPage.FK_TYPE_LOGICAL});
            if (vfk == null) {
                return;
            }
            vEntity.persistConfiguration();
            this.association = new ERDAssociation((DBSEntityAssociation)vfk, (ERDEntity)this.sourceEntity, (ERDEntity)this.targetEntity, true);
        } else {
            this.association = this.createAssociation(this.sourceEntity, this.targetEntity, true);
        }
    }

    public ERDElement getSourceEntity() {
        return this.sourceEntity;
    }

    public void setSourceEntity(ERDElement sourceEntity) {
        this.sourceEntity = sourceEntity;
    }

    public ERDElement getTargetEntity() {
        return this.targetEntity;
    }

    public void setTargetEntity(ERDElement targetEntity) {
        this.targetEntity = targetEntity;
    }

    public ERDAssociation getAssociation() {
        return this.association;
    }

    public void setAssociation(ERDAssociation association) {
        this.association = association;
    }

    public void redo() {
        if (this.association != null) {
            this.sourceEntity.addAssociation(this.association, true);
            this.targetEntity.addReferenceAssociation(this.association, true);
        }
    }

    public void undo() {
        if (this.association != null) {
            this.sourceEntity.removeAssociation(this.association, true);
            this.targetEntity.removeReferenceAssociation(this.association, true);
        }
    }

    protected ERDAssociation createAssociation(ERDElement sourceEntity, ERDElement targetEntity, boolean reflect) {
        return new ERDAssociation(sourceEntity, targetEntity, true);
    }
}

