/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.module;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2DataType;
import org.jkiss.dbeaver.ext.db2.model.DB2Routine;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2SchemaObject;
import org.jkiss.dbeaver.ext.db2.model.DB2Variable;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2OwnerType;
import org.jkiss.dbeaver.ext.db2.model.module.DB2ModuleCondition;
import org.jkiss.dbeaver.ext.db2.model.module.DB2ModuleType;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectSimpleCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureContainer;
import org.jkiss.utils.CommonUtils;

public class DB2Module
extends DB2SchemaObject
implements DBSProcedureContainer,
DBPRefreshableObject {
    private static final String C_CON = "SELECT * FROM SYSCAT.CONDITIONS WHERE CONDSCHEMA = ? AND CONDMODULENAME = ? ORDER BY CONDNAME WITH UR";
    private static final String C_FCT = "SELECT * FROM SYSCAT.ROUTINES WHERE ROUTINESCHEMA = ? AND ROUTINEMODULENAME = ? AND ROUTINETYPE = 'F' ORDER BY ROUTINENAME WITH UR";
    private static final String C_MOD = "SELECT * FROM SYSCAT.ROUTINES WHERE ROUTINESCHEMA = ? AND ROUTINEMODULENAME = ? AND ROUTINETYPE = 'M' ORDER BY ROUTINENAME WITH UR";
    private static final String C_PRC = "SELECT * FROM SYSCAT.ROUTINES WHERE ROUTINESCHEMA = ? AND ROUTINEMODULENAME = ? AND ROUTINETYPE = 'P' ORDER BY ROUTINENAME WITH UR";
    private static final String C_TYP = "SELECT * FROM SYSCAT.DATATYPES WHERE TYPESCHEMA = ? AND TYPEMODULENAME = ? ORDER BY TYPENAME WITH UR";
    private static final String C_VAR = "SELECT * FROM SYSCAT.VARIABLES WHERE VARSCHEMA = ? AND VARMODULENAME = ? ORDER BY VARNAME WITH UR";
    private final DBSObjectCache<DB2Module, DB2ModuleCondition> conditionCache;
    private final DBSObjectCache<DB2Module, DB2Routine> functionCache;
    private final DBSObjectCache<DB2Module, DB2Routine> methodCache;
    private final DBSObjectCache<DB2Module, DB2Routine> procedureCache;
    private final DBSObjectCache<DB2Module, DB2DataType> typeCache;
    private final DBSObjectCache<DB2Module, DB2Variable> variableCache;
    private Integer moduleId;
    private String owner;
    private DB2OwnerType ownerType;
    private String dialect;
    private DB2ModuleType type;
    private Timestamp createTime;
    private String remarks;

    public DB2Module(DB2Schema schema, ResultSet dbResult) {
        super(schema, JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"MODULENAME"), true);
        this.moduleId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"MODULEID");
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
        this.ownerType = (DB2OwnerType)CommonUtils.valueOf(DB2OwnerType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNERTYPE"));
        this.dialect = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DIALECT");
        this.type = (DB2ModuleType)CommonUtils.valueOf(DB2ModuleType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"MODULETYPE"));
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        this.conditionCache = new JDBCObjectSimpleCache(DB2ModuleCondition.class, C_CON, new Object[]{schema.getName(), this.name});
        this.functionCache = new JDBCObjectSimpleCache(DB2Routine.class, C_FCT, new Object[]{schema.getName(), this.name});
        this.methodCache = new JDBCObjectSimpleCache(DB2Routine.class, C_MOD, new Object[]{schema.getName(), this.name});
        this.procedureCache = new JDBCObjectSimpleCache(DB2Routine.class, C_PRC, new Object[]{schema.getName(), this.name});
        this.typeCache = new JDBCObjectSimpleCache(DB2DataType.class, C_TYP, new Object[]{schema.getName(), this.name});
        this.variableCache = new JDBCObjectSimpleCache(DB2Variable.class, C_VAR, new Object[]{schema.getName(), this.name});
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.conditionCache.clearCache();
        this.functionCache.clearCache();
        this.procedureCache.clearCache();
        this.typeCache.clearCache();
        this.variableCache.clearCache();
        return this;
    }

    @Association
    public Collection<DB2ModuleCondition> getConditions(DBRProgressMonitor monitor) throws DBException {
        return this.conditionCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public Collection<DB2Routine> getFunctions(DBRProgressMonitor monitor) throws DBException {
        return this.functionCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public Collection<DB2Routine> getProcedures(DBRProgressMonitor monitor) throws DBException {
        return this.procedureCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DBSProcedure getProcedure(DBRProgressMonitor monitor, String uniqueName) throws DBException {
        return (DBSProcedure)this.procedureCache.getObject(monitor, (DBSObject)this, uniqueName);
    }

    @Association
    public Collection<DB2DataType> getTypes(DBRProgressMonitor monitor) throws DBException {
        return this.typeCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2DataType getType(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2DataType)this.typeCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2Variable> getVariables(DBRProgressMonitor monitor) throws DBException {
        return this.variableCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Override
    @Property(viewable=true, order=2)
    public DB2Schema getSchema() {
        return (DB2Schema)this.parent;
    }

    @Property(viewable=true, order=10)
    public Integer getModuleId() {
        return this.moduleId;
    }

    @Property(viewable=true, order=11)
    public String getDialect() {
        return this.dialect;
    }

    @Property(viewable=true, order=12)
    public DB2ModuleType getType() {
        return this.type;
    }

    @Property(viewable=false, order=13, category="Owner")
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=false, order=14, category="Owner")
    public DB2OwnerType getOwnerType() {
        return this.ownerType;
    }

    @Property(viewable=false, order=15, category="Date & Time")
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Override
    @Property(viewable=false, multiline=true)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    public DBSObjectCache<DB2Module, DB2ModuleCondition> getConditionCache() {
        return this.conditionCache;
    }

    public DBSObjectCache<DB2Module, DB2Routine> getFunctionCache() {
        return this.functionCache;
    }

    public DBSObjectCache<DB2Module, DB2Routine> getMethodCache() {
        return this.methodCache;
    }

    public DBSObjectCache<DB2Module, DB2Routine> getProcedureCache() {
        return this.procedureCache;
    }

    public DBSObjectCache<DB2Module, DB2DataType> getTypeCache() {
        return this.typeCache;
    }

    public DBSObjectCache<DB2Module, DB2Variable> getVariableCache() {
        return this.variableCache;
    }
}

