/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.data.office.export;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.data.office.export.Worksheet;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterXLSX
extends StreamExporterAbstract {
    private static final Log log = Log.getLog(DataExporterXLSX.class);
    private static final String PROP_HEADER = "header";
    private static final String PROP_NULL_STRING = "nullString";
    private static final String PROP_ROWNUMBER = "rownumber";
    private static final String PROP_BORDER = "border";
    private static final String PROP_HEADER_FONT = "headerfont";
    private static final String BINARY_FIXED = "[BINARY]";
    private static final String PROP_TRUESTRING = "trueString";
    private static final String PROP_FALSESTRING = "falseString";
    private static final String PROP_EXPORT_SQL = "exportSql";
    private static final String PROP_SPLIT_SQLTEXT = "splitSqlText";
    private static final String PROP_SPLIT_BYROWCOUNT = "splitByRowCount";
    private static final String PROP_SPLIT_BYCOL = "splitByColNum";
    private static final String PROP_DATE_FORMAT = "dateFormat";
    private static final int EXCEL2007MAXROWS = 1048575;
    private boolean showDescription;
    private static final int ROW_WINDOW = 100;
    private String nullString;
    private List<DBDAttributeBinding> columns;
    private SXSSFWorkbook wb;
    private boolean printHeader = false;
    private boolean rowNumber = false;
    private String boolTrue = "true";
    private String boolFalse = "false";
    private boolean booleRedefined;
    private boolean exportSql = false;
    private boolean splitSqlText = false;
    private String dateFormat = "";
    private int splitByRowCount = 1048575;
    private int splitByCol = 0;
    private int rowCount = 0;
    private XSSFCellStyle style;
    private XSSFCellStyle styleDate;
    private XSSFCellStyle styleHeader;
    private HashMap<Object, Worksheet> worksheets;

    public static Map<Object, Object> getDefaultProperties() {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        properties.put(PROP_ROWNUMBER, false);
        properties.put(PROP_BORDER, "THIN");
        properties.put(PROP_HEADER, true);
        properties.put(PROP_NULL_STRING, null);
        properties.put(PROP_HEADER_FONT, "BOLD");
        properties.put(PROP_TRUESTRING, "true");
        properties.put(PROP_FALSESTRING, "false");
        properties.put(PROP_EXPORT_SQL, false);
        properties.put(PROP_SPLIT_SQLTEXT, false);
        properties.put(PROP_SPLIT_BYROWCOUNT, 1048575);
        properties.put(PROP_SPLIT_BYCOL, 0);
        properties.put(PROP_DATE_FORMAT, "");
        return properties;
    }

    public void init(IStreamDataExporterSite site) throws DBException {
        FontStyleProp fontStyle;
        BorderStyle border;
        Object nullStringProp = site.getProperties().get(PROP_NULL_STRING);
        this.nullString = nullStringProp == null ? null : nullStringProp.toString();
        try {
            this.printHeader = (Boolean)site.getProperties().get(PROP_HEADER);
        }
        catch (Exception exception) {
            this.printHeader = false;
        }
        try {
            this.rowNumber = (Boolean)site.getProperties().get(PROP_ROWNUMBER);
        }
        catch (Exception exception) {
            this.rowNumber = false;
        }
        try {
            this.boolTrue = (String)site.getProperties().get(PROP_TRUESTRING);
        }
        catch (Exception exception) {
            this.boolTrue = "true";
        }
        try {
            this.boolFalse = (String)site.getProperties().get(PROP_FALSESTRING);
        }
        catch (Exception exception) {
            this.boolFalse = "false";
        }
        if (!"true".equals(this.boolTrue) || !"false".equals(this.boolFalse)) {
            this.booleRedefined = true;
        }
        try {
            this.exportSql = (Boolean)site.getProperties().get(PROP_EXPORT_SQL);
        }
        catch (Exception exception) {
            this.exportSql = false;
        }
        try {
            this.splitSqlText = (Boolean)site.getProperties().get(PROP_SPLIT_SQLTEXT);
        }
        catch (Exception exception) {
            this.splitSqlText = false;
        }
        try {
            this.splitByRowCount = (Integer)site.getProperties().get(PROP_SPLIT_BYROWCOUNT);
        }
        catch (Exception exception) {
            this.splitByRowCount = 1048575;
        }
        try {
            this.splitByCol = (Integer)site.getProperties().get(PROP_SPLIT_BYCOL);
        }
        catch (Exception exception) {
            this.splitByCol = -1;
        }
        try {
            this.dateFormat = (String)site.getProperties().get(PROP_DATE_FORMAT);
        }
        catch (Exception exception) {
            this.dateFormat = "";
        }
        this.wb = new SXSSFWorkbook(100);
        this.worksheets = new HashMap(1);
        this.styleHeader = (XSSFCellStyle)this.wb.createCellStyle();
        try {
            border = BorderStyle.valueOf((String)((String)site.getProperties().get(PROP_BORDER)));
        }
        catch (Exception exception) {
            border = BorderStyle.NONE;
        }
        try {
            fontStyle = FontStyleProp.valueOf((String)site.getProperties().get(PROP_HEADER_FONT));
        }
        catch (Exception exception) {
            fontStyle = FontStyleProp.NONE;
        }
        this.styleHeader.setBorderTop(border);
        this.styleHeader.setBorderBottom(border);
        this.styleHeader.setBorderLeft(border);
        this.styleHeader.setBorderRight(border);
        XSSFFont fontBold = (XSSFFont)this.wb.createFont();
        switch (fontStyle) {
            case BOLD: {
                fontBold.setBold(true);
                break;
            }
            case ITALIC: {
                fontBold.setItalic(true);
                break;
            }
            case STRIKEOUT: {
                fontBold.setStrikeout(true);
                break;
            }
            case UNDERLINE: {
                fontBold.setUnderline((byte)3);
                break;
            }
        }
        this.styleHeader.setFont((Font)fontBold);
        this.style = (XSSFCellStyle)this.wb.createCellStyle();
        this.style.setBorderTop(border);
        this.style.setBorderBottom(border);
        this.style.setBorderLeft(border);
        this.style.setBorderRight(border);
        this.styleDate = (XSSFCellStyle)this.wb.createCellStyle();
        this.styleDate.setBorderTop(border);
        this.styleDate.setBorderBottom(border);
        this.styleDate.setBorderLeft(border);
        this.styleDate.setBorderRight(border);
        if (this.dateFormat == null || this.dateFormat.length() == 0) {
            this.styleDate.setDataFormat((short)14);
        } else {
            this.styleDate.setDataFormat(this.wb.getCreationHelper().createDataFormat().getFormat(this.dateFormat));
        }
        this.rowCount = 0;
        super.init(site);
    }

    public void dispose() {
        try {
            if (this.exportSql) {
                try {
                    SXSSFSheet sh = this.wb.createSheet();
                    if (this.splitSqlText) {
                        String[] sqlText = this.getSite().getSource().getName().split("\n", this.wb.getSpreadsheetVersion().getMaxRows());
                        int sqlRownum = 0;
                        String[] stringArray = sqlText;
                        int n = sqlText.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            Row row = sh.createRow(sqlRownum);
                            Cell newcell = row.createCell(0);
                            newcell.setCellValue(s);
                            ++sqlRownum;
                            ++n2;
                        }
                    } else {
                        Row row = sh.createRow(0);
                        Cell newcell = row.createCell(0);
                        newcell.setCellValue(this.getSite().getSource().getName());
                    }
                    sh = null;
                }
                catch (Exception e) {
                    log.error((Object)"Dispose error", (Throwable)e);
                }
            }
            this.wb.write(this.getSite().getOutputStream());
            this.wb.dispose();
        }
        catch (IOException e) {
            log.error((Object)"Dispose error", (Throwable)e);
        }
        this.wb = null;
        for (Worksheet w : this.worksheets.values()) {
            w.dispose();
        }
        super.dispose();
    }

    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        this.showDescription = session.getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.show.columnDescription");
    }

    private void printHeader(DBCResultSet resultSet, Worksheet wsh) throws DBException {
        boolean hasDescription = false;
        if (this.showDescription) {
            boolean bindingsOk = true;
            DBDAttributeBindingMeta[] bindings = new DBDAttributeBindingMeta[this.columns.size()];
            int i = 0;
            while (i < this.columns.size()) {
                if (!(this.columns.get(i) instanceof DBDAttributeBindingMeta)) {
                    bindingsOk = false;
                    break;
                }
                bindings[i] = (DBDAttributeBindingMeta)this.columns.get(i);
                ++i;
            }
            if (bindingsOk) {
                DBSEntity sourceEntity = null;
                if (this.getSite().getSource() instanceof DBSEntity) {
                    sourceEntity = (DBSEntity)this.getSite().getSource();
                }
                ResultSetUtils.bindAttributes((DBCSession)resultSet.getSession(), (DBSEntity)sourceEntity, (DBCResultSet)resultSet, (DBDAttributeBindingMeta[])bindings, null);
            }
            for (DBDAttributeBinding column : this.columns) {
                if (CommonUtils.isEmpty((String)column.getDescription())) continue;
                hasDescription = true;
                break;
            }
        }
        SXSSFSheet sh = (SXSSFSheet)wsh.getSh();
        SXSSFRow row = sh.createRow(wsh.getCurrentRow());
        int startCol = this.rowNumber ? 1 : 0;
        sh.trackAllColumnsForAutoSizing();
        int i = 0;
        int columnsSize = this.columns.size();
        while (i < columnsSize) {
            DBDAttributeBinding column = this.columns.get(i);
            String colName = column.getLabel();
            if (CommonUtils.isEmpty((String)colName)) {
                colName = column.getName();
            }
            Cell cell = row.createCell(i + startCol, CellType.STRING);
            cell.setCellValue(colName);
            cell.setCellStyle((CellStyle)this.styleHeader);
            ++i;
        }
        if (hasDescription) {
            wsh.incRow();
            SXSSFRow descRow = sh.createRow(wsh.getCurrentRow());
            int i2 = 0;
            int columnsSize2 = this.columns.size();
            while (i2 < columnsSize2) {
                Cell descCell = descRow.createCell(i2 + startCol, CellType.STRING);
                String description = this.columns.get(i2).getDescription();
                if (CommonUtils.isEmpty((String)description)) {
                    description = "";
                }
                descCell.setCellValue(description);
                descCell.setCellStyle((CellStyle)this.styleHeader);
                ++i2;
            }
        }
        i = 0;
        columnsSize = this.columns.size();
        while (i < columnsSize) {
            sh.autoSizeColumn(i);
            ++i;
        }
        wsh.incRow();
        try {
            sh.flushRows();
        }
        catch (IOException e) {
            throw new DBException("Error processing header", (Throwable)e);
        }
        sh.untrackAllColumnsForAutoSizing();
    }

    private void writeCellValue(Cell cell, Reader reader) throws IOException {
        try {
            int count;
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[2000];
            while ((count = reader.read(buffer)) > 0) {
                sb.append(buffer, 0, count);
            }
            cell.setCellValue(sb.toString());
        }
        finally {
            ContentUtils.close((Closeable)reader);
        }
    }

    private Worksheet createSheet(DBCResultSet resultSet, Object colValue) throws DBException {
        Worksheet w = new Worksheet((Sheet)this.wb.createSheet(), colValue, 0);
        if (this.printHeader) {
            this.printHeader(resultSet, w);
        }
        return w;
    }

    private Worksheet getWsh(DBCResultSet resultSet, Object[] row) throws DBException {
        Object colValue = this.splitByCol <= 0 || this.splitByCol >= this.columns.size() ? "" : row[this.splitByCol];
        Worksheet w = this.worksheets.get(colValue);
        if (w == null) {
            w = this.createSheet(resultSet, colValue);
            this.worksheets.put(w.getColumnVal(), w);
        } else if (w.getCurrentRow() >= this.splitByRowCount) {
            w = this.createSheet(resultSet, colValue);
            this.worksheets.put(w.getColumnVal(), w);
        }
        return w;
    }

    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        Worksheet wsh = this.getWsh(resultSet, row);
        Row rowX = wsh.getSh().createRow(wsh.getCurrentRow());
        int startCol = 0;
        if (this.rowNumber) {
            Cell cell = rowX.createCell(startCol, CellType.NUMERIC);
            cell.setCellStyle((CellStyle)this.style);
            cell.setCellValue(String.valueOf(wsh.getCurrentRow()));
            ++startCol;
        }
        int i = 0;
        while (i < row.length) {
            DBDAttributeBinding column = this.columns.get(i);
            Cell cell = rowX.createCell(i + startCol, this.getCellType(column));
            cell.setCellStyle((CellStyle)this.style);
            if (DBUtils.isNullValue((Object)row[i])) {
                if (!CommonUtils.isEmpty((String)this.nullString)) {
                    cell.setCellValue(this.nullString);
                } else {
                    cell.setCellValue("");
                }
            } else if (row[i] instanceof DBDContent) {
                DBDContent content = (DBDContent)row[i];
                try {
                    DBDContentStorage cs = content.getContents(session.getProgressMonitor());
                    if (cs == null) {
                        cell.setCellValue("[NULL]");
                    }
                    if (ContentUtils.isTextContent((DBDContent)content)) {
                        this.writeCellValue(cell, cs.getContentReader());
                    }
                    cell.setCellValue(BINARY_FIXED);
                }
                finally {
                    content.release();
                }
            } else if (row[i] instanceof Boolean) {
                if (this.booleRedefined) {
                    cell.setCellValue((Boolean)row[i] != false ? this.boolTrue : this.boolFalse);
                } else {
                    cell.setCellValue(((Boolean)row[i]).booleanValue());
                }
            } else if (row[i] instanceof Number) {
                cell.setCellValue(((Number)row[i]).doubleValue());
            } else if (row[i] instanceof Date) {
                cell.setCellValue((Date)row[i]);
                cell.setCellStyle((CellStyle)this.styleDate);
            } else {
                String stringValue = super.getValueDisplayString(column, row[i]);
                cell.setCellValue(stringValue);
            }
            ++i;
        }
        wsh.incRow();
        ++this.rowCount;
    }

    private CellType getCellType(DBDAttributeBinding column) {
        switch (column.getDataKind()) {
            case NUMERIC: {
                return CellType.NUMERIC;
            }
            case BOOLEAN: {
                return CellType.BOOLEAN;
            }
            case STRING: {
                return CellType.STRING;
            }
        }
        return CellType.BLANK;
    }

    public void exportFooter(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.rowCount == 0) {
            this.exportRow(null, null, new Object[this.columns.size()]);
        }
    }

    static enum FontStyleProp {
        NONE,
        BOLD,
        ITALIC,
        STRIKEOUT,
        UNDERLINE;

    }
}

