/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.data.gis.handlers;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.data.gis.handlers.GISGeometryValueHandler;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.ProxyValueHandler;
import org.jkiss.dbeaver.model.impl.data.transformers.TransformerPresentationAttribute;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class GeometryAttributeTransformer
implements DBDAttributeTransformer {
    private static final Log log = Log.getLog(GeometryAttributeTransformer.class);
    private static final String PROP_SRID = "srid";
    private static final String PROP_INVERT_COORDINATES = "invertCoordinates";
    public static final String GIS_TYPE_NAME = "GIS.Transformed";

    public void transformAttribute(@NotNull DBCSession session, @NotNull DBDAttributeBinding attribute, @NotNull List<Object[]> rows, @NotNull Map<String, Object> options) throws DBException {
        attribute.setPresentationAttribute((DBSAttributeBase)new TransformerPresentationAttribute(attribute, GIS_TYPE_NAME, -1, attribute.getDataKind()));
        int srid = CommonUtils.toInt((Object)options.get(PROP_SRID));
        if (srid == 0) {
            srid = 4326;
        }
        boolean invertCoordinates = CommonUtils.toBoolean((Object)options.get(PROP_INVERT_COORDINATES));
        attribute.setTransformHandler((DBDValueHandler)new GISValueHandler(attribute.getValueHandler(), srid, invertCoordinates));
    }

    private class GISValueHandler
    extends ProxyValueHandler {
        private final GISGeometryValueHandler realHandler;
        private final int srid;

        public GISValueHandler(DBDValueHandler target, int srid, boolean invertCoordinates) {
            super(target);
            this.realHandler = new GISGeometryValueHandler();
            this.realHandler.setDefaultSRID(srid);
            this.realHandler.setInvertCoordinates(invertCoordinates);
            this.srid = srid;
        }

        public Class<?> getValueObjectType(DBSTypedObject attribute) {
            return this.realHandler.getValueObjectType(attribute);
        }

        public Object fetchValueObject(DBCSession session, DBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException {
            Object object = super.fetchValueObject(session, resultSet, type, index);
            return this.getValueFromObject(session, type, object, false);
        }

        @Nullable
        public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, @Nullable Object object, boolean copy) throws DBCException {
            return this.realHandler.getValueFromObject(session, type, object, copy);
        }
    }
}

