/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.MultiPageWizardDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageSettings;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizard;
import org.jkiss.utils.CommonUtils;

public class EditConnectionDialog
extends MultiPageWizardDialog {
    public static final int TEST_BUTTON_ID = 2000;
    private static String lastActivePage;
    private Button testButton;

    public EditConnectionDialog(IWorkbenchWindow window, ConnectionWizard wizard) {
        super(window, (IWizard)wizard);
    }

    public ConnectionWizard getWizard() {
        return (ConnectionWizard)super.getWizard();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)"DBeaver.EditConnectionDialog");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (!CommonUtils.isEmpty((String)lastActivePage)) {
            this.getWizard().openSettingsPage(lastActivePage);
        }
        return contents;
    }

    protected boolean isAutoLayoutAvailable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.testButton = this.createButton(parent, 2000, CoreMessages.dialog_connection_button_test, false);
        this.testButton.setEnabled(false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 2000) {
            this.testConnection();
            return;
        }
        super.buttonPressed(buttonId);
    }

    public boolean close() {
        if (this.getCurrentPage() != null) {
            lastActivePage = this.getCurrentPage().getName();
        }
        return super.close();
    }

    public void updateButtons() {
        if (this.testButton != null) {
            ConnectionPageSettings settings = this.getWizard().getPageSettings();
            this.testButton.setEnabled(settings != null && settings.isPageComplete());
        }
        super.updateButtons();
    }

    private void testConnection() {
        this.getWizard().testConnection();
    }
}

