/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.compare.simple;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.compare.simple.CompareObjectsSettings;
import org.jkiss.dbeaver.tools.compare.simple.CompareReport;
import org.jkiss.dbeaver.tools.compare.simple.CompareReportLine;
import org.jkiss.dbeaver.tools.compare.simple.CompareReportProperty;
import org.jkiss.dbeaver.tools.compare.simple.CompareUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;

public class CompareReportRenderer {
    private CompareReport report;
    private XMLBuilder xml;
    private CompareObjectsSettings settings;

    public void renderReport(DBRProgressMonitor monitor, CompareReport report, CompareObjectsSettings settings, OutputStream outputStream) throws IOException {
        this.report = report;
        this.settings = settings;
        this.xml = new XMLBuilder(outputStream, GeneralUtils.UTF8_ENCODING, true);
        this.xml.setButify(true);
        this.xml.addContent((CharSequence)"<!DOCTYPE html \n     PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n    \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        if (settings.isShowOnlyDifferences()) {
            List<CompareReportLine> reportLines = report.getReportLines();
            int reportLinesSize = reportLines.size();
            int i = 0;
            while (i < reportLinesSize) {
                if (reportLines.get((int)i).hasDifference) {
                    int depth = reportLines.get((int)i).depth;
                    int k = i - 1;
                    while (k >= 0) {
                        CompareReportLine prevNode = reportLines.get(k);
                        if (prevNode.depth < depth) {
                            if (prevNode.hasDifference) break;
                            depth = prevNode.depth;
                            prevNode.hasDifference = true;
                        }
                        --k;
                    }
                }
                ++i;
            }
        }
        this.xml.startElement("html");
        this.xml.startElement("head");
        this.xml.startElement("meta");
        this.xml.addAttribute("http-equiv", "Content-type");
        this.xml.addAttribute("content", "text/html; charset=utf-8");
        this.xml.endElement();
        this.xml.startElement("title");
        this.xml.addText((CharSequence)"Compare report");
        this.xml.endElement();
        this.xml.endElement();
        this.xml.startElement("body");
        this.renderHeader();
        this.xml.startElement("table");
        this.xml.addAttribute("width", "100%");
        this.xml.addAttribute("cellspacing", 0);
        this.xml.addAttribute("cellpadding", 0);
        this.renderBody(monitor);
        this.xml.endElement();
        this.xml.endElement();
        this.xml.endElement();
        this.xml.flush();
    }

    private void renderHeader() throws IOException {
        int maxLevel = 0;
        for (CompareReportLine line : this.report.getReportLines()) {
            if (line.depth <= maxLevel) continue;
            maxLevel = line.depth;
        }
        ++maxLevel;
        this.xml.startElement("style");
        StringBuilder styles = new StringBuilder();
        styles.append("table {font-family:\"Lucida Sans Unicode\", \"Lucida Grande\", Sans-Serif;font-size:12px;text-align:left;} ");
        styles.append(".missing {color:red;} .differs {color:red;} ");
        styles.append(".object td,th {border-top:solid 1px; border-right:solid 1px; border-color: black; white-space:nowrap;} ");
        styles.append(".property td,th {border-top:dashed 1px; border-right:solid 1px; border-color: black; white-space:pre; } ");
        styles.append(".struct {border-top:none; !important } ");
        int i = 1;
        while (i <= maxLevel) {
            styles.append(".level").append(i).append(" td,th { text-align:left; padding-left:").append(20 * i).append("px; } ");
            ++i;
        }
        this.xml.addText((CharSequence)styles.toString(), false);
        this.xml.endElement();
    }

    private void renderBody(DBRProgressMonitor monitor) throws IOException {
        this.xml.startElement("tr");
        this.xml.startElement("th");
        this.xml.addText((CharSequence)"Structure");
        this.xml.endElement();
        for (DBNDatabaseNode node : this.report.getNodes()) {
            this.xml.startElement("th");
            this.xml.addText((CharSequence)node.getNodeFullName());
            this.xml.endElement();
        }
        this.xml.endElement();
        boolean showOnlyDifferences = this.settings.isShowOnlyDifferences();
        int objectCount = this.report.getNodes().size();
        List<CompareReportLine> reportLines = this.report.getReportLines();
        int reportLinesSize = reportLines.size();
        int i = 0;
        while (i < reportLinesSize) {
            monitor.worked(1);
            CompareReportLine line = reportLines.get(i);
            if (!showOnlyDifferences || line.hasDifference) {
                boolean onlyStructure;
                boolean bl = onlyStructure = line.structure instanceof DBNDatabaseFolder && !line.hasDifference;
                if (!onlyStructure || i < reportLinesSize - 1 && reportLines.get((int)(i + 1)).depth > line.depth) {
                    this.xml.startElement("tr");
                    this.xml.addAttribute("class", "object level" + line.depth);
                    this.xml.addAttribute("valign", "top");
                    this.xml.startElement("td");
                    this.xml.addText((CharSequence)line.structure.getNodeType());
                    this.xml.endElement();
                    if (onlyStructure) {
                        this.xml.startElement("td");
                        this.xml.addAttribute("colspan", line.nodes.length);
                        this.xml.addText((CharSequence)"&nbsp;", false);
                        this.xml.endElement();
                    } else {
                        int k = 0;
                        while (k < objectCount) {
                            this.xml.startElement("td");
                            if (line.nodes[k] == null) {
                                this.xml.addAttribute("class", "missing");
                                this.xml.addText((CharSequence)"N/A");
                            } else {
                                this.xml.addText((CharSequence)line.nodes[k].getName());
                            }
                            this.xml.endElement();
                            ++k;
                        }
                    }
                    this.xml.endElement();
                    if (line.properties != null) {
                        for (CompareReportProperty reportProperty : line.properties) {
                            boolean differs = false;
                            Object firstValue = null;
                            boolean hasValue = false;
                            int k = 0;
                            while (k < reportProperty.values.length) {
                                if (line.nodes[k] != null) {
                                    Object value = reportProperty.values[k];
                                    if (value != null) {
                                        hasValue = true;
                                        if (firstValue == null) {
                                            firstValue = value;
                                        }
                                    }
                                    if (!CompareUtils.equalPropertyValues(value, firstValue)) {
                                        differs = true;
                                        break;
                                    }
                                }
                                ++k;
                            }
                            if (!hasValue || showOnlyDifferences && !differs) continue;
                            this.xml.startElement("tr");
                            this.xml.addAttribute("class", "property level" + (line.depth + 1) + (differs ? " differs" : ""));
                            this.xml.addAttribute("valign", "top");
                            this.xml.startElement("td");
                            this.xml.addText((CharSequence)reportProperty.property.getDisplayName());
                            this.xml.endElement();
                            k = 0;
                            while (k < objectCount) {
                                this.xml.startElement("td");
                                String stringValue = "";
                                if (reportProperty.values[k] != null) {
                                    stringValue = reportProperty.values[k].toString();
                                }
                                if (CommonUtils.isEmpty((String)stringValue)) {
                                    this.xml.addText((CharSequence)"&nbsp;", false);
                                } else {
                                    this.xml.addText((CharSequence)stringValue);
                                }
                                this.xml.endElement();
                                ++k;
                            }
                            this.xml.endElement();
                        }
                    }
                }
            }
            ++i;
        }
        this.xml.startElement("tr");
        this.xml.addAttribute("class", "object");
        this.xml.startElement("td");
        this.xml.addAttribute("colspan", this.report.getNodes().size() + 1);
        this.xml.addText((CharSequence)(reportLines.size() + " objects compared"));
        this.xml.endElement();
        this.xml.endElement();
    }
}

