/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.position;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNodeSide;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.core.math.KVector;

public final class SelfLoopNodePortRestorator {
    private SelfLoopNodePortRestorator() {
    }

    public static void restorePorts(LNode node) {
        SelfLoopNode nodeRep = (SelfLoopNode)node.getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
        if (nodeRep == null) {
            return;
        }
        ArrayList<LPort> nodePorts = new ArrayList<LPort>();
        for (SelfLoopNodeSide side : nodeRep.getSides()) {
            for (SelfLoopPort port : side.getPorts()) {
                LPort lPort = port.getLPort();
                lPort.setSide(port.getPortSide());
                nodePorts.add(lPort);
            }
        }
        List<LPort> realNodePorts = node.getPorts();
        realNodePorts.removeAll(nodePorts);
        realNodePorts.addAll(nodePorts);
    }

    public static void restoreAndPlacePorts(LNode node) {
        SelfLoopNode nodeRep = (SelfLoopNode)node.getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
        if (nodeRep == null) {
            return;
        }
        ArrayList<LPort> nodePorts = new ArrayList<LPort>();
        List<LPort> realNodePorts = node.getPorts();
        HashSet<LPort> alreadyArranged = new HashSet<LPort>(realNodePorts);
        for (SelfLoopNodeSide side : nodeRep.getSides()) {
            List<SelfLoopPort> sidePorts = side.getPorts();
            double lastPosition = SelfLoopNodePortRestorator.getInitialPosition(side, node);
            Double spacing = null;
            int i = 0;
            while (i < sidePorts.size()) {
                SelfLoopPort port = sidePorts.get(i);
                LPort lPort = port.getLPort();
                if (alreadyArranged.contains((Object)lPort)) {
                    spacing = null;
                } else {
                    lPort.setSide(port.getPortSide());
                    if (spacing == null) {
                        spacing = SelfLoopNodePortRestorator.computeSpacing(side, i + 1, lastPosition, node, alreadyArranged);
                    }
                    SelfLoopNodePortRestorator.setPosition(lPort, lastPosition + spacing, node);
                }
                nodePorts.add(lPort);
                lastPosition = SelfLoopNodePortRestorator.getPosition(lPort);
                ++i;
            }
        }
        realNodePorts.removeAll(nodePorts);
        realNodePorts.addAll(nodePorts);
    }

    private static double getInitialPosition(SelfLoopNodeSide side, LNode node) {
        switch (side.getSide()) {
            case SOUTH: {
                return node.getSize().x;
            }
            case WEST: {
                return node.getSize().y;
            }
        }
        return 0.0;
    }

    private static double computeSpacing(SelfLoopNodeSide side, int startIndex, double lastPosition, LNode node, Set<LPort> alreadyArranged) {
        List<SelfLoopPort> sidePorts = side.getPorts();
        int i = startIndex;
        while (i < sidePorts.size()) {
            SelfLoopPort port = sidePorts.get(i);
            if (alreadyArranged.contains((Object)port.getLPort())) {
                KVector portPosition = port.getLPort().getPosition();
                int divisor = i - startIndex + 2;
                switch (side.getSide()) {
                    case NORTH: 
                    case SOUTH: {
                        return (portPosition.x - lastPosition) / (double)divisor;
                    }
                    case EAST: 
                    case WEST: {
                        return (portPosition.y - lastPosition) / (double)divisor;
                    }
                }
            }
            ++i;
        }
        KVector nodeSize = node.getSize();
        int divisor = sidePorts.size() - startIndex + 2;
        switch (side.getSide()) {
            case NORTH: {
                return (nodeSize.x - lastPosition) / (double)divisor;
            }
            case EAST: {
                return (nodeSize.y - lastPosition) / (double)divisor;
            }
            case SOUTH: 
            case WEST: {
                return -lastPosition / (double)divisor;
            }
        }
        return Double.NaN;
    }

    private static double getPosition(LPort port) {
        switch (port.getSide()) {
            case EAST: 
            case WEST: {
                return port.getPosition().y;
            }
            case NORTH: 
            case SOUTH: {
                return port.getPosition().x;
            }
        }
        return Double.NaN;
    }

    private static void setPosition(LPort port, double position, LNode node) {
        double offset = (Double)port.getProperty(LayeredOptions.PORT_BORDER_OFFSET);
        switch (port.getSide()) {
            case EAST: {
                port.getPosition().x = node.getSize().x + offset;
                port.getPosition().y = position;
                break;
            }
            case WEST: {
                port.getPosition().x = 0.0 - port.getSize().x - offset;
                port.getPosition().y = position;
                break;
            }
            case NORTH: {
                port.getPosition().x = position;
                port.getPosition().y = 0.0 - port.getSize().y - offset;
                break;
            }
            case SOUTH: {
                port.getPosition().x = position;
                port.getPosition().y = node.getSize().y + offset;
            }
        }
    }
}

